/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static void copyDirectory(File sourceDir, File destinationDir) throws IOException {
        FileUtils.copyDirectory((File)sourceDir, (File)destinationDir);
    }

    public static void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        FileUtil.copyDirectory(new File(sourceDirName), new File(destinationDirName));
    }

    public static File copyFileFromResource(String resourceName, String targetFilePath) throws IOException {
        ClassLoader classLoader = FileUtil.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(resourceName);){
            File file = new File(targetFilePath);
            file.mkdirs();
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file2 = file;
            return file2;
        }
    }

    public static boolean delete(File file) {
        return FileUtils.deleteQuietly((File)file);
    }

    public static boolean delete(String filePath) throws IOException {
        File file = new File(filePath);
        return FileUtils.deleteQuietly((File)file);
    }

    public static boolean exists(File file) {
        return file.exists();
    }

    public static boolean exists(String fileName) {
        File file = new File(fileName);
        return FileUtil.exists(file);
    }

    public static String fixFilePath(String filePath) {
        if (OSDetector.isWindows()) {
            return StringUtil.replace(filePath, "/", "\\");
        }
        return filePath;
    }

    public static String getCanonicalPath(String filePath) {
        try {
            File file = new File(filePath);
            return file.getCanonicalPath();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return filePath;
        }
    }

    public static String getFileName(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        Path fileName = path.getFileName();
        return fileName.toString();
    }

    public static List<URL> getIncludedResourceURLs(FileSystem fileSystem, String[] includes, String baseDirName) throws IOException {
        final ArrayList<PathMatcher> pathMatchers = new ArrayList<PathMatcher>();
        for (String include : includes) {
            pathMatchers.add(fileSystem.getPathMatcher("glob:" + include));
        }
        final ArrayList<URL> filePaths = new ArrayList<URL>();
        if (Validator.isNull(baseDirName)) {
            return filePaths;
        }
        Path path = fileSystem.getPath(baseDirName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            System.out.println("Directory " + baseDirName + " does not exist.");
            return filePaths;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                for (PathMatcher pathMatcher : pathMatchers) {
                    URI uri = filePath.toUri();
                    if (!pathMatcher.matches(filePath)) continue;
                    filePaths.add(uri.toURL());
                    break;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return filePaths;
    }

    public static List<URL> getIncludedResourceURLs(String[] includes, String baseDirName) throws IOException {
        return FileUtil.getIncludedResourceURLs(FileSystems.getDefault(), includes, baseDirName);
    }

    public static String getSeparator() {
        return File.separator;
    }

    public static URL getURL(File file) throws MalformedURLException {
        URI uri = file.toURI();
        return uri.toURL();
    }

    public static String read(File file) throws IOException {
        return FileUtil.read(FileUtil.getURL(file));
    }

    public static String read(String fileName) throws IOException {
        File file = new File(fileName);
        return FileUtil.read(file);
    }

    public static String read(URL url) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        if (sb.length() != 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void write(File file, byte[] bytes) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])bytes);
    }

    public static void write(File file, String string) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)string);
    }

    public static void write(String fileName, byte[] bytes) throws IOException {
        File file = new File(fileName);
        FileUtil.write(file, bytes);
    }

    public static void write(String fileName, String string) throws IOException {
        File file = new File(fileName);
        FileUtil.write(file, string);
    }
}

