/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.DefinitionPoshiElement;
import com.liferay.poshi.core.elements.DescriptionPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class CommandPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "command";
    private static final String _POSHI_SCRIPT_KEYWORD_REGEX = "(function|macro|test)[\\s]+";
    private static final Pattern _blockNamePattern = Pattern.compile("^(@.*=.*|)(function|macro|test)[\\s]+[\\s]*([\\w]*)", 32);

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new CommandPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new CommandPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public String getPoshiLogDescriptor() {
        return this.getBlockName();
    }

    @Override
    public int getPoshiScriptLineNumber() {
        return this.getPoshiScriptLineNumber(false);
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        String blockName = this.getBlockName(poshiScript);
        Matcher poshiScriptAnnotationMatcher = poshiScriptAnnotationPattern.matcher(blockName);
        while (poshiScriptAnnotationMatcher.find()) {
            String annotation = poshiScriptAnnotationMatcher.group();
            if (annotation.startsWith("@description")) {
                this.add(PoshiNodeFactory.newPoshiNode(this, annotation));
                continue;
            }
            String name = this.getNameFromAssignment(annotation);
            String value = this.getDoubleQuotedContent(annotation);
            this.addAttribute(name, value);
        }
        Matcher blockNameMatcher = _blockNamePattern.matcher(blockName);
        if (blockNameMatcher.find()) {
            this.addAttribute("name", blockNameMatcher.group(3));
        }
        String blockContent = this.getBlockContent(poshiScript);
        for (String poshiScriptSnippet : this.getPoshiScriptSnippets(blockContent)) {
            this.add(PoshiNodeFactory.newPoshiNode(this, poshiScriptSnippet));
        }
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        DescriptionPoshiElement descriptionPoshiElement = (DescriptionPoshiElement)this.element("description");
        if (descriptionPoshiElement != null) {
            sb.append("\n\t");
            sb.append(descriptionPoshiElement.toPoshiScript());
        }
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributeList())) {
            String name = poshiElementAttribute.getName();
            if (name.equals("name")) continue;
            sb.append("\n\t@");
            sb.append(poshiElementAttribute.toPoshiScript());
        }
        sb.append(this.createPoshiScriptBlock(this.getPoshiNodes()));
        return sb.toString();
    }

    protected CommandPoshiElement() {
        this(_ELEMENT_NAME);
    }

    protected CommandPoshiElement(Element element) {
        this(_ELEMENT_NAME, element);
    }

    protected CommandPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        this(_ELEMENT_NAME, attributes, nodes);
    }

    protected CommandPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        this(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    protected CommandPoshiElement(String name) {
        super(name);
    }

    protected CommandPoshiElement(String name, Element element) {
        super(name, element);
    }

    protected CommandPoshiElement(String elementName, List<Attribute> attributes, List<Node> nodes) {
        super(elementName, attributes, nodes);
    }

    protected CommandPoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(name, parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        return this.getPoshiScriptKeyword() + " " + this.attributeValue("name");
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (!(parentPoshiElement instanceof DefinitionPoshiElement)) {
            return false;
        }
        return this.isValidPoshiScriptBlock(_blockNamePattern, poshiScript);
    }
}

