/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.elements.AndPoshiElement;
import com.liferay.poshi.core.elements.DescriptionPoshiElement;
import com.liferay.poshi.core.elements.ElseIfPoshiElement;
import com.liferay.poshi.core.elements.ElsePoshiElement;
import com.liferay.poshi.core.elements.IfPoshiElement;
import com.liferay.poshi.core.elements.NotPoshiElement;
import com.liferay.poshi.core.elements.OrPoshiElement;
import com.liferay.poshi.core.elements.PoshiCDATA;
import com.liferay.poshi.core.elements.PoshiComment;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.elements.VarPoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.script.UnbalancedCodeException;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.PropsValues;
import com.liferay.poshi.core.util.RegexUtil;
import com.liferay.poshi.core.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultElement;

public abstract class PoshiElement
extends DefaultElement
implements PoshiNode<Element, PoshiElement> {
    protected static final String ASSIGNMENT_REGEX = "[\\s]*=[\\s]*";
    protected static final String BLOCK_NAME_ANNOTATION_REGEX = "(@.*=.*|)";
    protected static final String BLOCK_NAME_PARAMETER_REGEX = "[\\s]*\\(.*?\\)$";
    protected static final String INVOCATION_REGEX;
    protected static final String PARAMETER_REGEX = "\\(.*\\)";
    protected static final String STATEMENT_END_REGEX = ";$";
    protected static final String VAR_NAME_REGEX = "((static[\\s]*|)var|)([\\s]*[A-Z][\\w]*|)[\\s]*[\\w]*";
    protected static final String VAR_STATEMENT_END_REGEX = "(;|)$";
    protected static final Pattern poshiScriptAnnotationPattern;
    protected static final Pattern poshiScriptBlockPattern;
    private static final Map<Character, Character> _codeBoundariesMap;
    private static final Pattern _nestedConditionPattern;
    private static final Pattern _poshiScriptCommentPattern;
    private static final Pattern _varInvocationAssignmentStatementPattern;
    private String _poshiScript;

    public PoshiElement(String name) {
        super(name);
    }

    public void add(Attribute attribute) {
        if (attribute instanceof PoshiElementAttribute) {
            super.add(attribute);
            return;
        }
        super.add((Attribute)new PoshiElementAttribute(attribute));
    }

    public void add(CDATA cdata) {
        if (cdata instanceof PoshiCDATA) {
            super.add(cdata);
            return;
        }
        super.add((CDATA)new PoshiCDATA(cdata));
    }

    public abstract PoshiElement clone(PoshiElement var1, String var2) throws PoshiScriptParserException;

    @Override
    public PoshiElement clone(String poshiScript) throws PoshiScriptParserException {
        return this.clone(null, poshiScript);
    }

    public String getPoshiLogDescriptor() {
        return this.getPoshiScript();
    }

    @Override
    public String getPoshiScript() {
        return this._poshiScript;
    }

    public int getPoshiScriptLineNumber(Boolean includeAnnotation) {
        int poshiScriptLineNumber = PoshiNode.super.getPoshiScriptLineNumber();
        if (!includeAnnotation.booleanValue()) {
            poshiScriptLineNumber += StringUtil.count(this.getBlockName(this.getPoshiScript()), "\n");
        }
        return poshiScriptLineNumber;
    }

    public boolean isPoshiScriptComment(String poshiScript) {
        Matcher matcher = _poshiScriptCommentPattern.matcher(poshiScript);
        return matcher.find();
    }

    public boolean isValidPoshiScript() throws PoshiScriptParserException {
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributeList())) {
            poshiElementAttribute.validatePoshiScript();
        }
        String originalPoshiScript = this.getPoshiScript();
        String generatedPoshiScript = this.toPoshiScript();
        originalPoshiScript = originalPoshiScript.replaceAll("\\s+", "");
        generatedPoshiScript = generatedPoshiScript.replaceAll("\\s+", "");
        return (this.elements().size() != 0 || originalPoshiScript.equals(generatedPoshiScript)) && originalPoshiScript.length() == generatedPoshiScript.length();
    }

    public boolean remove(Attribute attribute) {
        if (attribute instanceof PoshiElementAttribute) {
            return super.remove(attribute);
        }
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributes())) {
            if (poshiElementAttribute != attribute) continue;
            return super.remove((Attribute)poshiElementAttribute);
        }
        return false;
    }

    public boolean remove(CDATA cdata) {
        if (cdata instanceof PoshiCDATA) {
            return super.remove(cdata);
        }
        for (PoshiNode<?, ?> poshiNode : this.toPoshiNodes(this.content())) {
            if (poshiNode != cdata) continue;
            return super.remove(poshiNode);
        }
        return false;
    }

    @Override
    public void setPoshiScript(String poshiScript) {
        this._poshiScript = poshiScript;
    }

    public List<PoshiElement> toPoshiElements(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PoshiElement> poshiElements = new ArrayList<PoshiElement>(list.size());
        for (Object object : list) {
            poshiElements.add((PoshiElement)object);
        }
        return poshiElements;
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        for (Node node : Dom4JUtil.toNodeList(this.content())) {
            if (node instanceof PoshiComment) {
                PoshiComment poshiComment = (PoshiComment)node;
                sb.append(poshiComment.toPoshiScript());
                continue;
            }
            if (!(node instanceof PoshiElement)) continue;
            PoshiElement poshiElement = (PoshiElement)node;
            sb.append(poshiElement.toPoshiScript());
        }
        return sb.toString();
    }

    @Override
    public void validatePoshiScript() throws PoshiScriptParserException {
        if (!this.isValidPoshiScript() && !this.isValidPoshiXML()) {
            throw new PoshiScriptParserException("Poshi Script syntax is not preserved in translation", this);
        }
    }

    protected PoshiElement(String name, Element element) {
        super(name);
        if (!this.isElementType(name, element)) {
            throw new RuntimeException("Element does not match expected Poshi element name\n" + element.toString());
        }
        this._addAttributes(element);
        this._addNodes(element);
    }

    protected PoshiElement(String name, Element element, URL url) {
        this(name, element);
        this.setFilePath(url);
    }

    protected PoshiElement(String name, List<Attribute> attributes, List<Node> nodes) {
        super(name);
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                this.add(attribute);
            }
        }
        if (nodes != null) {
            for (Node node : nodes) {
                this.add(node);
            }
        }
    }

    protected PoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        this(name, parentPoshiElement, poshiScript, null);
    }

    protected PoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript, URL url) throws PoshiScriptParserException {
        super(name);
        this.setFilePath(url);
        this.setParent((Element)parentPoshiElement);
        this.setPoshiScript(poshiScript);
        try {
            this.parsePoshiScript(poshiScript.trim());
            if (PropsValues.TEST_POSHI_SCRIPT_VALIDATION && !PoshiNodeFactory.validationInitialized.contains(this.getURL())) {
                PoshiNodeFactory.validationInitialized.add(this.getURL());
                this.validatePoshiScript();
            }
        }
        catch (PoshiScriptParserException poshiScriptParserException) {
            // empty catch block
        }
        this.detach();
    }

    protected String createPoshiScriptBlock(List<PoshiNode<?, ?>> poshiNodes) {
        StringBuilder sb = new StringBuilder();
        String pad = this.getPad();
        sb.append("\n");
        sb.append(pad);
        sb.append(this.getBlockName());
        sb.append(" {");
        PoshiNode<?, ?> previousPoshiNode = null;
        for (PoshiNode<?, ?> poshiNode : poshiNodes) {
            if (poshiNode instanceof DescriptionPoshiElement) continue;
            String poshiScriptSnippet = poshiNode.toPoshiScript();
            if ((previousPoshiNode == null || previousPoshiNode instanceof VarPoshiElement && poshiNode instanceof VarPoshiElement) && poshiScriptSnippet.startsWith("\n\n")) {
                poshiScriptSnippet = poshiScriptSnippet.replaceFirst("\n\n", "\n");
            }
            sb.append(this.padPoshiScriptSnippet(poshiScriptSnippet));
            previousPoshiNode = poshiNode;
        }
        sb.append("\n");
        sb.append(pad);
        sb.append("}");
        return sb.toString();
    }

    protected String createPoshiScriptSnippet(String content) {
        StringBuilder sb = new StringBuilder();
        String pad = this.getPad();
        sb.append("\n");
        sb.append(pad);
        sb.append(this.getBlockName());
        sb.append(" {");
        if (content.startsWith("\n\n")) {
            content = content.replaceFirst("\n\n", "\n");
        }
        content = content.replaceAll("\n", "\n" + pad);
        sb.append(content.replaceAll("\n\t\n", "\n\n"));
        sb.append("\n");
        sb.append(pad);
        sb.append("}");
        return sb.toString();
    }

    protected String doubleQuoteContent(String content) {
        return "\"" + content + "\"";
    }

    protected String getBlockContent(String poshiScriptBlock) {
        String blockName = this.getBlockName(poshiScriptBlock);
        int index = blockName.length();
        String blockContent = poshiScriptBlock.substring(index);
        return this.getBracedContent(blockContent);
    }

    protected abstract String getBlockName();

    protected String getBlockName(String poshiScriptBlock) {
        StringBuilder sb = new StringBuilder();
        for (char c : poshiScriptBlock.toCharArray()) {
            if (c == '{' && this.isBalancedPoshiScript(sb.toString())) {
                String blockName = sb.toString();
                return blockName.trim();
            }
            sb.append(c);
        }
        throw new RuntimeException("Unable to get Poshi script block name from:\n" + poshiScriptBlock);
    }

    protected String getBracedContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?\\{(.*)\\}", 1);
    }

    protected String getBracketedContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?\\[(.*)\\]", 1);
    }

    protected String getClassName(String classCommand) {
        int index;
        if ((classCommand = classCommand.trim()).contains("(")) {
            index = classCommand.indexOf("(");
            classCommand = classCommand.substring(0, index);
        }
        index = classCommand.length();
        if (classCommand.contains(".")) {
            index = classCommand.lastIndexOf(".");
        } else if (classCommand.contains("#")) {
            index = classCommand.lastIndexOf("#");
        }
        return classCommand.substring(0, index);
    }

    protected String getCommandName(String classCommand) {
        int index;
        if ((classCommand = classCommand.trim()).contains("(")) {
            index = classCommand.indexOf("(");
            classCommand = classCommand.substring(0, index);
        }
        if (classCommand.contains(".")) {
            index = classCommand.lastIndexOf(".");
            return classCommand.substring(index + 1);
        }
        return classCommand;
    }

    protected Pattern getConditionPattern() {
        return null;
    }

    protected String getDoubleQuotedContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?\"(.*)\"", 1);
    }

    protected List<String> getMethodParameters(String content) {
        try {
            return this.getMethodParameters(content, null);
        }
        catch (PoshiScriptParserException poshiScriptParserException) {
            poshiScriptParserException.printStackTrace();
            return new ArrayList<String>();
        }
    }

    protected List<String> getMethodParameters(String content, Pattern parameterPattern) throws PoshiScriptParserException {
        Matcher matcher;
        ArrayList<String> methodParameters = new ArrayList<String>();
        if (content.length() == 0) {
            return methodParameters;
        }
        StringBuilder sb = new StringBuilder();
        String methodParameter = sb.toString();
        for (char c : content.toCharArray()) {
            if (c == ',' && this.isBalancedPoshiScript(methodParameter)) {
                Matcher matcher2;
                if (parameterPattern != null && !(matcher2 = parameterPattern.matcher(methodParameter)).matches()) {
                    sb.append(c);
                    continue;
                }
                methodParameters.add(methodParameter);
                sb.setLength(0);
                continue;
            }
            sb.append(c);
            methodParameter = sb.toString();
        }
        if (parameterPattern != null && !(matcher = parameterPattern.matcher(methodParameter)).matches()) {
            throw new PoshiScriptParserException("Invalid Poshi Script parameter syntax", this);
        }
        methodParameters.add(methodParameter);
        return methodParameters;
    }

    protected String getNameFromAssignment(String assignment) {
        String name = assignment.split("=")[0];
        name = name.trim();
        name = StringUtil.replace(name, "@", "");
        name = StringUtil.replace(name, "property ", "");
        return StringUtil.replace(name, "var ", "");
    }

    protected List<String> getNestedConditions(String poshiScript, String operator) {
        ArrayList<String> nestedConditions = new ArrayList<String>();
        TreeSet<Integer> tokenIndices = new TreeSet<Integer>();
        int index = poshiScript.indexOf(operator);
        while (index >= 0) {
            tokenIndices.add(index);
            index = poshiScript.indexOf(operator, index + 1);
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = poshiScript.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (tokenIndices.contains(i) && this.isBalancedPoshiScript(sb.toString())) {
                nestedConditions.add(sb.toString());
                sb.setLength(0);
                ++i;
                continue;
            }
            if (i == chars.length - 1) {
                sb.append(c);
                if (this.isBalancedPoshiScript(sb.toString()) && !nestedConditions.isEmpty()) {
                    nestedConditions.add(sb.toString());
                }
            }
            sb.append(c);
        }
        return nestedConditions;
    }

    protected String getPad() {
        return "\t";
    }

    protected String getParentheticalContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?\\((.*)\\)", 1);
    }

    protected List<PoshiNode<?, ?>> getPoshiNodes() {
        return this.toPoshiNodes(this.content());
    }

    protected String getPoshiScriptEscapedContent(String poshiScript) {
        poshiScript = poshiScript.trim();
        return poshiScript.substring(3, poshiScript.length() - 3);
    }

    protected String getPoshiScriptKeyword() {
        PoshiElement poshiParentElement = (PoshiElement)this.getParent();
        return poshiParentElement.getPoshiScriptKeyword();
    }

    protected List<String> getPoshiScriptSnippets(String poshiScriptBlockContent) {
        return this.getPoshiScriptSnippets(poshiScriptBlockContent, true);
    }

    protected List<String> getPoshiScriptSnippets(String poshiScriptBlockContent, boolean splitElseBlocks) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> poshiScriptSnippets = new ArrayList<String>();
        int index = 0;
        boolean skipBalanceCheck = false;
        Stack<Integer> storedIndices = new Stack<Integer>();
        for (char c : poshiScriptBlockContent.toCharArray()) {
            sb.append(c);
            String poshiScriptSnippet = sb.toString();
            String trimmedPoshiScriptSnippet = poshiScriptSnippet.trim();
            if (trimmedPoshiScriptSnippet.startsWith("//")) {
                if (c != '\n') continue;
                poshiScriptSnippet = poshiScriptSnippet.substring(0, poshiScriptSnippet.length() - 1);
                poshiScriptSnippets.add(poshiScriptSnippet);
                sb.setLength(0);
                sb.append(c);
                continue;
            }
            if (trimmedPoshiScriptSnippet.startsWith("/*")) {
                if (!trimmedPoshiScriptSnippet.endsWith("*/")) continue;
                poshiScriptSnippets.add(poshiScriptSnippet);
                sb.setLength(0);
                continue;
            }
            ++index;
            if (c == '\'') {
                if (storedIndices.isEmpty()) {
                    storedIndices.push(index);
                } else if ((Integer)storedIndices.peek() == index - 1) {
                    storedIndices.push(index);
                }
                if (storedIndices.size() == 3 || storedIndices.size() == 6) {
                    boolean bl = skipBalanceCheck = !skipBalanceCheck;
                }
                if (storedIndices.size() > 6) {
                    throw new RuntimeException("Invalid multiline string: \n" + poshiScriptSnippet);
                }
            } else {
                storedIndices.clear();
            }
            if (skipBalanceCheck || c != '}' && c != ';' || trimmedPoshiScriptSnippet.startsWith("var") && c != ';' || !this.isBalancedPoshiScript(poshiScriptSnippet)) continue;
            if (splitElseBlocks && (this.isValidPoshiScriptBlock(ElseIfPoshiElement.blockNamePattern, poshiScriptSnippet) || this.isValidPoshiScriptBlock(ElsePoshiElement.blockNamePattern, poshiScriptSnippet))) {
                int lastIndex = poshiScriptSnippets.size() - 1;
                String lastPoshiScriptSnippet = (String)poshiScriptSnippets.get(lastIndex);
                poshiScriptSnippets.set(lastIndex, lastPoshiScriptSnippet + poshiScriptSnippet);
                sb.setLength(0);
                continue;
            }
            poshiScriptSnippets.add(poshiScriptSnippet);
            sb.setLength(0);
        }
        String poshiScriptSnippet = sb.toString();
        if (!(poshiScriptSnippet = poshiScriptSnippet.trim()).isEmpty()) {
            poshiScriptSnippets.add(poshiScriptSnippet);
        }
        return poshiScriptSnippets;
    }

    protected String getSingleQuotedContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?'(.*)'", 1);
    }

    protected String getValueFromAssignment(String assignment) {
        assignment = assignment.trim();
        int start = assignment.indexOf("=");
        int end = assignment.length();
        if (assignment.endsWith(";")) {
            --end;
        }
        String value = assignment.substring(start + 1, end);
        return value.trim();
    }

    protected boolean isBalancedPoshiScript(String poshiScript) {
        try {
            return this.isBalancedPoshiScript(poshiScript, false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isBalancedPoshiScript(String poshiScript, boolean throwException) throws UnbalancedCodeException {
        poshiScript = this._fixPoshiScript(poshiScript);
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < poshiScript.length(); ++i) {
            char c = poshiScript.charAt(i);
            if (!stack.isEmpty()) {
                int topIndex = (Integer)stack.peek();
                Character topCodeBoundary = Character.valueOf(poshiScript.charAt(topIndex));
                if (c == _codeBoundariesMap.get(topCodeBoundary).charValue()) {
                    stack.pop();
                    continue;
                }
                if (topCodeBoundary.charValue() == '\"' || topCodeBoundary.charValue() == '\'') continue;
            }
            if (_codeBoundariesMap.containsKey(Character.valueOf(c))) {
                stack.push(i);
                continue;
            }
            if (!_codeBoundariesMap.containsValue(Character.valueOf(c))) continue;
            if (throwException) {
                throw new UnbalancedCodeException("Unexpected closing boundary", i, poshiScript);
            }
            return false;
        }
        boolean balanced = stack.isEmpty();
        if (!balanced && throwException) {
            throw new UnbalancedCodeException("Unmatched opening boundary", (Integer)stack.peek(), poshiScript);
        }
        return balanced;
    }

    protected final boolean isConditionElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (!this.isConditionValidInParent(parentPoshiElement)) {
            return false;
        }
        poshiScript = poshiScript.trim();
        Pattern conditionPattern = this.getConditionPattern();
        if (conditionPattern == null) {
            throw new RuntimeException("Condition pattern has not been defined");
        }
        Matcher matcher = conditionPattern.matcher(poshiScript);
        return matcher.find();
    }

    protected boolean isConditionValidInParent(PoshiElement parentPoshiElement) {
        return parentPoshiElement instanceof AndPoshiElement || parentPoshiElement instanceof ElseIfPoshiElement || parentPoshiElement instanceof IfPoshiElement || parentPoshiElement instanceof NotPoshiElement || parentPoshiElement instanceof OrPoshiElement;
    }

    protected boolean isElementType(String name, Element element) {
        return name.equals(element.getName());
    }

    protected boolean isNestedCondition(String poshiScript) {
        List<String> nestedConditions;
        Matcher matcher = _nestedConditionPattern.matcher(poshiScript);
        return matcher.find() && (nestedConditions = this.getNestedConditions(poshiScript, matcher.group(0))).size() > 1;
    }

    protected boolean isValidFunctionFileName(String poshiScriptInvocation) {
        for (String functionFileName : PoshiContext.getFunctionFileNames()) {
            if (!poshiScriptInvocation.matches("(?s)" + Pattern.quote(functionFileName) + "[\\.\\(]+.*")) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidPoshiScriptBlock(Pattern poshiScriptBlockNamePattern, String poshiScript) {
        Matcher poshiScriptBlockNameMatcher;
        Matcher poshiScriptBlockMatcher = poshiScriptBlockPattern.matcher(poshiScript = poshiScript.trim());
        return poshiScriptBlockMatcher.find() && (poshiScriptBlockNameMatcher = poshiScriptBlockNamePattern.matcher(this.getBlockName(poshiScript))).find();
    }

    protected boolean isValidPoshiScriptStatement(Pattern poshiScriptStatementPattern, String poshiScript) {
        Matcher poshiScriptStatementMatcher = poshiScriptStatementPattern.matcher(poshiScript = poshiScript.trim());
        return poshiScriptStatementMatcher.find();
    }

    protected boolean isValidUtilityClassName(String classCommandName) {
        if (PoshiContext.ignoreUtilClassesErrors()) {
            return true;
        }
        String className = this.getClassName(classCommandName);
        if (className.equals("selenium")) {
            return true;
        }
        try {
            if (!className.contains(".")) {
                className = PoshiGetterUtil.getUtilityClassName(className);
            }
            if (PoshiGetterUtil.isValidUtilityClass(className)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return false;
    }

    protected boolean isVarAssignedToMacroInvocation(String poshiScript) {
        poshiScript = poshiScript.trim();
        String value = this.getValueFromAssignment(poshiScript);
        return this.isValidPoshiScriptStatement(_varInvocationAssignmentStatementPattern, poshiScript) && !this.isValidFunctionFileName(value) && !this.isValidUtilityClassName(value);
    }

    protected String padPoshiScriptSnippet(String poshiScriptSnippet) {
        if (!(poshiScriptSnippet.contains("'''") || poshiScriptSnippet.contains("/*") || poshiScriptSnippet.contains("*/"))) {
            poshiScriptSnippet = StringUtil.replace(poshiScriptSnippet, "\n", "\n" + this.getPad());
            poshiScriptSnippet = StringUtil.replace(poshiScriptSnippet, "\n\t\n", "\n\n");
            return StringUtil.replace(poshiScriptSnippet, "\n\n\n", "\n\n");
        }
        Stack<String> stack = new Stack<String>();
        StringBuilder sb = new StringBuilder();
        if (poshiScriptSnippet.startsWith("\n\n")) {
            poshiScriptSnippet = poshiScriptSnippet.replaceFirst("\n\n", "\n");
        }
        for (String line : poshiScriptSnippet.split("\n")) {
            String trimmedLine = line.trim();
            sb.append("\n");
            String stackPeek = "";
            if (stack.isEmpty()) {
                if (!trimmedLine.isEmpty()) {
                    line = this.getPad() + line;
                }
            } else {
                stackPeek = (String)stack.peek();
            }
            sb.append(line);
            if (trimmedLine.startsWith("/*") && !stack.contains("/*")) {
                stack.push("/*");
            }
            if (StringUtil.count(trimmedLine, "'''") % 2 == 1) {
                if (stackPeek.equals("'''")) {
                    stack.pop();
                } else {
                    stack.push("'''");
                }
            }
            if (!trimmedLine.endsWith("*/") || !stackPeek.equals("/*")) continue;
            stack.pop();
        }
        return sb.toString();
    }

    protected void setFilePath(URL url) {
    }

    protected String singleQuoteContent(String content) {
        return "'" + content + "'";
    }

    protected List<PoshiElementAttribute> toPoshiElementAttributes(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PoshiElementAttribute> poshiElementAttributes = new ArrayList<PoshiElementAttribute>(list.size());
        for (Object object : list) {
            poshiElementAttributes.add((PoshiElementAttribute)object);
        }
        return poshiElementAttributes;
    }

    protected List<PoshiNode<?, ?>> toPoshiNodes(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList poshiNodes = new ArrayList(list.size());
        for (Object object : list) {
            poshiNodes.add((PoshiNode)object);
        }
        return poshiNodes;
    }

    private void _addAttributes(Element element) {
        for (Attribute attribute : Dom4JUtil.toAttributeList(element.attributes())) {
            this.add((Attribute)new PoshiElementAttribute((Attribute)attribute.clone()));
        }
    }

    private void _addNodes(Element element) {
        for (Node node : Dom4JUtil.toNodeList(element.content())) {
            if (node instanceof Comment || node instanceof Element) {
                this.add(PoshiNodeFactory.newPoshiNode(node));
            }
            if (!(node instanceof CDATA)) continue;
            this.add((CDATA)new PoshiCDATA((CDATA)node.clone()));
        }
    }

    private String _fixPoshiScript(String poshiScript) {
        if (poshiScript.contains("/*") && poshiScript.contains("*/")) {
            poshiScript = poshiScript.replaceAll("(?s)/\\*.*?\\*/", "/\\*\\*/");
        }
        if (poshiScript.contains("'''")) {
            poshiScript = poshiScript.replaceAll("(?s)'''.*?'''", "''''''");
        }
        if (poshiScript.contains("//")) {
            poshiScript = poshiScript.replaceAll("(?m)\n[\\s]*//.*?$", "//\n");
        }
        return poshiScript.trim();
    }

    static {
        poshiScriptAnnotationPattern = Pattern.compile("@[\\w-]*[\\s]*?=[\\s]\".*?\"", 32);
        poshiScriptBlockPattern = Pattern.compile("^[^{]*\\{[\\s\\S]*\\}$");
        _codeBoundariesMap = new HashMap<Character, Character>(){
            {
                this.put(Character.valueOf('('), Character.valueOf(')'));
                this.put(Character.valueOf('['), Character.valueOf(']'));
                this.put(Character.valueOf('\"'), Character.valueOf('\"'));
                this.put(Character.valueOf('\''), Character.valueOf('\''));
                this.put(Character.valueOf('{'), Character.valueOf('}'));
            }
        };
        _nestedConditionPattern = Pattern.compile("(\\|{2}|\\&{2})");
        _poshiScriptCommentPattern = Pattern.compile("^[\\s]*(\\/\\/.*?(\\n|$)|\\/\\*.*?\\*\\/)", 32);
        INVOCATION_REGEX = "[\\s]*[\\w\\.]*\\(.*\\)";
        _varInvocationAssignmentStatementPattern = Pattern.compile("^((static[\\s]*|)var|)([\\s]*[A-Z][\\w]*|)[\\s]*[\\w]*[\\s]*=[\\s]*" + INVOCATION_REGEX + VAR_STATEMENT_END_REGEX, 32);
    }
}

