/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.script;

import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PoshiScriptParserException
extends Exception {
    public static final String TRANSLATION_LOSS_MESSAGE = "Poshi Script syntax is not preserved in translation";
    private static final int _ERROR_SNIPPET_POSTFIX_SIZE = 10;
    private static final int _ERROR_SNIPPET_PREFIX_SIZE = 10;
    private static final Set<PoshiScriptParserException> _poshiScriptParserExceptions = Collections.synchronizedSet(new HashSet());
    private int _errorLineNumber;
    private String _filePath = "Unknown file";
    private PoshiNode<?, ?> _poshiNode;

    public static void throwExceptions() throws Exception {
        if (!_poshiScriptParserExceptions.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n");
            sb.append(_poshiScriptParserExceptions.size());
            sb.append(" errors in Poshi script syntax\n\n");
            for (Exception exception : _poshiScriptParserExceptions) {
                sb.append(exception.getMessage());
                sb.append("\n\n");
            }
            System.out.println(sb.toString());
            throw new Exception();
        }
    }

    public PoshiScriptParserException(String msg) {
        super(msg);
        _poshiScriptParserExceptions.add(this);
    }

    public PoshiScriptParserException(String msg, PoshiNode<?, ?> poshiNode) {
        this(msg);
        this.setErrorLineNumber(poshiNode.getPoshiScriptLineNumber());
        URL url = poshiNode.getURL();
        this.setFilePath(url.getPath());
        this.setPoshiNode(poshiNode);
    }

    public PoshiScriptParserException(String msg, String poshiScript, PoshiNode<?, ?> parentPoshiNode) {
        this(msg);
        this.setPoshiNode(parentPoshiNode);
        String parentPoshiScript = parentPoshiNode.getPoshiScript();
        parentPoshiScript = parentPoshiScript.replaceFirst("^[\\n\\r]*", "");
        int startingLineNumber = parentPoshiNode.getPoshiScriptLineNumber();
        if (parentPoshiNode instanceof PoshiElement) {
            PoshiElement parentPoshiElement = (PoshiElement)parentPoshiNode;
            startingLineNumber = parentPoshiElement.getPoshiScriptLineNumber(true);
        }
        int index = parentPoshiScript.indexOf(poshiScript.trim());
        this.setErrorLineNumber(startingLineNumber + StringUtil.count(parentPoshiScript, "\n", index));
        URL url = parentPoshiNode.getURL();
        this.setFilePath(url.getPath());
    }

    public int getErrorLineNumber() {
        return this._errorLineNumber;
    }

    public String getErrorSnippet() {
        PoshiElement rootPoshiElement = this.getRootPoshiElement(this.getPoshiNode());
        int errorLineNumber = this.getErrorLineNumber();
        int startingLineNumber = Math.max(errorLineNumber - 10, 1);
        String poshiScript = rootPoshiElement.getPoshiScript();
        String[] lines = poshiScript.split("\n");
        int endingLineNumber = lines.length;
        endingLineNumber = Math.min(errorLineNumber + 10, endingLineNumber);
        StringBuilder sb = new StringBuilder();
        String lineNumberString = String.valueOf(endingLineNumber);
        int pad = lineNumberString.length() + 2;
        for (int currentLineNumber = startingLineNumber; currentLineNumber <= endingLineNumber; ++currentLineNumber) {
            StringBuilder prefix = new StringBuilder();
            if (currentLineNumber == errorLineNumber) {
                prefix.append(">");
            } else {
                prefix.append(" ");
            }
            prefix.append(" ");
            prefix.append(currentLineNumber);
            sb.append(String.format("%" + pad + "s", prefix.toString()));
            sb.append(" |");
            String line = lines[currentLineNumber - 1];
            sb.append(StringUtil.replace(line, "\t", "    "));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getFilePath() {
        return this._filePath;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        sb.append(" at:\n");
        sb.append(this.getFilePath());
        sb.append(":");
        sb.append(this.getErrorLineNumber());
        sb.append("\n");
        sb.append(this.getErrorSnippet());
        return sb.toString();
    }

    public PoshiNode<?, ?> getPoshiNode() {
        return this._poshiNode;
    }

    public PoshiElement getRootPoshiElement(PoshiNode<?, ?> poshiNode) {
        if (Validator.isNotNull(poshiNode.getParent())) {
            PoshiElement parentPoshiElement = (PoshiElement)poshiNode.getParent();
            return this.getRootPoshiElement(parentPoshiElement);
        }
        return (PoshiElement)poshiNode;
    }

    public void setErrorLineNumber(int errorLineNumber) {
        this._errorLineNumber = errorLineNumber;
    }

    public void setFilePath(String filePath) {
        this._filePath = filePath;
    }

    public void setPoshiNode(PoshiNode<?, ?> poshiNode) {
        this._poshiNode = poshiNode;
    }
}

