/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.net.URL;

public class PoshiElementException
extends Exception {
    private static final int _ERROR_SNIPPET_POSTFIX_SIZE = 7;
    private static final int _ERROR_SNIPPET_PREFIX_SIZE = 7;
    private int _errorLineNumber;
    private String _filePath = "Unknown file";
    private PoshiNode<?, ?> _poshiNode;

    public static PoshiElement getRootPoshiElement(PoshiNode<?, ?> poshiNode) {
        if (Validator.isNotNull(poshiNode.getParent())) {
            PoshiElement parentPoshiElement = (PoshiElement)poshiNode.getParent();
            return PoshiElementException.getRootPoshiElement(parentPoshiElement);
        }
        return (PoshiElement)poshiNode;
    }

    public static String join(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object.toString());
        }
        return sb.toString();
    }

    public PoshiElementException(PoshiNode<?, ?> poshiNode, Object ... messageParts) {
        this(PoshiElementException.join(messageParts), poshiNode);
    }

    public PoshiElementException(String msg) {
        super(msg);
    }

    public PoshiElementException(String msg, PoshiNode<?, ?> poshiNode) {
        this(msg);
        this.setErrorLineNumber(poshiNode.getPoshiScriptLineNumber());
        URL filePathURL = poshiNode.getFilePathURL();
        this.setFilePath(filePathURL.getPath());
        this.setPoshiNode(poshiNode);
    }

    public int getErrorLineNumber() {
        return this._errorLineNumber;
    }

    public String getErrorSnippet() {
        PoshiElement rootPoshiElement = PoshiElementException.getRootPoshiElement(this.getPoshiNode());
        int errorLineNumber = this.getErrorLineNumber();
        int startingLineNumber = Math.max(errorLineNumber - 7, 1);
        String poshiScript = rootPoshiElement.getPoshiScript();
        String[] lines = poshiScript.split("\n");
        int endingLineNumber = lines.length;
        endingLineNumber = Math.min(errorLineNumber + 7, endingLineNumber);
        StringBuilder sb = new StringBuilder();
        String lineNumberString = String.valueOf(endingLineNumber);
        int pad = lineNumberString.length() + 2;
        for (int currentLineNumber = startingLineNumber; currentLineNumber <= endingLineNumber; ++currentLineNumber) {
            StringBuilder prefix = new StringBuilder();
            if (currentLineNumber == errorLineNumber) {
                prefix.append(">");
            } else {
                prefix.append(" ");
            }
            prefix.append(" ");
            prefix.append(currentLineNumber);
            sb.append(String.format("%" + pad + "s", prefix.toString()));
            sb.append(" |");
            String line = lines[currentLineNumber - 1];
            sb.append(StringUtil.replace(line, "\t", "    "));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getFilePath() {
        return this._filePath;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        sb.append(" at:\n");
        sb.append(this.getFilePath());
        sb.append(":");
        sb.append(this.getErrorLineNumber());
        sb.append("\n");
        sb.append(this.getErrorSnippet());
        return sb.toString();
    }

    public PoshiNode<?, ?> getPoshiNode() {
        return this._poshiNode;
    }

    public void setErrorLineNumber(int errorLineNumber) {
        this._errorLineNumber = errorLineNumber;
    }

    public void setFilePath(String filePath) {
        this._filePath = filePath;
    }

    public void setPoshiNode(PoshiNode<?, ?> poshiNode) {
        this._poshiNode = poshiNode;
    }
}

