/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.guard.connector;

import com.liferay.data.guard.connector.DataGuardConnectorThread;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component(service={})
public class DataGuardConnector {
    private static final int _PORT = 42763;
    private static final InetAddress _inetAddress = InetAddress.getLoopbackAddress();
    private DataGuardConnectorThread _dataGuardConnectorThread;
    @Reference
    private LoggerFactory _loggerFactory;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, String> properties) {
        int port = 42763;
        String portString = properties.get("port");
        if (portString != null) {
            port = Integer.valueOf(portString);
        }
        Logger logger = this._loggerFactory.getLogger(DataGuardConnector.class);
        logger.info("Listening on port {}", (Object)port);
        try {
            this._dataGuardConnectorThread = new DataGuardConnectorThread(bundleContext, _inetAddress, port, properties.get("passcode"), logger);
        }
        catch (IOException ioException) {
            logger.error("Encountered a problem while using {}:{}. Shutting down now.", new Object[]{_inetAddress.getHostAddress(), port, ioException});
            System.exit(-10);
        }
        this._dataGuardConnectorThread.start();
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this._dataGuardConnectorThread.close();
        this._dataGuardConnectorThread.join();
    }
}

