/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.guard.connector.client;

import com.liferay.data.guard.connector.DataGuardResult;
import com.liferay.data.guard.connector.command.DataGuardCommand;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataGuardClient {
    private static final int _MAX_RETRY_ATTEMPTS = 5;
    private static final int _PORT = 42763;
    private static final int _RETRY_INTERVAL = 10;
    private static final Logger _logger = Logger.getLogger(DataGuardClient.class.getName());
    private static final InetAddress _inetAddress = InetAddress.getLoopbackAddress();
    private ObjectInputStream _objectInputStream;
    private ObjectOutputStream _objectOutputStream;
    private Socket _socket;

    public void close() throws IOException {
        this._objectInputStream.close();
        this._objectInputStream = null;
        this._objectOutputStream.close();
        this._objectOutputStream = null;
        this._socket.close();
        this._socket = null;
    }

    public void connect() throws Exception {
        Integer port = Integer.getInteger("liferay.data.guard.port");
        if (port == null) {
            port = 42763;
        }
        int retries = 0;
        while (true) {
            try {
                this._socket = new Socket(_inetAddress, (int)port);
            }
            catch (ConnectException connectException) {
                if (retries++ < 5) {
                    _logger.log(Level.INFO, "Unable to connect at " + _inetAddress.getHostAddress() + ":" + port + ". Retrying in " + 10 + "s.");
                    Thread.sleep(10000L);
                    continue;
                }
                _logger.log(Level.SEVERE, "Unable to connect after 5 attempts");
                throw connectException;
            }
            break;
        }
        this._objectOutputStream = new ObjectOutputStream(this._socket.getOutputStream());
        this._objectInputStream = new ObjectInputStream(this._socket.getInputStream());
        String passcode = System.getProperty("liferay.data.guard.passcode");
        if (passcode == null) {
            passcode = "";
        }
        this._objectOutputStream.writeUTF(passcode);
        this._objectOutputStream.flush();
    }

    public long endCapture(long id, String testClassName) throws Throwable {
        this._objectOutputStream.writeObject(DataGuardCommand.endCapture(id, testClassName));
        this._objectOutputStream.flush();
        return this._getResult();
    }

    public long startCapture() throws Exception {
        this._objectOutputStream.writeObject(DataGuardCommand.startCapture());
        this._objectOutputStream.flush();
        return this._getResult();
    }

    private long _getResult() throws Exception {
        DataGuardResult dataGuardResult = (DataGuardResult)this._objectInputStream.readObject();
        return dataGuardResult.get();
    }
}

