/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.petra.io.unsync.UnsyncPrintWriter;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionCustomizer;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.SessionWrapper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.util.ResourcePermissionTestUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class DataGuardTestRuleUtil {
    private static final ThreadLocal<Map<String, Map<Serializable, String>>> _recordsThreadLocal = new ThreadLocal();
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.SUPPORTS, (Class[])new Class[]{PortalException.class, SystemException.class}, (Class[])new Class[0]);

    public static void afterClass(DataBag dataBag, String testClassName) throws Throwable {
        DataGuardTestRuleUtil.afterClass(dataBag, testClassName, true);
    }

    public static void afterClass(DataBag dataBag, String testClassName, boolean autoDelete) throws Throwable {
        ServiceRegistration serviceRegistration = dataBag._serviceRegistration;
        serviceRegistration.unregister();
        _recordsThreadLocal.remove();
        DataGuardTestRuleUtil._autoDeleteAndAssert(testClassName, dataBag._dataMap, dataBag._portlets, dataBag._records, autoDelete);
    }

    public static void afterMethod(DataBag dataBag, String testClassName) throws Throwable {
        DataGuardTestRuleUtil.afterMethod(dataBag, testClassName, true);
    }

    public static void afterMethod(DataBag dataBag, String testClassName, boolean autoDelete) throws Throwable {
        DataGuardTestRuleUtil._autoDeleteAndAssert(testClassName, dataBag._dataMap, dataBag._portlets, dataBag._records, autoDelete);
    }

    public static DataBag beforeClass() {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        ConcurrentHashMap records = new ConcurrentHashMap();
        _recordsThreadLocal.set(records);
        ServiceRegistration serviceRegistration = bundleContext.registerService(SessionCustomizer.class, (Object)new RecordingSessionCustomizer(records), null);
        return new DataBag(DataGuardTestRuleUtil._captureDataMap(), PortletLocalServiceUtil.getPortlets(), records, serviceRegistration);
    }

    public static DataBag beforeMethod() {
        return new DataBag(DataGuardTestRuleUtil._captureDataMap(), PortletLocalServiceUtil.getPortlets(), _recordsThreadLocal.get(), null);
    }

    public static void smartDelete(PersistedModelLocalService persistedModelLocalService, Class<?> modelClass, PersistedModel persistedModel) throws Exception {
        Method deleteMethod = null;
        Class<?> clazz = persistedModelLocalService.getClass();
        Object[] parameterTypes = new Class[]{modelClass};
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("delete") || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            if (deleteMethod == null) {
                deleteMethod = method;
                continue;
            }
            String deleteMethodName = deleteMethod.getName();
            if (deleteMethodName.length() <= methodName.length()) continue;
            deleteMethod = method;
        }
        try {
            if (deleteMethod == null) {
                persistedModelLocalService.deletePersistedModel(persistedModel);
            } else {
                BaseModel baseModel = (BaseModel)persistedModel;
                deleteMethod.invoke((Object)persistedModelLocalService, persistedModelLocalService.getPersistedModel(baseModel.getPrimaryKeyObj()));
            }
        }
        catch (Throwable throwable1) {
            ResourcePermissionTestUtil.deleteResourcePermissions((PersistedModel)persistedModel);
            BasePersistence<?> basePersistence = DataGuardTestRuleUtil._getBasePersistence(persistedModelLocalService);
            Class<?> persistenceClass = basePersistence.getClass();
            try (Closeable closeable1 = DataGuardTestRuleUtil._installTransactionExecutor(DataGuardTestRuleUtil._getSymbolicName(persistenceClass.getClassLoader()));){
                TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                    try (Closeable closeable2 = DataGuardTestRuleUtil._removeSessionFactoryVerifier(basePersistence);){
                        Session session = basePersistence.getCurrentSession();
                        if (session.contains((Object)persistedModel)) {
                            session.delete((Object)persistedModel);
                        } else {
                            BaseModel baseModel = (BaseModel)persistedModel;
                            Object refetchedBaseModel = session.get(persistedModel.getClass(), baseModel.getPrimaryKeyObj());
                            if (refetchedBaseModel != null) {
                                session.delete(refetchedBaseModel);
                            }
                        }
                        Object var5_6 = null;
                        return var5_6;
                    }
                });
                Indexer indexer = IndexerRegistryUtil.getIndexer(modelClass);
                if (indexer != null) {
                    indexer.delete((Object)persistedModel);
                }
            }
            catch (Throwable throwable2) {
                throwable2.addSuppressed(throwable1);
                ReflectionUtil.throwException((Throwable)throwable2);
            }
        }
    }

    private static void _autoDeleteAndAssert(String testClassName, Map<String, List<BaseModel<?>>> previousDataMap, List<Portlet> previousPortlets, Map<String, Map<Serializable, String>> records, boolean autoDelete) throws Throwable {
        for (Portlet portlet : PortletLocalServiceUtil.getPortlets()) {
            if (previousPortlets.remove(portlet)) continue;
            PortletLocalServiceUtil.destroyPortlet((Portlet)portlet);
        }
        if (autoDelete) {
            DataGuardTestRuleUtil._autoDeleteLeftovers(previousDataMap);
        }
        StringBundler sb = new StringBundler();
        Map<String, List<BaseModel<?>>> dataMap = DataGuardTestRuleUtil._captureDataMap();
        for (Map.Entry<String, List<BaseModel<?>>> entry : dataMap.entrySet()) {
            String className = entry.getKey();
            List<BaseModel<?>> currentBaseModels = entry.getValue();
            List<BaseModel<?>> previsoutBaseModels = previousDataMap.remove(className);
            ArrayList leftoverBaseModels = new ArrayList(currentBaseModels);
            if (previsoutBaseModels != null) {
                leftoverBaseModels.removeAll(previsoutBaseModels);
            }
            if (leftoverBaseModels.isEmpty()) continue;
            sb.append(testClassName);
            sb.append(" caused leftover data for class :");
            sb.append(className);
            sb.append(" with data : [\n");
            for (BaseModel baseModel : leftoverBaseModels) {
                sb.append("\t");
                sb.append((Object)baseModel);
                String backtraceInfo = null;
                Map<Serializable, String> map = records.get(baseModel.getModelClassName());
                if (map != null) {
                    backtraceInfo = map.get(baseModel.getPrimaryKeyObj());
                }
                if (backtraceInfo == null) {
                    sb.append(" with no backtrace info,\n");
                    continue;
                }
                sb.append(" with backtrace info,\n");
                sb.append("\t");
                sb.append("\t");
                sb.append(backtraceInfo);
                sb.append(",\n");
            }
            sb.setStringAt("\n]\n", sb.index() - 1);
        }
        Assert.assertTrue((String)sb.toString(), (sb.index() == 0 ? 1 : 0) != 0);
    }

    private static void _autoDeleteLeftovers(Map<String, List<BaseModel<?>>> previousDataMap) throws Throwable {
        boolean deleted;
        Map<String, PersistedModelLocalService> persistedModelLocalServices = DataGuardTestRuleUtil._getPersistedModelLocalServices();
        do {
            deleted = false;
            Map<String, List<BaseModel<?>>> dataMap = DataGuardTestRuleUtil._captureDataMap();
            for (Map.Entry<String, List<BaseModel<?>>> entry : dataMap.entrySet()) {
                String className = entry.getKey();
                PersistedModelLocalService persistedModelLocalService = persistedModelLocalServices.get(className);
                Class<?> persistedModelLocalServiceClass = persistedModelLocalService.getClass();
                ClassLoader classLoader = persistedModelLocalServiceClass.getClassLoader();
                Class<?> modelClass = classLoader.loadClass(className);
                List<BaseModel<?>> currentBaseModels = entry.getValue();
                List<BaseModel<?>> previsoutBaseModels = previousDataMap.get(className);
                ArrayList leftoverBaseModels = new ArrayList(currentBaseModels);
                if (previsoutBaseModels != null) {
                    leftoverBaseModels.removeAll(previsoutBaseModels);
                }
                for (BaseModel baseModel : leftoverBaseModels) {
                    ResourcePermission resourcePermission;
                    if (className.equals(ResourcePermission.class.getName()) && (resourcePermission = (ResourcePermission)baseModel).getScope() == 4 && resourcePermission.getPrimKeyId() != 0L && persistedModelLocalServices.containsKey(resourcePermission.getName())) continue;
                    DataGuardTestRuleUtil.smartDelete(persistedModelLocalService, modelClass, (PersistedModel)baseModel);
                    deleted = true;
                }
            }
        } while (deleted);
    }

    private static Map<String, List<BaseModel<?>>> _captureDataMap() {
        Map<String, PersistedModelLocalService> persistedModelLocalServices = DataGuardTestRuleUtil._getPersistedModelLocalServices();
        HashMap dataMap = new HashMap();
        for (Map.Entry<String, PersistedModelLocalService> entry : persistedModelLocalServices.entrySet()) {
            PersistedModelLocalService persistedModelLocalService = entry.getValue();
            BasePersistence<?> basePersistence = DataGuardTestRuleUtil._getBasePersistence(persistedModelLocalService);
            if (basePersistence == null) continue;
            Class<?> clazz = basePersistence.getClass();
            try {
                Closeable closeable1 = DataGuardTestRuleUtil._installTransactionExecutor(DataGuardTestRuleUtil._getSymbolicName(clazz.getClassLoader()));
                Throwable throwable = null;
                try {
                    TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                        basePersistence.clearCache();
                        try (Closeable closeable2 = DataGuardTestRuleUtil._removeSessionFactoryVerifier(basePersistence);){
                            List baseModels = (List)ReflectionTestUtil.invoke((Object)basePersistence, (String)"findAll", (Class[])new Class[0], (Object[])new Object[0]);
                            if (!baseModels.isEmpty()) {
                                dataMap.put((String)entry.getKey(), baseModels);
                            }
                        }
                        return null;
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (closeable1 == null) continue;
                    if (throwable != null) {
                        try {
                            closeable1.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    closeable1.close();
                }
            }
            catch (Throwable throwable) {
                return (Map)ReflectionUtil.throwException((Throwable)throwable);
            }
        }
        return dataMap;
    }

    private static BasePersistence<?> _getBasePersistence(PersistedModelLocalService persistedModelLocalService) {
        while (true) {
            Class<?> clazz;
            if (ProxyUtil.isProxyClass(persistedModelLocalService.getClass())) {
                InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)persistedModelLocalService);
                clazz = invocationHandler.getClass();
                String className = clazz.getName();
                if (className.equals("com.liferay.portal.spring.aop.AopInvocationHandler")) {
                    persistedModelLocalService = (PersistedModelLocalService)ReflectionTestUtil.getFieldValue((Object)invocationHandler, (String)"_target");
                    continue;
                }
                if (invocationHandler instanceof ClassLoaderBeanHandler) {
                    ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
                    persistedModelLocalService = (PersistedModelLocalService)classLoaderBeanHandler.getBean();
                    continue;
                }
            }
            if (!(persistedModelLocalService instanceof ServiceWrapper)) break;
            ServiceWrapper serviceWrapper = (ServiceWrapper)persistedModelLocalService;
            clazz = serviceWrapper.getClass();
            String simpleName = clazz.getSimpleName();
            if (simpleName.startsWith("Modular")) {
                return null;
            }
            persistedModelLocalService = (PersistedModelLocalService)serviceWrapper.getWrappedService();
        }
        Class<?> clazz = persistedModelLocalService.getClass();
        Deprecated deprecated = clazz.getAnnotation(Deprecated.class);
        if (deprecated != null) {
            return null;
        }
        return persistedModelLocalService.getBasePersistence();
    }

    private static Map<String, PersistedModelLocalService> _getPersistedModelLocalServices() {
        HashMap<String, PersistedModelLocalService> scrubbedPersistedModelLocalServices = new HashMap<String, PersistedModelLocalService>();
        Map persistedModelLocalServices = (Map)ReflectionTestUtil.getFieldValue((Object)PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalServiceRegistry(), (String)"_persistedModelLocalServices");
        for (Map.Entry entry : persistedModelLocalServices.entrySet()) {
            String className = (String)entry.getKey();
            if (className.indexOf(35) != -1) continue;
            scrubbedPersistedModelLocalServices.put(className, (PersistedModelLocalService)entry.getValue());
        }
        return scrubbedPersistedModelLocalServices;
    }

    private static String _getSymbolicName(ClassLoader classLoader) {
        if (classLoader instanceof BundleReference) {
            BundleReference bundleReference = (BundleReference)classLoader;
            Bundle bundle = bundleReference.getBundle();
            return bundle.getSymbolicName();
        }
        return null;
    }

    private static Closeable _installTransactionExecutor(String originBundleSymbolicName) throws Exception {
        if (originBundleSymbolicName == null) {
            return () -> {};
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        Class<?> clazz = classLoader.loadClass("com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal");
        Field field = clazz.getDeclaredField("_transactionExecutorThreadLocal");
        field.setAccessible(true);
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        Object[] serviceReferences = bundleContext.getAllServiceReferences("com.liferay.portal.spring.transaction.TransactionExecutor", "(origin.bundle.symbolic.name=" + originBundleSymbolicName + ")");
        if (serviceReferences == null) {
            return () -> {};
        }
        Assert.assertEquals((String)StringBundler.concat((String[])new String[]{"Expected 1 TransactionExecutor for ", originBundleSymbolicName, ", actually have ", Arrays.toString(serviceReferences)}), (long)1L, (long)serviceReferences.length);
        Object serviceReference = serviceReferences[0];
        Object portletTransactionExecutor = bundleContext.getService((ServiceReference)serviceReference);
        ThreadLocal transactionExecutorsThreadLocal = (ThreadLocal)field.get(null);
        Deque transactionExecutors = (Deque)transactionExecutorsThreadLocal.get();
        if (portletTransactionExecutor == transactionExecutors.peek()) {
            return () -> {};
        }
        transactionExecutors.push(portletTransactionExecutor);
        return () -> DataGuardTestRuleUtil.lambda$_installTransactionExecutor$5(transactionExecutors, bundleContext, (ServiceReference)serviceReference);
    }

    private static Closeable _removeSessionFactoryVerifier(BasePersistence<?> basePersistence) {
        SessionFactory originalSessionFactory = (SessionFactory)ReflectionTestUtil.getFieldValue(basePersistence, (String)"_sessionFactory");
        Class<?> clazz = originalSessionFactory.getClass();
        if (!Objects.equals(clazz.getName(), "com.liferay.portal.dao.orm.hibernate.VerifySessionFactoryWrapper")) {
            return () -> {};
        }
        SessionFactory sessionFactory = (SessionFactory)ReflectionTestUtil.getFieldValue((Object)originalSessionFactory, (String)"_sessionFactoryImpl");
        ReflectionTestUtil.setFieldValue(basePersistence, (String)"_sessionFactory", (Object)sessionFactory);
        return () -> ReflectionTestUtil.setFieldValue((Object)basePersistence, (String)"_sessionFactory", (Object)originalSessionFactory);
    }

    private static /* synthetic */ void lambda$_installTransactionExecutor$5(Deque transactionExecutors, BundleContext bundleContext, ServiceReference serviceReference) throws IOException {
        transactionExecutors.pop();
        bundleContext.ungetService(serviceReference);
    }

    private static class RecordingSessionWrapper
    extends SessionWrapper {
        private final Map<String, Map<Serializable, String>> _records;

        public void delete(Object object) throws ORMException {
            super.delete(object);
            BaseModel baseModel = (BaseModel)object;
            Map<Serializable, String> map = this._records.get(baseModel.getModelClassName());
            if (map != null) {
                map.remove(baseModel.getPrimaryKeyObj());
            }
        }

        public Serializable save(Object object) throws ORMException {
            this._record(object);
            return super.save(object);
        }

        public void saveOrUpdate(Object object) throws ORMException {
            this._record(object);
            super.saveOrUpdate(object);
        }

        private RecordingSessionWrapper(Session session, Map<String, Map<Serializable, String>> records) {
            super(session);
            this._records = records;
        }

        private void _record(Object object) {
            BaseModel baseModel = (BaseModel)object;
            if (baseModel.isNew()) {
                Map map = this._records.computeIfAbsent(baseModel.getModelClassName(), className -> new ConcurrentHashMap());
                Thread currentThread = Thread.currentThread();
                UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                unsyncStringWriter.write("Thread name : ");
                unsyncStringWriter.write(currentThread.getName());
                unsyncStringWriter.write(", id : ");
                unsyncStringWriter.write(String.valueOf(currentThread.getId()));
                unsyncStringWriter.write(", created : ");
                unsyncStringWriter.write(baseModel.toString());
                unsyncStringWriter.write(" at \n");
                Exception exception = new Exception();
                exception.printStackTrace((PrintWriter)new UnsyncPrintWriter((Writer)unsyncStringWriter));
                map.put(baseModel.getPrimaryKeyObj(), unsyncStringWriter.toString());
            }
        }
    }

    private static class RecordingSessionCustomizer
    implements SessionCustomizer {
        private final Map<String, Map<Serializable, String>> _records;

        public Session customize(Session session) {
            return new RecordingSessionWrapper(session, this._records);
        }

        private RecordingSessionCustomizer(Map<String, Map<Serializable, String>> records) {
            this._records = records;
        }
    }

    public static class DataBag {
        private final Map<String, List<BaseModel<?>>> _dataMap;
        private final List<Portlet> _portlets;
        private final Map<String, Map<Serializable, String>> _records;
        private final ServiceRegistration<SessionCustomizer> _serviceRegistration;

        private DataBag(Map<String, List<BaseModel<?>>> dataMap, List<Portlet> portlets, Map<String, Map<Serializable, String>> records, ServiceRegistration<SessionCustomizer> serviceRegistration) {
            this._dataMap = dataMap;
            this._portlets = portlets;
            this._records = records;
            this._serviceRegistration = serviceRegistration;
        }
    }
}

