/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner;

import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.runner.PoshiRunner;
import com.liferay.poshi.runner.junit.ParallelParameterized;
import com.liferay.poshi.runner.logger.ParallelPrintStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=ParallelParameterized.class)
public class ParallelPoshiRunner
extends PoshiRunner {
    public static ParallelPrintStream systemErrParallelPrintStream = new ParallelPrintStream(System.err);
    public static ParallelPrintStream systemOutParallelPrintStream = new ParallelPrintStream(System.out);
    private static final Map<String, List<String>> _testResults = new HashMap<String, List<String>>();

    @AfterClass
    public static void evaluateResults() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> testResult : _testResults.entrySet()) {
            List<String> testResultMessages = testResult.getValue();
            if (testResultMessages.size() == 1) continue;
            int passes = Collections.frequency(testResultMessages, "PASS");
            int failures = testResultMessages.size() - passes;
            if (passes <= 0 || failures <= 0) continue;
            sb.append("\n");
            sb.append(testResult.getKey());
        }
        if (sb.length() != 0) {
            FileUtil.write((String)(FileUtil.getCanonicalPath((String)".") + "/test-results/flaky-tests"), (String)sb.toString());
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static List<String> getList() throws Exception {
        return PoshiRunner.getList();
    }

    @BeforeClass
    public static void setUpClass() {
        System.setErr(systemErrParallelPrintStream);
        System.setOut(systemOutParallelPrintStream);
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        CustomConsoleHandler customConsoleHandler = new CustomConsoleHandler();
        customConsoleHandler.setOutputStream(systemOutParallelPrintStream);
        rootLogger.addHandler(customConsoleHandler);
    }

    public ParallelPoshiRunner(String namespacedClassCommandName) throws Exception {
        super(namespacedClassCommandName);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        PrintStream originalSystemOutPrintStream = systemOutParallelPrintStream.getOriginalPrintStream();
        originalSystemOutPrintStream.println("Writing log for " + this.getTestNamespacedClassCommandName() + " to " + ParallelPrintStream.getLogFile());
        PoshiProperties.addThreadBasedPoshiProperties();
        super.setUp();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @After
    public void tearDown() throws Throwable {
        try {
            super.tearDown();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            String testName = this.getTestNamespacedClassCommandName();
            testName = testName.replace("#", "_");
            File file = new File("test-results/" + testName + "/console.txt");
            File logFile = ParallelPrintStream.getLogFile();
            if (!file.exists()) {
                Files.copy(logFile.toPath(), file.toPath(), new CopyOption[0]);
            } else {
                FileWriter fileWriter = new FileWriter(file, true);
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(logFile));){
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        fileWriter.write("\n");
                        fileWriter.write(line);
                        fileWriter.flush();
                        line = bufferedReader.readLine();
                    }
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            ParallelPrintStream.resetPrintStream();
        }
    }

    public static class CustomConsoleHandler
    extends ConsoleHandler {
        @Override
        protected void setOutputStream(OutputStream outputStream) throws SecurityException {
            super.setOutputStream(outputStream);
        }
    }
}

