/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner;

import com.liferay.data.guard.connector.client.DataGuardClient;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.PoshiStackTrace;
import com.liferay.poshi.core.PoshiValidation;
import com.liferay.poshi.core.PoshiVariablesContext;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.PoshiRunnerException;
import com.liferay.poshi.runner.PoshiRunnerExecutor;
import com.liferay.poshi.runner.exception.PoshiRunnerWarningException;
import com.liferay.poshi.runner.logger.PoshiLogger;
import com.liferay.poshi.runner.logger.SummaryLogger;
import com.liferay.poshi.runner.selenium.LiferaySeleniumUtil;
import com.liferay.poshi.runner.selenium.WebDriverUtil;
import com.liferay.poshi.runner.util.ProxyUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Element;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.UnreachableBrowserException;

@RunWith(value=Parameterized.class)
public class PoshiRunner {
    @Rule
    public RetryTestRule retryTestRule = new RetryTestRule();
    private static DataGuardClient _dataGuardClient;
    private static long _dataGuardId;
    private static int _jvmRetryCount;
    private static final PoshiProperties _poshiProperties;
    private static final Map<String, List<String>> _testResults;
    private PoshiLogger _poshiLogger;
    private PoshiRunnerExecutor _poshiRunnerExecutor;
    private PoshiStackTrace _poshiStackTrace;
    private SummaryLogger _summaryLogger;
    private final String _testNamespacedClassCommandName;
    private final String _testNamespacedClassName;

    @AfterClass
    public static void evaluateResults() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> testResult : _testResults.entrySet()) {
            List<String> testResultMessages = testResult.getValue();
            if (testResultMessages.size() == 1) continue;
            int passes = Collections.frequency(testResultMessages, "PASS");
            int failures = testResultMessages.size() - passes;
            if (passes <= 0 || failures <= 0) continue;
            sb.append("\n");
            sb.append(testResult.getKey());
        }
        if (sb.length() != 0) {
            FileUtil.write((String)(FileUtil.getCanonicalPath((String)".") + "/test-results/flaky-tests"), (String)sb.toString());
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static List<String> getList() throws Exception {
        ArrayList<String> namespacedClassCommandNames = new ArrayList<String>();
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        List<String> testNames = Arrays.asList(poshiProperties.testName.split("\\s*,\\s*"));
        PoshiContext.readFiles((boolean)false);
        PoshiValidation.validate();
        for (String testName : testNames) {
            PoshiValidation.validate((String)testName);
            String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName((String)testName);
            if (Validator.isNull((String)namespace)) {
                namespace = PoshiContext.getDefaultNamespace();
            }
            if (testName.contains("#")) {
                String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)testName);
                namespacedClassCommandNames.add(namespace + "." + classCommandName);
                continue;
            }
            String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName((String)testName);
            Element rootElement = PoshiContext.getTestCaseRootElement((String)className, (String)namespace);
            List commandElements = rootElement.elements("command");
            for (Element commandElement : commandElements) {
                namespacedClassCommandNames.add(namespace + "." + className + "#" + commandElement.attributeValue("name"));
            }
        }
        return namespacedClassCommandNames;
    }

    public PoshiRunner(String namespacedClassCommandName) throws Exception {
        this._testNamespacedClassCommandName = namespacedClassCommandName;
        this._testNamespacedClassName = PoshiGetterUtil.getNamespacedClassNameFromNamespacedClassCommandName((String)this._testNamespacedClassCommandName);
    }

    public String getTestNamespacedClassCommandName() {
        return this._testNamespacedClassCommandName;
    }

    @Before
    public void setUp() throws Exception {
        System.out.println();
        System.out.println("###");
        System.out.println("### " + this._testNamespacedClassCommandName);
        System.out.println("###");
        System.out.println();
        this._poshiLogger = new PoshiLogger(this._testNamespacedClassCommandName);
        this._summaryLogger = SummaryLogger.getSummaryLogger(this._testNamespacedClassCommandName);
        this._poshiRunnerExecutor = new PoshiRunnerExecutor(this._poshiLogger, this._summaryLogger);
        this._poshiStackTrace = PoshiStackTrace.getPoshiStackTrace((String)this._testNamespacedClassCommandName);
        FileUtil.delete((File)new File(PoshiRunner._poshiProperties.outputDirName));
        try {
            if (PoshiRunner._poshiProperties.liferayDataGuardEnabled.booleanValue()) {
                _dataGuardClient = new DataGuardClient();
                _dataGuardClient.connect();
                _dataGuardId = _dataGuardClient.startCapture();
            }
            this._summaryLogger.startRunning();
            Properties properties = PoshiContext.getNamespacedClassCommandNameProperties((String)this._testNamespacedClassCommandName);
            if (!GetterUtil.getBoolean((String)properties.getProperty("disable-webdriver"))) {
                WebDriverUtil.startWebDriver(this._testNamespacedClassCommandName);
            }
            this._runSetUp();
        }
        catch (WebDriverException webDriverException) {
            webDriverException.printStackTrace();
            throw webDriverException;
        }
        catch (Exception exception) {
            LiferaySeleniumUtil.printJavaProcessStacktrace();
            this._throwException(exception);
        }
    }

    @After
    public void tearDown() throws Throwable {
        this._summaryLogger.createSummaryReport();
        try {
            if (!PoshiRunner._poshiProperties.testSkipTearDown) {
                this._runTearDown();
            }
        }
        catch (Exception exception) {
            PoshiRunnerException poshiRunnerException = new PoshiRunnerException(exception, this._poshiStackTrace);
            this._poshiStackTrace.emptyStackTrace();
            poshiRunnerException.printStackTrace();
            PoshiRunnerWarningException.addException(new PoshiRunnerWarningException("TEAR_DOWN_FAILURE: " + exception.getMessage(), exception));
        }
        finally {
            if (PoshiRunner._poshiProperties.proxyServerEnabled.booleanValue()) {
                ProxyUtil.stopBrowserMobProxy();
            }
            LiferaySeleniumUtil.writePoshiWarnings();
            this._poshiLogger.createPoshiReport();
            WebDriverUtil.stopWebDriver(this._testNamespacedClassCommandName);
            PoshiRunnerWarningException.clear();
            PoshiStackTrace.clear((String)this._testNamespacedClassCommandName);
            PoshiVariablesContext.clear((String)this._testNamespacedClassCommandName);
            SummaryLogger.clear(this._testNamespacedClassCommandName);
        }
        if (!PoshiRunner._poshiProperties.liferayDataGuardEnabled.booleanValue()) {
            return;
        }
        try {
            _dataGuardClient.endCapture(_dataGuardId, this._testNamespacedClassCommandName);
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
            throwable.printStackTrace();
            throw throwable;
        }
        finally {
            _dataGuardClient.close();
        }
    }

    @Test
    public void test() throws Exception {
        try {
            this._runCommand();
            LiferaySeleniumUtil.assertNoPoshiWarnings();
        }
        catch (Exception exception) {
            LiferaySeleniumUtil.printJavaProcessStacktrace();
            this._throwException(exception);
        }
    }

    private void _runCommand() throws Exception {
        this._poshiLogger.logNamespacedClassCommandName(this._testNamespacedClassCommandName);
        this._runNamespacedClassCommandName(this._testNamespacedClassCommandName);
    }

    private void _runNamespacedClassCommandName(String namespacedClassCommandName) throws Exception {
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName((String)namespacedClassCommandName);
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        Element commandElement = PoshiContext.getTestCaseCommandElement((String)classCommandName, (String)namespace);
        if (commandElement != null) {
            this._poshiStackTrace.startStackTrace(namespacedClassCommandName, "test-case");
            this._poshiLogger.updateStatus(commandElement, "pending");
            this._poshiRunnerExecutor.runTestCaseCommandElement(commandElement, namespacedClassCommandName);
            this._poshiLogger.updateStatus(commandElement, "pass");
            this._poshiStackTrace.emptyStackTrace();
        }
    }

    private void _runSetUp() throws Exception {
        this._poshiLogger.logNamespacedClassCommandName(this._testNamespacedClassName + "#set-up");
        this._summaryLogger.startMajorSteps();
        this._runNamespacedClassCommandName(this._testNamespacedClassName + "#set-up");
    }

    private void _runTearDown() throws Exception {
        this._poshiLogger.logNamespacedClassCommandName(this._testNamespacedClassName + "#tear-down");
        this._summaryLogger.startMajorSteps();
        this._runNamespacedClassCommandName(this._testNamespacedClassName + "#tear-down");
    }

    private void _throwException(Exception exception) throws PoshiRunnerException {
        PoshiRunnerException poshiRunnerException = new PoshiRunnerException(exception, this._poshiStackTrace);
        this._poshiStackTrace.emptyStackTrace();
        poshiRunnerException.printStackTrace();
        throw poshiRunnerException;
    }

    static {
        _poshiProperties = PoshiProperties.getPoshiProperties();
        _testResults = new HashMap<String, List<String>>();
    }

    private class RetryTestRule
    implements TestRule {
        private RetryTestRule() {
        }

        public Statement apply(Statement statement, Description description) {
            return new RetryStatement(statement);
        }

        public class RetryStatement
        extends Statement {
            private final Statement _statement;
            private int _testcaseRetryCount;
            private final List<String> _testResultMessages = new ArrayList<String>();
            private final Throwable[] _validRetryThrowables = new Throwable[]{new TimeoutException(), new UnreachableBrowserException(null), new WebDriverException("Timed out waiting 45 seconds for Firefox to start."), new WebDriverException("unknown error: unable to discover open pages")};

            public RetryStatement(Statement statement) {
                this._statement = statement;
            }

            public void evaluate() throws Throwable {
                while (true) {
                    try {
                        this._statement.evaluate();
                        this._testResultMessages.add("PASS");
                        _testResults.put(PoshiRunner.this._testNamespacedClassCommandName, this._testResultMessages);
                        return;
                    }
                    catch (Throwable throwable) {
                        this._testResultMessages.add(throwable.getMessage());
                        if (!this._isRetryable(throwable)) {
                            _testResults.put(PoshiRunner.this._testNamespacedClassCommandName, this._testResultMessages);
                            throw throwable;
                        }
                        _jvmRetryCount++;
                        ++this._testcaseRetryCount;
                        System.out.println("Retrying test attempt " + this._testcaseRetryCount + " of " + _poshiProperties.testTestcaseMaxRetries);
                        continue;
                    }
                    break;
                }
            }

            private String _getShortMessage(Throwable throwable) {
                String message = throwable.getMessage();
                if (throwable instanceof WebDriverException) {
                    int index = message.indexOf("Build info:");
                    message = message.substring(0, index);
                    message = message.trim();
                }
                return message;
            }

            private boolean _isKnownFlakyIssue(Throwable throwable1) {
                List<Throwable> throwables = null;
                if (throwable1 instanceof MultipleFailureException) {
                    MultipleFailureException multipleFailureException = (MultipleFailureException)throwable1;
                    throwables = multipleFailureException.getFailures();
                } else {
                    throwables = Arrays.asList(throwable1);
                }
                for (Throwable validRetryThrowable : this._validRetryThrowables) {
                    Class<?> validRetryThrowableClass = validRetryThrowable.getClass();
                    String validRetryThrowableShortMessage = this._getShortMessage(validRetryThrowable);
                    for (Throwable throwable2 : throwables) {
                        if (!validRetryThrowableClass.equals(throwable2.getClass()) || validRetryThrowableShortMessage != null && !validRetryThrowableShortMessage.isEmpty() && !validRetryThrowableShortMessage.equals(this._getShortMessage(throwable2))) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean _isRetryable(Throwable throwable) {
                if (_jvmRetryCount >= _poshiProperties.testJVMMaxRetries) {
                    System.out.println("Test retry attempts exceeded in Poshi Runner JVM");
                    return false;
                }
                return this._isKnownFlakyIssue(throwable) || this._isTestcaseRetryable();
            }

            private boolean _isTestcaseRetryable() {
                return this._testcaseRetryCount < _poshiProperties.testTestcaseMaxRetries && !_poshiProperties.testSkipTearDown && _poshiProperties.testTestcaseMaxRetries != 0;
            }
        }
    }
}

