/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiValidation;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.runner.PoshiRunner;
import com.liferay.poshi.runner.PoshiRunnerConsoleEvaluator;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import org.junit.runner.JUnitCore;

public class PoshiRunnerCommandExecutor {
    public static void main(String[] args) throws Exception {
        String command = null;
        command = args.length < 1 ? "help" : args[0];
        if (command.equals("evaluatePoshiConsole")) {
            PoshiRunnerCommandExecutor.populateSystemProperties();
            PoshiRunnerCommandExecutor.evaluatePoshiConsole();
        } else if (command.equals("executePQLQuery")) {
            PoshiRunnerCommandExecutor.populateSystemProperties();
            PoshiRunnerCommandExecutor.executePQLQuery();
        } else if (command.equals("help")) {
            PoshiRunnerCommandExecutor.commandHelp();
        } else if (command.equals("runPoshi")) {
            PoshiRunnerCommandExecutor.populateSystemProperties();
            PoshiRunnerCommandExecutor.runPoshi(args);
        } else if (command.equals("validatePoshi")) {
            PoshiRunnerCommandExecutor.populateSystemProperties();
            PoshiRunnerCommandExecutor.validatePoshi();
        } else if (command.equals("writePoshiProperties")) {
            PoshiRunnerCommandExecutor.populateSystemProperties();
            PoshiRunnerCommandExecutor.writePoshiProperties();
        } else {
            System.out.println("Unrecognized command name: " + command);
            PoshiRunnerCommandExecutor.commandHelp();
        }
    }

    protected static void commandHelp() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: PoshiRunnerCommandExecutor <command> <args>\n");
        sb.append("\n");
        sb.append("command options include:\n");
        sb.append("\tevaluatePoshiConsole\tEvaluate the console output errors.\n");
        sb.append("\texecutePQLQuery\t\tPrints test commands found by the query.\n");
        sb.append("\trunPoshi\t\tExecute tests using Poshi Runner.\n");
        sb.append("\tvalidatePoshi\t\tValidates the Poshi files syntax.\n");
        sb.append("\twritePoshiProperties\tWrite the Poshi properties files.\n");
        System.out.println(sb.toString());
    }

    protected static void evaluatePoshiConsole() throws Exception {
        System.out.println("Executing task: evaluatePoshiConsole");
        PoshiRunnerConsoleEvaluator.main(null);
    }

    protected static void executePQLQuery() throws Exception {
        System.out.println("Executing task: executePQLQuery");
        for (String classCommandName : PoshiContext.executePQLQuery()) {
            System.out.println(classCommandName);
        }
    }

    protected static void populateSystemProperties() throws Exception {
        Properties systemProperties = System.getProperties();
        String poshiRunnerExtPropertyFileNames = systemProperties.getProperty("poshiRunnerExtPropertyFileNames");
        if (poshiRunnerExtPropertyFileNames != null) {
            for (String poshiRunnerExtPropertyFileName : poshiRunnerExtPropertyFileNames.split(",")) {
                if (!FileUtil.exists((String)poshiRunnerExtPropertyFileName)) continue;
                try (FileInputStream inputStream = new FileInputStream(poshiRunnerExtPropertyFileName);){
                    systemProperties.load(inputStream);
                }
            }
        }
    }

    protected static void printSystemProperties() throws Exception {
        Properties systemProperties = System.getProperties();
        for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
            System.out.println(entry);
        }
    }

    protected static void runPoshi(String[] args) throws Exception {
        System.out.println("Executing task: runPoshi");
        JUnitCore.runClasses((Class[])new Class[]{PoshiRunner.class});
    }

    protected static void validatePoshi() throws Exception {
        System.out.println("Executing task: validatePoshi");
        PoshiValidation.main(null);
    }

    protected static void writePoshiProperties() throws Exception {
        System.out.println("Executing task: writePoshiProperties");
        PoshiContext.main(null);
    }
}

