/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner;

import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.runner.selenium.LiferaySeleniumUtil;
import java.io.BufferedReader;
import java.io.StringReader;

public class PoshiRunnerConsoleEvaluator {
    private static final String _TEST_CONSOLE_SHUT_DOWN_FILE_NAME;
    private static final String _TEST_POSHI_WARNINGS_FILE_NAME;

    public static void main(String[] args) throws Exception {
        if (!FileUtil.exists((String)_TEST_CONSOLE_SHUT_DOWN_FILE_NAME)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (FileUtil.exists((String)_TEST_POSHI_WARNINGS_FILE_NAME)) {
            String poshiWarningsFileContent = FileUtil.read((String)_TEST_POSHI_WARNINGS_FILE_NAME);
            sb.append(poshiWarningsFileContent.trim());
        }
        String consoleShutDownFileContent = FileUtil.read((String)_TEST_CONSOLE_SHUT_DOWN_FILE_NAME);
        StringReader stringReader = new StringReader(consoleShutDownFileContent);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (LiferaySeleniumUtil.isIgnorableErrorLine(line)) continue;
            if (line.contains("ERROR") || line.contains("SEVERE")) {
                sb.append("\n<value><![CDATA[SHUT_DOWN_ERROR: ");
                sb.append(line.trim());
                sb.append("]]></value>");
                continue;
            }
            if (!line.contains("WARN")) continue;
            sb.append("\n<value><![CDATA[SHUT_DOWN_WARNING: ");
            sb.append(line.trim());
            sb.append("]]></value>");
        }
        String poshiWarningsFileContent = sb.toString();
        FileUtil.write((String)_TEST_POSHI_WARNINGS_FILE_NAME, (String)poshiWarningsFileContent.trim());
    }

    static {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        _TEST_CONSOLE_SHUT_DOWN_FILE_NAME = poshiProperties.testLiferayConsoleShutDownFileName;
        _TEST_POSHI_WARNINGS_FILE_NAME = poshiProperties.testPoshiWarningsFileName;
    }
}

