/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner;

import com.liferay.poshi.core.PoshiStackTrace;
import com.liferay.poshi.core.util.PoshiProperties;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class PoshiRunnerException
extends Exception {
    private final StackTraceElement[] _poshiStackTraceElements;

    public PoshiRunnerException(Exception exception, PoshiStackTrace poshiStackTrace) {
        super(exception);
        this._poshiStackTraceElements = poshiStackTrace.getStackTrace();
    }

    @Override
    public String getLocalizedMessage() {
        Throwable throwable = this.getCause();
        return throwable.getLocalizedMessage();
    }

    @Override
    public String getMessage() {
        Throwable throwable = this.getCause();
        return throwable.getMessage();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        Throwable throwable = this.getCause();
        ArrayList stackTraceElements = new ArrayList();
        Collections.addAll(stackTraceElements, this._poshiStackTraceElements);
        Collections.addAll(stackTraceElements, throwable.getStackTrace());
        return stackTraceElements.toArray(new StackTraceElement[0]);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        this._printStackTrace(new WrappedPrintStream(printStream));
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        this._printStackTrace(new WrappedPrintWriter(printWriter));
    }

    @Override
    public String toString() {
        Throwable throwable = this.getCause();
        return throwable.toString();
    }

    private void _printStackTrace(PrintStreamOrWriter printStreamOrWriter) {
        Throwable throwable = this.getCause();
        printStreamOrWriter.println(throwable);
        for (StackTraceElement stackTraceElement : this.getStackTrace()) {
            printStreamOrWriter.println("\tat " + stackTraceElement);
        }
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (poshiProperties.debugStacktrace.booleanValue()) {
            super.printStackTrace();
        }
    }

    private static class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter _printWriter;

        public WrappedPrintWriter(PrintWriter printWriter) {
            this._printWriter = printWriter;
        }

        @Override
        public void println(Object object) {
            this._printWriter.println(object);
        }
    }

    private static class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream _printStream;

        public WrappedPrintStream(PrintStream printStream) {
            this._printStream = printStream;
        }

        @Override
        public void println(Object object) {
            this._printStream.println(object);
        }
    }

    private static abstract class PrintStreamOrWriter {
        private PrintStreamOrWriter() {
        }

        public abstract void println(Object var1);
    }
}

