/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.PoshiStackTrace;
import com.liferay.poshi.core.PoshiVariablesContext;
import com.liferay.poshi.core.selenium.LiferaySelenium;
import com.liferay.poshi.core.selenium.LiferaySeleniumMethod;
import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.exception.PoshiRunnerWarningException;
import com.liferay.poshi.runner.logger.PoshiLogger;
import com.liferay.poshi.runner.logger.SummaryLogger;
import com.liferay.poshi.runner.selenium.WebDriverUtil;
import com.liferay.poshi.runner.util.TableUtil;
import com.liferay.poshi.runner.var.type.DefaultTable;
import com.liferay.poshi.runner.var.type.TableFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Element;
import org.openqa.selenium.StaleElementReferenceException;

public class PoshiRunnerExecutor {
    private static final Pattern _locatorKeyPattern = Pattern.compile("((?<namespace>[\\w]+)\\.)?(\\w+)#(\\$\\{\\w+\\}|[A-Z0-9_]+)");
    private static final Pattern _parameterPattern = Pattern.compile("('([^'\\\\]|\\\\.)*'|[^',\\s]+)");
    private static final Pattern _variablePattern = Pattern.compile("\\$\\{([^}]*)\\}");
    private Element _functionExecuteElement;
    private String _functionWarningMessage;
    private boolean _hasBreak;
    private boolean _hasContinue;
    private boolean _inLoop;
    private Object _macroReturnValue;
    private final PoshiLogger _poshiLogger;
    private final PoshiProperties _poshiProperties;
    private final PoshiStackTrace _poshiStackTrace;
    private final PoshiVariablesContext _poshiVariablesContext;
    private Object _returnObject;
    private final SummaryLogger _summaryLogger;
    private final String _testNamespacedClassCommandName;

    public PoshiRunnerExecutor(PoshiLogger poshiLogger, SummaryLogger summaryLogger) {
        this._poshiLogger = poshiLogger;
        this._summaryLogger = summaryLogger;
        this._testNamespacedClassCommandName = poshiLogger.getTestNamespacedClassCommandName();
        this._poshiProperties = PoshiProperties.getPoshiProperties();
        this._poshiStackTrace = PoshiStackTrace.getPoshiStackTrace((String)this._testNamespacedClassCommandName);
        this._poshiVariablesContext = PoshiVariablesContext.getPoshiVariablesContext((String)this._testNamespacedClassCommandName);
    }

    public boolean evaluateConditionalElement(Element element) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        boolean conditionalValue = false;
        String elementName = element.getName();
        if (elementName.equals("and")) {
            List andElements = element.elements();
            conditionalValue = true;
            for (Element andElement : andElements) {
                if (conditionalValue) {
                    conditionalValue = this.evaluateConditionalElement(andElement);
                }
                if (conditionalValue) continue;
                break;
            }
        } else if (elementName.equals("condition")) {
            if (element.attributeValue("function") != null) {
                this.runFunctionExecuteElement(element);
                conditionalValue = (Boolean)this._returnObject;
            } else if (element.attributeValue("selenium") != null) {
                this.runSeleniumElement(element);
                conditionalValue = (Boolean)this._returnObject;
            }
        } else if (elementName.equals("contains")) {
            String substring;
            String string = this._poshiVariablesContext.getReplacedCommandVarsString(element.attributeValue("string"));
            if (string.contains(substring = this._poshiVariablesContext.getReplacedCommandVarsString(element.attributeValue("substring")))) {
                conditionalValue = true;
            }
        } else if (elementName.equals("equals")) {
            String arg2;
            String arg1 = this._poshiVariablesContext.getReplacedCommandVarsString(element.attributeValue("arg1"));
            if (arg1.equals(arg2 = this._poshiVariablesContext.getReplacedCommandVarsString(element.attributeValue("arg2")))) {
                conditionalValue = true;
            }
        } else if (elementName.equals("isset")) {
            if (this._poshiVariablesContext.containsKeyInCommandMap(element.attributeValue("var"))) {
                conditionalValue = true;
            }
        } else if (elementName.equals("or")) {
            List orElements = element.elements();
            for (Element orElement : orElements) {
                if (!conditionalValue) {
                    conditionalValue = this.evaluateConditionalElement(orElement);
                }
                if (!conditionalValue) continue;
                break;
            }
        } else if (elementName.equals("not")) {
            List notElements = element.elements();
            Element notElement = (Element)notElements.get(0);
            boolean bl = conditionalValue = !this.evaluateConditionalElement(notElement);
        }
        if (conditionalValue) {
            this._poshiLogger.updateStatus(element, "pass");
        } else {
            this._poshiLogger.updateStatus(element, "conditional-fail");
        }
        return conditionalValue;
    }

    public void evaluateLoopElement(Element element) {
        if (this._inLoop) {
            String elementName = element.getName();
            if (elementName.equals("break")) {
                this._hasBreak = true;
            }
            if (elementName.equals("continue")) {
                this._hasContinue = true;
            }
        }
    }

    public String getTestNamespacedClassCommandName() {
        return this._testNamespacedClassCommandName;
    }

    public boolean isOcularFunction(Element functionCommandElement) {
        List executeElements = functionCommandElement.elements("execute");
        for (Element executeElement : executeElements) {
            String seleniumAttributeValue = executeElement.attributeValue("selenium");
            if (seleniumAttributeValue == null || !seleniumAttributeValue.startsWith("ocularAssertElementImage")) continue;
            return true;
        }
        return false;
    }

    public void parseElement(Element element) throws Exception {
        List childElements = element.elements();
        for (Element childElement : childElements) {
            String childElementName;
            if (this._inLoop) {
                if (this._hasBreak) {
                    return;
                }
                if (this._hasContinue) continue;
            }
            if ((childElementName = childElement.getName()).equals("break") || childElementName.equals("continue")) {
                this.evaluateLoopElement(childElement);
                continue;
            }
            if (childElementName.equals("echo") || childElementName.equals("description")) {
                this.runEchoElement(childElement);
                continue;
            }
            if (childElementName.equals("execute")) {
                if (childElement.attributeValue("function") != null) {
                    this.runFunctionExecuteElement(childElement);
                    continue;
                }
                if (childElement.attributeValue("macro") != null) {
                    this.runMacroExecuteElement(childElement, "macro");
                    continue;
                }
                if (childElement.attributeValue("selenium") != null) {
                    this.runSeleniumElement(childElement);
                    continue;
                }
                if (childElement.attributeValue("test-case") != null) {
                    this.runTestCaseExecuteElement(childElement);
                    continue;
                }
                if (childElement.attributeValue("method") == null) continue;
                this.runMethodExecuteElement(childElement);
                continue;
            }
            if (childElementName.equals("if")) {
                this.runIfElement(childElement);
                continue;
            }
            if (childElementName.equals("fail")) {
                this.runFailElement(childElement);
                continue;
            }
            if (childElementName.equals("for")) {
                this.runForElement(childElement);
                continue;
            }
            if (childElementName.equals("return")) {
                this.runReturnElement(childElement);
                continue;
            }
            if (childElementName.equals("take-screenshot")) {
                this.runTakeScreenshotElement(childElement);
                continue;
            }
            if (childElementName.equals("task")) {
                this.runTaskElement(childElement);
                continue;
            }
            if (childElementName.equals("var")) {
                this.runCommandVarElement(childElement, true);
                continue;
            }
            if (!childElementName.equals("while")) continue;
            this.runWhileElement(childElement);
        }
    }

    public void runCommandVarElement(Element element, boolean updateLoggerStatus) throws Exception {
        String staticValue;
        Matcher matcher;
        this._poshiStackTrace.setCurrentElement(element);
        Object varValue = null;
        try {
            varValue = this._getVarValue(element);
        }
        catch (Exception exception) {
            if (updateLoggerStatus) {
                if (Validator.isNotNull((String)element.attributeValue("method"))) {
                    this._poshiLogger.startCommand(element);
                    this._summaryLogger.startSummary(element);
                    this._summaryLogger.failSummary(element, exception.getMessage(), this._poshiLogger.getDetailsLinkId());
                    this._poshiLogger.failCommand(element);
                }
                this._poshiLogger.updateStatus(element, "fail");
            }
            throw exception;
        }
        if (varValue instanceof String && (varValue = this._poshiVariablesContext.replaceCommandVars((String)varValue)) instanceof String && (matcher = _variablePattern.matcher((String)varValue)).matches()) {
            if (updateLoggerStatus) {
                this._poshiLogger.updateStatus(element, "pass");
            }
            return;
        }
        String varName = element.attributeValue("name");
        this._poshiVariablesContext.putIntoCommandMap(varName, varValue);
        String currentFilePath = this._poshiStackTrace.getCurrentFilePath();
        if ((currentFilePath.contains(".macro") || currentFilePath.contains(".testcase")) && (staticValue = element.attributeValue("static")) != null && staticValue.equals("true")) {
            this._poshiVariablesContext.putIntoStaticMap(varName, varValue);
        }
        if (updateLoggerStatus) {
            this._poshiLogger.updateStatus(element, "pass");
        }
    }

    public void runEchoElement(Element element) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        this._poshiLogger.logMessage(element);
        String message = element.attributeValue("message");
        if (message == null) {
            message = element.getText();
        }
        message = StringEscapeUtils.unescapeXml((String)message);
        System.out.println(this._poshiVariablesContext.replaceCommandVars(message));
    }

    public void runExecuteVarElement(Element element, boolean updateLoggerStatus) throws Exception {
        Matcher matcher;
        this._poshiStackTrace.setCurrentElement(element);
        String varName = element.attributeValue("name");
        if (this._poshiVariablesContext.containsKeyInStaticMap(varName)) {
            if (updateLoggerStatus) {
                this._poshiLogger.updateStatus(element, "fail");
            }
            throw new Exception("Unable to set var '" + varName + "' as parameter of function. It is already set in the static context.");
        }
        Object varValue = null;
        try {
            varValue = this._getVarValue(element);
        }
        catch (Exception exception) {
            if (updateLoggerStatus) {
                this._poshiLogger.updateStatus(element, "fail");
            }
            throw exception;
        }
        if (varValue instanceof String && (varValue = this._poshiVariablesContext.replaceCommandVars((String)varValue)) instanceof String && (varValue = this._poshiVariablesContext.replaceExecuteVars((String)varValue)) instanceof String && (matcher = _variablePattern.matcher((String)varValue)).matches() && varValue.equals(varValue)) {
            if (updateLoggerStatus) {
                this._poshiLogger.updateStatus(element, "pass");
            }
            return;
        }
        this._poshiVariablesContext.putIntoExecuteMap(varName, varValue);
        if (updateLoggerStatus) {
            this._poshiLogger.updateStatus(element, "pass");
        }
    }

    public void runFailElement(Element element) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        this._poshiLogger.logMessage(element);
        String message = element.attributeValue("message");
        this._poshiLogger.updateStatus(element, "fail");
        if (Validator.isNotNull((String)message)) {
            throw new Exception(this._poshiVariablesContext.getReplacedCommandVarsString(message));
        }
        throw new Exception();
    }

    public void runForElement(Element element) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        this._inLoop = true;
        String paramName = this._poshiVariablesContext.getReplacedCommandVarsString(element.attributeValue("param"));
        if (element.attributeValue("list") != null) {
            String[] paramValues;
            String list = this._poshiVariablesContext.getReplacedCommandVarsString(element.attributeValue("list"));
            for (String paramValue : paramValues = list.split(",")) {
                this._poshiVariablesContext.putIntoCommandMap(paramName, (Object)paramValue);
                this.parseElement(element);
                if (this._hasContinue) {
                    this._hasContinue = false;
                    continue;
                }
                if (!this._hasBreak) continue;
                this._hasBreak = false;
                break;
            }
        } else if (element.attributeValue("table") != null) {
            DefaultTable defaultTable = (DefaultTable)this._poshiVariablesContext.replaceCommandVars(element.attributeValue("table"));
            List<List<String>> rows = defaultTable.getRows();
            Iterator<List<String>> iterator = rows.iterator();
            while (iterator.hasNext()) {
                this._poshiVariablesContext.putIntoCommandMap(paramName, iterator.next());
                this.parseElement(element);
            }
        }
        this._inLoop = false;
        this._poshiLogger.updateStatus(element, "pass");
    }

    public void runFunctionCommandElement(Element commandElement) throws Exception {
        this._poshiStackTrace.setCurrentElement(commandElement);
        this._poshiVariablesContext.pushCommandMap();
        try {
            this.parseElement(commandElement);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this._poshiVariablesContext.popCommandMap();
        }
    }

    public void runFunctionExecuteElement(Element executeElement) throws Exception {
        if (this._functionExecuteElement == null) {
            this._functionExecuteElement = executeElement;
        }
        this._poshiStackTrace.setCurrentElement(executeElement);
        List executeVarElements = executeElement.elements("var");
        for (Element executeVarElement : executeVarElements) {
            this.runExecuteVarElement(executeVarElement, false);
        }
        this._poshiStackTrace.setCurrentElement(executeElement);
        String namespacedClassCommandName = executeElement.attributeValue("function");
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        Exception exception = null;
        for (int i = 1; i <= PoshiContext.getFunctionMaxArgumentCount(); ++i) {
            Object value;
            String locator = executeElement.attributeValue("locator" + i);
            if (locator == null) {
                locator = (String)this._poshiVariablesContext.getObjectFromCommandMap("locator" + i);
            }
            if (locator != null) {
                Matcher matcher = _locatorKeyPattern.matcher(locator);
                if (matcher.find() && !locator.contains("/")) {
                    String pathClassName = this._poshiVariablesContext.getReplacedCommandVarsString(PoshiGetterUtil.getClassNameFromNamespacedClassCommandName((String)locator));
                    String locatorKey = this._poshiVariablesContext.getReplacedCommandVarsString(PoshiGetterUtil.getCommandNameFromNamespacedClassCommandName((String)locator));
                    this._poshiVariablesContext.putIntoExecuteMap("locator-key" + i, (Object)locatorKey);
                    locator = PoshiContext.getPathLocator((String)(pathClassName + "#" + locatorKey), (String)this._poshiStackTrace.getNamespaceFromNamespacedClassCommandName(locator));
                    if (locator == null) {
                        exception = new Exception("No such locator key " + pathClassName + "#" + locatorKey);
                    }
                    locator = (String)this._poshiVariablesContext.replaceExecuteVars(locator);
                }
                this._poshiVariablesContext.putIntoExecuteMap("locator" + i, (Object)locator);
            }
            if ((value = executeElement.attributeValue("value" + i)) == null) {
                value = this._poshiVariablesContext.getObjectFromCommandMap("value" + i);
            }
            if (value == null) continue;
            this._poshiVariablesContext.putIntoExecuteMap("value" + i, value);
        }
        if (this._functionExecuteElement == executeElement) {
            this._summaryLogger.startSummary(this._functionExecuteElement);
        }
        this._poshiLogger.startCommand(executeElement);
        this._poshiStackTrace.pushStackTrace(executeElement);
        Element commandElement = PoshiContext.getFunctionCommandElement((String)classCommandName, (String)this._poshiStackTrace.getCurrentNamespace(namespacedClassCommandName));
        try {
            if (exception != null) {
                throw exception;
            }
            this.runFunctionCommandElement(commandElement);
        }
        catch (Throwable throwable) {
            String warningMessage = this._getWarningFromThrowable(throwable);
            if (warningMessage != null) {
                this._functionWarningMessage = warningMessage;
            }
            this._poshiStackTrace.popStackTrace();
            if (this._functionExecuteElement == executeElement) {
                this._poshiStackTrace.setCurrentElement(executeElement);
                this._summaryLogger.failSummary(this._functionExecuteElement, throwable.getMessage(), this._poshiLogger.getDetailsLinkId());
                if (this.isOcularFunction(commandElement)) {
                    this._poshiLogger.ocularCommand(this._functionExecuteElement);
                } else {
                    this._poshiLogger.failCommand(this._functionExecuteElement);
                }
                this._functionExecuteElement = null;
                this._functionWarningMessage = null;
            }
            throw throwable;
        }
        this._poshiStackTrace.popStackTrace();
        this._poshiStackTrace.setCurrentElement(executeElement);
        if (this._functionExecuteElement == executeElement) {
            if (this._functionWarningMessage != null) {
                this._summaryLogger.warnSummary(this._functionExecuteElement, this._functionWarningMessage);
                this._poshiLogger.warnCommand(this._functionExecuteElement);
            } else {
                this._summaryLogger.passSummary(executeElement);
                this._poshiLogger.passCommand(executeElement);
            }
            this._functionExecuteElement = null;
            this._functionWarningMessage = null;
        }
    }

    public void runIfElement(Element element) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        List ifChildElements = element.elements();
        Element ifConditionElement = (Element)ifChildElements.get(0);
        boolean condition = this.evaluateConditionalElement(ifConditionElement);
        if (condition) {
            Element ifThenElement = element.element("then");
            this._poshiStackTrace.setCurrentElement(ifThenElement);
            this.parseElement(ifThenElement);
            this._poshiLogger.updateStatus(ifThenElement, "pass");
            this._poshiLogger.updateStatus(element, "pass");
            return;
        }
        this._poshiLogger.updateStatus(element, "conditional-fail");
        if (element.element("elseif") != null) {
            List elseIfElements = element.elements("elseif");
            for (Element elseIfElement : elseIfElements) {
                this._poshiStackTrace.setCurrentElement(elseIfElement);
                List elseIfChildElements = elseIfElement.elements();
                Element elseIfConditionElement = (Element)elseIfChildElements.get(0);
                condition = this.evaluateConditionalElement(elseIfConditionElement);
                if (condition) {
                    Element elseIfThenElement = elseIfElement.element("then");
                    this._poshiStackTrace.setCurrentElement(elseIfThenElement);
                    this.parseElement(elseIfThenElement);
                    this._poshiLogger.updateStatus(elseIfThenElement, "pass");
                    this._poshiLogger.updateStatus(elseIfElement, "pass");
                    return;
                }
                this._poshiLogger.updateStatus(elseIfElement, "conditional-fail");
            }
        }
        if (element.element("else") != null) {
            Element elseElement = element.element("else");
            this._poshiStackTrace.setCurrentElement(elseElement);
            this.parseElement(elseElement);
            this._poshiLogger.updateStatus(elseElement, "pass");
        }
    }

    public void runMacroCommandElement(Element commandElement, String namespacedClassCommandName) throws Exception {
        this._poshiStackTrace.setCurrentElement(commandElement);
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName((String)classCommandName);
        String namespace = this._poshiStackTrace.getCurrentNamespace(namespacedClassCommandName);
        List rootVarElements = PoshiContext.getRootVarElements((String)"macro", (String)className, (String)namespace);
        for (Element rootVarElement : rootVarElements) {
            if (Validator.isNotNull((String)rootVarElement.attributeValue("static"))) {
                this._poshiVariablesContext.pushStaticVarsIntoCommandMap();
            }
            this.runRootVarElement(rootVarElement, true);
        }
        this._poshiVariablesContext.pushCommandMap();
        if (commandElement == null) {
            throw new RuntimeException("Nonexistent macro command: " + namespacedClassCommandName);
        }
        this.parseElement(commandElement);
        this._poshiVariablesContext.popCommandMap();
    }

    public void runMacroExecuteElement(Element executeElement, String macroType) throws Exception {
        this._poshiStackTrace.setCurrentElement(executeElement);
        String namespacedClassCommandName = executeElement.attributeValue(macroType);
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        List executeVarElements = executeElement.elements("var");
        for (Element executeVarElement : executeVarElements) {
            this.runExecuteVarElement(executeVarElement, false);
        }
        this._poshiStackTrace.pushStackTrace(executeElement);
        String namespace = this._poshiStackTrace.getCurrentNamespace(namespacedClassCommandName);
        this._summaryLogger.startSummary(executeElement);
        Element commandElement = PoshiContext.getMacroCommandElement((String)classCommandName, (String)namespace);
        try {
            this.runMacroCommandElement(commandElement, namespacedClassCommandName);
            Element returnElement = executeElement.element("return");
            if (returnElement != null) {
                if (this._macroReturnValue == null) {
                    throw new RuntimeException("No value was returned from macro command '" + namespacedClassCommandName + "'");
                }
                String returnName = returnElement.attributeValue("name");
                if (this._poshiVariablesContext.containsKeyInStaticMap(returnName)) {
                    this._poshiVariablesContext.putIntoStaticMap(returnName, this._macroReturnValue);
                }
                this._poshiVariablesContext.putIntoCommandMap(returnName, this._macroReturnValue);
                this._macroReturnValue = null;
            }
        }
        catch (Exception exception) {
            this._summaryLogger.failSummary(executeElement, exception.getMessage(), this._poshiLogger.getDetailsLinkId());
            throw exception;
        }
        this._summaryLogger.passSummary(executeElement);
        this._poshiStackTrace.popStackTrace();
        this._poshiLogger.updateStatus(executeElement, "pass");
    }

    public void runMethodExecuteElement(Element executeElement) throws Exception {
        this._poshiStackTrace.setCurrentElement(executeElement);
        ArrayList<String> args = new ArrayList<String>();
        List argElements = executeElement.elements("arg");
        for (Element argElement : argElements) {
            args.add(argElement.attributeValue("value"));
        }
        String className = executeElement.attributeValue("class");
        String methodName = executeElement.attributeValue("method");
        try {
            Object returnValue = PoshiGetterUtil.getMethodReturnValue((String)this.getTestNamespacedClassCommandName(), args, (String)className, (String)methodName, null);
            Element returnElement = executeElement.element("return");
            if (returnElement != null) {
                this._poshiVariablesContext.putIntoCommandMap(returnElement.attributeValue("name"), returnValue);
            }
            this._poshiLogger.logExternalMethodCommand(executeElement, args, returnValue);
        }
        catch (Throwable throwable) {
            this._poshiLogger.startCommand(executeElement);
            this._summaryLogger.startSummary(executeElement);
            this._summaryLogger.failSummary(executeElement, throwable.getMessage(), this._poshiLogger.getDetailsLinkId());
            this._poshiLogger.failCommand(executeElement);
            this._poshiLogger.updateStatus(executeElement, "fail");
            throw throwable;
        }
        this._poshiLogger.updateStatus(executeElement, "pass");
    }

    public void runReturnElement(Element returnElement) throws Exception {
        this._poshiStackTrace.setCurrentElement(returnElement);
        if (returnElement.attributeValue("value") != null) {
            String returnValue = returnElement.attributeValue("value");
            this._macroReturnValue = this._poshiVariablesContext.replaceCommandVars(returnValue);
        }
        this._poshiLogger.updateStatus(returnElement, "pass");
    }

    public void runRootVarElement(Element element, boolean updateLoggerStatus) throws Exception {
        String staticValue;
        String currentFilePath;
        String varName;
        this._poshiStackTrace.setCurrentElement(element);
        Object varValue = null;
        try {
            varValue = this._getVarValue(element);
        }
        catch (Exception exception) {
            if (updateLoggerStatus) {
                this._poshiLogger.updateStatus(element, "fail");
            }
            throw exception;
        }
        if (varValue instanceof String) {
            Matcher matcher;
            varValue = this._poshiVariablesContext.replaceExecuteVars((String)varValue);
            if ((varValue = this._poshiVariablesContext.replaceStaticVars((String)varValue)) instanceof String && (matcher = _variablePattern.matcher((String)varValue)).matches() && varValue.equals(varValue)) {
                if (updateLoggerStatus) {
                    this._poshiLogger.updateStatus(element, "pass");
                }
                return;
            }
        }
        if (!this._poshiVariablesContext.containsKeyInExecuteMap(varName = element.attributeValue("name"))) {
            this._poshiVariablesContext.putIntoExecuteMap(varName, varValue);
        }
        if ((currentFilePath = this._poshiStackTrace.getCurrentFilePath()).contains(".testcase") && (staticValue = element.attributeValue("static")) != null && staticValue.equals("true") && !this._poshiVariablesContext.containsKeyInStaticMap(varName)) {
            this._poshiVariablesContext.putIntoStaticMap(varName, varValue);
        }
        if (updateLoggerStatus) {
            this._poshiLogger.updateStatus(element, "pass");
        }
    }

    public void runSeleniumElement(Element executeElement) throws Exception {
        Properties properties = PoshiContext.getNamespacedClassCommandNameProperties((String)this.getTestNamespacedClassCommandName());
        if (GetterUtil.getBoolean((String)properties.getProperty("disable-webdriver"))) {
            throw new RuntimeException("Unable to call Selenium method while WebDriver is disabled");
        }
        this._poshiStackTrace.setCurrentElement(executeElement);
        String selenium = executeElement.attributeValue("selenium");
        LiferaySeleniumMethod liferaySeleniumMethod = PoshiContext.getLiferaySeleniumMethod((String)selenium);
        ArrayList<Object> arguments = new ArrayList<Object>();
        ArrayList<Class> parameterClasses = new ArrayList<Class>();
        int parameterCount = liferaySeleniumMethod.getParameterCount();
        for (int i = 0; i < parameterCount; ++i) {
            Object argument = executeElement.attributeValue("argument" + (i + 1));
            if (argument == null) {
                List list = liferaySeleniumMethod.getParameterNames();
                String parameterName = (String)list.get(i);
                argument = this._poshiVariablesContext.getObjectFromCommandMap(parameterName);
            } else {
                argument = this._poshiVariablesContext.getReplacedCommandVarsObject((String)argument);
            }
            Class clazz = liferaySeleniumMethod.getParameterTypes()[i];
            if (Objects.equals(clazz.getName(), "java.lang.String") && Validator.isNotNull((Object)argument)) {
                argument = argument.toString();
            }
            arguments.add(argument);
            parameterClasses.add(liferaySeleniumMethod.getParameterTypes()[i]);
        }
        ArrayList<String> argumentsList = new ArrayList<String>();
        for (Object e : arguments) {
            if (e == null) continue;
            argumentsList.add(e.toString());
        }
        this._poshiLogger.logSeleniumCommand(executeElement, argumentsList);
        LiferaySelenium liferaySelenium = WebDriverUtil.getLiferaySelenium(this.getTestNamespacedClassCommandName());
        Class<?> clazz = liferaySelenium.getClass();
        this._returnObject = this.invokeLiferaySeleniumMethod(clazz.getMethod(selenium, parameterClasses.toArray(new Class[0])), arguments.toArray(new Object[0]));
    }

    public void runTakeScreenshotElement(Element element) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        this._poshiLogger.takeScreenshotCommand(element);
    }

    public void runTaskElement(Element element) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        try {
            this._summaryLogger.startSummary(element);
            this.parseElement(element);
        }
        catch (Exception exception) {
            this._summaryLogger.failSummary(element, exception.getMessage(), this._poshiLogger.getDetailsLinkId());
            throw exception;
        }
        this._summaryLogger.passSummary(element);
        this._poshiLogger.updateStatus(element, "pass");
    }

    public void runTestCaseCommandElement(Element element, String namespacedClassCommandName) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName((String)namespacedClassCommandName);
        List rootVarElements = PoshiContext.getRootVarElements((String)"test-case", (String)className, (String)namespace);
        for (Element rootVarElement : rootVarElements) {
            if (Validator.isNotNull((String)rootVarElement.attributeValue("static"))) {
                this._poshiVariablesContext.pushStaticVarsIntoCommandMap();
            }
            this.runRootVarElement(rootVarElement, false);
        }
        this._poshiVariablesContext.pushCommandMap();
        this.parseElement(element);
        this._poshiVariablesContext.popCommandMap();
    }

    public void runTestCaseExecuteElement(Element executeElement) throws Exception {
        this._poshiStackTrace.setCurrentElement(executeElement);
        String namespacedClassCommandName = executeElement.attributeValue("test-case");
        this._poshiStackTrace.pushStackTrace(executeElement);
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName((String)namespacedClassCommandName);
        Element commandElement = PoshiContext.getTestCaseCommandElement((String)namespacedClassCommandName, (String)namespace);
        this.runTestCaseCommandElement(commandElement, namespacedClassCommandName);
        this._poshiStackTrace.popStackTrace();
        this._poshiLogger.updateStatus(executeElement, "pass");
    }

    public void runWhileElement(Element element) throws Exception {
        this._poshiStackTrace.setCurrentElement(element);
        this._inLoop = true;
        int maxIterations = 15;
        if (element.attributeValue("max-iterations") != null) {
            maxIterations = GetterUtil.getInteger((String)element.attributeValue("max-iterations"));
        }
        List whileChildElements = element.elements();
        Element conditionElement = (Element)whileChildElements.get(0);
        Element thenElement = element.element("then");
        boolean conditionRun = false;
        for (int i = 0; i < maxIterations && this.evaluateConditionalElement(conditionElement) && !this._hasBreak; ++i) {
            if (this._hasContinue) continue;
            conditionRun = true;
            this._poshiStackTrace.setCurrentElement(thenElement);
            this.parseElement(thenElement);
            this._poshiLogger.updateStatus(thenElement, "pass");
        }
        this._inLoop = false;
        if (conditionRun) {
            this._poshiLogger.updateStatus(element, "pass");
        } else {
            this._poshiLogger.updateStatus(element, "conditional-fail");
        }
    }

    protected Object callWithTimeout(Callable<?> callable, String description, long timeoutSeconds) throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<?> future = executorService.submit(callable);
        executorService.shutdown();
        try {
            return future.get(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            if (this._poshiProperties.debugStacktrace.booleanValue()) {
                throw executionException;
            }
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
        catch (InterruptedException | TimeoutException exception) {
            future.cancel(true);
            if (exception instanceof TimeoutException) {
                System.out.println("Timed out after " + timeoutSeconds + " seconds while executing " + description);
            }
            throw new Exception("An error occurred while executing " + description, exception);
        }
    }

    protected Object getVarMethodValue(String expression, String defaultNamespace) throws Exception {
        int y;
        ArrayList<String> args = new ArrayList<String>();
        int x = expression.indexOf("(");
        if (x + 1 < (y = expression.lastIndexOf(")"))) {
            String parameterString = expression.substring(x + 1, y);
            Matcher parameterMatcher = _parameterPattern.matcher(parameterString);
            while (parameterMatcher.find()) {
                Matcher matcher;
                String parameterValue = parameterMatcher.group();
                if (parameterValue.startsWith("'") && parameterValue.endsWith("'")) {
                    parameterValue = parameterValue.substring(1, parameterValue.length() - 1);
                }
                if ((matcher = _locatorKeyPattern.matcher(parameterValue)).matches()) {
                    String namespace = matcher.group("namespace");
                    parameterValue = namespace == null ? PoshiContext.getPathLocator((String)parameterValue, (String)defaultNamespace) : PoshiContext.getPathLocator((String)parameterValue, (String)namespace);
                }
                if (parameterValue.contains("'")) {
                    parameterValue = parameterValue.replaceAll("\\\\'", "'");
                }
                args.add(parameterValue);
            }
        }
        y = expression.indexOf("#");
        String className = expression.substring(0, y);
        String methodName = expression.substring(y + 1, x);
        LiferaySelenium object = null;
        if (className.equals("selenium")) {
            object = WebDriverUtil.getLiferaySelenium(this.getTestNamespacedClassCommandName());
        }
        return PoshiGetterUtil.getMethodReturnValue((String)this.getTestNamespacedClassCommandName(), args, (String)className, (String)methodName, (Object)object);
    }

    protected Object invokeLiferaySeleniumMethod(Method method, Object ... args) throws Exception {
        LiferaySelenium liferaySelenium = WebDriverUtil.getLiferaySelenium(this.getTestNamespacedClassCommandName());
        String methodName = method.getName();
        Callable<Object> task = () -> {
            int maxRetries = 1;
            int retryCount = 0;
            while (true) {
                try {
                    return method.invoke((Object)liferaySelenium, args);
                }
                catch (Exception exception) {
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof StaleElementReferenceException && retryCount < maxRetries) {
                        ++retryCount;
                        StringBuilder sb = new StringBuilder();
                        sb.append("\nElement turned stale while running ");
                        sb.append(methodName);
                        sb.append(". Retrying in ");
                        sb.append(this._poshiProperties.testRetryCommandWaitTime);
                        sb.append("seconds.");
                        System.out.println(sb.toString());
                        continue;
                    }
                    if (this._poshiProperties.debugStacktrace.booleanValue()) {
                        throw exception;
                    }
                    if (throwable instanceof Error) {
                        exception = new Exception(throwable.getMessage());
                        exception.setStackTrace(throwable.getStackTrace());
                        throw exception;
                    }
                    throw (Exception)throwable;
                }
                break;
            }
        };
        Long timeout = Long.valueOf(this._poshiProperties.timeoutExplicitWait) + 60L;
        if (methodName.equals("antCommand") | methodName.equals("pause")) {
            timeout = 3600L;
        }
        return this.callWithTimeout(task, methodName, timeout);
    }

    private Object _getVarValue(Element element) throws Exception {
        Object varValue = element.attributeValue("value");
        if (varValue == null) {
            if (element.attributeValue("method") != null) {
                String methodName = element.attributeValue("method");
                try {
                    varValue = this.getVarMethodValue(methodName, this._poshiStackTrace.getCurrentNamespace());
                }
                catch (Exception exception) {
                    Throwable throwable = exception.getCause();
                    if (throwable != null && throwable.getMessage() != null) {
                        throw new Exception(throwable.getMessage(), exception);
                    }
                    throw exception;
                }
            } else if (element.attributeValue("type") != null) {
                String varType = element.attributeValue("type");
                if (varType.equals("Table")) {
                    varValue = TableUtil.getRawDataListFromString(element.getText());
                } else if ((varType.equals("HashesTable") || varType.equals("RawTable") || varType.equals("RowsHashTable")) && element.attributeValue("from") != null) {
                    Object varFrom = this._poshiVariablesContext.replaceCommandVars(element.attributeValue("from"));
                    if (!(varFrom instanceof List)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Variable '");
                        sb.append((String)varFrom);
                        sb.append("' is not an instance of type 'List'");
                        throw new IllegalArgumentException(sb.toString());
                    }
                    varValue = TableFactory.newTable((List)varFrom, varType);
                }
            } else if (element.attributeValue("from") != null) {
                Object varFrom = this._poshiVariablesContext.replaceCommandVars(element.attributeValue("from"));
                if (element.attributeValue("hash") != null) {
                    LinkedHashMap varFromMap = (LinkedHashMap)varFrom;
                    varValue = varFromMap.get(element.attributeValue("hash"));
                } else if (element.attributeValue("index") != null) {
                    List varFromList = (List)varFrom;
                    varValue = varFromList.get(GetterUtil.getInteger((String)element.attributeValue("index")));
                }
            } else {
                varValue = element.getText();
            }
        }
        return varValue;
    }

    private String _getWarningFromThrowable(Throwable throwable) {
        if (throwable instanceof PoshiRunnerWarningException) {
            return throwable.getMessage();
        }
        Throwable causeThrowable = throwable.getCause();
        if (causeThrowable != null) {
            return this._getWarningFromThrowable(causeThrowable);
        }
        return null;
    }
}

