/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.junit;

import com.liferay.poshi.core.util.PoshiProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runners.Parameterized;
import org.junit.runners.model.RunnerScheduler;

public class ParallelParameterized
extends Parameterized {
    public ParallelParameterized(Class<?> clazz) throws Throwable {
        super(clazz);
        this.setScheduler(new ThreadPoolScheduler());
    }

    private static class ThreadPoolScheduler
    implements RunnerScheduler {
        private final ExecutorService _executorService;

        public ThreadPoolScheduler() {
            PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
            this._executorService = Executors.newFixedThreadPool(poshiProperties.testRunThreadPoolSize);
        }

        public void finished() {
            this._executorService.shutdown();
            try {
                this._executorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }

        public void schedule(Runnable childStatement) {
            this._executorService.submit(childStatement);
        }
    }
}

