/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.logger;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiStackTrace;
import com.liferay.poshi.core.PoshiVariablesContext;
import com.liferay.poshi.core.selenium.LiferaySelenium;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.exception.PoshiRunnerLoggerException;
import com.liferay.poshi.runner.logger.LoggerElement;
import com.liferay.poshi.runner.logger.SummaryLogger;
import com.liferay.poshi.runner.logger.SyntaxLogger;
import com.liferay.poshi.runner.selenium.WebDriverUtil;
import com.liferay.poshi.runner.util.HtmlUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.dom4j.Element;

public final class CommandLogger {
    protected LoggerElement lineGroupLoggerElement;
    private int _btnLinkId;
    private Element _commandElement;
    private final LoggerElement _commandLogLoggerElement = new LoggerElement("commandLog");
    private int _detailsLinkId;
    private int _functionLinkId;
    private final PoshiProperties _poshiProperties;
    private final PoshiStackTrace _poshiStackTrace;
    private final PoshiVariablesContext _poshiVariablesContext;
    private final String _testNamespacedClassCommandName;

    public CommandLogger(String testNamespacedClassCommandName) {
        this._commandLogLoggerElement.setAttribute("data-logid", "01");
        this._commandLogLoggerElement.setClassName("collapse command-log");
        this._commandLogLoggerElement.setName("ul");
        this._testNamespacedClassCommandName = testNamespacedClassCommandName;
        this._poshiProperties = PoshiProperties.getPoshiProperties();
        this._poshiStackTrace = PoshiStackTrace.getPoshiStackTrace((String)testNamespacedClassCommandName);
        this._poshiVariablesContext = PoshiVariablesContext.getPoshiVariablesContext((String)testNamespacedClassCommandName);
    }

    public void copyOcularImage(String imageName, String filePath, int detailsLinkId) throws IOException {
        Path sourcePath = Paths.get(this._poshiProperties.testDependenciesDirName + "/ocular/" + imageName + "/" + filePath, new String[0]);
        String testClassCommandName = this.getTestNamespacedClassCommandName();
        testClassCommandName = StringUtil.replace((String)testClassCommandName, (String)"#", (String)"_");
        Path targetPath = Paths.get("test-results/" + testClassCommandName + "/screenshots/" + imageName + detailsLinkId + ".jpg", new String[0]);
        Files.copy(sourcePath, targetPath, new CopyOption[0]);
    }

    public void failCommand(Element element, SyntaxLogger syntaxLogger) throws PoshiRunnerLoggerException {
        if (!this._isCurrentCommand(element)) {
            return;
        }
        try {
            this._commandElement = null;
            this._failLineGroupLoggerElement(this.lineGroupLoggerElement);
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    public String getCommandLogText() {
        return this._commandLogLoggerElement.toString();
    }

    public int getDetailsLinkId() {
        return this._detailsLinkId;
    }

    public String getTestNamespacedClassCommandName() {
        return this._testNamespacedClassCommandName;
    }

    public void logExternalMethodCommand(Element element, List<String> arguments, Object returnValue, SyntaxLogger syntaxLogger) throws Exception {
        this.lineGroupLoggerElement = new LoggerElement();
        this.lineGroupLoggerElement.setClassName("line-group linkable");
        this.lineGroupLoggerElement.setName("li");
        this.lineGroupLoggerElement.addChildLoggerElement(this._getExternalMethodLineLoggerElement(element, arguments, returnValue));
        this._commandLogLoggerElement.addChildLoggerElement(this.lineGroupLoggerElement);
        LoggerElement scriptLoggerElement = syntaxLogger.getSyntaxLoggerElement(this._poshiStackTrace.getSimpleStackTraceMessage());
        this._linkLoggerElements(scriptLoggerElement);
    }

    public void logMessage(Element element, SyntaxLogger syntaxLogger) throws PoshiRunnerLoggerException {
        try {
            this.lineGroupLoggerElement = this._getMessageGroupLoggerElement(element);
            this._commandLogLoggerElement.addChildLoggerElement(this.lineGroupLoggerElement);
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    public void logNamespacedClassCommandName(String namespacedClassCommandName) {
        this._commandLogLoggerElement.addChildLoggerElement(this._getDividerLineLoggerElement(namespacedClassCommandName));
    }

    public void logSeleniumCommand(Element element, List<String> arguments) {
        LoggerElement loggerElement = this.lineGroupLoggerElement.loggerElement("ul");
        loggerElement.addChildLoggerElement(this._getRunLineLoggerElement(element, arguments));
    }

    public void ocularCommand(Element element, SyntaxLogger syntaxLogger) throws PoshiRunnerLoggerException {
        if (!this._isCurrentCommand(element)) {
            return;
        }
        try {
            this._commandElement = null;
            this._ocularLineGroupLoggerElement(element, this.lineGroupLoggerElement);
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    public void passCommand(Element element, SyntaxLogger syntaxLogger) {
        if (!this._isCurrentCommand(element)) {
            return;
        }
        this._commandElement = null;
    }

    public void startCommand(Element element, SyntaxLogger syntaxLogger) throws PoshiRunnerLoggerException {
        if (!this._isCommand(element)) {
            return;
        }
        try {
            this._takeScreenshot("before", this._detailsLinkId);
            this._commandElement = element;
            this.lineGroupLoggerElement = this._getLineGroupLoggerElement(element);
            this._commandLogLoggerElement.addChildLoggerElement(this.lineGroupLoggerElement);
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    public void takeScreenshotCommand(Element element, SyntaxLogger syntaxLogger) throws PoshiRunnerLoggerException {
        try {
            this._takeScreenshot("screenshot", this._detailsLinkId);
            this._commandElement = element;
            this.lineGroupLoggerElement = this._getMessageGroupLoggerElement(element);
            this._commandLogLoggerElement.addChildLoggerElement(this.lineGroupLoggerElement);
            this._commandElement = null;
            this._screenshotLineGroupLoggerElement(this.lineGroupLoggerElement);
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    public void warnCommand(Element element, SyntaxLogger syntaxLogger) throws PoshiRunnerLoggerException {
        if (!this._isCurrentCommand(element)) {
            return;
        }
        try {
            this._commandElement = null;
            this._warningLineGroupLoggerElement(this.lineGroupLoggerElement);
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    private void _failLineGroupLoggerElement(LoggerElement lineGroupLoggerElement) throws Exception {
        lineGroupLoggerElement.addClassName("failed");
        lineGroupLoggerElement.addChildLoggerElement(this._getErrorDetailsContainerLoggerElement());
        LoggerElement childContainerLoggerElement = lineGroupLoggerElement.loggerElement("ul");
        List<LoggerElement> runLineLoggerElements = childContainerLoggerElement.loggerElements("li");
        if (!runLineLoggerElements.isEmpty()) {
            LoggerElement runLineLoggerElement = runLineLoggerElements.get(runLineLoggerElements.size() - 1);
            runLineLoggerElement.addClassName("error-line");
        }
    }

    private LoggerElement _getBasicConsoleLoggerElement(int detailsLinkId) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-detailslinkid", "console-" + detailsLinkId);
        loggerElement.setClassName("console detailsPanel toggle");
        return loggerElement;
    }

    private LoggerElement _getBasicScreenshotsLoggerElement(int detailsLinkId) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-detailslinkid", "screenshots-" + detailsLinkId);
        loggerElement.setClassName("detailsPanel screenshots toggle");
        loggerElement.addChildLoggerElement(this._getScreenshotContainerLoggerElement("screenshot", detailsLinkId));
        return loggerElement;
    }

    private LoggerElement _getButtonLoggerElement(int btnLinkId) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-btnlinkid", "command-" + btnLinkId);
        loggerElement.setClassName("btn expand-toggle");
        return loggerElement;
    }

    private LoggerElement _getChildContainerLoggerElement(int btnLinkId) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-btnlinkid", "command-" + btnLinkId);
        loggerElement.setClassName("child-container collapse");
        loggerElement.setName("ul");
        return loggerElement;
    }

    private LoggerElement _getConsoleLoggerElement(int detailsLinkId) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-detailslinkid", "console-" + detailsLinkId);
        loggerElement.setClassName("console detailsPanel toggle");
        SummaryLogger summaryLogger = SummaryLogger.getSummaryLogger(this.getTestNamespacedClassCommandName());
        loggerElement.addChildLoggerElement(summaryLogger.getSummarySnapshotLoggerElement());
        return loggerElement;
    }

    private LoggerElement _getDividerLineLoggerElement(String classCommandName) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("divider-line");
        loggerElement.setText(classCommandName);
        return loggerElement;
    }

    private LoggerElement _getErrorDetailsContainerLoggerElement() throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("details-container hidden");
        loggerElement.addChildLoggerElement(this._getConsoleLoggerElement(this._detailsLinkId));
        loggerElement.addChildLoggerElement(this._getScreenshotsLoggerElement(this._detailsLinkId));
        ++this._detailsLinkId;
        return loggerElement;
    }

    private LoggerElement _getExternalMethodLineLoggerElement(Element element, List<String> arguments, Object returnValue) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("line-container");
        loggerElement.setText(this._getExternalMethodLineText(element, arguments, returnValue));
        return loggerElement;
    }

    private String _getExternalMethodLineText(Element element, List<String> arguments, Object returnValue) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this._getLineItemText("misc", "Running "));
        sb.append(this._getLineItemText("command-name", element.attributeValue("method")));
        if (!arguments.isEmpty()) {
            sb.append(this._getLineItemText("misc", " with parameters"));
            for (String argument : arguments) {
                sb.append(this._getLineItemText("param-value", HtmlUtil.escape("Arg: " + argument)));
            }
        }
        if (returnValue != null) {
            returnValue = "Return: " + returnValue.toString();
            sb.append(this._getLineItemText("param-value", HtmlUtil.escape(returnValue.toString())));
        }
        return sb.toString();
    }

    private LoggerElement _getLineContainerLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("line-container");
        loggerElement.setText(this._getLineContainerText(element));
        return loggerElement;
    }

    private String _getLineContainerText(Element element) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this._getLineItemText("misc", "Running "));
        String namespacedClassCommandName = element.attributeValue("function");
        sb.append(this._getLineItemText("command-name", namespacedClassCommandName));
        for (int i = 0; i < PoshiContext.getFunctionMaxArgumentCount(); ++i) {
            String valueKey;
            String locatorKey = "locator" + (i + 1);
            if (this._poshiVariablesContext.containsKeyInExecuteMap(locatorKey)) {
                sb.append(this._getLineItemText("misc", " with "));
                sb.append(this._getLineItemText("param-type", locatorKey));
                String paramValue = this._poshiVariablesContext.getStringFromExecuteMap(locatorKey);
                sb.append(this._getLineItemText("param-value", HtmlUtil.escape(paramValue)));
            }
            if (!this._poshiVariablesContext.containsKeyInExecuteMap(valueKey = "value" + (i + 1))) continue;
            sb.append(this._getLineItemText("misc", " with "));
            sb.append(this._getLineItemText("param-type", valueKey));
            String paramValue = this._poshiVariablesContext.getStringFromExecuteMap(valueKey);
            sb.append(this._getLineItemText("param-value", HtmlUtil.escape(paramValue)));
        }
        return sb.toString();
    }

    private LoggerElement _getLineGroupLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("line-group linkable");
        loggerElement.setName("li");
        loggerElement.addChildLoggerElement(this._getButtonLoggerElement(this._btnLinkId));
        loggerElement.addChildLoggerElement(this._getLineContainerLoggerElement(element));
        loggerElement.addChildLoggerElement(this._getChildContainerLoggerElement(this._btnLinkId));
        ++this._btnLinkId;
        return loggerElement;
    }

    private String _getLineItemText(String className, String text) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName(className);
        loggerElement.setID(null);
        loggerElement.setName("span");
        loggerElement.setText(text);
        return loggerElement.toString();
    }

    private LoggerElement _getMessageContainerLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("line-container");
        String elementName = element.getName();
        if (elementName.equals("take-screenshot")) {
            loggerElement.setText("Taking screenshot");
        } else {
            loggerElement.setText(this._getMessageContainerText(element));
        }
        return loggerElement;
    }

    private String _getMessageContainerText(Element element) throws Exception {
        String message = element.attributeValue("message");
        if (message == null) {
            message = element.getText();
        }
        return this._poshiVariablesContext.getReplacedCommandVarsString(message);
    }

    private LoggerElement _getMessageGroupLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        String className = "line-group linkable";
        if (this._isFail(element)) {
            className = className + " failed";
        }
        loggerElement.setClassName(className);
        loggerElement.setName("li");
        loggerElement.addChildLoggerElement(this._getMessageContainerLoggerElement(element));
        return loggerElement;
    }

    private LoggerElement _getOcularErrorDetailsContainerLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("details-container hidden");
        loggerElement.addChildLoggerElement(this._getConsoleLoggerElement(this._detailsLinkId));
        loggerElement.addChildLoggerElement(this._getOcularScreenshotsLoggerElement(this._detailsLinkId, element));
        ++this._detailsLinkId;
        return loggerElement;
    }

    private LoggerElement _getOcularScreenshotsLoggerElement(int detailsLinkId, Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-detailslinkid", "screenshots-" + detailsLinkId);
        loggerElement.setClassName("detailsPanel screenshots toggle");
        String filePath = element.attributeValue("value1");
        this.copyOcularImage("baseline", filePath, detailsLinkId);
        loggerElement.addChildLoggerElement(this._getScreenshotContainerLoggerElement("baseline", detailsLinkId));
        this.copyOcularImage("result", filePath, detailsLinkId);
        loggerElement.addChildLoggerElement(this._getScreenshotContainerLoggerElement("result", detailsLinkId));
        return loggerElement;
    }

    private LoggerElement _getRunLineLoggerElement(Element element, List<String> arguments) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("run-line");
        loggerElement.setName("li");
        loggerElement.setText(this._getRunLineText(element, arguments));
        return loggerElement;
    }

    private String _getRunLineText(Element element, List<String> arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._getLineItemText("misc", "Running "));
        sb.append(this._getLineItemText("command-name", element.attributeValue("selenium")));
        if (!arguments.isEmpty()) {
            sb.append(this._getLineItemText("misc", " with parameters"));
            for (String argument : arguments) {
                sb.append(this._getLineItemText("param-value", HtmlUtil.escape(argument)));
            }
        }
        return sb.toString();
    }

    private LoggerElement _getScreenshotContainerLoggerElement(String screenshotName, int detailsLinkId) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName(screenshotName + " screenshot-container");
        loggerElement.addChildLoggerElement(this._getScreenshotLoggerElement(screenshotName, detailsLinkId));
        loggerElement.addChildLoggerElement(this._getScreenshotSpanLoggerElement(StringUtil.upperCaseFirstLetter((String)screenshotName)));
        return loggerElement;
    }

    private LoggerElement _getScreenshotDetailsContainerLoggerElement() throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.addChildLoggerElement(this._getBasicConsoleLoggerElement(this._detailsLinkId));
        loggerElement.addChildLoggerElement(this._getBasicScreenshotsLoggerElement(this._detailsLinkId));
        ++this._detailsLinkId;
        return loggerElement;
    }

    private LoggerElement _getScreenshotLoggerElement(String screenshotName, int detailsLinkId) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("alt", screenshotName + detailsLinkId);
        loggerElement.setAttribute("src", "screenshots/" + screenshotName + detailsLinkId + ".jpg");
        loggerElement.setName("img");
        return loggerElement;
    }

    private LoggerElement _getScreenshotsLoggerElement(int detailsLinkId) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-detailslinkid", "screenshots-" + detailsLinkId);
        loggerElement.setClassName("detailsPanel screenshots toggle");
        loggerElement.addChildLoggerElement(this._getScreenshotContainerLoggerElement("before", detailsLinkId));
        this._takeScreenshot("after", detailsLinkId);
        loggerElement.addChildLoggerElement(this._getScreenshotContainerLoggerElement("after", detailsLinkId));
        return loggerElement;
    }

    private LoggerElement _getScreenshotSpanLoggerElement(String screenshotName) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setName("span");
        loggerElement.setText(StringUtil.upperCaseFirstLetter((String)screenshotName));
        return loggerElement;
    }

    private boolean _isCommand(Element element) {
        if (!Objects.equals(element.getName(), "condition") && !Objects.equals(element.getName(), "execute") && !Objects.equals(element.getName(), "var") || Validator.isNull((String)element.attributeValue("function")) && Validator.isNull((String)element.attributeValue("method"))) {
            return false;
        }
        return this._commandElement == null;
    }

    private boolean _isCurrentCommand(Element element) {
        return element.equals(this._commandElement);
    }

    private boolean _isFail(Element element) {
        return Objects.equals(StringUtil.toLowerCase((String)element.getName()), "fail");
    }

    private void _linkLoggerElements(LoggerElement scriptLoggerElement) {
        String functionLinkID = scriptLoggerElement.getAttributeValue("data-functionlinkid");
        if (functionLinkID != null) {
            this._functionLinkId = GetterUtil.getInteger((String)functionLinkID.substring(15));
        }
        scriptLoggerElement.setAttribute("data-functionlinkid", "functionLinkId-" + this._functionLinkId);
        this.lineGroupLoggerElement.setAttribute("data-functionlinkid", "functionLinkId-" + this._functionLinkId);
        ++this._functionLinkId;
    }

    private void _ocularLineGroupLoggerElement(Element element, LoggerElement lineGroupLoggerElement) throws Exception {
        lineGroupLoggerElement.addClassName("failed");
        lineGroupLoggerElement.addChildLoggerElement(this._getOcularErrorDetailsContainerLoggerElement(element));
        LoggerElement childContainerLoggerElement = lineGroupLoggerElement.loggerElement("ul");
        List<LoggerElement> runLineLoggerElements = childContainerLoggerElement.loggerElements("li");
        if (!runLineLoggerElements.isEmpty()) {
            LoggerElement runLineLoggerElement = runLineLoggerElements.get(runLineLoggerElements.size() - 1);
            runLineLoggerElement.addClassName("error-line");
        }
    }

    private void _screenshotLineGroupLoggerElement(LoggerElement lineGroupLoggerElement) throws Exception {
        lineGroupLoggerElement.addClassName("screenshot");
        lineGroupLoggerElement.addChildLoggerElement(this._getScreenshotDetailsContainerLoggerElement());
    }

    private void _takeScreenshot(String screenshotName, int detailsLinkId) throws Exception {
        String testClassCommandName = this.getTestNamespacedClassCommandName();
        Properties properties = PoshiContext.getNamespacedClassCommandNameProperties((String)testClassCommandName);
        if (GetterUtil.getBoolean((String)properties.getProperty("disable-webdriver"))) {
            return;
        }
        testClassCommandName = StringUtil.replace((String)testClassCommandName, (String)"#", (String)"_");
        LiferaySelenium liferaySelenium = WebDriverUtil.getLiferaySelenium(this.getTestNamespacedClassCommandName());
        liferaySelenium.saveScreenshot(FileUtil.getCanonicalPath((String)".") + "/test-results/" + testClassCommandName + "/screenshots/" + screenshotName + detailsLinkId + ".jpg");
    }

    private void _warningLineGroupLoggerElement(LoggerElement lineGroupLoggerElement) throws Exception {
        lineGroupLoggerElement.addClassName("warning");
        lineGroupLoggerElement.addChildLoggerElement(this._getErrorDetailsContainerLoggerElement());
        LoggerElement childContainerLoggerElement = lineGroupLoggerElement.loggerElement("ul");
        List<LoggerElement> runLineLoggerElements = childContainerLoggerElement.loggerElements("li");
        if (!runLineLoggerElements.isEmpty()) {
            LoggerElement runLineLoggerElement = runLineLoggerElements.get(runLineLoggerElements.size() - 1);
            runLineLoggerElement.addClassName("warning-line");
        }
    }
}

