/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.logger;

import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;

public class LoggerElement {
    private final Map<String, String> _attributes = new HashMap<String, String>();
    private final List<LoggerElement> _childLoggerElements = new ArrayList<LoggerElement>();
    private String _className = "";
    private String _id;
    private String _name = "div";
    private String _text = "";

    public LoggerElement() {
    }

    public LoggerElement(String id) {
        this._id = id;
    }

    public void addChildLoggerElement(LoggerElement childLoggerElement) {
        this._childLoggerElements.add(childLoggerElement);
    }

    public void addClassName(String className) {
        this.setClassName(this._className + " " + className);
    }

    public LoggerElement copy() {
        LoggerElement loggerElement = new LoggerElement();
        List<LoggerElement> childLoggerElements = this.loggerElements();
        for (LoggerElement childLoggerElement : childLoggerElements) {
            loggerElement.addChildLoggerElement(childLoggerElement.copy());
        }
        List<String> attributeNames = this.getAttributeNames();
        for (String attributeName : attributeNames) {
            loggerElement.setAttribute(attributeName, this.getAttributeValue(attributeName));
        }
        loggerElement.setClassName(this.getClassName());
        loggerElement.setName(this.getName());
        loggerElement.setText(this.getText());
        return loggerElement;
    }

    public List<String> getAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (String attributeName : this._attributes.keySet()) {
            attributeNames.add(attributeName);
        }
        return attributeNames;
    }

    public String getAttributeValue(String key) {
        return this._attributes.get(key);
    }

    public String getClassName() {
        return this._className;
    }

    public String getID() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getText() {
        return this._text;
    }

    public LoggerElement loggerElement(String name) {
        List<LoggerElement> loggerElements = this.loggerElements(name);
        if (!loggerElements.isEmpty()) {
            return loggerElements.get(0);
        }
        return null;
    }

    public LoggerElement loggerElement(String name, String className) {
        List<LoggerElement> loggerElements = this.loggerElements(name);
        for (LoggerElement loggerElement : loggerElements) {
            String childLoggerElementClassName = loggerElement.getClassName();
            List<String> childLoggerElementClassNames = Arrays.asList(StringUtil.split((String)childLoggerElementClassName, (String)" "));
            if (!childLoggerElementClassNames.contains(className)) continue;
            return loggerElement;
        }
        return null;
    }

    public List<LoggerElement> loggerElements() {
        return this._childLoggerElements;
    }

    public List<LoggerElement> loggerElements(String name) {
        ArrayList<LoggerElement> childLoggerElements = new ArrayList<LoggerElement>();
        for (LoggerElement childLoggerElement : this._childLoggerElements) {
            if (!Objects.equals(childLoggerElement.getName(), name)) continue;
            childLoggerElements.add(childLoggerElement);
        }
        return childLoggerElements;
    }

    public void removeChildLoggerElements(String name) {
        ArrayList<LoggerElement> childLoggerElements = new ArrayList<LoggerElement>();
        for (LoggerElement childLoggerElement : this._childLoggerElements) {
            if (!Objects.equals(childLoggerElement.getName(), name)) continue;
            childLoggerElements.add(childLoggerElement);
        }
        for (LoggerElement childLoggerElement : childLoggerElements) {
            this._childLoggerElements.remove(childLoggerElement);
        }
    }

    public void removeClassName(String className) {
        String cleanedClassName = this._className.replaceFirst("(.*?)\\s*" + Matcher.quoteReplacement(className) + "\\s*(.*)", "$1 $2");
        this.setClassName(cleanedClassName.trim());
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this._attributes.put(attributeName, attributeValue);
    }

    public void setClassName(String className) {
        this._className = this._fixClassName(className);
    }

    public void setID(String id) {
        this._id = id;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this._name);
        for (Map.Entry<String, String> entry : this._attributes.entrySet()) {
            sb.append(" ");
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(entry.getValue());
            sb.append("\"");
        }
        if (Validator.isNotNull((String)this._className)) {
            sb.append(" class=\"");
            sb.append(this._className);
            sb.append("\"");
        }
        if (Validator.isNotNull((String)this._id)) {
            sb.append(" id=\"");
            sb.append(this._id);
            sb.append("\"");
        }
        sb.append(">");
        boolean hasChildren = false;
        if (!this._childLoggerElements.isEmpty()) {
            hasChildren = true;
        }
        boolean hasText = Validator.isNotNull((String)this._text);
        if (hasChildren || hasText) {
            if (hasText) {
                sb.append(this._text);
            }
            if (hasChildren) {
                for (LoggerElement childLoggerElement : this._childLoggerElements) {
                    sb.append(childLoggerElement.toString());
                }
            }
        }
        sb.append("</");
        sb.append(this._name);
        sb.append(">");
        return sb.toString();
    }

    private String _fixClassName(String className) {
        Object[] classNames = StringUtil.split((String)className, (String)" ");
        Arrays.sort(classNames);
        return StringUtil.join((String[])classNames, (String)" ");
    }
}

