/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.logger;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.PoshiStackTrace;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.runner.exception.PoshiRunnerLoggerException;
import com.liferay.poshi.runner.logger.CommandLogger;
import com.liferay.poshi.runner.logger.LoggerElement;
import com.liferay.poshi.runner.logger.PoshiScriptSyntaxLogger;
import com.liferay.poshi.runner.logger.SyntaxLogger;
import com.liferay.poshi.runner.logger.XMLSyntaxLogger;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.dom4j.Element;

public class PoshiLogger {
    private final CommandLogger _commandLogger;
    private int _functionLinkId;
    private final PoshiProperties _poshiProperties;
    private final PoshiStackTrace _poshiStackTrace;
    private final SyntaxLogger _syntaxLogger;
    private final String _testNamespacedClassCommandName;

    public PoshiLogger(String testNamespacedClassCommandName) throws Exception {
        this._commandLogger = new CommandLogger(testNamespacedClassCommandName);
        this._syntaxLogger = this._getSyntaxLogger(testNamespacedClassCommandName);
        this._testNamespacedClassCommandName = testNamespacedClassCommandName;
        this._poshiProperties = PoshiProperties.getPoshiProperties();
        this._poshiStackTrace = PoshiStackTrace.getPoshiStackTrace((String)testNamespacedClassCommandName);
    }

    public void createPoshiReport() throws IOException {
        String indexHTMLContent = null;
        String currentDirName = FileUtil.getCanonicalPath((String)".");
        try {
            ClassLoader classLoader = PoshiLogger.class.getClassLoader();
            URL url = classLoader.getResource("META-INF/resources/html/index.html");
            indexHTMLContent = FileUtil.read((URL)url);
            indexHTMLContent = StringUtil.replace((String)indexHTMLContent, (String)"<ul class=\"command-log\" data-logid=\"01\" id=\"commandLog\"></ul>", (String)this._commandLogger.getCommandLogText());
            indexHTMLContent = StringUtil.replace((String)indexHTMLContent, (String)"<ul class=\"syntax-log-container\" id=\"syntaxLogContainer\"></ul>", (String)this._syntaxLogger.getSyntaxLogText());
            if (this._poshiProperties.testRunLocally) {
                FileUtil.copyFileFromResource((String)"META-INF/resources/css/main.css", (String)(currentDirName + "/test-results/css/main.css"));
                FileUtil.copyFileFromResource((String)"META-INF/resources/js/component.js", (String)(currentDirName + "/test-results/js/component.js"));
                FileUtil.copyFileFromResource((String)"META-INF/resources/js/main.js", (String)(currentDirName + "/test-results/js/main.js"));
                FileUtil.copyFileFromResource((String)"META-INF/resources/js/update_images.js", (String)(currentDirName + "/test-results/js/update_images.js"));
            } else {
                indexHTMLContent = StringUtil.replace((String)indexHTMLContent, (String)"<link href=\"../css/main.css\"", (String)("<link href=\"" + this._poshiProperties.loggerResourcesURL + "/css/main.css\""));
                indexHTMLContent = StringUtil.replace((String)indexHTMLContent, (String)"<script defer src=\"../js/component.js\"", (String)("<script defer src=\"" + this._poshiProperties.loggerResourcesURL + "/js/component.js\""));
                indexHTMLContent = StringUtil.replace((String)indexHTMLContent, (String)"<script defer src=\"../js/main.js\"", (String)("<script defer src=\"" + this._poshiProperties.loggerResourcesURL + "/js/main.js\""));
                indexHTMLContent = StringUtil.replace((String)indexHTMLContent, (String)"<script defer src=\"../js/update_images.js\"", (String)("<script defer src=\"" + this._poshiProperties.loggerResourcesURL + "/js/update_images.js\""));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Unable to create Poshi syntax logger. See POSHI-378 for details. Use the summary.html log instead.");
            String summaryHTMLFileName = "summary.html";
            if (System.getenv("JENKINS_HOME") != null) {
                summaryHTMLFileName = summaryHTMLFileName + ".gz";
            }
            Element element = Dom4JUtil.getNewElement((String)"html", null, (Object[])new Object[]{Dom4JUtil.getNewElement((String)"body", null, (Object[])new Object[]{"Unable to create Poshi syntax logger. See ", Dom4JUtil.getNewAnchorElement((String)"https://issues.liferay.com/browse/POSHI-378", (Object[])new Object[]{"POSHI-378"}), " details. Use the ", Dom4JUtil.getNewAnchorElement((String)summaryHTMLFileName, (Object[])new Object[]{"Summary Log"}), " instead."})});
            indexHTMLContent = Dom4JUtil.format((Element)element);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(currentDirName);
        sb.append("/test-results/");
        sb.append(StringUtil.replace((String)this._testNamespacedClassCommandName, (String)"#", (String)"_"));
        sb.append("/index.html");
        FileUtil.write((String)sb.toString(), (String)indexHTMLContent);
    }

    public void failCommand(Element element) throws PoshiRunnerLoggerException {
        this._commandLogger.failCommand(element, this._syntaxLogger);
        LoggerElement syntaxLoggerElement = this._getSyntaxLoggerElement();
        syntaxLoggerElement.setAttribute("data-status01", "fail");
    }

    public int getDetailsLinkId() {
        return this._commandLogger.getDetailsLinkId();
    }

    public String getTestNamespacedClassCommandName() {
        return this._testNamespacedClassCommandName;
    }

    public void logExternalMethodCommand(Element element, List<String> arguments, Object returnValue) throws Exception {
        this._commandLogger.logExternalMethodCommand(element, arguments, returnValue, this._syntaxLogger);
    }

    public void logMessage(Element element) throws PoshiRunnerLoggerException {
        this._commandLogger.logMessage(element, this._syntaxLogger);
        LoggerElement syntaxLoggerElement = this._getSyntaxLoggerElement();
        syntaxLoggerElement.setAttribute("data-status01", "pass");
        this._linkLoggerElements(syntaxLoggerElement, this._commandLogger.lineGroupLoggerElement);
    }

    public void logNamespacedClassCommandName(String namespacedClassCommandName) {
        this._commandLogger.logNamespacedClassCommandName(namespacedClassCommandName);
    }

    public void logSeleniumCommand(Element element, List<String> arguments) throws PoshiRunnerLoggerException {
        this._commandLogger.logSeleniumCommand(element, arguments);
    }

    public void ocularCommand(Element element) throws PoshiRunnerLoggerException {
        this._commandLogger.ocularCommand(element, this._syntaxLogger);
        LoggerElement syntaxLoggerElement = this._getSyntaxLoggerElement();
        syntaxLoggerElement.setAttribute("data-status01", "fail");
    }

    public void passCommand(Element element) throws PoshiRunnerLoggerException {
        this._commandLogger.passCommand(element, this._syntaxLogger);
        LoggerElement syntaxLoggerElement = this._getSyntaxLoggerElement();
        syntaxLoggerElement.setAttribute("data-status01", "pass");
    }

    public void startCommand(Element element) throws PoshiRunnerLoggerException {
        this._commandLogger.startCommand(element, this._syntaxLogger);
        LoggerElement syntaxLoggerElement = this._getSyntaxLoggerElement();
        syntaxLoggerElement.setAttribute("data-status01", "pending");
        this._linkLoggerElements(syntaxLoggerElement, this._commandLogger.lineGroupLoggerElement);
    }

    public void takeScreenshotCommand(Element element) throws PoshiRunnerLoggerException {
        this._commandLogger.takeScreenshotCommand(element, this._syntaxLogger);
        LoggerElement syntaxLoggerElement = this._getSyntaxLoggerElement();
        syntaxLoggerElement.setAttribute("data-status01", "screenshot");
        this._linkLoggerElements(syntaxLoggerElement, this._commandLogger.lineGroupLoggerElement);
    }

    public void updateStatus(Element element, String status) {
        this._syntaxLogger.updateStatus(element, status);
    }

    public void warnCommand(Element element) throws PoshiRunnerLoggerException {
        this._commandLogger.warnCommand(element, this._syntaxLogger);
        LoggerElement syntaxLoggerElement = this._getSyntaxLoggerElement();
        syntaxLoggerElement.setAttribute("data-status01", "warning");
    }

    private SyntaxLogger _getSyntaxLogger(String namespacedClassCommandName) throws Exception {
        PoshiElement poshiCommandElement;
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName((String)namespacedClassCommandName);
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        Element commandElement = PoshiContext.getTestCaseCommandElement((String)classCommandName, (String)namespace);
        if (commandElement instanceof PoshiElement && !(poshiCommandElement = (PoshiElement)commandElement).isPoshiProse()) {
            return new PoshiScriptSyntaxLogger(namespacedClassCommandName);
        }
        return new XMLSyntaxLogger(namespacedClassCommandName);
    }

    private LoggerElement _getSyntaxLoggerElement() {
        return this._syntaxLogger.getSyntaxLoggerElement(this._poshiStackTrace.getSimpleStackTraceMessage());
    }

    private void _linkLoggerElements(LoggerElement lineGroupLoggerElement, LoggerElement scriptLoggerElement) {
        String functionLinkID = scriptLoggerElement.getAttributeValue("data-functionlinkid");
        if (functionLinkID != null) {
            this._functionLinkId = GetterUtil.getInteger((String)functionLinkID.substring(15));
        }
        scriptLoggerElement.setAttribute("data-functionlinkid", "functionLinkId-" + this._functionLinkId);
        lineGroupLoggerElement.setAttribute("data-functionlinkid", "functionLinkId-" + this._functionLinkId);
        ++this._functionLinkId;
    }
}

