/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.logger;

import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.runner.logger.LoggerElement;
import com.liferay.poshi.runner.logger.SyntaxLogger;
import java.util.List;
import org.dom4j.Element;

public final class PoshiScriptSyntaxLogger
extends SyntaxLogger {
    public PoshiScriptSyntaxLogger(String namespacedClassCommandName) throws Exception {
        this.generateSyntaxLog(namespacedClassCommandName);
    }

    @Override
    public void updateStatus(Element element, String status) {
        String elementName = element.getName();
        if (!elementName.equals("then")) {
            this.updateElementStatus(element, status);
        }
    }

    protected LoggerElement getClosingLineContainerLoggerElement() {
        LoggerElement closingLineContainerLoggerElement = new LoggerElement();
        closingLineContainerLoggerElement.setClassName("line-container");
        closingLineContainerLoggerElement.setName("div");
        closingLineContainerLoggerElement.setText("}");
        return closingLineContainerLoggerElement;
    }

    @Override
    protected LoggerElement getIfLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setName("div");
        LoggerElement ifLoggerElement = this.getLineGroupLoggerElement("conditional", element);
        ifLoggerElement.addChildLoggerElement(this.getChildContainerLoggerElement(element.element("then")));
        ifLoggerElement.addChildLoggerElement(this.getClosingLineContainerLoggerElement());
        loggerElement.addChildLoggerElement(ifLoggerElement);
        List elseIfElements = element.elements("elseif");
        for (Element elseIfElement : elseIfElements) {
            loggerElement.addChildLoggerElement(this.getIfLoggerElement(elseIfElement));
        }
        Element elseElement = element.element("else");
        if (elseElement != null) {
            loggerElement.addChildLoggerElement(this.getLoggerElementFromElement(elseElement));
        }
        return loggerElement;
    }

    @Override
    protected LoggerElement getLineContainerLoggerElement(Element element) {
        LoggerElement lineContainerLoggerElement = new LoggerElement();
        lineContainerLoggerElement.setClassName("line-container");
        lineContainerLoggerElement.setName("div");
        if (element.attributeValue("macro") != null) {
            lineContainerLoggerElement.setAttribute("onmouseout", "macroHover(this, false)");
            lineContainerLoggerElement.setAttribute("onmouseover", "macroHover(this, true)");
        }
        PoshiElement poshiElement = (PoshiElement)element;
        String logStatement = StringUtil.trim((String)poshiElement.getPoshiLogDescriptor());
        String name = element.getName();
        List elements = poshiElement.toPoshiElements(element.elements());
        if (!name.equals("execute") && !elements.isEmpty()) {
            logStatement = logStatement + " {";
        }
        lineContainerLoggerElement.setText(this.getLineItemText("name", logStatement));
        return lineContainerLoggerElement;
    }

    @Override
    protected LoggerElement getLoggerElementFromElement(Element element) throws Exception {
        LoggerElement loggerElement = this.getLineGroupLoggerElement(element);
        loggerElement.addChildLoggerElement(this.getChildContainerLoggerElement(element));
        loggerElement.addChildLoggerElement(this.getClosingLineContainerLoggerElement());
        return loggerElement;
    }

    @Override
    protected LoggerElement getWhileLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = this.getLineGroupLoggerElement(element);
        loggerElement.addChildLoggerElement(this.getChildContainerLoggerElement(element.element("then")));
        loggerElement.addChildLoggerElement(this.getClosingLineContainerLoggerElement());
        return loggerElement;
    }
}

