/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.logger;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.PoshiStackTrace;
import com.liferay.poshi.core.PoshiVariablesContext;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.exception.PoshiRunnerLoggerException;
import com.liferay.poshi.runner.logger.LoggerElement;
import com.liferay.poshi.runner.util.HtmlUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public final class SummaryLogger {
    private static final Pattern _pattern = Pattern.compile("\\$\\{([^}]*)\\}");
    private static final Map<String, SummaryLogger> _summaryLoggers = new HashMap<String, SummaryLogger>();
    private LoggerElement _causeBodyLoggerElement;
    private boolean _containsMinorStepWarning;
    private Element _majorStepElement;
    private LoggerElement _majorStepLoggerElement;
    private LoggerElement _majorStepsLoggerElement;
    private Element _minorStepElement;
    private LoggerElement _minorStepLoggerElement;
    private LoggerElement _minorStepsLoggerElement;
    private final PoshiProperties _poshiProperties;
    private final PoshiStackTrace _poshiStackTrace;
    private final PoshiVariablesContext _poshiVariablesContext;
    private LoggerElement _summaryContentContainerLoggerElement;
    private LoggerElement _summaryContentWrapperLoggerElement;
    private LoggerElement _summaryLogLoggerElement;
    private LoggerElement _summaryTitleContainerLoggerElement;
    private final String _testNamespacedClassCommandName;
    private int _warningCount;

    public static void clear(String testNamespacedClassCommandName) {
        if (_summaryLoggers.containsKey(testNamespacedClassCommandName)) {
            SummaryLogger summaryLogger = _summaryLoggers.get(testNamespacedClassCommandName);
            summaryLogger.stopRunning();
            _summaryLoggers.remove(testNamespacedClassCommandName);
        }
    }

    public static synchronized SummaryLogger getSummaryLogger(String testNamespacedClassCommandName) {
        if (!_summaryLoggers.containsKey(testNamespacedClassCommandName)) {
            _summaryLoggers.put(testNamespacedClassCommandName, new SummaryLogger(testNamespacedClassCommandName));
        }
        return _summaryLoggers.get(testNamespacedClassCommandName);
    }

    public void createSummaryReport() throws Exception {
        String summaryHTMLContent = this._readResource("META-INF/resources/html/summary.html");
        this._summaryContentWrapperLoggerElement.addChildLoggerElement(this._getSummaryContentLoggerElement());
        summaryHTMLContent = StringUtil.replace((String)summaryHTMLContent, (String)"<div id=\"summaryContentContainer\" />", (String)this._summaryContentContainerLoggerElement.toString());
        summaryHTMLContent = StringUtil.replace((String)summaryHTMLContent, (String)"<p id=\"summaryTestDescription\" />", (String)String.valueOf(this._getSummaryTestDescriptionLoggerElement()));
        summaryHTMLContent = StringUtil.replace((String)summaryHTMLContent, (String)"<h3 id=\"summaryTestName\" />", (String)String.valueOf(this._getSummaryTestNameLoggerElement()));
        summaryHTMLContent = StringUtil.replace((String)summaryHTMLContent, (String)"<ul id=\"summaryTitleContainer\" />", (String)this._summaryTitleContainerLoggerElement.toString());
        summaryHTMLContent = StringUtil.replace((String)summaryHTMLContent, (String)"<script defer src=\"../js/update_images.js\"", (String)("<script defer src=\"" + this._poshiProperties.loggerResourcesURL + "/js/update_images.js\""));
        StringBuilder sb = new StringBuilder();
        sb.append(FileUtil.getCanonicalPath((String)"."));
        sb.append("/test-results/");
        sb.append(StringUtil.replace((String)this.getTestNamespacedClassCommandName(), (String)"#", (String)"_"));
        sb.append("/summary.html");
        FileUtil.write((String)sb.toString(), (String)summaryHTMLContent);
    }

    public void failSummary(Element element, String message, int screenshotNumber) {
        if (this._isCurrentMajorStep(element)) {
            this._causeBodyLoggerElement.setText(HtmlUtil.escape(message));
            this._failStepLoggerElement(this._majorStepLoggerElement);
            this._summaryLogLoggerElement.addChildLoggerElement(this._getScreenshotsLoggerElement(screenshotNumber));
            this._stopMajorStep();
        }
        if (this._isCurrentMinorStep(element)) {
            this._causeBodyLoggerElement.setText(HtmlUtil.escape(message));
            this._failStepLoggerElement(this._minorStepLoggerElement);
            this._stopMinorStep();
        }
    }

    public LoggerElement getSummarySnapshotLoggerElement() {
        LoggerElement stepsLoggerElement;
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("summary-log");
        loggerElement.setName("div");
        LoggerElement causeLoggerElement = this._summaryLogLoggerElement.loggerElement("div", "cause");
        if (causeLoggerElement != null) {
            loggerElement.addChildLoggerElement(causeLoggerElement.copy());
        }
        if ((stepsLoggerElement = this._summaryLogLoggerElement.loggerElement("div", "steps")) != null) {
            stepsLoggerElement = stepsLoggerElement.copy();
            this._removeUnneededStepsFromLoggerElement(stepsLoggerElement);
            loggerElement.addChildLoggerElement(stepsLoggerElement);
        }
        return loggerElement;
    }

    public String getTestNamespacedClassCommandName() {
        return this._testNamespacedClassCommandName;
    }

    public void passSummary(Element element) {
        if (this._isCurrentMajorStep(element)) {
            if (this._containsMinorStepWarning) {
                this._warnStepLoggerElement(this._majorStepLoggerElement);
                this._containsMinorStepWarning = false;
            } else {
                this._passStepLoggerElement(this._majorStepLoggerElement);
            }
            this._stopMajorStep();
        }
        if (this._isCurrentMinorStep(element)) {
            this._passStepLoggerElement(this._minorStepLoggerElement);
            this._stopMinorStep();
        }
    }

    public void startMajorSteps() throws PoshiRunnerLoggerException {
        try {
            this._causeBodyLoggerElement = this._getCauseBodyLoggerElement();
            this._majorStepsLoggerElement = this._getMajorStepsLoggerElement();
            this._summaryLogLoggerElement = this._getSummaryLogLoggerElement();
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    public void startRunning() {
        this._containsMinorStepWarning = false;
        this._summaryContentContainerLoggerElement = new LoggerElement("summaryContentContainer");
        this._summaryContentWrapperLoggerElement = new LoggerElement("summaryContentWrapper");
        this._summaryContentContainerLoggerElement.addChildLoggerElement(this._summaryContentWrapperLoggerElement);
        this._summaryTitleContainerLoggerElement = new LoggerElement("summaryTitleContainer");
        this._summaryTitleContainerLoggerElement.addChildLoggerElement(this._getSummaryTitleLoggerElement("SUMMARY"));
        this._summaryTitleContainerLoggerElement.setName("ul");
        this._warningCount = 0;
    }

    public void startSummary(Element element) throws Exception {
        try {
            if (this._isMajorStep(element)) {
                this._startMajorStep(element);
                this._majorStepLoggerElement = this._getMajorStepLoggerElement(element);
                this._majorStepsLoggerElement.addChildLoggerElement(this._majorStepLoggerElement);
                this._minorStepsLoggerElement = this._getMinorStepsLoggerElement();
                this._majorStepLoggerElement.addChildLoggerElement(this._minorStepsLoggerElement);
            }
            if (this._isMinorStep(element)) {
                this._startMinorStep(element);
                this._minorStepLoggerElement = this._getMinorStepLoggerElement(element);
                this._minorStepsLoggerElement.addChildLoggerElement(this._minorStepLoggerElement);
            }
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    public void stopRunning() {
        this._stopMajorStep();
    }

    public void warnSummary(Element element, String message) {
        if (this._isCurrentMajorStep(element)) {
            this._causeBodyLoggerElement.setText(message);
            this._warnStepLoggerElement(this._majorStepLoggerElement);
            this._stopMajorStep();
        }
        if (this._isCurrentMinorStep(element)) {
            this._causeBodyLoggerElement.setText(message);
            this._warnStepLoggerElement(this._minorStepLoggerElement);
            this._containsMinorStepWarning = true;
            ++this._warningCount;
            this._summaryContentContainerLoggerElement.addChildLoggerElement(this._getSummaryContentLoggerElement());
            this._summaryTitleContainerLoggerElement.addChildLoggerElement(this._getSummaryTitleLoggerElement("WARNING #" + this._warningCount));
            this._stopMinorStep();
        }
    }

    private SummaryLogger(String testNamespacedClassCommandName) {
        this._testNamespacedClassCommandName = testNamespacedClassCommandName;
        this._poshiProperties = PoshiProperties.getPoshiProperties();
        this._poshiStackTrace = PoshiStackTrace.getPoshiStackTrace((String)testNamespacedClassCommandName);
        this._poshiVariablesContext = PoshiVariablesContext.getPoshiVariablesContext((String)testNamespacedClassCommandName);
    }

    private void _failStepLoggerElement(LoggerElement stepLoggerElement) {
        stepLoggerElement.addClassName("summary-failure");
        LoggerElement lineContainerLoggerElement = stepLoggerElement.loggerElement("div");
        if (lineContainerLoggerElement == null) {
            return;
        }
        lineContainerLoggerElement.addChildLoggerElement(this._getStatusLoggerElement("FAILED"));
        lineContainerLoggerElement.setName("strong");
    }

    private LoggerElement _getButtonLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("btn header");
        loggerElement.setName("button");
        loggerElement.setText("+");
        return loggerElement;
    }

    private LoggerElement _getCauseBodyLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("cause-body");
        loggerElement.setName("pre");
        return loggerElement;
    }

    private LoggerElement _getCauseHeaderLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("cause-header");
        loggerElement.setName("h4");
        loggerElement.setText("Cause:");
        return loggerElement;
    }

    private LoggerElement _getCauseLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("cause");
        loggerElement.addChildLoggerElement(this._getCauseHeaderLoggerElement());
        loggerElement.addChildLoggerElement(this._causeBodyLoggerElement);
        return loggerElement;
    }

    private LoggerElement _getMajorStepLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("major-step");
        loggerElement.setName("li");
        loggerElement.addChildLoggerElement(this._getButtonLoggerElement());
        loggerElement.addChildLoggerElement(this._getStepDescriptionLoggerElement(element));
        return loggerElement;
    }

    private LoggerElement _getMajorStepsLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("major-steps");
        loggerElement.setName("ul");
        return loggerElement;
    }

    private LoggerElement _getMinorStepLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("minor-step");
        loggerElement.setName("li");
        loggerElement.addChildLoggerElement(this._getStepDescriptionLoggerElement(element));
        return loggerElement;
    }

    private LoggerElement _getMinorStepsLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("content minor-steps");
        loggerElement.setName("ul");
        return loggerElement;
    }

    private LoggerElement _getScreenshotsAfterHeaderLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setText("After Failure:");
        loggerElement.setName("h5");
        return loggerElement;
    }

    private LoggerElement _getScreenshotsAfterLinkLoggerElement(int screenshotNumber) {
        LoggerElement loggerElement = new LoggerElement();
        StringBuilder sb = new StringBuilder();
        sb.append("screenshots/after");
        sb.append(screenshotNumber);
        sb.append(".jpg");
        loggerElement.setAttribute("href", sb.toString());
        loggerElement.setAttribute("title", "After Failure");
        loggerElement.setName("a");
        loggerElement.addChildLoggerElement(this._getScreenshotsAfterThumbnailLoggerElement(screenshotNumber));
        return loggerElement;
    }

    private LoggerElement _getScreenshotsAfterThumbnailLoggerElement(int screenshotNumber) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("alt", "After Failure");
        StringBuilder sb = new StringBuilder();
        sb.append("screenshots/after");
        sb.append(screenshotNumber);
        sb.append(".jpg");
        loggerElement.setAttribute("src", sb.toString());
        loggerElement.setClassName("screenshots-thumbnail");
        loggerElement.setName("img");
        return loggerElement;
    }

    private LoggerElement _getScreenshotsBeforeHeaderLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setText("Before Failure:");
        loggerElement.setName("h5");
        return loggerElement;
    }

    private LoggerElement _getScreenshotsBeforeLinkLoggerElement(int screenshotNumber) {
        LoggerElement loggerElement = new LoggerElement();
        StringBuilder sb = new StringBuilder();
        sb.append("screenshots/before");
        sb.append(screenshotNumber);
        sb.append(".jpg");
        loggerElement.setAttribute("href", sb.toString());
        loggerElement.setAttribute("title", "Before Failure");
        loggerElement.setName("a");
        loggerElement.addChildLoggerElement(this._getScreenshotsBeforeThumbnailLoggerElement(screenshotNumber));
        return loggerElement;
    }

    private LoggerElement _getScreenshotsBeforeThumbnailLoggerElement(int screenshotNumber) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("alt", "Before Failure");
        StringBuilder sb = new StringBuilder();
        sb.append("screenshots/before");
        sb.append(screenshotNumber);
        sb.append(".jpg");
        loggerElement.setAttribute("src", sb.toString());
        loggerElement.setClassName("screenshots-thumbnail");
        loggerElement.setName("img");
        return loggerElement;
    }

    private LoggerElement _getScreenshotsHeaderLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("screenshots-header");
        loggerElement.setName("h4");
        loggerElement.setText("Screenshots:");
        return loggerElement;
    }

    private LoggerElement _getScreenshotsLoggerElement(int screenshotNumber) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("screenshots");
        loggerElement.addChildLoggerElement(this._getScreenshotsHeaderLoggerElement());
        loggerElement.addChildLoggerElement(this._getScreenshotsBeforeHeaderLoggerElement());
        loggerElement.addChildLoggerElement(this._getScreenshotsBeforeLinkLoggerElement(screenshotNumber));
        loggerElement.addChildLoggerElement(this._getScreenshotsAfterHeaderLoggerElement());
        loggerElement.addChildLoggerElement(this._getScreenshotsAfterLinkLoggerElement(screenshotNumber));
        return loggerElement;
    }

    private LoggerElement _getStatusLoggerElement(String status) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("status");
        loggerElement.setID(null);
        loggerElement.setName("span");
        loggerElement.setText(" --> " + status);
        return loggerElement;
    }

    private LoggerElement _getStepDescriptionLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("step-description");
        loggerElement.setText(this._getSummary(element));
        return loggerElement;
    }

    private LoggerElement _getStepsHeaderLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("steps-header");
        loggerElement.setName("h4");
        loggerElement.setText("Steps:");
        return loggerElement;
    }

    private LoggerElement _getStepsLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("steps");
        loggerElement.addChildLoggerElement(this._getStepsHeaderLoggerElement());
        loggerElement.addChildLoggerElement(this._majorStepsLoggerElement);
        return loggerElement;
    }

    private String _getSummary(Element element) throws Exception {
        String summary = null;
        if (element.attributeValue("summary") != null) {
            summary = element.attributeValue("summary");
        }
        if (summary == null) {
            String namespacedClassCommandName = null;
            String classType = null;
            if (element.attributeValue("function") != null) {
                namespacedClassCommandName = element.attributeValue("function");
                classType = "function";
            } else if (element.attributeValue("function-summary") != null) {
                namespacedClassCommandName = element.attributeValue("function-summary");
                classType = "function-summary";
            } else if (element.attributeValue("macro") != null) {
                namespacedClassCommandName = element.attributeValue("macro");
                classType = "macro";
            } else if (element.attributeValue("macro-summary") != null) {
                namespacedClassCommandName = element.attributeValue("macro-summary");
                classType = "macro-summary";
            } else {
                if (element.attributeValue("method") != null) {
                    return element.attributeValue("method");
                }
                return null;
            }
            String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
            String namespace = this._poshiStackTrace.getCurrentNamespace();
            if (classType.startsWith("function")) {
                summary = PoshiContext.getFunctionCommandSummary((String)classCommandName, (String)namespace);
            } else if (classType.startsWith("macro")) {
                summary = PoshiContext.getMacroCommandSummary((String)classCommandName, (String)namespace);
            }
        }
        if (summary != null) {
            summary = HtmlUtil.escape(this._poshiVariablesContext.getReplacedCommandVarsString(summary));
            return this._replaceExecuteVars(summary, element);
        }
        return null;
    }

    private LoggerElement _getSummaryContentLoggerElement() {
        LoggerElement loggerElement = this._summaryLogLoggerElement.copy();
        LoggerElement stepsLoggerElement = loggerElement.loggerElement("div");
        LoggerElement majorStepsLoggerElement = stepsLoggerElement.loggerElement("ul");
        List<LoggerElement> majorStepLoggerElements = majorStepsLoggerElement.loggerElements("li");
        for (int i = 0; i < majorStepLoggerElements.size(); ++i) {
            LoggerElement majorStepLoggerElement = majorStepLoggerElements.get(i);
            boolean lastMajorStep = false;
            if (i >= majorStepLoggerElements.size() - 1) {
                lastMajorStep = true;
            }
            if (this._containsMinorStepWarning && lastMajorStep) {
                this._warnStepLoggerElement(majorStepLoggerElement);
            }
            String togglerClassNameSuffix = "collapsed";
            String majorStepClassName = majorStepLoggerElement.getClassName();
            if (lastMajorStep && (majorStepClassName.contains("summary-failure") || majorStepClassName.contains("summary-warning"))) {
                togglerClassNameSuffix = "expanded";
            }
            LoggerElement buttonLoggerElement = majorStepLoggerElement.loggerElement("button");
            buttonLoggerElement.addClassName("toggler-header-" + togglerClassNameSuffix);
            LoggerElement minorStepsLoggerElement = majorStepLoggerElement.loggerElement("ul");
            minorStepsLoggerElement.addClassName("toggler-content-" + togglerClassNameSuffix);
        }
        return loggerElement;
    }

    private LoggerElement _getSummaryLogLoggerElement() {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("summary-log");
        loggerElement.setName("div");
        loggerElement.addChildLoggerElement(this._getStepsLoggerElement());
        loggerElement.addChildLoggerElement(this._getCauseLoggerElement());
        return loggerElement;
    }

    private LoggerElement _getSummaryTestDescriptionLoggerElement() {
        LoggerElement loggerElement = new LoggerElement("summaryTestDescription");
        String testCaseDescription = PoshiContext.getTestCaseDescription((String)this.getTestNamespacedClassCommandName());
        if (Validator.isNull((String)testCaseDescription)) {
            testCaseDescription = "";
        }
        loggerElement.setName("p");
        loggerElement.setText(testCaseDescription);
        return loggerElement;
    }

    private LoggerElement _getSummaryTestNameLoggerElement() {
        LoggerElement loggerElement = new LoggerElement("summaryTestName");
        loggerElement.setName("h3");
        loggerElement.setText(this.getTestNamespacedClassCommandName());
        return loggerElement;
    }

    private LoggerElement _getSummaryTitleLinkLoggerElement(String title) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("href", "#");
        loggerElement.setName("a");
        loggerElement.setText(title);
        return loggerElement;
    }

    private LoggerElement _getSummaryTitleLoggerElement(String title) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setName("li");
        loggerElement.addChildLoggerElement(this._getSummaryTitleLinkLoggerElement(title));
        return loggerElement;
    }

    private boolean _isCurrentMajorStep(Element element) {
        return element == this._majorStepElement;
    }

    private boolean _isCurrentMinorStep(Element element) {
        return element == this._minorStepElement;
    }

    private boolean _isMajorStep(Element element) throws Exception {
        String summary = this._getSummary(element);
        if (summary == null) {
            return false;
        }
        if (!(Objects.equals(element.getName(), "condition") || Objects.equals(element.getName(), "execute") || Objects.equals(element.getName(), "task") || Objects.equals(element.getName(), "var"))) {
            return false;
        }
        if (Validator.isNull((String)element.attributeValue("function")) && Validator.isNull((String)element.attributeValue("function-summary")) && Validator.isNull((String)element.attributeValue("macro")) && Validator.isNull((String)element.attributeValue("macro-summary")) && Validator.isNull((String)element.attributeValue("method")) && Validator.isNull((String)element.attributeValue("summary"))) {
            return false;
        }
        return this._majorStepElement == null;
    }

    private boolean _isMinorStep(Element element) throws Exception {
        String summary = this._getSummary(element);
        return summary != null && Objects.equals(element.getName(), "execute") && !Validator.isNull((String)element.attributeValue("function")) && this._minorStepElement == null && !Validator.isNotNull((String)this._majorStepElement.attributeValue("function"));
    }

    private void _passStepLoggerElement(LoggerElement stepLoggerElement) {
        LoggerElement lineContainerLoggerElement = stepLoggerElement.loggerElement("div");
        lineContainerLoggerElement.addChildLoggerElement(this._getStatusLoggerElement("PASSED"));
    }

    private String _readResource(String path) throws Exception {
        StringBuilder sb = new StringBuilder();
        ClassLoader classLoader = SummaryLogger.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(path);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        bufferedReader.close();
        return sb.toString();
    }

    private void _removeUnneededStepsFromLoggerElement(LoggerElement loggerElement) {
        LoggerElement majorStepsLoggerElement = loggerElement.loggerElement("ul");
        List<LoggerElement> majorStepLoggerElements = majorStepsLoggerElement.loggerElements("li");
        Iterator<LoggerElement> iterator = majorStepLoggerElements.iterator();
        while (iterator.hasNext()) {
            LoggerElement majorStepLoggerElement = iterator.next();
            majorStepLoggerElement.removeChildLoggerElements("button");
            if (iterator.hasNext()) {
                majorStepLoggerElement.removeChildLoggerElements("ul");
                continue;
            }
            if (this._containsMinorStepWarning) {
                this._warnStepLoggerElement(majorStepLoggerElement);
                continue;
            }
            this._failStepLoggerElement(majorStepLoggerElement);
        }
    }

    private String _replaceExecuteVars(String token, Element element) throws Exception {
        Matcher matcher = _pattern.matcher(token);
        while (matcher.find() && this._poshiVariablesContext.containsKeyInExecuteMap(matcher.group(1))) {
            String locatorKey;
            String varName = matcher.group(1);
            String varValue = HtmlUtil.escape(this._poshiVariablesContext.getStringFromExecuteMap(varName));
            if (element.attributeValue("function") != null && varName.startsWith("locator") && Validator.isNotNull((String)(locatorKey = this._poshiVariablesContext.getStringFromExecuteMap(varName = StringUtil.replace((String)varName, (String)"locator", (String)"locator-key"))))) {
                StringBuilder sb = new StringBuilder();
                sb.append("<em title=\"");
                sb.append(varValue);
                sb.append("\">");
                sb.append(locatorKey);
                sb.append("</em>");
                varValue = sb.toString();
            }
            token = StringUtil.replace((String)token, (String)matcher.group(), (String)varValue);
        }
        return token;
    }

    private void _startMajorStep(Element element) {
        this._majorStepElement = element;
    }

    private void _startMinorStep(Element element) {
        this._minorStepElement = element;
    }

    private void _stopMajorStep() {
        this._majorStepElement = null;
        this._majorStepLoggerElement = null;
        this._minorStepElement = null;
        this._minorStepLoggerElement = null;
        this._minorStepsLoggerElement = null;
    }

    private void _stopMinorStep() {
        this._minorStepElement = null;
        this._minorStepLoggerElement = null;
    }

    private void _warnStepLoggerElement(LoggerElement stepLoggerElement) {
        stepLoggerElement.addClassName("summary-warning");
        LoggerElement lineContainerLoggerElement = stepLoggerElement.loggerElement("div");
        if (lineContainerLoggerElement == null) {
            return;
        }
        lineContainerLoggerElement.addChildLoggerElement(this._getStatusLoggerElement("WARNING"));
        lineContainerLoggerElement.setName("strong");
    }
}

