/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.logger;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.PoshiStackTrace;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.exception.PoshiRunnerLoggerException;
import com.liferay.poshi.runner.logger.LoggerElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public abstract class SyntaxLogger {
    protected PoshiStackTrace poshiStackTrace;
    private int _btnLinkCollapseId;
    private int _btnLinkVarId;
    private final Map<String, LoggerElement> _loggerElements = new HashMap<String, LoggerElement>();
    private LoggerElement _syntaxLogLoggerElement;

    public SyntaxLogger() {
    }

    public SyntaxLogger(String namespacedClassCommandName) throws Exception {
        this.generateSyntaxLog(namespacedClassCommandName);
        this.poshiStackTrace = PoshiStackTrace.getPoshiStackTrace((String)namespacedClassCommandName);
    }

    public void generateSyntaxLog(String namespacedClassCommandName) throws PoshiRunnerLoggerException {
        this.poshiStackTrace = PoshiStackTrace.getPoshiStackTrace((String)namespacedClassCommandName);
        try {
            this._syntaxLogLoggerElement = new LoggerElement("syntaxLogContainer");
            this._syntaxLogLoggerElement.setClassName("syntax-log-container");
            this._syntaxLogLoggerElement.setName("ul");
            LoggerElement headerLoggerElement = new LoggerElement();
            headerLoggerElement.setClassName("header");
            headerLoggerElement.setName("li");
            LoggerElement lineContainerLoggerElement = new LoggerElement();
            lineContainerLoggerElement.setClassName("line-container");
            lineContainerLoggerElement.setID(null);
            lineContainerLoggerElement.setName("div");
            LoggerElement lineLoggerElement = new LoggerElement();
            lineLoggerElement.setClassName("test-case-command");
            lineLoggerElement.setID(null);
            lineLoggerElement.setName("h3");
            lineLoggerElement.setText(namespacedClassCommandName);
            lineContainerLoggerElement.addChildLoggerElement(lineLoggerElement);
            headerLoggerElement.addChildLoggerElement(lineContainerLoggerElement);
            LoggerElement childContainerLoggerElement = new LoggerElement();
            childContainerLoggerElement.setClassName("child-container");
            childContainerLoggerElement.setID(null);
            childContainerLoggerElement.setName("ul");
            String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
            String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName((String)namespacedClassCommandName);
            Element setUpElement = PoshiContext.getTestCaseCommandElement((String)(className + "#set-up"), (String)namespace);
            if (setUpElement != null) {
                this.poshiStackTrace.startStackTrace(namespace + "." + className + "#set-up", "test-case");
                childContainerLoggerElement.addChildLoggerElement(this.getLoggerElementFromElement(setUpElement));
                this.poshiStackTrace.emptyStackTrace();
            }
            this.poshiStackTrace.startStackTrace(namespacedClassCommandName, "test-case");
            String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
            Element testCaseElement = PoshiContext.getTestCaseCommandElement((String)classCommandName, (String)namespace);
            if (testCaseElement == null) {
                throw new PoshiRunnerLoggerException("No test case element found for " + classCommandName);
            }
            childContainerLoggerElement.addChildLoggerElement(this.getLoggerElementFromElement(testCaseElement));
            this.poshiStackTrace.emptyStackTrace();
            Element tearDownElement = PoshiContext.getTestCaseCommandElement((String)(className + "#tear-down"), (String)namespace);
            if (tearDownElement != null) {
                this.poshiStackTrace.startStackTrace(namespace + "." + className + "#tear-down", "test-case");
                childContainerLoggerElement.addChildLoggerElement(this.getLoggerElementFromElement(tearDownElement));
                this.poshiStackTrace.emptyStackTrace();
            }
            headerLoggerElement.addChildLoggerElement(childContainerLoggerElement);
            this._syntaxLogLoggerElement.addChildLoggerElement(headerLoggerElement);
        }
        catch (Throwable throwable) {
            throw new PoshiRunnerLoggerException(throwable.getMessage(), throwable);
        }
    }

    public LoggerElement getSyntaxLoggerElement(String stackTrace) {
        return this._loggerElements.get(stackTrace);
    }

    public String getSyntaxLogText() {
        return this._syntaxLogLoggerElement.toString();
    }

    public abstract void updateStatus(Element var1, String var2);

    protected LoggerElement getBtnContainerLoggerElement(Element element) {
        LoggerElement btnContainerLoggerElement = new LoggerElement();
        btnContainerLoggerElement.setClassName("btn-container");
        btnContainerLoggerElement.setName("div");
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLineNumberItemText(PoshiGetterUtil.getLineNumber((Element)element)));
        if (this.isExecuteChildElementLogged(element)) {
            sb.append(this.getBtnItemText("btn-collapse"));
        }
        btnContainerLoggerElement.setText(sb.toString());
        return btnContainerLoggerElement;
    }

    protected final String getBtnItemText(String className) {
        LoggerElement loggerElement = new LoggerElement();
        if (className.equals("btn-collapse")) {
            loggerElement.setAttribute("data-btnlinkid", "collapse-" + this._btnLinkCollapseId);
        } else if (className.equals("btn-var")) {
            loggerElement.setAttribute("data-btnlinkid", "var-" + this._btnLinkVarId);
        }
        loggerElement.setClassName("btn " + className);
        loggerElement.setID(null);
        loggerElement.setName("button");
        return loggerElement.toString();
    }

    protected int getBtnLinkVarId() {
        return this._btnLinkVarId;
    }

    protected LoggerElement getChildContainerLoggerElement() throws Exception {
        return this.getChildContainerLoggerElement(null, null);
    }

    protected LoggerElement getChildContainerLoggerElement(Element element) throws Exception {
        return this.getChildContainerLoggerElement(element, null);
    }

    protected LoggerElement getChildContainerLoggerElement(Element element, Element rootElement) throws Exception {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-btnlinkid", "collapse-" + this._btnLinkCollapseId);
        loggerElement.setClassName("child-container collapse collapsible");
        loggerElement.setName("ul");
        if (rootElement != null) {
            List rootVarElements = rootElement.elements("var");
            for (Element rootVarElement : rootVarElements) {
                loggerElement.addChildLoggerElement(this.getVarLoggerElement(rootVarElement));
            }
        }
        if (element != null) {
            List childElements = element.elements();
            for (Element childElement : childElements) {
                String childElementName = childElement.getName();
                if (childElementName.equals("description") || childElementName.equals("echo")) {
                    loggerElement.addChildLoggerElement(this.getEchoLoggerElement(childElement));
                    continue;
                }
                if (childElementName.equals("execute")) {
                    if (childElement.attributeValue("function") != null) {
                        loggerElement.addChildLoggerElement(this.getFunctionExecuteLoggerElement(childElement));
                        continue;
                    }
                    if (childElement.attributeValue("macro") != null) {
                        loggerElement.addChildLoggerElement(this.getMacroExecuteLoggerElement(childElement, "macro"));
                        continue;
                    }
                    if (childElement.attributeValue("method") != null) {
                        loggerElement.addChildLoggerElement(this.getMethodExecuteLoggerElement(childElement));
                        continue;
                    }
                    if (childElement.attributeValue("test-case") == null) continue;
                    loggerElement.addChildLoggerElement(this.getTestCaseExecuteLoggerElement(childElement));
                    continue;
                }
                if (childElementName.equals("fail")) {
                    loggerElement.addChildLoggerElement(this.getFailLoggerElement(childElement));
                    continue;
                }
                if (childElementName.equals("for") || childElementName.equals("task")) {
                    loggerElement.addChildLoggerElement(this.getForLoggerElement(childElement));
                    continue;
                }
                if (childElementName.equals("if")) {
                    loggerElement.addChildLoggerElement(this.getIfLoggerElement(childElement));
                    continue;
                }
                if (childElementName.equals("return")) {
                    loggerElement.addChildLoggerElement(this.getReturnLoggerElement(childElement));
                    continue;
                }
                if (childElementName.equals("take-screenshot")) {
                    loggerElement.addChildLoggerElement(this.getTakeScreenshotLoggerElement(childElement));
                    continue;
                }
                if (childElementName.equals("var")) {
                    loggerElement.addChildLoggerElement(this.getVarLoggerElement(childElement));
                    continue;
                }
                if (!childElementName.equals("while")) continue;
                loggerElement.addChildLoggerElement(this.getWhileLoggerElement(childElement));
            }
        }
        return loggerElement;
    }

    protected LoggerElement getEchoLoggerElement(Element element) {
        return this.getLineGroupLoggerElement("echo", element);
    }

    protected LoggerElement getFailLoggerElement(Element element) {
        return this.getLineGroupLoggerElement(element);
    }

    protected LoggerElement getForLoggerElement(Element element) throws Exception {
        return this.getLoggerElementFromElement(element);
    }

    protected LoggerElement getFunctionExecuteLoggerElement(Element element) {
        return this.getLineGroupLoggerElement("function", element);
    }

    protected abstract LoggerElement getIfLoggerElement(Element var1) throws Exception;

    protected abstract LoggerElement getLineContainerLoggerElement(Element var1);

    protected LoggerElement getLineGroupLoggerElement(Element element) {
        return this.getLineGroupLoggerElement(null, element);
    }

    protected LoggerElement getLineGroupLoggerElement(String className, Element element) {
        ++this._btnLinkCollapseId;
        ++this._btnLinkVarId;
        this.poshiStackTrace.setCurrentElement(element);
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("line-group");
        loggerElement.setName("li");
        if (Validator.isNotNull((String)className)) {
            loggerElement.addClassName(className);
        }
        loggerElement.addChildLoggerElement(this.getBtnContainerLoggerElement(element));
        loggerElement.addChildLoggerElement(this.getLineContainerLoggerElement(element));
        this._loggerElements.put(this.poshiStackTrace.getSimpleStackTraceMessage(), loggerElement);
        return loggerElement;
    }

    protected String getLineItemText(String className, String text) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName(className);
        loggerElement.setID(null);
        loggerElement.setName("span");
        loggerElement.setText(text);
        return loggerElement.toString();
    }

    protected LoggerElement getLineNumberItem(int lineNumber) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setClassName("line-number");
        loggerElement.setID(null);
        loggerElement.setName("div");
        loggerElement.setText(String.valueOf(lineNumber));
        return loggerElement;
    }

    protected final String getLineNumberItemText(int lineNumber) {
        LoggerElement loggerElement = this.getLineNumberItem(lineNumber);
        return loggerElement.toString();
    }

    protected abstract LoggerElement getLoggerElementFromElement(Element var1) throws Exception;

    protected LoggerElement getMacroExecuteLoggerElement(Element executeElement, String macroType) throws Exception {
        LoggerElement loggerElement = this.getLineGroupLoggerElement("macro", executeElement);
        String classCommandName = executeElement.attributeValue(macroType);
        this.poshiStackTrace.pushStackTrace(executeElement);
        loggerElement.addChildLoggerElement(this._getMacroCommandLoggerElement(classCommandName));
        this.poshiStackTrace.popStackTrace();
        return loggerElement;
    }

    protected LoggerElement getMethodExecuteLoggerElement(Element executeElement) throws Exception {
        return this.getLineGroupLoggerElement("method", executeElement);
    }

    protected LoggerElement getReturnLoggerElement(Element element) {
        return this.getLineGroupLoggerElement("return", element);
    }

    protected LoggerElement getTakeScreenshotLoggerElement(Element element) {
        return this.getLineGroupLoggerElement("take-screenshot", element);
    }

    protected LoggerElement getTestCaseCommandLoggerElement(String namespacedClassCommandName) throws Exception {
        Element commandElement = PoshiContext.getTestCaseCommandElement((String)namespacedClassCommandName, (String)PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName((String)namespacedClassCommandName));
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        Element rootElement = PoshiContext.getTestCaseRootElement((String)className, (String)PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName((String)namespacedClassCommandName));
        return this.getChildContainerLoggerElement(commandElement, rootElement);
    }

    protected LoggerElement getTestCaseExecuteLoggerElement(Element executeElement) throws Exception {
        LoggerElement loggerElement = this.getLineGroupLoggerElement("test-case", executeElement);
        String namespacedClassCommandName = executeElement.attributeValue("test-case");
        this.poshiStackTrace.pushStackTrace(executeElement);
        loggerElement.addChildLoggerElement(this.getTestCaseCommandLoggerElement(namespacedClassCommandName));
        this.poshiStackTrace.popStackTrace();
        return loggerElement;
    }

    protected LoggerElement getVarLoggerElement(Element element) {
        return this.getLineGroupLoggerElement("var", element);
    }

    protected abstract LoggerElement getWhileLoggerElement(Element var1) throws Exception;

    protected boolean isExecuteChildElementLogged(Element element) {
        List childElements = element.elements();
        return !childElements.isEmpty() && !this.isExecutingFunction(element) && !this.isExecutingMethod(element) || this.isExecutingMacro(element) || this.isExecutingTestCase(element);
    }

    protected boolean isExecuting(Element element) {
        return this.isExecutingFunction(element) || this.isExecutingMacro(element) || this.isExecutingMethod(element) || this.isExecutingTestCase(element);
    }

    protected boolean isExecutingFunction(Element element) {
        return element.attributeValue("function") != null;
    }

    protected boolean isExecutingMacro(Element element) {
        return element.attributeValue("macro") != null;
    }

    protected boolean isExecutingMethod(Element element) {
        return element.attributeValue("method") != null;
    }

    protected boolean isExecutingTestCase(Element element) {
        return element.attributeValue("test-case") != null;
    }

    protected void updateElementStatus(Element element, String status) {
        this.poshiStackTrace.setCurrentElement(element);
        String stackTrace = this.poshiStackTrace.getSimpleStackTraceMessage();
        if (stackTrace.contains(".function")) {
            return;
        }
        LoggerElement loggerElement = this.getSyntaxLoggerElement(stackTrace);
        loggerElement.setAttribute("data-status01", status);
    }

    private LoggerElement _getMacroCommandLoggerElement(String namespacedClassCommandName) throws Exception {
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        String namespace = this.poshiStackTrace.getCurrentNamespace(namespacedClassCommandName);
        Element commandElement = PoshiContext.getMacroCommandElement((String)classCommandName, (String)namespace);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName((String)namespacedClassCommandName);
        Element rootElement = PoshiContext.getMacroRootElement((String)className, (String)namespace);
        return this.getChildContainerLoggerElement(commandElement, rootElement);
    }
}

