/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.logger;

import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.logger.LoggerElement;
import com.liferay.poshi.runner.logger.SyntaxLogger;
import com.liferay.poshi.runner.util.HtmlUtil;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public final class XMLSyntaxLogger
extends SyntaxLogger {
    public XMLSyntaxLogger(String namespacedClassCommandName) throws Exception {
        super(namespacedClassCommandName);
    }

    @Override
    public void updateStatus(Element element, String status) {
        this.updateElementStatus(element, status);
        String elementName = element.getName();
        if (elementName.equals("else") || elementName.equals("elseif")) {
            Element ifElement = element.getParent();
            this.updateElementStatus(ifElement, status);
        }
        this.poshiStackTrace.setCurrentElement(element);
    }

    @Override
    protected LoggerElement getBtnContainerLoggerElement(Element element) {
        List childElements;
        LoggerElement btnContainerLoggerElement = new LoggerElement();
        btnContainerLoggerElement.setClassName("btn-container");
        btnContainerLoggerElement.setName("div");
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLineNumberItemText(PoshiGetterUtil.getLineNumber((Element)element)));
        if (this.isExecuteChildElementLogged(element)) {
            sb.append(this.getBtnItemText("btn-collapse"));
        }
        if (!(childElements = element.elements()).isEmpty() && this.isExecuting(element)) {
            sb.append(this.getBtnItemText("btn-var"));
        }
        btnContainerLoggerElement.setText(sb.toString());
        return btnContainerLoggerElement;
    }

    @Override
    protected LoggerElement getIfLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = this.getLineGroupLoggerElement("conditional", element);
        loggerElement.addChildLoggerElement(this._getIfChildContainerLoggerElement(element));
        loggerElement.addChildLoggerElement(this._getClosingLineContainerLoggerElement(element));
        return loggerElement;
    }

    @Override
    protected LoggerElement getLineContainerLoggerElement(Element element) {
        LoggerElement lineContainerLoggerElement = new LoggerElement();
        lineContainerLoggerElement.setClassName("line-container");
        lineContainerLoggerElement.setName("div");
        if (element.attributeValue("macro") != null) {
            lineContainerLoggerElement.setAttribute("onmouseout", "macroHover(this, false)");
            lineContainerLoggerElement.setAttribute("onmouseover", "macroHover(this, true)");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLineItemText("misc", "&lt;"));
        sb.append(this.getLineItemText("action-type", element.getName()));
        List attributes = element.attributes();
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (attributeName.equals("line-number")) continue;
            sb.append(this.getLineItemText("tag-type", attributeName));
            sb.append(this.getLineItemText("misc", "="));
            sb.append(this.getLineItemText("misc quote", "\""));
            sb.append(this.getLineItemText("name", attribute.getValue()));
            sb.append(this.getLineItemText("misc quote", "\""));
        }
        List elements = element.elements();
        String innerText = element.getText();
        innerText = innerText.trim();
        if (elements.isEmpty() && Validator.isNull((String)innerText)) {
            sb.append(this.getLineItemText("misc", "/&gt;"));
        } else {
            sb.append(this.getLineItemText("misc", "&gt;"));
        }
        if (Validator.isNotNull((String)innerText)) {
            sb.append(this.getLineItemText("name", HtmlUtil.escape(innerText)));
            sb.append(this.getLineItemText("misc", "&lt;/"));
            sb.append(this.getLineItemText("action-type", element.getName()));
            sb.append(this.getLineItemText("misc", "&gt;"));
        }
        lineContainerLoggerElement.setText(sb.toString());
        String elementName = element.getName();
        if (elementName.equals("execute") && !elements.isEmpty()) {
            lineContainerLoggerElement.addChildLoggerElement(this._getParameterContainerLoggerElement(element));
        }
        return lineContainerLoggerElement;
    }

    @Override
    protected LoggerElement getLoggerElementFromElement(Element element) throws Exception {
        LoggerElement loggerElement = this.getLineGroupLoggerElement(element);
        loggerElement.addChildLoggerElement(this.getChildContainerLoggerElement(element));
        loggerElement.addChildLoggerElement(this._getClosingLineContainerLoggerElement(element));
        return loggerElement;
    }

    @Override
    protected LoggerElement getWhileLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = this.getLineGroupLoggerElement(element);
        loggerElement.addChildLoggerElement(this._getIfChildContainerLoggerElement(element));
        loggerElement.addChildLoggerElement(this._getClosingLineContainerLoggerElement(element));
        return loggerElement;
    }

    private LoggerElement _getClosingLineContainerLoggerElement(Element element) {
        LoggerElement closingLineContainerLoggerElement = new LoggerElement();
        closingLineContainerLoggerElement.setClassName("line-container");
        closingLineContainerLoggerElement.setName("div");
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLineItemText("misc", "&lt;/"));
        sb.append(this.getLineItemText("action-type", element.getName()));
        sb.append(this.getLineItemText("misc", "&gt;"));
        closingLineContainerLoggerElement.setText(sb.toString());
        return closingLineContainerLoggerElement;
    }

    private LoggerElement _getConditionalLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = null;
        loggerElement = this.isExecutingFunction(element) ? this.getLineGroupLoggerElement("conditional-function", element) : this.getLineGroupLoggerElement("conditional", element);
        List childElements = element.elements();
        if (!childElements.isEmpty()) {
            LoggerElement childContainerLoggerElement = this.getChildContainerLoggerElement();
            for (Element childElement : childElements) {
                childContainerLoggerElement.addChildLoggerElement(this._getConditionalLoggerElement(childElement));
            }
            loggerElement.addChildLoggerElement(childContainerLoggerElement);
            loggerElement.addChildLoggerElement(this._getClosingLineContainerLoggerElement(element));
        }
        return loggerElement;
    }

    private LoggerElement _getIfChildContainerLoggerElement(Element element) throws Exception {
        LoggerElement loggerElement = this.getChildContainerLoggerElement();
        List childElements = element.elements();
        Element conditionElement = (Element)childElements.get(0);
        loggerElement.addChildLoggerElement(this._getConditionalLoggerElement(conditionElement));
        Element thenElement = element.element("then");
        loggerElement.addChildLoggerElement(this.getLoggerElementFromElement(thenElement));
        List elseIfElements = element.elements("elseif");
        for (Element elseIfElement : elseIfElements) {
            loggerElement.addChildLoggerElement(this.getIfLoggerElement(elseIfElement));
        }
        Element elseElement = element.element("else");
        if (elseElement != null) {
            loggerElement.addChildLoggerElement(this.getLoggerElementFromElement(elseElement));
        }
        return loggerElement;
    }

    private LoggerElement _getParameterContainerLoggerElement(Element element) {
        LoggerElement loggerElement = new LoggerElement();
        loggerElement.setAttribute("data-btnlinkid", "var-" + this.getBtnLinkVarId());
        loggerElement.setClassName("child-container collapse parameter-container");
        loggerElement.setID(null);
        loggerElement.setName("div");
        List childElements = element.elements();
        for (Element childElement : childElements) {
            loggerElement.addChildLoggerElement(this.getLineNumberItem(PoshiGetterUtil.getLineNumber((Element)childElement)));
            loggerElement.addChildLoggerElement(this.getLineContainerLoggerElement(childElement));
        }
        return loggerElement;
    }
}

