/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.selenium;

import com.deque.html.axecore.results.Results;
import com.deque.html.axecore.selenium.AxeBuilder;
import com.deque.html.axecore.selenium.AxeReporter;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.selenium.LiferaySelenium;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.exception.ElementNotFoundPoshiRunnerException;
import com.liferay.poshi.runner.exception.JavaScriptException;
import com.liferay.poshi.runner.exception.PoshiRunnerWarningException;
import com.liferay.poshi.runner.selenium.LiferaySeleniumUtil;
import com.liferay.poshi.runner.selenium.RetryWebElementImpl;
import com.liferay.poshi.runner.util.AntCommands;
import com.liferay.poshi.runner.util.ArchiveUtil;
import com.liferay.poshi.runner.util.EmailCommands;
import com.liferay.poshi.runner.util.HtmlUtil;
import com.liferay.poshi.runner.var.type.DefaultTable;
import com.liferay.poshi.runner.var.type.Table;
import com.testautomationguru.ocular.Ocular;
import com.testautomationguru.ocular.OcularConfiguration;
import com.testautomationguru.ocular.comparator.OcularResult;
import com.testautomationguru.ocular.sample.SampleBuilder;
import com.testautomationguru.ocular.snapshot.SnapshotBuilder;
import java.awt.Robot;
import java.io.File;
import java.io.StringReader;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import junit.framework.TestCase;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.chromium.HasCdp;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.Region;
import org.sikuli.api.ScreenLocation;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.api.robot.desktop.DesktopKeyboard;
import org.sikuli.api.robot.desktop.DesktopMouse;
import org.sikuli.api.visual.CanvasBuilder;
import org.sikuli.api.visual.DesktopCanvas;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class BaseWebDriverImpl
implements LiferaySelenium,
WebDriver {
    protected PoshiProperties poshiProperties;
    private static final String _OCULAR_BASELINE_IMAGE_DIR_NAME;
    private static final String _OCULAR_RESULT_IMAGE_DIR_NAME;
    private static final String _OUTPUT_DIR_NAME;
    private static final String _SIKULI_IMAGES_DIR_NAME;
    private static final String _TEST_DEPENDENCIES_DIR_NAME;
    private static final Pattern _aceEditorPattern;
    private static final Pattern _coordinatePairsPattern;
    private static final Map<String, Integer> _keyCodeMap;
    private static final Map<String, Keys> _keysMap;
    private static final Pattern _tabPattern;
    private Alert _alert;
    private String _clipBoard = "";
    private String _defaultWindowHandle;
    private final Stack<WebElement> _frameWebElements = new Stack();
    private int _navigationBarHeight = 120;
    private String _primaryTestSuiteName;
    private String _testName;
    private int _totalPauseDuration;
    private final WebDriver _webDriver;

    public BaseWebDriverImpl(String browserURL, WebDriver webDriver) {
        System.setProperty("java.awt.headless", "false");
        this.poshiProperties = PoshiProperties.getPoshiProperties();
        this._webDriver = webDriver;
        this.setDefaultWindowHandle(webDriver.getWindowHandle());
        WebDriver.Options options = webDriver.manage();
        options.deleteAllCookies();
        WebDriver.Window window = options.window();
        window.setSize(new Dimension(1280, 1040));
        try {
            webDriver.get(browserURL);
        }
        catch (WebDriverException webDriverException) {
            String message = webDriverException.getMessage();
            if (!message.contains("ERR_CONNECTION_REFUSED")) {
                throw webDriverException;
            }
            System.out.println(browserURL + " is unavailable");
        }
        this.ocularConfig();
    }

    public void acceptAlert() {
        Alert alert = this.getAlert();
        alert.accept();
        this.setAlert(null);
    }

    public void addSelection(String locator, String optionLocator) {
        Select select = new Select(this.getWebElement(locator));
        if (optionLocator.startsWith("index=")) {
            select.selectByIndex(GetterUtil.getInteger((String)optionLocator.substring(6)));
        } else if (optionLocator.startsWith("label=")) {
            select.selectByVisibleText(optionLocator.substring(6));
        } else if (optionLocator.startsWith("value=")) {
            select.selectByValue(optionLocator.substring(6));
        } else {
            select.selectByVisibleText(optionLocator);
        }
    }

    public void antCommand(String fileName, String target) throws Exception {
        AntCommands antCommands = new AntCommands(fileName, target);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<Void> future = executorService.submit(antCommands);
        try {
            future.get(150L, TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            throw executionException;
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void assertAccessible() throws Exception {
        this.assertElementAccessible(null);
    }

    public void assertAlert(String pattern) throws Exception {
        TestCase.assertEquals((String)pattern, (String)this.getAlertText());
    }

    public void assertAlertNotPresent() throws Exception {
        if (this.isAlertPresent()) {
            throw new Exception("Alert is present");
        }
    }

    public void assertAlertText(String pattern) throws Exception {
        Alert alert = this.getAlert();
        String alertText = alert.getText();
        if (!pattern.equals(alertText)) {
            String message = StringUtil.combine((String[])new String[]{"Expected text \"", pattern, "\" does not match actual text \"", alertText, "\""});
            throw new Exception(message);
        }
    }

    public void assertAttributeNotPresent(String attribute, String locator) throws Exception {
        if (this.isAttributePresent(attribute, locator)) {
            throw new Exception("Unexpected attribute \"" + attribute + "\" is present");
        }
    }

    public void assertAttributePresent(String attribute, String locator) throws Exception {
        if (!this.isAttributePresent(attribute, locator)) {
            throw new Exception("Expected attribute \"" + attribute + "\" is not present");
        }
    }

    public void assertAttributeValue(String attribute, String locator, String pattern) throws Exception {
        WebElement webElement = this.getWebElement(locator);
        String actualValue = webElement.getAttribute(attribute);
        if (!pattern.equals(actualValue)) {
            throw new Exception("Actual value of attribute \"" + attribute + "\", \"" + actualValue + "\" does not match expected value \"" + pattern + "\"");
        }
    }

    public void assertChecked(String locator) throws Exception {
        this.assertElementPresent(locator);
        if (this.isNotChecked(locator)) {
            throw new Exception("Element is not checked at \"" + locator + "\"");
        }
    }

    public void assertConfirmation(String pattern) throws Exception {
        Condition confirmationCondition = this.getConfirmationCondition(pattern);
        confirmationCondition.assertTrue();
    }

    public void assertConsoleErrors() throws Exception {
        LiferaySeleniumUtil.assertConsoleErrors();
    }

    public void assertConsoleTextNotPresent(String text) throws Exception {
        Condition consoleTextNotPresentCondition = this.getConsoleTextNotPresentCondition(text);
        consoleTextNotPresentCondition.assertTrue();
    }

    public void assertConsoleTextPresent(String text) throws Exception {
        Condition consoleTextPresentCondition = this.getConsoleTextPresentCondition(text);
        consoleTextPresentCondition.assertTrue();
    }

    public void assertCssValue(String locator, String cssAttribute, String cssValue) throws Exception {
        WebElement webElement = this.getWebElement(locator);
        String actualCssValue = webElement.getCssValue(cssAttribute);
        if (!actualCssValue.equals(cssValue)) {
            throw new Exception("CSS Value " + actualCssValue + " does not match " + cssValue);
        }
    }

    public void assertEditable(String locator) throws Exception {
        Condition editableCondition = this.getEditableCondition(locator);
        editableCondition.assertTrue();
    }

    public void assertElementAccessible(String locator) throws Exception {
        AxeBuilder axeBuilder = new AxeBuilder();
        axeBuilder.withTags(Arrays.asList(this.poshiProperties.accessibilityStandardsTags.split(",")));
        Results results = null;
        results = Validator.isNotNull((String)locator) ? axeBuilder.analyze(this._webDriver, new WebElement[]{this.getWebElement(locator)}) : axeBuilder.analyze(this._webDriver);
        List violations = results.getViolations();
        if (!violations.isEmpty()) {
            AxeReporter.getReadableAxeResults((String)"analyze", (WebDriver)this, (List)violations);
            throw new Exception(AxeReporter.getAxeResultString());
        }
    }

    public void assertElementFocused(String locator) throws Exception {
        Condition elementFocusedCondition = this.getElementFocusedCondition(locator);
        elementFocusedCondition.assertTrue();
    }

    public void assertElementNotFocused(String locator) throws Exception {
        Condition elementNotFocusedCondition = this.getElementNotFocusedCondition(locator);
        elementNotFocusedCondition.assertTrue();
    }

    public void assertElementNotPresent(String locator) throws Exception {
        Condition elementNotPresentCondition = this.getElementNotPresentCondition(locator);
        elementNotPresentCondition.assertTrue();
    }

    public void assertElementPresent(String locator) throws Exception {
        Condition elementPresentCondition = this.getElementPresentCondition(locator);
        elementPresentCondition.assertTrue();
    }

    public void assertEmailBody(String index, String body) throws Exception {
        TestCase.assertEquals((String)body, (String)this.getEmailBody(index));
    }

    public void assertEmailSubject(String index, String subject) throws Exception {
        TestCase.assertEquals((String)subject, (String)this.getEmailSubject(index));
    }

    public void assertHTMLSourceTextNotPresent(String value) throws Exception {
        if (this.isHTMLSourceTextPresent(value)) {
            throw new Exception("Pattern \"" + value + "\" does exists in the HTML source");
        }
    }

    public void assertHTMLSourceTextPresent(String value) throws Exception {
        if (!this.isHTMLSourceTextPresent(value)) {
            throw new Exception("Pattern \"" + value + "\" does not exists in the HTML source");
        }
    }

    public void assertJavaScript(String javaScript, String message, String argument) throws Exception {
        Condition javaScriptCondition = this.getJavaScriptCondition(javaScript, message, argument);
        javaScriptCondition.assertTrue();
    }

    public void assertJavaScriptErrors(String ignoreJavaScriptError) throws Exception {
        if (!this.poshiProperties.testAssertJavascriptErrors) {
            return;
        }
        String pageSource = null;
        try {
            pageSource = this.getPageSource();
        }
        catch (Exception exception) {
            WebDriver.TargetLocator targetLocator = this.switchTo();
            targetLocator.window(this._defaultWindowHandle);
            pageSource = this.getPageSource();
        }
        if (pageSource == null) {
            System.out.println("Unable to obtain HTML source");
        } else if (pageSource.contains("html id=\"feedHandler\" xmlns=\"http://www.w3.org/1999/xhtml\"")) {
            return;
        }
        JavaScriptException javaScriptException = null;
        List javaScriptErrors = JavaScriptError.readErrors((WebDriver)this.getWrappedWebDriver("//body"));
        for (JavaScriptError javaScriptError : javaScriptErrors) {
            String javaScriptErrorValue = javaScriptError.toString();
            if (Validator.isNotNull((String)ignoreJavaScriptError) && javaScriptErrorValue.contains(ignoreJavaScriptError) || LiferaySeleniumUtil.isInIgnoreErrorsFile(javaScriptErrorValue, "javascript")) continue;
            String message = "JAVA_SCRIPT_ERROR: " + javaScriptErrorValue;
            System.out.println(message);
            if (javaScriptException == null) {
                javaScriptException = new JavaScriptException(message);
                continue;
            }
            PoshiRunnerWarningException.addException(new JavaScriptException(message));
        }
        if (javaScriptException != null) {
            throw javaScriptException;
        }
    }

    public void assertLiferayErrors() throws Exception {
        LiferaySeleniumUtil.assertConsoleErrors();
    }

    public void assertLocation(String pattern) throws Exception {
        TestCase.assertEquals((String)pattern, (String)this.getLocation());
    }

    public void assertNoJavaScriptExceptions() throws Exception {
        LiferaySeleniumUtil.assertNoJavaScriptExceptions();
    }

    public void assertNoLiferayExceptions() throws Exception {
        LiferaySeleniumUtil.assertNoLiferayExceptions();
    }

    public void assertNotAlert(String pattern) {
        TestCase.assertTrue((boolean)Objects.equals(pattern, this.getAlertText()));
    }

    public void assertNotAttributeValue(String locator, String attribute, String forbiddenValue) throws Exception {
        WebElement webElement = this.getWebElement(locator);
        String actualValue = webElement.getAttribute(attribute);
        if (forbiddenValue.equals(actualValue)) {
            throw new Exception("Actual value of attribute \"" + attribute + "\" matches forbidden value \"" + forbiddenValue + "\"");
        }
    }

    public void assertNotChecked(String locator) throws Exception {
        this.assertElementPresent(locator);
        if (this.isChecked(locator)) {
            throw new Exception("Element is checked at \"" + locator + "\"");
        }
    }

    public void assertNotEditable(String locator) throws Exception {
        Condition notEditable = this.getNotEditableCondition(locator);
        notEditable.assertTrue();
    }

    public void assertNotLocation(String pattern) throws Exception {
        TestCase.assertTrue((boolean)Objects.equals(pattern, this.getLocation()));
    }

    public void assertNotPartialText(String locator, String pattern) throws Exception {
        this.assertElementPresent(locator);
        Condition notPartialText = this.getNotPartialTextCondition(locator, pattern);
        notPartialText.assertTrue();
    }

    public void assertNotSelectedLabel(String selectLocator, String pattern) throws Exception {
        this.assertElementPresent(selectLocator);
        Condition notSelectedLabelCondition = this.getNotSelectedLabelCondition(selectLocator, pattern);
        notSelectedLabelCondition.assertTrue();
    }

    public void assertNotText(String locator, String pattern) throws Exception {
        this.assertElementPresent(locator);
        Condition notTextCondition = this.getNotTextCondition(locator, pattern);
        notTextCondition.assertTrue();
    }

    public void assertNotValue(String locator, String pattern) throws Exception {
        this.assertElementPresent(locator);
        Condition notValueCondition = this.getNotValueCondition(locator, pattern);
        notValueCondition.assertTrue();
    }

    public void assertNotVisible(String locator) throws Exception {
        this.assertElementPresent(locator);
        Condition notVisibleCondition = this.getNotVisibleCondition(locator);
        notVisibleCondition.assertTrue();
    }

    public void assertNotVisibleInPage(String locator) throws Exception {
        this.assertElementPresent(locator);
        Condition notVisibleInPageCondition = this.getNotVisibleInPageCondition(locator);
        notVisibleInPageCondition.assertTrue();
    }

    public void assertNotVisibleInViewport(String locator) throws Exception {
        this.assertElementPresent(locator);
        Condition notVisibleInViewportCondition = this.getNotVisibleInViewportCondition(locator);
        notVisibleInViewportCondition.assertTrue();
    }

    public void assertPartialConfirmation(String pattern) throws Exception {
        String confirmation = this.getConfirmation(null);
        if (!confirmation.contains(pattern)) {
            throw new Exception("\"" + confirmation + "\" does not contain \"" + pattern + "\"");
        }
    }

    public void assertPartialLocation(String pattern) throws Exception {
        String location = this.getLocation();
        if (!location.contains(pattern)) {
            throw new Exception("\"" + location + "\" does not contain \"" + pattern + "\"");
        }
    }

    public void assertPartialText(String locator, String pattern) throws Exception {
        this.assertElementPresent(locator);
        Condition partialTextCondition = this.getPartialTextCondition(locator, pattern);
        partialTextCondition.assertTrue();
    }

    public void assertPartialTextAceEditor(String locator, String pattern) throws Exception {
        this.assertElementPresent(locator);
        Condition partialTextAceEditorCondition = this.getPartialTextAceEditorCondition(locator, pattern);
        partialTextAceEditorCondition.assertTrue();
    }

    public void assertPartialTextCaseInsensitive(String locator, String pattern) throws Exception {
        this.assertElementPresent(locator);
        Condition partialTextCaseInsensitiveCondition = this.getPartialTextCaseInsensitiveCondition(locator, pattern);
        partialTextCaseInsensitiveCondition.assertTrue();
    }

    public void assertPrompt(String pattern, String value) throws Exception {
        String confirmation = this.getConfirmation(value);
        if (!pattern.equals(confirmation)) {
            throw new Exception("Expected text \"" + pattern + "\" does not match actual text \"" + confirmation + "\"");
        }
    }

    public void assertSelectedLabel(String selectLocator, String pattern) throws Exception {
        this.assertElementPresent(selectLocator);
        Condition selectedLabelCondition = this.getSelectedLabelCondition(selectLocator, pattern);
        selectedLabelCondition.assertTrue();
    }

    public void assertTable(String locator, String tableString) throws Exception {
        Table htmlTable = this.getHTMLTable(locator);
        DefaultTable table = new DefaultTable(tableString);
        if (htmlTable.getTableSize() != table.getTableSize()) {
            throw new Exception("Expected " + table.getTableSize() + " rows but found " + htmlTable.getTableSize() + " rows");
        }
        for (int i = 0; i < htmlTable.getTableSize(); ++i) {
            List<String> htmlCellValues = htmlTable.getRowByIndex(i);
            List<String> cellValues = table.getRowByIndex(i);
            if (htmlCellValues.size() != cellValues.size()) {
                throw new Exception("Expected " + cellValues.size() + " columns but found " + htmlCellValues.size() + " columns");
            }
            for (int j = 0; j < htmlCellValues.size(); ++j) {
                String cellValue;
                String htmlCellValue = htmlCellValues.get(j);
                if (htmlCellValue.equals(cellValue = cellValues.get(j))) continue;
                throw new Exception("Expected text \"" + cellValue + "\" does not match actual text \"" + htmlCellValue + "\"");
            }
        }
    }

    public void assertText(String locator, String pattern) throws Exception {
        this.assertElementPresent(locator);
        Condition textCondition = this.getTextCondition(locator, pattern);
        textCondition.assertTrue();
    }

    public void assertTextCaseInsensitive(String locator, String pattern) throws Exception {
        Condition textCaseInsensitiveCondition = this.getTextCaseInsensitiveCondition(locator, pattern);
        textCaseInsensitiveCondition.assertTrue();
    }

    public void assertTextMatches(String locator, String regex) throws Exception {
        this.assertElementPresent(locator);
        Condition textMatchedCondition = this.getTextMatchesCondition(locator, regex);
        textMatchedCondition.assertTrue();
    }

    public void assertTextNotPresent(String pattern) throws Exception {
        Condition textNotPresentCondition = this.getTextNotPresentCondition(pattern);
        textNotPresentCondition.assertTrue();
    }

    public void assertTextPresent(String pattern) throws Exception {
        Condition textPresentCondition = this.getTextPresentCondition(pattern);
        textPresentCondition.assertTrue();
    }

    public void assertValue(String locator, String pattern) throws Exception {
        this.assertElementPresent(locator);
        Condition valueCondition = this.getValueCondition(locator, pattern);
        valueCondition.assertTrue();
    }

    public void assertVisible(String locator) throws Exception {
        this.assertElementPresent(locator);
        Condition visibleCondition = this.getVisibleCondition(locator);
        visibleCondition.assertTrue();
    }

    public void assertVisibleInPage(String locator) throws Exception {
        this.assertElementPresent(locator);
        Condition visibleInPageCondition = this.getVisibleInPageCondition(locator);
        visibleInPageCondition.assertTrue();
    }

    public void assertVisibleInViewport(String locator) throws Exception {
        this.assertElementPresent(locator);
        Condition visibleInViewportCondition = this.getVisibleInViewportCondition(locator);
        visibleInViewportCondition.assertTrue();
    }

    public void check(String locator) {
        WebElement webElement = this.getWebElement(locator);
        if (!webElement.isSelected()) {
            webElement.click();
        }
    }

    public void click(String locator) {
        if (locator.contains("x:")) {
            String url = this.getHtmlNodeHref(locator);
            this.open(url);
        } else {
            this.clickAt(locator, null);
        }
    }

    public void clickAt(String locator, String offset) {
        WebElement webElement = this.getWebElement(locator);
        if (Validator.isNotNull((String)offset) && offset.contains(",")) {
            this.scrollWebElementIntoView(webElement);
            Actions actions = new Actions(this.getWrappedWebDriver(webElement));
            this.moveToElement(actions, webElement, offset);
            actions.pause(1500L);
            actions.click();
            Action action = actions.build();
            action.perform();
        } else {
            try {
                webElement.click();
            }
            catch (Exception exception) {
                this.scrollWebElementIntoView(webElement);
                webElement.click();
            }
        }
    }

    public void close() {
        this._webDriver.close();
    }

    public void connectToEmailAccount(String emailAddress, String emailPassword) throws Exception {
        LiferaySeleniumUtil.connectToEmailAccount(emailAddress, emailPassword);
    }

    public void copyText(String locator) throws Exception {
        this._clipBoard = this.getText(locator);
    }

    public void copyValue(String locator) throws Exception {
        this._clipBoard = this.getElementValue(locator);
    }

    public void deleteAllEmails() throws Exception {
        LiferaySeleniumUtil.deleteAllEmails();
    }

    public void dismissAlert() {
        Alert alert = this.getAlert();
        alert.dismiss();
        this.setAlert(null);
    }

    public void doubleClick(String locator) {
        this.doubleClickAt(locator, null);
    }

    public void doubleClickAt(String locator, String offset) {
        WebElement webElement = this.getWebElement(locator);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        if (Validator.isNotNull((String)offset) && offset.contains(",")) {
            this.moveToElement(actions, webElement, offset);
            actions.doubleClick();
        } else {
            actions.doubleClick(webElement);
        }
        Action action = actions.build();
        action.perform();
    }

    public void dragAndDrop(String locator, String coordinatePairs) {
        this.dragAtAndDrop(locator, null, coordinatePairs);
    }

    public void dragAndDropToObject(String locatorOfObjectToBeDragged, String locatorOfDragDestinationObject) {
        WebElement objectToBeDraggedWebElement = this.getWebElement(locatorOfObjectToBeDragged);
        WebDriver wrappedWebDriver = this.getWrappedWebDriver(objectToBeDraggedWebElement);
        Actions actions = new Actions(wrappedWebDriver);
        WebElement dragDestinationObjectWebElement = this.getWebElement(locatorOfDragDestinationObject);
        actions.dragAndDrop(objectToBeDraggedWebElement, dragDestinationObjectWebElement);
        Action action = actions.build();
        action.perform();
    }

    public void dragAtAndDrop(String locator, String offset, String destinationOffsets) {
        Matcher matcher = _coordinatePairsPattern.matcher(destinationOffsets);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Coordinate pairs \"" + destinationOffsets + "\" do not match pattern \"" + _coordinatePairsPattern.pattern() + "\"");
        }
        WebElement webElement = this.getWebElement(locator);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        if (Validator.isNotNull((String)offset)) {
            this.moveToElement(actions, webElement, offset);
            actions.clickAndHold();
        } else {
            actions.clickAndHold(webElement);
        }
        actions.pause(1500L);
        for (String destinationOffset : destinationOffsets.split("\\|")) {
            String[] destinationOffsetCoordinates = destinationOffset.split(",");
            actions.moveByOffset(GetterUtil.getInteger((String)destinationOffsetCoordinates[0]), GetterUtil.getInteger((String)destinationOffsetCoordinates[1]));
        }
        actions.pause(1500L);
        actions.release();
        Action action = actions.build();
        action.perform();
    }

    public void echo(String message) {
        LiferaySeleniumUtil.echo(message);
    }

    public void executeCDPCommand(String commandName, Map<String, Object> commandParameters) {
        Augmenter augmenter = new Augmenter();
        WebDriver webDriver = augmenter.augment(this.getWebDriver());
        HasCdp hasCdp = (HasCdp)webDriver;
        hasCdp.executeCdpCommand(commandName, commandParameters);
    }

    public void executeJavaScript(String javaScript, String argument1, String argument2) {
        this.getJavaScriptResult(javaScript, argument1, argument2);
    }

    public void fail(String message) {
        LiferaySeleniumUtil.fail(message);
    }

    public WebElement findElement(By by) {
        return this._webDriver.findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return this._webDriver.findElements(by);
    }

    public void get(String url) {
        try {
            this._webDriver.get(url);
        }
        catch (Throwable throwable) {
            throw new WebDriverException("Invalid URL: " + url, throwable.getCause());
        }
    }

    public String getAttribute(String attributeLocator) {
        int pos = attributeLocator.lastIndexOf(64);
        String locator = attributeLocator.substring(0, pos);
        WebElement webElement = this.getWebElement(locator);
        String attribute = attributeLocator.substring(pos + 1);
        return webElement.getAttribute(attribute);
    }

    public String getBodyText() {
        WebElement webElement = this.getWebElement("//body");
        return webElement.getText();
    }

    public String getConfirmation(String value) {
        this.switchTo();
        WebDriverWait webDriverWait = new WebDriverWait((WebDriver)this, Duration.ofSeconds(1L));
        try {
            Alert alert = (Alert)webDriverWait.until((Function)ExpectedConditions.alertIsPresent());
            String confirmation = alert.getText();
            if (Validator.isNotNull((String)value)) {
                alert.sendKeys(value);
            }
            alert.accept();
            return confirmation;
        }
        catch (Exception exception) {
            throw new WebDriverException((Throwable)exception);
        }
    }

    public String getCurrentUrl() {
        return this._webDriver.getCurrentUrl();
    }

    public long getElementHeight(String locator) {
        WebElement webElement = this.getWebElement(locator);
        Dimension dimension = webElement.getSize();
        return GetterUtil.getLong((Object)dimension.getHeight());
    }

    public String getElementValue(String locator) throws Exception {
        return this.getElementValue(locator, null);
    }

    public String getElementValue(String locator, String timeout) {
        WebElement webElement = this.getWebElement(locator, timeout);
        this.scrollWebElementIntoView(webElement);
        return webElement.getAttribute("value");
    }

    public long getElementWidth(String locator) {
        WebElement webElement = this.getWebElement(locator);
        Dimension dimension = webElement.getSize();
        return GetterUtil.getLong((Object)dimension.getWidth());
    }

    public String getEmailBody(String index) throws Exception {
        return LiferaySeleniumUtil.getEmailBody(index);
    }

    public String getEmailSubject(String index) throws Exception {
        return LiferaySeleniumUtil.getEmailSubject(index);
    }

    public String getEval(String script) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver("//body");
        return (String)javascriptExecutor.executeScript(script, new Object[0]);
    }

    public String getFirstNumber(String locator) {
        char[] chars;
        WebElement webElement = this.getWebElement(locator);
        String text = webElement.getText();
        if (text == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : chars = text.toCharArray()) {
            String s;
            boolean digit = false;
            if (Validator.isDigit((char)c)) {
                sb.append(c);
                digit = true;
            }
            if (!Validator.isNotNull((String)(s = sb.toString())) || digit) continue;
            return s;
        }
        return sb.toString();
    }

    public String getFirstNumberIncrement(String locator) {
        return String.valueOf(GetterUtil.getInteger((String)this.getFirstNumber(locator)) + 1);
    }

    public Node getHtmlNode(String locator) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            locator = StringUtil.replace((String)locator, (String)"x:", (String)"");
            XPathExpression xPathExpression = xPath.compile(locator);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String htmlSource = this.getHtmlSource();
            htmlSource = htmlSource.substring(htmlSource.indexOf("<html"));
            StringReader stringReader = new StringReader(htmlSource);
            InputSource inputSource = new InputSource(stringReader);
            org.w3c.dom.Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() < 1) {
                throw new Exception(locator + " is not present");
            }
            return nodeList.item(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getHtmlNodeHref(String locator) {
        Node elementNode = this.getHtmlNode(locator);
        NamedNodeMap namedNodeMap = elementNode.getAttributes();
        Node attributeNode = namedNodeMap.getNamedItem("href");
        return attributeNode.getTextContent();
    }

    public String getHtmlNodeText(String locator) throws Exception {
        Node node = this.getHtmlNode(locator);
        if (node == null) {
            throw new Exception(locator + " is not present");
        }
        return node.getTextContent();
    }

    public String getHtmlSource() {
        return this.getPageSource();
    }

    public String getJavaScriptResult(String javaScript, String argument1, String argument2) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver("//body");
        String object1 = null;
        String object2 = null;
        try {
            if (Validator.isNotNull((String)argument1)) {
                object1 = this.getWebElement(argument1);
            }
        }
        catch (ElementNotFoundPoshiRunnerException | InvalidSelectorException exception) {
            object1 = argument1;
        }
        try {
            if (Validator.isNotNull((String)argument2)) {
                object2 = this.getWebElement(argument2);
            }
        }
        catch (ElementNotFoundPoshiRunnerException | InvalidSelectorException exception) {
            object2 = argument2;
        }
        return (String)javascriptExecutor.executeScript(javaScript, new Object[]{object1, object2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocation() throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        LocationCallable callable = new LocationCallable();
        for (int i = 0; i < this.poshiProperties.getLocationMaxRetries; ++i) {
            FutureTask futureTask = new FutureTask(callable._init(this));
            Thread thread = new Thread(futureTask);
            thread.start();
            try {
                String string = (String)futureTask.get(this.poshiProperties.getLocationTimeout, TimeUnit.SECONDS);
                return string;
            }
            catch (CancellationException cancellationException) {
                exceptions.add(cancellationException);
            }
            catch (ExecutionException executionException) {
                exceptions.add(executionException);
            }
            catch (InterruptedException interruptedException) {
                exceptions.add(interruptedException);
            }
            catch (TimeoutException timeoutException) {
                exceptions.add(timeoutException);
            }
            finally {
                thread.interrupt();
            }
            System.out.println("getLocation(WebDriver):");
            System.out.println(this.toString());
            Set<String> windowHandles = this.getWindowHandles();
            for (String windowHandle : windowHandles) {
                System.out.println(windowHandle);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new Exception((Throwable)exceptions.get(0));
        }
        throw new TimeoutException();
    }

    public String getNumberDecrement(String value) {
        return LiferaySeleniumUtil.getNumberDecrement(value);
    }

    public String getNumberIncrement(String value) {
        return LiferaySeleniumUtil.getNumberIncrement(value);
    }

    public String getOcularBaselineImageDirName() {
        return _OCULAR_BASELINE_IMAGE_DIR_NAME;
    }

    public String getOcularResultImageDirName() {
        return _OCULAR_RESULT_IMAGE_DIR_NAME;
    }

    public String getOutputDirName() {
        return _OUTPUT_DIR_NAME;
    }

    public String getPageSource() {
        return this._webDriver.getPageSource();
    }

    public String getPrimaryTestSuiteName() {
        return this._primaryTestSuiteName;
    }

    public String getSelectedLabel(String selectLocator) {
        return this.getSelectedLabel(selectLocator, null);
    }

    public String getSelectedLabel(String selectLocator, String timeout) {
        try {
            WebElement selectLocatorWebElement = this.getWebElement(selectLocator, timeout);
            Select select = new Select(selectLocatorWebElement);
            WebElement firstSelectedOptionWebElement = select.getFirstSelectedOption();
            return firstSelectedOptionWebElement.getText();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getSelectedLabels(String selectLocator) {
        WebElement selectLocatorWebElement = this.getWebElement(selectLocator);
        Select select = new Select(selectLocatorWebElement);
        List allSelectedOptionsWebElements = select.getAllSelectedOptions();
        String[] selectedOptionsWebElements = new String[allSelectedOptionsWebElements.size()];
        for (int i = 0; i < allSelectedOptionsWebElements.size(); ++i) {
            WebElement webElement = (WebElement)allSelectedOptionsWebElements.get(i);
            if (webElement == null) continue;
            selectedOptionsWebElements[i] = webElement.getText();
        }
        return selectedOptionsWebElements;
    }

    public String getSikuliImagesDirName() {
        return _SIKULI_IMAGES_DIR_NAME;
    }

    public String getTestDependenciesDirName() {
        return _TEST_DEPENDENCIES_DIR_NAME;
    }

    public String getTestName() {
        return this._testName;
    }

    public String getText(String locator) throws Exception {
        return this.getText(locator, null);
    }

    public String getText(String locator, String timeout) throws Exception {
        if (locator.contains("x:")) {
            return this.getHtmlNodeText(locator);
        }
        WebElement webElement = this.getWebElement(locator, timeout);
        this.scrollWebElementIntoView(webElement);
        String text = webElement.getText();
        text = text.trim();
        return StringUtil.replace((String)text, (String)"\n", (String)" ");
    }

    public String getTextAceEditor(String locator) throws Exception {
        return this.getTextAceEditor(locator, null);
    }

    public String getTextAceEditor(String locator, String timeout) {
        WebElement webElement = this.getWebElement(locator, timeout);
        this.scrollWebElementIntoView(webElement);
        String text = webElement.getText();
        text = text.trim();
        return StringUtil.replace((String)text, (String)"\n", (String)"");
    }

    public String getTitle() {
        return this._webDriver.getTitle();
    }

    public String getWebElementAttribute(String locator, String attributeName) {
        WebElement webElement = this.getWebElement(locator);
        return webElement.getAttribute(attributeName);
    }

    public String getWindowHandle() {
        return this._webDriver.getWindowHandle();
    }

    public Set<String> getWindowHandles() {
        return this._webDriver.getWindowHandles();
    }

    public void goBack() {
        WebDriver.Navigation navigation = this.navigate();
        navigation.back();
    }

    public boolean isAlertPresent() {
        boolean alertPresent = false;
        this.switchTo();
        try {
            WebDriverWait webDriverWait = new WebDriverWait((WebDriver)this, Duration.ofSeconds(1L));
            webDriverWait.until((Function)ExpectedConditions.alertIsPresent());
            alertPresent = true;
        }
        catch (Exception exception) {
            alertPresent = false;
        }
        return alertPresent;
    }

    public boolean isAttributeNotPresent(String attribute, String locator) {
        return !this.isAttributePresent(attribute, locator);
    }

    public boolean isAttributePresent(String attribute, String locator) {
        WebElement webElement = this.getWebElement(locator);
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver(webElement);
        StringBuilder sb = new StringBuilder();
        sb.append("var element = arguments[0];");
        sb.append("return element.attributes['");
        sb.append(attribute);
        sb.append("'];");
        Object returnObject = javascriptExecutor.executeScript(sb.toString(), new Object[]{webElement});
        return returnObject != null;
    }

    public boolean isChecked(String locator) {
        WebElement webElement = this.getWebElement(locator);
        this.scrollWebElementIntoView(webElement);
        return webElement.isSelected();
    }

    public boolean isConfirmation(String pattern) throws Exception {
        Condition confirmationCondition = this.getConfirmationCondition(pattern);
        return confirmationCondition.evaluate();
    }

    public boolean isConsoleTextNotPresent(String text) throws Exception {
        Condition consoleTextNotPresentCondition = this.getConsoleTextNotPresentCondition(text);
        return consoleTextNotPresentCondition.evaluate();
    }

    public boolean isConsoleTextPresent(String text) throws Exception {
        Condition consoleTextPresentCondition = this.getConsoleTextPresentCondition(text);
        return consoleTextPresentCondition.evaluate();
    }

    public boolean isEditable(String locator) throws Exception {
        Condition editableCondition = this.getEditableCondition(locator);
        return editableCondition.evaluate();
    }

    public boolean isElementFocused(String locator) throws Exception {
        Condition elementFocusedCondition = this.getElementFocusedCondition(locator);
        return elementFocusedCondition.evaluate();
    }

    public boolean isElementNotPresent(String locator) throws Exception {
        Condition elementNotPresentCondition = this.getElementNotPresentCondition(locator);
        return elementNotPresentCondition.evaluate();
    }

    public boolean isElementPresent(String locator) throws Exception {
        Condition elementPresentCondition = this.getElementPresentCondition(locator);
        return elementPresentCondition.evaluate();
    }

    public boolean isElementPresentAfterWait(String locator) throws Exception {
        int second = 0;
        while (true) {
            if (second >= this.poshiProperties.timeoutExplicitWait) {
                return this.isElementPresent(locator);
            }
            if (this.isElementPresent(locator)) break;
            Thread.sleep(1000L);
            ++second;
        }
        return this.isElementPresent(locator);
    }

    public boolean isHTMLSourceTextPresent(String value) throws Exception {
        String pageSource = this.getPageSource();
        return pageSource.contains(value);
    }

    public boolean isNotChecked(String locator) {
        return !this.isChecked(locator);
    }

    public boolean isNotEditable(String locator) throws Exception {
        return !this.isEditable(locator);
    }

    public boolean isNotPartialText(String locator, String value) throws Exception {
        return !this.isPartialText(locator, value);
    }

    public boolean isNotPartialTextAceEditor(String locator, String value) throws Exception {
        return !this.isPartialTextAceEditor(locator, value);
    }

    public boolean isNotSelectedLabel(String selectLocator, String pattern) throws Exception {
        Condition notSelectedLabelCondition = this.getNotSelectedLabelCondition(selectLocator, pattern);
        return notSelectedLabelCondition.evaluate();
    }

    public boolean isNotText(String locator, String value) throws Exception {
        return !this.isText(locator, value);
    }

    public boolean isNotValue(String locator, String value) throws Exception {
        return !this.isValue(locator, value);
    }

    public boolean isNotVisible(String locator) throws Exception {
        return !this.isVisible(locator);
    }

    public boolean isNotVisibleInPage(String locator) throws Exception {
        return !this.isVisibleInPage(locator);
    }

    public boolean isNotVisibleInViewport(String locator) throws Exception {
        return !this.isVisibleInViewport(locator);
    }

    public boolean isPartialText(String locator, String value) throws Exception {
        Condition partialTextCondition = this.getPartialTextCondition(locator, value);
        return partialTextCondition.evaluate();
    }

    public boolean isPartialTextAceEditor(String locator, String value) throws Exception {
        Condition partialTextAceEditorCondition = this.getPartialTextAceEditorCondition(locator, value);
        return partialTextAceEditorCondition.evaluate();
    }

    public boolean isPartialTextCaseInsensitive(String locator, String value) throws Exception {
        Condition partialTextCaseInsensitiveCondition = this.getPartialTextCaseInsensitiveCondition(locator, value);
        return partialTextCaseInsensitiveCondition.evaluate();
    }

    public boolean isSelectedLabel(String selectLocator, String pattern) throws Exception {
        Condition selectedLabelCondition = this.getSelectedLabelCondition(selectLocator, pattern);
        return selectedLabelCondition.evaluate();
    }

    public boolean isSikuliImagePresent(String image) throws Exception {
        DesktopScreenRegion screenRegion = new DesktopScreenRegion();
        return screenRegion.find((Target)this.getImageTarget(image)) != null;
    }

    public boolean isTCatEnabled() {
        return this.poshiProperties.tcatEnabled;
    }

    public boolean isTestName(String testName) {
        String expectedTestName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName((String)this.getTestName());
        return testName.equals(expectedTestName);
    }

    public boolean isText(String locator, String value) throws Exception {
        Condition textCondition = this.getTextCondition(locator, value);
        return textCondition.evaluate();
    }

    public boolean isTextCaseInsensitive(String locator, String value) throws Exception {
        Condition textCaseInsensitiveCondition = this.getTextCaseInsensitiveCondition(locator, value);
        return textCaseInsensitiveCondition.evaluate();
    }

    public boolean isTextNotPresent(String pattern) throws Exception {
        return !this.isTextPresent(pattern);
    }

    public boolean isTextPresent(String pattern) throws Exception {
        Condition textPresentCondition = this.getTextPresentCondition(pattern);
        return textPresentCondition.evaluate();
    }

    public boolean isValue(String locator, String value) throws Exception {
        Condition valueConditionCondition = this.getValueCondition(locator, value);
        return valueConditionCondition.evaluate();
    }

    public boolean isVisible(String locator) throws Exception {
        return this.isVisibleInPage(locator);
    }

    public boolean isVisibleInPage(String locator) throws Exception {
        Condition visibleInPageCondition = this.getVisibleInPageCondition(locator);
        return visibleInPageCondition.evaluate();
    }

    public boolean isVisibleInViewport(String locator) throws Exception {
        Condition visibleInViewportCondition = this.getVisibleInViewportCondition(locator);
        return visibleInViewportCondition.evaluate();
    }

    public void javaScriptClick(String locator) {
        this.executeJavaScriptEvent(locator, "MouseEvent", "click");
    }

    public void javaScriptDoubleClick(String locator) {
        this.executeJavaScriptEvent(locator, "MouseEvent", "dblclick");
    }

    public String javaScriptGetText(String locator, String timeout) throws Exception {
        if (locator.contains("x:")) {
            return this.getHtmlNodeText(locator);
        }
        WebElement webElement = this.getWebElement(locator, timeout);
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver(webElement);
        StringBuilder sb = new StringBuilder(2);
        sb.append("var element = arguments[0];");
        sb.append("return element.innerText;");
        String text = (String)javascriptExecutor.executeScript(sb.toString(), new Object[]{webElement});
        text = text.trim();
        return StringUtil.replace((String)text, (String)"\n", (String)" ");
    }

    public void javaScriptMouseDown(String locator) {
        this.executeJavaScriptEvent(locator, "MouseEvent", "mousedown");
    }

    public void javaScriptMouseOver(String locator) {
        this.executeJavaScriptEvent(locator, "MouseEvent", "mouseover");
    }

    public void javaScriptMouseUp(String locator) {
        this.executeJavaScriptEvent(locator, "MouseEvent", "mouseup");
    }

    public void keyDown(String locator, String keySequence) {
        WebElement webElement = this.getWebElement(locator);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        String keycode = keySequence.substring(1);
        Keys keys = Keys.valueOf((String)keycode);
        actions.keyDown(webElement, (CharSequence)keys);
        Action action = actions.build();
        action.perform();
    }

    public void keyPress(String locator, String keySequence) {
        WebElement webElement = this.getWebElement(locator);
        if (keySequence.startsWith("\\")) {
            String keycode = keySequence.substring(1);
            if (this.isValidKeycode(keycode)) {
                Keys keys = Keys.valueOf((String)keycode);
                if (keycode.equals("ALT") || keycode.equals("COMMAND") || keycode.equals("CONTROL") || keycode.equals("SHIFT")) {
                    Actions actions = new Actions(this.getWrappedWebDriver(webElement));
                    actions.keyDown(webElement, (CharSequence)keys);
                    actions.keyUp(webElement, (CharSequence)keys);
                    Action action = actions.build();
                    action.perform();
                } else {
                    webElement.sendKeys(new CharSequence[]{keys});
                }
            }
        } else {
            webElement.sendKeys(new CharSequence[]{keySequence});
        }
    }

    public void keyUp(String locator, String keySequence) {
        WebElement webElement = this.getWebElement(locator);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        String keycode = keySequence.substring(1);
        Keys keys = Keys.valueOf((String)keycode);
        actions.keyUp(webElement, (CharSequence)keys);
        Action action = actions.build();
        action.perform();
    }

    public void makeVisible(String locator) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver("//body");
        StringBuilder sb = new StringBuilder();
        sb.append("var element = arguments[0];");
        sb.append("element.style.cssText = 'display:inline !important';");
        sb.append("element.style.overflow = 'visible';");
        sb.append("element.style.minHeight = '1px';");
        sb.append("element.style.minWidth = '1px';");
        sb.append("element.style.opacity = '1';");
        sb.append("element.style.visibility = 'visible';");
        WebElement locatorWebElement = this.getWebElement(locator);
        javascriptExecutor.executeScript(sb.toString(), new Object[]{locatorWebElement});
    }

    public WebDriver.Options manage() {
        return this._webDriver.manage();
    }

    public void maximizeWindow() {
        WebDriver.Options option = this._webDriver.manage();
        WebDriver.Window window = option.window();
        window.maximize();
    }

    public void mouseDown(String locator) {
        this.mouseDownAt(locator, null);
    }

    public void mouseDownAt(String locator, String offset) {
        WebElement webElement = this.getWebElement(locator);
        this.scrollWebElementIntoView(webElement);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        if (Validator.isNotNull((String)offset) && offset.contains(",")) {
            this.moveToElement(actions, webElement, offset);
            actions.clickAndHold();
        } else {
            actions.moveToElement(webElement);
            actions.clickAndHold(webElement);
        }
        Action action = actions.build();
        action.perform();
    }

    public void mouseMove(String locator) {
        this.mouseMoveAt(locator, null);
    }

    public void mouseMoveAt(String locator, String offset) {
        WebElement webElement = this.getWebElement(locator);
        this.scrollWebElementIntoView(webElement);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        if (Validator.isNotNull((String)offset) && offset.contains(",")) {
            this.moveToElement(actions, webElement, offset);
        } else {
            actions.moveToElement(webElement);
        }
        Action action = actions.build();
        action.perform();
    }

    public void mouseOut(String locator) {
        WebElement webElement = this.getWebElement(locator);
        this.scrollWebElementIntoView(webElement);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        actions.moveToElement(webElement);
        actions.moveByOffset(10, 10);
        Action action = actions.build();
        action.perform();
    }

    public void mouseOver(String locator) {
        WebElement webElement = this.getWebElement(locator);
        this.scrollWebElementIntoView(webElement);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        actions.moveToElement(webElement);
        Action action = actions.build();
        action.perform();
    }

    public void mouseRelease() {
        Actions actions = new Actions(this.getWrappedWebDriver("//body"));
        actions.release();
        Action action = actions.build();
        action.perform();
    }

    public void mouseUp(String locator) {
        this.mouseUpAt(locator, null);
    }

    public void mouseUpAt(String locator, String offset) {
        WebElement webElement = this.getWebElement(locator);
        this.scrollWebElementIntoView(webElement);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        if (Validator.isNotNull((String)offset) && offset.contains(",")) {
            this.moveToElement(actions, webElement, offset);
            actions.release();
        } else {
            actions.moveToElement(webElement);
            actions.release(webElement);
        }
        Action action = actions.build();
        action.perform();
    }

    public WebDriver.Navigation navigate() {
        return this._webDriver.navigate();
    }

    public void ocularAssertElementImage(String locator, String fileName, String match) throws Exception {
        File baselineFile = new File(this.poshiProperties.testBaseDirName + this.getOcularBaselineImageDirName() + "/" + fileName);
        if (!baselineFile.exists()) {
            File snapParentFile = baselineFile.getParentFile();
            snapParentFile.mkdirs();
        }
        File resultFile = new File(this.poshiProperties.testBaseDirName + this.getOcularResultImageDirName() + "/" + fileName);
        File resultParentFile = resultFile.getParentFile();
        resultParentFile.mkdirs();
        OcularConfiguration ocularConfiguration = Ocular.config();
        ocularConfiguration.resultPath(Paths.get(resultParentFile.getPath(), new String[0]));
        ocularConfiguration.globalSimilarity(GetterUtil.getInteger((String)match));
        WebElement webElement = this.getWebElement(locator);
        SnapshotBuilder snapshotBuilder = Ocular.snapshot();
        snapshotBuilder = snapshotBuilder.from(Paths.get(fileName, new String[0]));
        SampleBuilder sampleBuilder = snapshotBuilder.sample();
        sampleBuilder = sampleBuilder.using(this._webDriver);
        sampleBuilder.element(webElement);
        OcularResult ocularResult = sampleBuilder.compare();
        if (!ocularResult.isEqualsImages()) {
            throw new Exception("Actual element image does not match expected element image");
        }
    }

    public void open(String url) {
        String targetURL = url.trim();
        if (targetURL.startsWith("/")) {
            targetURL = this.poshiProperties.portalURL + targetURL;
        }
        this.get(targetURL);
    }

    public void openWindow(String url, String windowID) {
        this.open(url);
    }

    public void paste(String location) throws Exception {
        this.type(location, this._clipBoard);
    }

    public void pause(String durationString) throws Exception {
        int duration = GetterUtil.getInteger((String)durationString);
        this._totalPauseDuration += duration;
        LiferaySeleniumUtil.pause(duration);
    }

    public void pauseLoggerCheck() throws Exception {
    }

    public void quit() {
        System.out.println("Total duration of 'LiferaySelenium.pause' usages: " + this._totalPauseDuration + " ms");
        this._webDriver.quit();
    }

    public void refresh() {
        String url = this.getCurrentUrl();
        this.open(url);
        if (this.isAlertPresent()) {
            this.getConfirmation(null);
        }
    }

    public void replyToEmail(String to, String body) throws Exception {
        EmailCommands.replyToEmail(to, body);
        this.pause("3000");
    }

    public void rightClick(String locator) {
        WebElement webElement = this.getWebElement(locator);
        Actions actions = new Actions(this.getWrappedWebDriver(webElement));
        actions.contextClick(webElement);
        Action action = actions.build();
        action.perform();
    }

    public void robotType(String value) {
        DesktopKeyboard keyboard = new DesktopKeyboard();
        keyboard.type(value);
    }

    public void robotTypeShortcut(String value) {
        DesktopKeyboard keyboard = new DesktopKeyboard();
        List<String> keys = Arrays.asList(value.split("\\s\\+\\s"));
        Collections.sort(keys, Comparator.comparing(String::length));
        Collections.reverse(keys);
        for (String key : keys) {
            if (key.length() == 1) {
                keyboard.type(key);
                continue;
            }
            keyboard.keyDown(_keyCodeMap.get(key.toUpperCase()).intValue());
        }
        Collections.reverse(keys);
        for (String key : keys) {
            if (key.length() == 1) continue;
            keyboard.keyUp(_keyCodeMap.get(key.toUpperCase()).intValue());
        }
    }

    public void runScript(String script) {
        this.getEval(script);
    }

    public void saveScreenshot(String fileName) throws Exception {
        if (!this.poshiProperties.saveScreenshot) {
            return;
        }
        try {
            TakesScreenshot takesScreenshot = (TakesScreenshot)this._webDriver;
            FileUtil.write((File)new File(fileName), (byte[])((byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES)));
        }
        catch (NoSuchWindowException noSuchWindowException) {
            this.selectWindow("null");
            this.saveScreenshot(fileName);
        }
        catch (UnhandledAlertException unhandledAlertException) {
            LiferaySeleniumUtil.captureScreen(fileName);
        }
    }

    public void scrollBy(String offset) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver("//html");
        javascriptExecutor.executeScript("window.scrollBy(" + offset + ");", new Object[0]);
    }

    public void scrollWebElementIntoView(String locator) throws Exception {
        this.scrollWebElementIntoView(this.getWebElement(locator));
    }

    public void select(String selectLocator, String optionLocator) {
        Select select = new Select(this.getWebElement(selectLocator));
        String label = optionLocator;
        if (optionLocator.startsWith("index=")) {
            String indexString = optionLocator.substring(6);
            int index = GetterUtil.getInteger((String)indexString);
            select.selectByIndex(index - 1);
        } else if (optionLocator.startsWith("value=")) {
            String value = optionLocator.substring(6);
            if (value.startsWith("regexp:")) {
                String regexp = value.substring(7);
                this.selectByRegexpValue(selectLocator, regexp);
            } else {
                List optionWebElements = select.getOptions();
                for (WebElement optionWebElement : optionWebElements) {
                    String optionWebElementValue = optionWebElement.getAttribute("value");
                    if (!optionWebElementValue.equals(value)) continue;
                    label = optionWebElementValue;
                    break;
                }
                select.selectByValue(label);
            }
        } else {
            if (optionLocator.startsWith("label=")) {
                label = optionLocator.substring(6);
            }
            if (label.startsWith("regexp:")) {
                String regexp = label.substring(7);
                this.selectByRegexpText(selectLocator, regexp);
            } else {
                select.selectByVisibleText(label);
            }
        }
    }

    public void selectFieldText() {
        LiferaySeleniumUtil.selectFieldText();
    }

    public void selectFrame(String locator) {
        WebDriver.TargetLocator targetLocator = this.switchTo();
        if (locator.equals("relative=parent")) {
            if (!this._frameWebElements.isEmpty()) {
                this._frameWebElements.pop();
            }
            targetLocator.parentFrame();
        } else if (locator.equals("relative=top")) {
            this._frameWebElements.clear();
            targetLocator.defaultContent();
        } else {
            this._frameWebElements.push(this.getWebElement(locator));
            targetLocator.frame(this._frameWebElements.peek());
        }
    }

    public void selectPopUp(String windowID) {
        if (windowID.equals("") || windowID.equals("null")) {
            String title = this.getTitle();
            Set<String> windowHandles = this.getWindowHandles();
            for (String windowHandle : windowHandles) {
                WebDriver.TargetLocator targetLocator = this.switchTo();
                targetLocator.window(windowHandle);
                if (title.equals(this.getTitle())) continue;
                return;
            }
        } else {
            this.selectWindow(windowID);
        }
    }

    public void selectWindow(String windowID) {
        Set<String> windowHandles = this.getWindowHandles();
        if (windowID.equals("name=undefined")) {
            String title = this.getTitle();
            for (String windowHandle : windowHandles) {
                WebDriver.TargetLocator targetLocator = this.switchTo();
                targetLocator.window(windowHandle);
                if (title.equals(this.getTitle())) continue;
                return;
            }
            TestCase.fail((String)("Unable to find the window ID \"" + windowID + "\""));
        } else if (windowID.equals("null")) {
            WebDriver.TargetLocator targetLocator = this.switchTo();
            targetLocator.window(this._defaultWindowHandle);
        } else {
            String targetWindowTitle = windowID;
            if (targetWindowTitle.startsWith("title=")) {
                targetWindowTitle = targetWindowTitle.substring(6);
            }
            for (String windowHandle : windowHandles) {
                WebDriver.TargetLocator targetLocator = this.switchTo();
                targetLocator.window(windowHandle);
                if (!targetWindowTitle.equals(this.getTitle())) continue;
                return;
            }
            TestCase.fail((String)("Unable to find the window ID \"" + windowID + "\""));
        }
    }

    public void sendEmail(String to, String subject, String body) throws Exception {
        EmailCommands.sendEmail(to, subject, body);
        this.pause("3000");
    }

    public void sendKeys(String locator, String value) throws Exception {
        this.typeKeys(locator, value);
    }

    public void sendKeysAceEditor(String locator, String value) throws Exception {
        WebElement webElement = this.getWebElement(locator);
        webElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, Keys.END})});
        this.typeKeys(locator, "");
        Matcher matcher = _aceEditorPattern.matcher(value);
        int x = 0;
        while (matcher.find()) {
            int y = matcher.start();
            String line = value.substring(x, y);
            webElement.sendKeys(new CharSequence[]{line.trim()});
            String specialCharacter = matcher.group();
            if (specialCharacter.equals("(")) {
                webElement.sendKeys(new CharSequence[]{"("});
            } else if (specialCharacter.equals("${line.separator}")) {
                this.keyPress(locator, "\\SPACE");
                this.keyPress(locator, "\\RETURN");
            }
            x = y + specialCharacter.length();
        }
        String line = value.substring(x);
        webElement.sendKeys(new CharSequence[]{line.trim()});
    }

    public void setDefaultTimeout() {
    }

    public void setDefaultTimeoutImplicit() {
        int timeout = this.poshiProperties.timeoutImplicitWait * 1000;
        this.setTimeoutImplicit(String.valueOf(timeout));
    }

    public void setPrimaryTestSuiteName(String primaryTestSuiteName) {
        this._primaryTestSuiteName = primaryTestSuiteName;
    }

    public void setTestName(String testName) {
        this._testName = testName;
    }

    public void setTimeout(String timeout) {
    }

    public void setTimeoutImplicit(String timeout) {
        WebDriver.Options options = this.manage();
        if (!this.poshiProperties.browserType.equals("safari")) {
            WebDriver.Timeouts timeouts = options.timeouts();
            timeouts.implicitlyWait((long)GetterUtil.getInteger((String)timeout), TimeUnit.SECONDS);
        }
    }

    public void setWindowSize(String size) {
        WebDriver wrappedWebDriver = this.getWrappedWebDriver("//body");
        WebDriver.Options options = wrappedWebDriver.manage();
        WebDriver.Window window = options.window();
        String[] sizeCoordinates = StringUtil.split((String)size, (String)",");
        int x = GetterUtil.getInteger((String)sizeCoordinates[0]);
        int y = GetterUtil.getInteger((String)sizeCoordinates[1]);
        window.setSize(new Dimension(x, y));
    }

    public void sikuliAssertElementNotPresent(String image) throws Exception {
        DesktopScreenRegion screenRegion = new DesktopScreenRegion();
        if (screenRegion.wait((Target)this.getImageTarget(image), 5000) != null) {
            throw new Exception("Element is present");
        }
    }

    public void sikuliAssertElementPresent(String image) throws Exception {
        DesktopScreenRegion screenRegion = new DesktopScreenRegion();
        if ((screenRegion = screenRegion.wait((Target)this.getImageTarget(image), 5000)) == null) {
            throw new Exception("Element is not present");
        }
        DesktopCanvas canvas = new DesktopCanvas();
        CanvasBuilder.ElementAdder elementAdder = canvas.add();
        CanvasBuilder.ElementAreaSetter elementAreaSetter = elementAdder.box();
        elementAreaSetter.around((Region)screenRegion);
        canvas.display(2);
    }

    public void sikuliClick(String image) throws Exception {
        DesktopScreenRegion screenRegion = new DesktopScreenRegion();
        ScreenRegion imageTargetScreenRegion = screenRegion.find((Target)this.getImageTarget(image));
        if (imageTargetScreenRegion != null) {
            DesktopMouse mouse = new DesktopMouse();
            mouse.click(imageTargetScreenRegion.getCenter());
        }
    }

    public void sikuliClickByIndex(String image, String index) throws Exception {
        DesktopScreenRegion screenRegion = new DesktopScreenRegion();
        List imageTargetScreenRegions = screenRegion.findAll((Target)this.getImageTarget(image));
        ScreenRegion imageTargetScreenRegion = (ScreenRegion)imageTargetScreenRegions.get(GetterUtil.getInteger((String)index));
        if (imageTargetScreenRegion != null) {
            DesktopMouse mouse = new DesktopMouse();
            mouse.click(imageTargetScreenRegion.getCenter());
        }
    }

    public void sikuliDragAndDrop(String image, String offset) throws Exception {
        DesktopScreenRegion screenRegion = new DesktopScreenRegion();
        screenRegion = screenRegion.find((Target)this.getImageTarget(image));
        DesktopMouse mouse = new DesktopMouse();
        mouse.move(screenRegion.getCenter());
        Robot robot = new Robot();
        robot.delay(1000);
        mouse.press();
        robot.delay(2000);
        String[] offsetCoordinates = offset.split(",");
        ScreenLocation location = screenRegion.getCenter();
        int x = location.getX() + GetterUtil.getInteger((String)offsetCoordinates[0]);
        int y = location.getY() + GetterUtil.getInteger((String)offsetCoordinates[1]);
        robot.mouseMove(x, y);
        robot.delay(1000);
        mouse.release();
    }

    public void sikuliLeftMouseDown() throws Exception {
        this.pause("1000");
        DesktopMouse mouse = new DesktopMouse();
        mouse.press();
    }

    public void sikuliLeftMouseUp() throws Exception {
        this.pause("1000");
        DesktopMouse mouse = new DesktopMouse();
        mouse.release();
    }

    public void sikuliMouseMove(String image) throws Exception {
        DesktopScreenRegion screenRegion = new DesktopScreenRegion();
        screenRegion = screenRegion.find((Target)this.getImageTarget(image));
        DesktopMouse mouse = new DesktopMouse();
        mouse.move(screenRegion.getCenter());
    }

    public void sikuliRightMouseDown() throws Exception {
        this.pause("1000");
        DesktopMouse mouse = new DesktopMouse();
        mouse.rightPress();
    }

    public void sikuliRightMouseUp() throws Exception {
        this.pause("1000");
        DesktopMouse mouse = new DesktopMouse();
        mouse.rightRelease();
    }

    public void sikuliType(String image, String value) throws Exception {
        this.sikuliClick(image);
        this.pause("1000");
        DesktopKeyboard keyboard = new DesktopKeyboard();
        if (value.contains("${line.separator}")) {
            String[] tokens = StringUtil.split((String)value, (String)"${line.separator}");
            for (int i = 0; i < tokens.length; ++i) {
                keyboard.type(tokens[i]);
                if (i + 1 >= tokens.length) continue;
                keyboard.type("\n");
            }
            if (value.endsWith("${line.separator}")) {
                keyboard.type("\n");
            }
        } else {
            keyboard.type(value);
        }
    }

    public void sikuliUploadCommonFile(String image, String value) throws Exception {
        this.sikuliClick(image);
        DesktopKeyboard keyboard = new DesktopKeyboard();
        String fileName = FileUtil.getSeparator() + _TEST_DEPENDENCIES_DIR_NAME + FileUtil.getSeparator() + value;
        fileName = LiferaySeleniumUtil.getSourceDirFilePath(fileName);
        fileName = StringUtil.replace((String)fileName, (String)"/", (String)FileUtil.getSeparator());
        if (OSDetector.isApple()) {
            keyboard.keyDown("\ue023");
            keyboard.keyDown("\ue020");
            keyboard.type("g");
            keyboard.keyUp("\ue023");
            keyboard.keyUp("\ue020");
            this.sikuliType(image, fileName);
            keyboard.type("\n");
        } else {
            keyboard.keyDown("\ue021");
            keyboard.type("a");
            keyboard.keyUp("\ue021");
            this.sikuliType(image, fileName);
        }
        this.pause("1000");
        keyboard.type("\n");
    }

    public void sikuliUploadTCatFile(String image, String value) throws Exception {
        String fileName = this.poshiProperties.tcatAdminRepository + "/" + value;
        fileName = FileUtil.fixFilePath((String)fileName);
        this.sikuliType(image, fileName);
        DesktopKeyboard keyboard = new DesktopKeyboard();
        this.pause("1000");
        keyboard.type("\n");
    }

    public void sikuliUploadTempFile(String image, String value) throws Exception {
        this.sikuliClick(image);
        DesktopKeyboard keyboard = new DesktopKeyboard();
        keyboard.keyDown("\ue021");
        keyboard.type("a");
        keyboard.keyUp("\ue021");
        String fileName = this.getOutputDirName() + "/" + value;
        fileName = FileUtil.fixFilePath((String)fileName);
        this.sikuliType(image, fileName);
        this.pause("1000");
        keyboard.type("\n");
    }

    public WebDriver.TargetLocator switchTo() {
        return this._webDriver.switchTo();
    }

    public void tripleClick(String locator) {
        Actions actions = new Actions(this.getWrappedWebDriver(locator));
        for (int count = 3; count > 0; --count) {
            actions.click();
        }
        Action action = actions.build();
        action.perform();
    }

    public void type(String locator, String value) {
        WebElement webElement = this.getWebElement(locator);
        if (!webElement.isEnabled()) {
            return;
        }
        int maxRetries = 3;
        int retryCount = 0;
        while (retryCount < maxRetries) {
            webElement.clear();
            if (retryCount == 0) {
                this.typeKeys(locator, value);
            } else {
                for (char c : value.toCharArray()) {
                    this.typeKeys(locator, Character.toString(c));
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            String webElementTagNametagName = webElement.getTagName();
            if (!webElementTagNametagName.equals("input")) break;
            String typedValue = webElement.getAttribute("value");
            if (typedValue.equals(value)) {
                return;
            }
            if (++retryCount >= maxRetries) continue;
            String message = "Actual typed value: '" + typedValue + "' did not match expected typed value: '" + value + "'.";
            System.out.println(message + " Retrying LiferaySelenium.type() attempt #" + (retryCount + 1) + ".");
        }
    }

    public void typeAceEditor(String locator, String value) {
        WebElement webElement = this.getWebElement(locator);
        String webElementTagName = webElement.getTagName();
        if (webElementTagName.equals("textarea")) {
            webElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
            webElement.sendKeys(new CharSequence[]{Keys.DELETE});
            Matcher matcher = _aceEditorPattern.matcher(value);
            int x = 0;
            while (matcher.find()) {
                int y = matcher.start();
                String line = value.substring(x, y);
                webElement.sendKeys(new CharSequence[]{line.trim()});
                String specialCharacter = matcher.group();
                if (specialCharacter.equals("(")) {
                    webElement.sendKeys(new CharSequence[]{"("});
                } else if (specialCharacter.equals("${line.separator}")) {
                    this.keyPress(locator, "\\SPACE");
                    this.keyPress(locator, "\\RETURN");
                }
                x = y + specialCharacter.length();
            }
            String line = value.substring(x);
            webElement.sendKeys(new CharSequence[]{line.trim()});
            webElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, Keys.SHIFT, Keys.END})});
            webElement.sendKeys(new CharSequence[]{Keys.DELETE});
            return;
        }
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver(webElement);
        StringBuilder sb = new StringBuilder();
        sb.append("ace.edit(");
        sb.append(this.getAttribute(locator + "@id"));
        sb.append(").setValue(\"");
        sb.append(HtmlUtil.escapeJS(StringUtil.replace((String)value, (String)"\\", (String)"\\\\")));
        sb.append("\");");
        javascriptExecutor.executeScript(sb.toString(), new Object[0]);
    }

    public void typeAlert(String value) {
        Alert alert = this.getAlert();
        alert.sendKeys(value);
    }

    public void typeCKEditor(String locator, String value) {
        int x;
        StringBuilder sb = new StringBuilder();
        String idAttribute = this.getAttribute(locator + "@id");
        int y = idAttribute.indexOf("cke__", (x = idAttribute.indexOf("cke__")) + 1);
        if (y == -1) {
            y = idAttribute.length();
        }
        sb.append(idAttribute.substring(x + 4, y));
        sb.append(".setHTML(\"");
        sb.append(HtmlUtil.escapeJS(StringUtil.replace((String)value, (String)"\\", (String)"\\\\")));
        sb.append("\")");
        this.runScript(sb.toString());
    }

    public void typeCodeMirrorEditor(String locator, String value) throws Exception {
        WebElement webElement = this.getWebElement(locator);
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver(webElement);
        javascriptExecutor.executeScript("arguments[0].CodeMirror.setValue(arguments[1]);", new Object[]{webElement, value});
    }

    public void typeEditor(String locator, String value) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver(locator);
        StringBuilder sb = new StringBuilder();
        sb.append("CKEDITOR.instances[\"");
        sb.append(this.getEditorName(locator));
        sb.append("\"].setData(\"");
        sb.append(HtmlUtil.escapeJS(StringUtil.replace((String)value, (String)"\\", (String)"\\\\")));
        sb.append("\");");
        javascriptExecutor.executeScript(sb.toString(), new Object[0]);
    }

    public void typeKeys(String locator, String value) {
        WebElement webElement = this.getWebElement(locator);
        if (!webElement.isEnabled()) {
            return;
        }
        if (value.startsWith("keys=")) {
            value = value.substring(5);
            ArrayList<String> charSequences = new ArrayList<String>();
            String[] stringArray = value.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String key;
                CharSequence charSequence = key = stringArray[i];
                if (_keysMap.containsKey(key)) {
                    charSequence = (CharSequence)_keysMap.get(key);
                }
                charSequences.add((String)charSequence);
            }
            webElement.sendKeys(charSequences.toArray(new CharSequence[0]));
            return;
        }
        if (value.contains("line-number=")) {
            value = value.replaceAll("line-number=\"\\d+\"", "");
        }
        int i = 0;
        Matcher matcher = _tabPattern.matcher(value);
        while (matcher.find()) {
            webElement.sendKeys(new CharSequence[]{value.substring(matcher.start(), matcher.end() - 1)});
            webElement.sendKeys(new CharSequence[]{Keys.TAB});
            i = matcher.end();
        }
        webElement.sendKeys(new CharSequence[]{value.substring(i)});
    }

    public void typeScreen(String value) {
        LiferaySeleniumUtil.typeScreen(value);
    }

    public void uncheck(String locator) {
        WebElement webElement = this.getWebElement(locator);
        if (webElement.isSelected()) {
            webElement.click();
        }
    }

    public void uploadCommonFile(String locator, String commonFilePath) throws Exception {
        String filePath = FileUtil.getSeparator() + this.getTestDependenciesDirName() + FileUtil.getSeparator() + commonFilePath;
        filePath = LiferaySeleniumUtil.getSourceDirFilePath(filePath);
        this.uploadFile(locator, FileUtil.fixFilePath((String)filePath));
    }

    public void uploadFile(String locator, String filePath) {
        File file;
        this.makeVisible(locator);
        WebElement webElement = this.getWebElement(locator);
        filePath = FileUtil.getCanonicalPath((String)filePath);
        if ((filePath.endsWith(".jar") || filePath.endsWith(".lar") || filePath.endsWith(".war") || filePath.endsWith(".zip")) && (file = new File(filePath)).isDirectory()) {
            String archiveFilePath = this.getOutputDirName() + FileUtil.getSeparator() + file.getName();
            archiveFilePath = FileUtil.getCanonicalPath((String)archiveFilePath);
            ArchiveUtil.archive(filePath, archiveFilePath);
            filePath = archiveFilePath;
        }
        filePath = FileUtil.fixFilePath((String)filePath);
        webElement.sendKeys(new CharSequence[]{filePath});
    }

    public void uploadTempFile(String location, String value) {
        String fileName = this.getOutputDirName() + FileUtil.getSeparator() + value;
        fileName = FileUtil.fixFilePath((String)fileName);
        this.uploadFile(location, fileName);
    }

    public void verifyElementNotPresent(String locator) throws Exception {
        Condition elementNotPresentCondition = this.getElementNotPresentCondition(locator);
        elementNotPresentCondition.verify();
    }

    public void verifyElementPresent(String locator) throws Exception {
        Condition elementPresentCondition = this.getElementPresentCondition(locator);
        elementPresentCondition.verify();
    }

    public void verifyJavaScript(String javaScript, String message, String argument) throws Exception {
        Condition javaScriptCondition = this.getJavaScriptCondition(javaScript, message, argument);
        javaScriptCondition.verify();
    }

    public void verifyNotVisible(String locator) throws Exception {
        Condition notVisibleCondition = this.getNotVisibleCondition(locator);
        notVisibleCondition.verify();
    }

    public void verifyVisible(String locator) throws Exception {
        Condition visibleCondition = this.getVisibleCondition(locator);
        visibleCondition.verify();
    }

    public void waitForConfirmation(String pattern) throws Exception {
        Condition confirmationCondition = this.getConfirmationCondition(pattern);
        confirmationCondition.waitFor();
    }

    public void waitForConsoleTextNotPresent(String text) throws Exception {
        Condition consoleTextNotPresentCondition = this.getConsoleTextNotPresentCondition(text);
        consoleTextNotPresentCondition.waitFor();
    }

    public void waitForConsoleTextPresent(String text) throws Exception {
        Condition consoleTextPresentCondition = this.getConsoleTextPresentCondition(text);
        consoleTextPresentCondition.waitFor();
    }

    public void waitForEditable(String locator) throws Exception {
        Condition editableCondition = this.getEditableCondition(locator);
        editableCondition.waitFor();
    }

    public void waitForElementNotPresent(String locator, String throwException) throws Exception {
        Condition elementNotPresentCondition = this.getElementNotPresentCondition(locator);
        elementNotPresentCondition.waitFor(throwException);
    }

    public void waitForElementPresent(String locator, String throwException) throws Exception {
        Condition elementPresentCondition = this.getElementPresentCondition(locator);
        elementPresentCondition.waitFor(throwException);
    }

    public void waitForJavaScript(String javaScript, String message, String argument) throws Exception {
        Condition javaScriptCondition = this.getJavaScriptCondition(javaScript, message, argument);
        javaScriptCondition.waitFor();
    }

    public void waitForJavaScriptNoError(String javaScript, String message, String argument) throws Exception {
        Condition javaScriptCondition = this.getJavaScriptCondition(javaScript, message, argument);
        javaScriptCondition.waitFor("false");
    }

    public void waitForNotEditable(String locator) throws Exception {
        Condition notEditableCondition = this.getNotEditableCondition(locator);
        notEditableCondition.waitFor();
    }

    public void waitForNotPartialText(String locator, String value) throws Exception {
        Condition notPartialTextCondition = this.getNotPartialTextCondition(locator, value);
        notPartialTextCondition.waitFor();
    }

    public void waitForNotSelectedLabel(String selectLocator, String pattern) throws Exception {
        Condition notSelectedLabelCondition = this.getNotSelectedLabelCondition(selectLocator, pattern);
        notSelectedLabelCondition.waitFor();
    }

    public void waitForNotText(String locator, String value) throws Exception {
        Condition notTextCondition = this.getNotTextCondition(locator, value);
        notTextCondition.waitFor();
    }

    public void waitForNotValue(String locator, String value) throws Exception {
        Condition notValueCondition = this.getNotValueCondition(locator, value);
        notValueCondition.waitFor();
    }

    public void waitForNotVisible(String locator, String throwException) throws Exception {
        Condition notVisibleCondition = this.getNotVisibleCondition(locator);
        notVisibleCondition.waitFor(throwException);
    }

    public void waitForNotVisibleInPage(String locator) throws Exception {
        Condition notVisibleInPageCondition = this.getNotVisibleInPageCondition(locator);
        notVisibleInPageCondition.waitFor();
    }

    public void waitForNotVisibleInViewport(String locator) throws Exception {
        Condition notVisibleInViewportCondition = this.getNotVisibleInViewportCondition(locator);
        notVisibleInViewportCondition.waitFor();
    }

    public void waitForPartialText(String locator, String value) throws Exception {
        Condition partialTextCondition = this.getPartialTextCondition(locator, value);
        partialTextCondition.waitFor();
    }

    public void waitForPartialTextAceEditor(String locator, String value) throws Exception {
        Condition partialTextAceEditorCondition = this.getPartialTextAceEditorCondition(locator, value);
        partialTextAceEditorCondition.waitFor();
    }

    public void waitForPartialTextCaseInsensitive(String locator, String pattern) throws Exception {
        Condition partialTextCaseInsensitiveCondition = this.getPartialTextCaseInsensitiveCondition(locator, pattern);
        partialTextCaseInsensitiveCondition.waitFor();
    }

    public void waitForPopUp(String windowID, String timeout) {
        int wait = 0;
        wait = timeout.equals("") ? 30 : GetterUtil.getInteger((String)timeout) / 1000;
        if (windowID.equals("") || windowID.equals("null")) {
            for (int i = 0; i <= wait; ++i) {
                Set<String> windowHandles = this.getWindowHandles();
                if (windowHandles.size() > 1) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            String targetWindowTitle = windowID;
            if (targetWindowTitle.startsWith("title=")) {
                targetWindowTitle = targetWindowTitle.substring(6);
            }
            for (int i = 0; i <= wait; ++i) {
                for (String windowHandle : this.getWindowHandles()) {
                    WebDriver.TargetLocator targetLocator = this.switchTo();
                    targetLocator.window(windowHandle);
                    if (!targetWindowTitle.equals(this.getTitle())) continue;
                    targetLocator.window(this.getDefaultWindowHandle());
                    return;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        TestCase.fail((String)("Unable to find the window ID \"" + windowID + "\""));
    }

    public void waitForSelectedLabel(String selectLocator, String pattern) throws Exception {
        Condition selectedLabelCondition = this.getSelectedLabelCondition(selectLocator, pattern);
        selectedLabelCondition.waitFor();
    }

    public void waitForText(String locator, String value) throws Exception {
        Condition textCondition = this.getTextCondition(locator, value);
        textCondition.waitFor();
    }

    public void waitForTextCaseInsensitive(String locator, String pattern) throws Exception {
        Condition textCaseInsensitiveCondition = this.getTextCaseInsensitiveCondition(locator, pattern);
        textCaseInsensitiveCondition.waitFor();
    }

    public void waitForTextMatches(String locator, String regex) throws Exception {
        Condition textMatchesCondition = this.getTextMatchesCondition(locator, regex);
        textMatchesCondition.waitFor();
    }

    public void waitForTextNotPresent(String value) throws Exception {
        Condition textNotPresentCondition = this.getTextNotPresentCondition(value);
        textNotPresentCondition.waitFor();
    }

    public void waitForTextPresent(String value) throws Exception {
        Condition textPresentCondition = this.getTextPresentCondition(value);
        textPresentCondition.waitFor();
    }

    public void waitForValue(String locator, String value) throws Exception {
        Condition valueConditionCondition = this.getValueCondition(locator, value);
        valueConditionCondition.waitFor();
    }

    public void waitForVisible(String locator, String throwException) throws Exception {
        Condition visibleCondition = this.getVisibleCondition(locator);
        visibleCondition.waitFor(throwException);
    }

    public void waitForVisibleInPage(String locator) throws Exception {
        Condition visibleInPageCondition = this.getVisibleInPageCondition(locator);
        visibleInPageCondition.waitFor();
    }

    public void waitForVisibleInViewport(String locator) throws Exception {
        Condition visibleInViewportCondition = this.getVisibleInViewportCondition(locator);
        visibleInViewportCondition.waitFor();
    }

    protected void acceptConfirmation() {
        WebDriver.TargetLocator targetLocator = this.switchTo();
        Alert alert = targetLocator.alert();
        alert.accept();
    }

    protected void executeJavaScriptEvent(String locator, String eventType, String event) {
        WebElement webElement = this.getWebElement(locator);
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver(webElement);
        if (!webElement.isDisplayed()) {
            this.scrollWebElementIntoView(webElement);
        }
        StringBuilder sb = new StringBuilder(6);
        sb.append("var element = arguments[0];");
        sb.append("var event = document.createEvent('");
        sb.append(eventType);
        sb.append("');event.initEvent('");
        sb.append(event);
        sb.append("', true, false);element.dispatchEvent(event);");
        javascriptExecutor.executeScript(sb.toString(), new Object[]{webElement});
    }

    protected Alert getAlert() {
        if (this._alert == null) {
            this.switchTo();
            WebDriverWait webDriverWait = new WebDriverWait((WebDriver)this, Duration.ofSeconds(1L));
            this._alert = (Alert)webDriverWait.until((Function)ExpectedConditions.alertIsPresent());
        }
        return this._alert;
    }

    protected String getAlertText() {
        this.switchTo();
        WebDriverWait webDriverWait = new WebDriverWait((WebDriver)this, Duration.ofSeconds(1L));
        Alert alert = (Alert)webDriverWait.until((Function)ExpectedConditions.alertIsPresent());
        return alert.getText();
    }

    protected By getBy(String locator) {
        return LiferaySeleniumUtil.getBy(locator);
    }

    protected Condition getConfirmationCondition(final String pattern) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Expected text \"", pattern, "\" does not match actual text \"", BaseWebDriverImpl.this.getConfirmation(null), "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                return pattern.equals(BaseWebDriverImpl.this.getConfirmation(null));
            }
        };
    }

    protected Condition getConsoleTextNotPresentCondition(final String text) {
        String message = "\"" + text + "\" is present in console";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return !LiferaySeleniumUtil.isConsoleTextPresent(text);
            }
        };
    }

    protected Condition getConsoleTextPresentCondition(final String text) {
        String message = "\"" + text + "\" is not present in console";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return LiferaySeleniumUtil.isConsoleTextPresent(text);
            }
        };
    }

    protected String getCSSSource(String htmlSource) throws Exception {
        Document htmlDocument = Jsoup.parse((String)htmlSource);
        Elements elements = htmlDocument.select("link[type=text/css]");
        StringBuilder sb = new StringBuilder();
        for (Element element : elements) {
            String href = element.attr("href");
            if (!href.contains(this.poshiProperties.portalURL)) {
                href = this.poshiProperties.portalURL + href;
            }
            Connection connection = Jsoup.connect((String)href);
            Document document = connection.get();
            sb.append(document.text());
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String getDefaultWindowHandle() {
        return this._defaultWindowHandle;
    }

    protected Condition getEditableCondition(final String locator) {
        String message = "Element is not editable at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                WebElement webElement = BaseWebDriverImpl.this.getWebElement(locator);
                return webElement.isEnabled();
            }
        };
    }

    protected String getEditorName(String locator) {
        String titleAttribute = this.getAttribute(locator + "@title");
        if (titleAttribute.contains("Rich Text Editor,")) {
            int x = titleAttribute.indexOf(",");
            int y = titleAttribute.indexOf(",", x + 1);
            if (y == -1) {
                y = titleAttribute.length();
            }
            return titleAttribute.substring(x + 2, y);
        }
        String idAttribute = this.getAttribute(locator + "@id");
        if (idAttribute.contains("cke__")) {
            int x = idAttribute.indexOf("cke__");
            int y = idAttribute.indexOf("cke__", x + 1);
            if (y == -1) {
                y = idAttribute.length();
            }
            return idAttribute.substring(x + 4, y);
        }
        return idAttribute;
    }

    protected Condition getElementFocusedCondition(final String locator) {
        String message = "Element from locator " + locator + " is not focused";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                WebElement webElement = BaseWebDriverImpl.this.getWebElement(locator);
                WebDriver webDriver = BaseWebDriverImpl.this.getWebDriver();
                WebDriver.TargetLocator targetLocator = webDriver.switchTo();
                WebElement activeWebElement = targetLocator.activeElement();
                return webElement.equals(activeWebElement);
            }
        };
    }

    protected Condition getElementNotFocusedCondition(final String locator) {
        String message = "Element from locator " + locator + " is not focused";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isElementFocused(locator);
            }
        };
    }

    protected Condition getElementNotPresentCondition(final String locator) {
        String message = "Element is present at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isElementPresent(locator);
            }
        };
    }

    protected long getElementPositionBottom(String locator) {
        return (long)this.getElementPositionTop(locator) + this.getElementHeight(locator);
    }

    protected long getElementPositionCenterX(String locator) {
        return (long)this.getElementPositionLeft(locator) + this.getElementWidth(locator) / 2L;
    }

    protected long getElementPositionCenterY(String locator) {
        return (long)this.getElementPositionTop(locator) + this.getElementHeight(locator) / 2L;
    }

    protected int getElementPositionLeft(String locator) {
        WebElement webElement = this.getWebElement(locator);
        Point point = webElement.getLocation();
        return point.getX();
    }

    protected long getElementPositionRight(String locator) {
        return (long)this.getElementPositionLeft(locator) + this.getElementWidth(locator);
    }

    protected int getElementPositionTop(String locator) {
        WebElement webElement = this.getWebElement(locator);
        Point point = webElement.getLocation();
        return point.getY();
    }

    protected Condition getElementPresentCondition(final String locator) {
        String message = "Element is not present at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                List<WebElement> webElements = BaseWebDriverImpl.this.getWebElements(locator);
                return !webElements.isEmpty();
            }
        };
    }

    protected Point getFramePoint() {
        int x = 0;
        int y = 0;
        WebDriver wrappedWebDriver = this.getWrappedWebDriver("//body");
        WebDriver.TargetLocator targetLocator = wrappedWebDriver.switchTo();
        targetLocator.window(this._defaultWindowHandle);
        for (WebElement webElement : this._frameWebElements) {
            Point point = webElement.getLocation();
            x += point.getX();
            y += point.getY();
            targetLocator.frame(webElement);
        }
        return new Point(x, y);
    }

    protected int getFramePositionLeft() {
        Point point = this.getFramePoint();
        return point.getX();
    }

    protected int getFramePositionTop() {
        Point point = this.getFramePoint();
        return point.getY();
    }

    protected Stack<WebElement> getFrameWebElements() {
        return this._frameWebElements;
    }

    protected Table getHTMLTable(String locator) {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        List<WebElement> rowWebElements = this.findElements(By.xpath((String)(locator + "//tr")));
        for (int i = 2; i <= rowWebElements.size(); ++i) {
            ArrayList<String> webElementTexts = new ArrayList<String>();
            List<WebElement> columnWebElements = this.findElements(By.xpath((String)(locator + "//tr[" + i + "]//td")));
            for (int j = 1; j <= columnWebElements.size(); ++j) {
                WebElement webElement = this.findElement(By.xpath((String)(locator + "//tr[" + i + "]//td[" + j + "]")));
                webElementTexts.add(webElement.getText());
            }
            table.add(webElementTexts);
        }
        return new DefaultTable(table);
    }

    protected ImageTarget getImageTarget(String image) throws Exception {
        String fileName = FileUtil.getSeparator() + this.getSikuliImagesDirName() + image;
        File file = new File(LiferaySeleniumUtil.getSourceDirFilePath(fileName));
        return new ImageTarget(file);
    }

    protected Condition getJavaScriptCondition(final String javaScript, String message, final String argument) {
        return new Condition(message){

            @Override
            public boolean evaluate() {
                JavascriptExecutor javascriptExecutor = (JavascriptExecutor)BaseWebDriverImpl.this.getWrappedWebDriver("//body");
                String object = null;
                try {
                    if (Validator.isNotNull((String)argument)) {
                        object = BaseWebDriverImpl.this.getWebElement(argument);
                    }
                }
                catch (ElementNotFoundPoshiRunnerException | NullPointerException | InvalidSelectorException exception) {
                    object = argument;
                }
                Boolean javaScriptResult = (Boolean)javascriptExecutor.executeScript(javaScript, new Object[]{object});
                if (javaScriptResult == null) {
                    return false;
                }
                return javaScriptResult;
            }
        };
    }

    protected int getNavigationBarHeight() {
        return this._navigationBarHeight;
    }

    protected Condition getNotEditableCondition(final String locator) {
        String message = "Element is editable at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isEditable(locator);
            }
        };
    }

    protected Condition getNotPartialTextCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"\"", BaseWebDriverImpl.this.getText(locator), "\" contains \"", value, "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isPartialText(locator, value);
            }
        };
    }

    protected Condition getNotSelectedLabelCondition(final String selectLocator, final String pattern) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (BaseWebDriverImpl.this.isSelectedLabel(selectLocator, pattern)) {
                    String message = StringUtil.combine((String[])new String[]{"Pattern \"", pattern, "\" matches \"", BaseWebDriverImpl.this.getSelectedLabel(selectLocator), "\" at \"", selectLocator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                if (BaseWebDriverImpl.this.isElementNotPresent(selectLocator)) {
                    return false;
                }
                List<String> selectedLabelsList = Arrays.asList(BaseWebDriverImpl.this.getSelectedLabels(selectLocator));
                return !selectedLabelsList.contains(pattern);
            }
        };
    }

    protected Condition getNotTextCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Pattern \"", value, "\" matches \"", BaseWebDriverImpl.this.getText(locator), "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isText(locator, value);
            }
        };
    }

    protected Condition getNotValueCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Pattern \"", value, "\" matches \"", BaseWebDriverImpl.this.getElementValue(locator), "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isValue(locator, value);
            }
        };
    }

    protected Condition getNotVisibleCondition(final String locator) {
        String message = "Element is visible at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isVisible(locator);
            }
        };
    }

    protected Condition getNotVisibleInPageCondition(final String locator) {
        String message = "Element is visible in page at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isVisibleInPage(locator);
            }
        };
    }

    protected Condition getNotVisibleInViewportCondition(final String locator) {
        String message = "Element is visible in viewport at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isVisibleInViewport(locator);
            }
        };
    }

    protected Condition getPartialTextAceEditorCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Actual text \"", BaseWebDriverImpl.this.getTextAceEditor(locator), "\" does not contain expected text \"", value, "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                WebElement webElement = BaseWebDriverImpl.this.getWebElement(locator);
                String text = webElement.getText();
                text = StringUtil.replace((String)text, (String)"\n", (String)"");
                return text.contains(value);
            }
        };
    }

    protected Condition getPartialTextCaseInsensitiveCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Actual text \"", BaseWebDriverImpl.this.getText(locator), "\" does not contain expected text (case insensitive) ", "\"", value, "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                String actual = StringUtil.toUpperCase((String)BaseWebDriverImpl.this.getText(locator));
                return actual.contains(StringUtil.toUpperCase((String)value));
            }
        };
    }

    protected Condition getPartialTextCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Actual text \"", BaseWebDriverImpl.this.getText(locator), "\" does not contain expected text \"", value, "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                WebElement webElement = BaseWebDriverImpl.this.getWebElement(locator);
                String text = webElement.getText();
                return text.contains(value);
            }
        };
    }

    protected int getScrollOffsetX() {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver("//body");
        Object pageXOffset = javascriptExecutor.executeScript("return window.pageXOffset;", new Object[0]);
        return GetterUtil.getInteger((Object)pageXOffset);
    }

    protected int getScrollOffsetY() {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver("//body");
        Object pageYOffset = javascriptExecutor.executeScript("return window.pageYOffset;", new Object[0]);
        return GetterUtil.getInteger((Object)pageYOffset);
    }

    protected Condition getSelectedLabelCondition(final String selectLocator, final String pattern) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (BaseWebDriverImpl.this.isNotSelectedLabel(selectLocator, pattern)) {
                    String message = StringUtil.combine((String[])new String[]{"Expected text \"", pattern, "\" does not match actual text \"", BaseWebDriverImpl.this.getSelectedLabel(selectLocator), "\" at \"", selectLocator + "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                if (BaseWebDriverImpl.this.isElementNotPresent(selectLocator)) {
                    return false;
                }
                return pattern.equals(BaseWebDriverImpl.this.getSelectedLabel(selectLocator));
            }
        };
    }

    protected Condition getTextCaseInsensitiveCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Expected text \"", value, "\" does not match actual text (case insensitive) \"", BaseWebDriverImpl.this.getText(locator), "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                String actual = StringUtil.toUpperCase((String)BaseWebDriverImpl.this.getText(locator));
                return actual.equals(StringUtil.toUpperCase((String)value));
            }
        };
    }

    protected Condition getTextCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Expected text \"", value, "\" does not match actual text \"", BaseWebDriverImpl.this.getText(locator), "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                return value.equals(BaseWebDriverImpl.this.getText(locator));
            }
        };
    }

    protected Condition getTextMatchesCondition(final String locator, final String regex) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Actual text \"", BaseWebDriverImpl.this.getText(locator), "\" does not match pattern \"", regex, "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                String text = BaseWebDriverImpl.this.getText(locator);
                return text.matches(regex);
            }
        };
    }

    protected Condition getTextNotPresentCondition(final String pattern) {
        String message = "\"" + pattern + "\" is present";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return !BaseWebDriverImpl.this.isTextPresent(pattern);
            }
        };
    }

    protected Condition getTextPresentCondition(final String pattern) {
        String message = "\"" + pattern + "\" is not present";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                WebElement webElement = BaseWebDriverImpl.this.getWebElement("//body");
                String text = webElement.getText();
                return text.contains(pattern);
            }
        };
    }

    protected Condition getValueCondition(final String locator, final String value) {
        return new Condition(){

            @Override
            public void assertTrue() throws Exception {
                if (!this.evaluate()) {
                    String message = StringUtil.combine((String[])new String[]{"Expected text \"", value, "\" does not match actual text \"", BaseWebDriverImpl.this.getElementValue(locator), "\" at \"", locator, "\""});
                    throw new Exception(message);
                }
            }

            @Override
            public boolean evaluate() throws Exception {
                return value.equals(BaseWebDriverImpl.this.getElementValue(locator));
            }
        };
    }

    protected int getViewportHeight() {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver("//body");
        return GetterUtil.getInteger((Object)javascriptExecutor.executeScript("return window.innerHeight;", new Object[0]));
    }

    protected int getViewportPositionBottom() {
        return this.getScrollOffsetY() + this.getViewportHeight();
    }

    protected Condition getVisibleCondition(final String locator) {
        String message = "Element is not visible at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                return BaseWebDriverImpl.this.isVisibleInPage(locator);
            }
        };
    }

    protected Condition getVisibleInPageCondition(final String locator) {
        String message = "Element is not visible in page at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                WebElement webElement = BaseWebDriverImpl.this.getWebElement(locator);
                BaseWebDriverImpl.this.scrollWebElementIntoView(webElement);
                return webElement.isDisplayed();
            }
        };
    }

    protected Condition getVisibleInViewportCondition(final String locator) {
        String message = "Element is not visible in viewport at \"" + locator + "\"";
        return new Condition(message){

            @Override
            public boolean evaluate() throws Exception {
                WebElement webElement = BaseWebDriverImpl.this.getWebElement(locator);
                return webElement.isDisplayed();
            }
        };
    }

    protected WebDriver getWebDriver() {
        return this._webDriver;
    }

    protected WebElement getWebElement(String locator) {
        return this.getWebElement(locator, null);
    }

    protected WebElement getWebElement(String locator, String timeout) {
        List<WebElement> webElements = this.getWebElements(locator, timeout);
        if (!webElements.isEmpty()) {
            return webElements.get(0);
        }
        throw new ElementNotFoundPoshiRunnerException("Element is not present at \"" + locator + "\"");
    }

    protected List<WebElement> getWebElements(String locator) {
        return this.getWebElements(locator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<WebElement> getWebElements(String locator, String timeout) {
        if (timeout != null) {
            this.setTimeoutImplicit(timeout);
        }
        try {
            ArrayList<RetryWebElementImpl> webElements = new ArrayList<RetryWebElementImpl>();
            for (WebElement webElement : this.findElements(this.getBy(locator))) {
                webElements.add(new RetryWebElementImpl(locator, webElement));
            }
            ArrayList<RetryWebElementImpl> arrayList = webElements;
            return arrayList;
        }
        finally {
            if (timeout != null) {
                this.setDefaultTimeoutImplicit();
            }
        }
    }

    protected Point getWindowPoint() {
        WebDriver wrappedWebDriver = this.getWrappedWebDriver("//body");
        WebDriver.Options options = wrappedWebDriver.manage();
        WebDriver.Window window = options.window();
        return window.getPosition();
    }

    protected int getWindowPositionLeft() {
        Point point = this.getWindowPoint();
        return point.getX();
    }

    protected int getWindowPositionTop() {
        Point point = this.getWindowPoint();
        return point.getY();
    }

    protected WebDriver getWrappedWebDriver(String locator) {
        WebDriverWait webDriverWait = new WebDriverWait((WebDriver)this, Duration.ofSeconds(5L));
        webDriverWait.until((Function)ExpectedConditions.presenceOfElementLocated((By)this.getBy(locator)));
        return this.getWrappedWebDriver(this.getWebElement(locator));
    }

    protected WebDriver getWrappedWebDriver(WebElement webElement) {
        WrapsDriver wrapsDriver = (WrapsDriver)webElement;
        return wrapsDriver.getWrappedDriver();
    }

    protected boolean isObscured(WebElement webElement) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver(webElement);
        StringBuilder sb = new StringBuilder();
        sb.append("var element = arguments[0];");
        sb.append("console.log(element);");
        sb.append("var rect = element.getBoundingClientRect();");
        sb.append("elementX = (rect.right + rect.left) / 2;");
        sb.append("elementY = (rect.top + rect.bottom) / 2;");
        sb.append("var newElement = ");
        sb.append("document.elementFromPoint(elementX, elementY);");
        sb.append("if (element == newElement) {");
        sb.append("return false;}");
        sb.append("return true;");
        Boolean obscured = (Boolean)javascriptExecutor.executeScript(sb.toString(), new Object[]{webElement});
        return obscured;
    }

    protected boolean isValidKeycode(String keycode) {
        for (Keys keys : Keys.values()) {
            String keysName = keys.name();
            if (!keysName.equals(keycode)) continue;
            return true;
        }
        return false;
    }

    protected void moveToElement(Actions actions, WebElement webElement, String offset) {
        String[] offsetCoordinates = offset.split(",");
        int x = GetterUtil.getInteger((String)offsetCoordinates[0]);
        int y = GetterUtil.getInteger((String)offsetCoordinates[1]);
        actions.moveToElement(webElement, x, y);
    }

    protected void ocularConfig() {
        String testBaseDirName = this.poshiProperties.testBaseDirName;
        OcularConfiguration ocularConfiguration = Ocular.config();
        ocularConfiguration = ocularConfiguration.snapshotPath(Paths.get(testBaseDirName, this.getOcularBaselineImageDirName()));
        FileUtil.delete((File)new File(testBaseDirName, this.getOcularResultImageDirName()));
        ocularConfiguration.resultPath(Paths.get(testBaseDirName, this.getOcularResultImageDirName()));
        ocularConfiguration.globalSimilarity(99);
        ocularConfiguration.saveSnapshot(true);
    }

    protected void saveWebPage(String fileName, String htmlSource) throws Exception {
        if (!this.poshiProperties.saveWebPage) {
            return;
        }
        StringBuilder sb = new StringBuilder(3);
        sb.append("<style>");
        sb.append(this.getCSSSource(htmlSource));
        sb.append("</style></html>");
        FileUtil.write((String)fileName, (String)StringUtil.replace((String)htmlSource, (String)"<\\html>", (String)sb.toString()));
    }

    protected void scrollWebElementIntoView(WebElement webElement) {
        if (!webElement.isDisplayed() || this.isObscured(webElement)) {
            JavascriptExecutor javascriptExecutor = (JavascriptExecutor)this.getWrappedWebDriver(webElement);
            javascriptExecutor.executeScript("arguments[0].scrollIntoView(false);", new Object[]{webElement});
        }
    }

    protected void selectByRegexpText(String selectLocator, String regexp) {
        Select select = new Select(this.getWebElement(selectLocator));
        List optionWebElements = select.getOptions();
        Pattern pattern = Pattern.compile(regexp);
        int index = -1;
        for (WebElement optionWebElement : optionWebElements) {
            String optionWebElementText = optionWebElement.getText();
            Matcher matcher = pattern.matcher(optionWebElementText);
            if (!matcher.matches()) continue;
            index = optionWebElements.indexOf(optionWebElement);
            break;
        }
        select.selectByIndex(index);
    }

    protected void selectByRegexpValue(String selectLocator, String regexp) {
        Select select = new Select(this.getWebElement(selectLocator));
        List optionWebElements = select.getOptions();
        Pattern pattern = Pattern.compile(regexp);
        int index = -1;
        for (WebElement optionWebElement : optionWebElements) {
            String optionWebElementValue = optionWebElement.getAttribute("value");
            Matcher matcher = pattern.matcher(optionWebElementValue);
            if (!matcher.matches()) continue;
            index = optionWebElements.indexOf(optionWebElement);
            break;
        }
        select.selectByIndex(index);
    }

    protected void setAlert(Alert alert) {
        this._alert = alert;
    }

    protected void setDefaultWindowHandle(String defaultWindowHandle) {
        this._defaultWindowHandle = defaultWindowHandle;
    }

    protected void setNavigationBarHeight(int navigationBarHeight) {
        this._navigationBarHeight = navigationBarHeight;
    }

    static {
        _aceEditorPattern = Pattern.compile("\\(|\\$\\{line\\.separator\\}");
        _coordinatePairsPattern = Pattern.compile("[+-]?\\d+\\,[+-]?\\d+(\\|[+-]?\\d+\\,[+-]?\\d+)*");
        _keyCodeMap = new Hashtable<String, Integer>(){
            {
                this.put("ALT", 18);
                this.put("COMMAND", 157);
                this.put("CONTROL", 17);
                this.put("CTRL", 17);
                this.put("SHIFT", 16);
            }
        };
        _keysMap = new Hashtable<String, Keys>(){
            {
                for (Keys keys : (Keys[])Keys.class.getEnumConstants()) {
                    this.put(keys.name(), keys);
                }
                this.put("CTRL", Keys.CONTROL);
            }
        };
        _tabPattern = Pattern.compile(".*?(\\t).*?", 32);
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        String testDependenciesDirName = poshiProperties.testDependenciesDirName;
        String ocularResultImageDirName = testDependenciesDirName + "//ocular//result";
        String ocularBaselineImageDirName = testDependenciesDirName + "//ocular//baseline";
        String sikuliImagesDirName = testDependenciesDirName + "//sikuli//linux//";
        String outputDirName = poshiProperties.outputDirName;
        if (OSDetector.isApple()) {
            sikuliImagesDirName = StringUtil.replace((String)sikuliImagesDirName, (String)"linux", (String)"osx");
        } else if (OSDetector.isWindows()) {
            ocularResultImageDirName = StringUtil.replace((String)ocularResultImageDirName, (String)"//", (String)"\\");
            ocularBaselineImageDirName = StringUtil.replace((String)ocularBaselineImageDirName, (String)"//", (String)"\\");
            outputDirName = StringUtil.replace((String)outputDirName, (String)"//", (String)"\\");
            sikuliImagesDirName = StringUtil.replace((String)sikuliImagesDirName, (String)"//", (String)"\\");
            sikuliImagesDirName = StringUtil.replace((String)sikuliImagesDirName, (String)"linux", (String)"windows");
            testDependenciesDirName = StringUtil.replace((String)testDependenciesDirName, (String)"//", (String)"\\");
        }
        _OUTPUT_DIR_NAME = outputDirName;
        _OCULAR_RESULT_IMAGE_DIR_NAME = ocularResultImageDirName;
        _OCULAR_BASELINE_IMAGE_DIR_NAME = ocularBaselineImageDirName;
        _SIKULI_IMAGES_DIR_NAME = sikuliImagesDirName;
        _TEST_DEPENDENCIES_DIR_NAME = testDependenciesDirName;
    }

    private class LocationCallable
    implements Callable<String> {
        private WebDriver _webDriver;

        private LocationCallable() {
        }

        @Override
        public String call() throws Exception {
            return this._webDriver.getCurrentUrl();
        }

        private Callable<String> _init(WebDriver webDriver) throws Exception {
            this._webDriver = webDriver;
            return this;
        }
    }

    protected abstract class Condition {
        private final String _message;

        public Condition() {
            this("");
        }

        public Condition(String message) {
            this._message = message;
        }

        public void assertTrue() throws Exception {
            if (!this.evaluate()) {
                throw new Exception(this._message);
            }
        }

        public abstract boolean evaluate() throws Exception;

        public void verify() throws Exception {
            if (!this.evaluate()) {
                throw new PoshiRunnerWarningException("VERIFICATION_WARNING: " + this._message);
            }
        }

        public void waitFor() throws Exception {
            this.waitFor("true");
        }

        public void waitFor(String throwException) throws Exception {
            int timeout = BaseWebDriverImpl.this.poshiProperties.timeoutExplicitWait * 1000;
            int wait = 500;
            for (int millisecond = 0; millisecond < timeout; millisecond += wait) {
                try {
                    if (this.evaluate()) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.sleep(wait);
            }
            if (throwException == null || Boolean.parseBoolean(throwException)) {
                this.assertTrue();
            }
        }
    }
}

