/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.selenium;

import java.io.Serializable;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class LiferayByUtil {
    public static By cssSelectorWithShadowRoot(String selector) {
        return new ByCssSelectorWithShadowRoot(selector);
    }

    public static class ByCssSelectorWithShadowRoot
    extends By
    implements Serializable {
        private final String _cssSelector;

        public ByCssSelectorWithShadowRoot(String cssSelector) {
            if (cssSelector == null) {
                throw new IllegalArgumentException("Unable to find elements when the selector is null");
            }
            this._cssSelector = cssSelector;
        }

        public WebElement findElement(SearchContext searchContext) {
            List<WebElement> webElements = this.findElements(searchContext);
            if (!webElements.isEmpty()) {
                return webElements.get(0);
            }
            throw new WebDriverException("Unable to find element using CSS selector: " + this._cssSelector);
        }

        public List<WebElement> findElements(SearchContext searchContext) {
            if (searchContext instanceof WebDriver) {
                String[] partialCssSelectors = this._cssSelector.split(">>>");
                for (int i = 0; i < partialCssSelectors.length - 1; ++i) {
                    By.ByCssSelector byCssSelector = new By.ByCssSelector(partialCssSelectors[i]);
                    WebElement webElement = byCssSelector.findElement(searchContext);
                    searchContext = webElement.getShadowRoot();
                }
                return searchContext.findElements(By.cssSelector((String)partialCssSelectors[partialCssSelectors.length - 1]));
            }
            throw new WebDriverException("Unable to find elements using CSS selector: " + this._cssSelector);
        }

        public String toString() {
            return "By.cssSelector: " + this._cssSelector;
        }
    }
}

