/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.selenium;

import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.selenium.LiferaySeleniumUtil;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class RetryWebElementImpl
extends RemoteWebElement {
    private static final int _RETRY_WAIT_TIME;
    private final String _locator;
    private RemoteWebElement _remoteWebElement;
    private WebElement _webElement;

    public RetryWebElementImpl(String locator, WebElement webElement) {
        this._locator = locator;
        this._webElement = webElement;
        this._remoteWebElement = (RemoteWebElement)this._webElement;
    }

    public void clear() {
        try {
            this._clear();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            this._clear();
        }
    }

    public void click() {
        try {
            this._webElement.click();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            this._webElement.click();
        }
    }

    public boolean equals(Object object) {
        try {
            return this._remoteWebElement.equals(object);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._remoteWebElement.equals(object);
        }
    }

    public WebElement findElement(By by) {
        try {
            return this._webElement.findElement(by);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.findElement(by);
        }
    }

    public List<WebElement> findElements(By by) {
        try {
            return this._webElement.findElements(by);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.findElements(by);
        }
    }

    public String getAccessibleName() {
        try {
            return this._webElement.getAccessibleName();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getAccessibleName();
        }
    }

    public String getAriaRole() {
        try {
            return this._webElement.getAriaRole();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getAriaRole();
        }
    }

    public String getAttribute(String name) {
        try {
            return this._webElement.getAttribute(name);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getAttribute(name);
        }
    }

    public Coordinates getCoordinates() {
        try {
            Locatable locatable = (Locatable)this._webElement;
            return locatable.getCoordinates();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            Locatable locatable = (Locatable)this._webElement;
            return locatable.getCoordinates();
        }
    }

    public String getCssValue(String propertyName) {
        try {
            return this._webElement.getCssValue(propertyName);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getCssValue(propertyName);
        }
    }

    public String getDomAttribute(String name) {
        try {
            return this._webElement.getDomAttribute(name);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getDomAttribute(name);
        }
    }

    public String getDomProperty(String name) {
        try {
            return this._webElement.getDomProperty(name);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getDomProperty(name);
        }
    }

    public String getId() {
        try {
            return this._remoteWebElement.getId();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._remoteWebElement.getId();
        }
    }

    public Point getLocation() {
        try {
            return this._webElement.getLocation();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getLocation();
        }
    }

    public Rectangle getRect() {
        try {
            return this._webElement.getRect();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getRect();
        }
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        try {
            return (X)this._webElement.getScreenshotAs(target);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return (X)this._webElement.getScreenshotAs(target);
        }
    }

    public SearchContext getShadowRoot() {
        try {
            return this._webElement.getShadowRoot();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getShadowRoot();
        }
    }

    public Dimension getSize() {
        try {
            return this._webElement.getSize();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getSize();
        }
    }

    public String getTagName() {
        try {
            return this._webElement.getTagName();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getTagName();
        }
    }

    public String getText() {
        try {
            return this._webElement.getText();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.getText();
        }
    }

    public WebDriver getWrappedDriver() {
        return this._remoteWebElement.getWrappedDriver();
    }

    public int hashCode() {
        try {
            return this._remoteWebElement.hashCode();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._remoteWebElement.hashCode();
        }
    }

    public boolean isDisplayed() {
        try {
            return this._webElement.isDisplayed();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.isDisplayed();
        }
    }

    public boolean isEnabled() {
        try {
            return this._webElement.isEnabled();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.isEnabled();
        }
    }

    public boolean isSelected() {
        try {
            return this._webElement.isSelected();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            return this._webElement.isSelected();
        }
    }

    public void sendKeys(CharSequence ... keys) {
        try {
            this._webElement.sendKeys(keys);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            this._webElement.sendKeys(keys);
        }
    }

    public void setFileDetector(FileDetector fileDetector) {
        try {
            this._remoteWebElement.setFileDetector(fileDetector);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            this._remoteWebElement.setFileDetector(fileDetector);
        }
    }

    public void setId(String id) {
        try {
            this._remoteWebElement.setId(id);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            this._remoteWebElement.setId(id);
        }
    }

    public void setParent(RemoteWebDriver remoteWebDriver) {
        try {
            this._remoteWebElement.setParent(remoteWebDriver);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            this._remoteWebElement.setParent(remoteWebDriver);
        }
    }

    public void submit() {
        try {
            this._webElement.submit();
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            this._refreshWebElement(staleElementReferenceException);
            this._webElement.submit();
        }
    }

    protected String getLocator() {
        return this._locator;
    }

    private void _clear() {
        Keys controlCharSequence = Keys.CONTROL;
        if (OSDetector.isApple() && !(this._remoteWebElement.getWrappedDriver() instanceof RemoteWebDriver)) {
            controlCharSequence = Keys.COMMAND;
        }
        this._webElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{controlCharSequence, "a", Keys.DELETE})});
        String webElementValue = this._webElement.getAttribute("value");
        if (Validator.isNull((String)webElementValue) || webElementValue.isEmpty()) {
            return;
        }
        this._webElement.click();
        for (int i = 0; i < webElementValue.length(); ++i) {
            this._webElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        }
    }

    private void _refreshWebElement(Throwable throwable) {
        System.out.println("\n" + throwable.getMessage());
        System.out.println("\nWill retry command in " + _RETRY_WAIT_TIME + " seconds\n");
        try {
            Thread.sleep(_RETRY_WAIT_TIME * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        WebDriver webDriver = this._remoteWebElement.getWrappedDriver();
        WebElement webElement = webDriver.findElement(LiferaySeleniumUtil.getBy(this._locator));
        if (webElement == this._webElement) {
            System.out.println("Unable to find a new web element");
        } else {
            System.out.println("Found a new web element");
        }
        this._webElement = webElement;
        this._remoteWebElement = (RemoteWebElement)this._webElement;
    }

    static {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        _RETRY_WAIT_TIME = poshiProperties.testRetryCommandWaitTime;
    }
}

