/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.selenium;

import com.liferay.poshi.runner.selenium.BaseWebDriverImpl;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;

public class SafariWebDriverImpl
extends BaseWebDriverImpl {
    public SafariWebDriverImpl(String browserURL, WebDriver webDriver) {
        super(browserURL, webDriver);
    }

    @Override
    public void assertConfirmation(String pattern) throws Exception {
    }

    @Override
    public void click(String locator) {
        if (locator.contains("x:")) {
            String url = this.getHtmlNodeHref(locator);
            this.open(url);
        } else {
            WebElement webElement = this.getWebElement(locator);
            WrapsDriver wrapsDriver = (WrapsDriver)webElement;
            WebDriver wrappedWebDriver = wrapsDriver.getWrappedDriver();
            JavascriptExecutor javascriptExecutor = (JavascriptExecutor)wrappedWebDriver;
            try {
                javascriptExecutor.executeScript("confirm = function(){return true;};", new Object[0]);
                this.javaScriptClick(locator);
            }
            catch (ElementNotInteractableException elementNotInteractableException) {
                if (this.isVisible(locator)) {
                    this.javaScriptClick(locator);
                    return;
                }
                throw elementNotInteractableException;
            }
        }
    }

    @Override
    public String getText(String locator, String timeout) throws Exception {
        return this.javaScriptGetText(locator, timeout);
    }

    @Override
    public boolean isVisible(String locator) {
        WebElement webElement = this.getWebElement(locator, "1");
        this.scrollWebElementIntoView(webElement);
        return webElement.isDisplayed() || !this.isObscured(webElement);
    }

    @Override
    public void mouseDown(String locator) {
        this.executeJavaScriptEvent(locator, "MouseEvent", "mousedown");
    }

    @Override
    public void mouseOver(String locator) {
        this.executeJavaScriptEvent(locator, "MouseEvent", "mouseover");
    }

    @Override
    public void mouseUp(String locator) {
        this.executeJavaScriptEvent(locator, "MouseEvent", "mouseup");
        this.executeJavaScriptEvent(locator, "MouseEvent", "click");
    }
}

