/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.selenium;

import com.liferay.poshi.core.selenium.LiferaySelenium;
import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import com.liferay.poshi.runner.logger.ParallelPrintStream;
import com.liferay.poshi.runner.selenium.ChromeWebDriverImpl;
import com.liferay.poshi.runner.selenium.EdgeWebDriverImpl;
import com.liferay.poshi.runner.selenium.FirefoxWebDriverImpl;
import com.liferay.poshi.runner.selenium.InternetExplorerWebDriverImpl;
import com.liferay.poshi.runner.selenium.SafariWebDriverImpl;
import com.liferay.poshi.runner.util.ProxyUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;

public class WebDriverUtil {
    private static final URL _REMOTE_DRIVER_URL;
    private static final Map<String, Object> _genericCapabilities;
    private static final Map<String, WebDriver> _webDrivers;

    public static LiferaySelenium getLiferaySelenium(String testName) {
        if (!_webDrivers.containsKey(testName)) {
            WebDriverUtil.startWebDriver(testName);
        }
        return (LiferaySelenium)_webDrivers.get(testName);
    }

    public static WebDriver getWebDriver(String testName) {
        return _webDrivers.get(testName);
    }

    public static synchronized void startWebDriver(String testName) {
        if (_webDrivers.containsKey(testName)) {
            throw new RuntimeException("WebDriver instance already started for: " + testName);
        }
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        String portalURL = poshiProperties.portalURL;
        if (poshiProperties.tcatEnabled) {
            portalURL = "http://localhost:8180/console";
        }
        if (poshiProperties.browserType.equals("chrome")) {
            _webDrivers.put(testName, new ChromeWebDriverImpl(portalURL, WebDriverUtil._getChromeDriver()));
        } else if (poshiProperties.browserType.equals("edge")) {
            if (poshiProperties.seleniumEdgeDriverExecutable != null) {
                System.setProperty("webdriver.edge.driver", poshiProperties.seleniumExecutableDirName + poshiProperties.seleniumEdgeDriverExecutable);
            }
            _webDrivers.put(testName, new EdgeWebDriverImpl(portalURL, WebDriverUtil._getEdgeDriver()));
        } else if (poshiProperties.browserType.equals("firefox")) {
            _webDrivers.put(testName, new FirefoxWebDriverImpl(portalURL, WebDriverUtil._getFirefoxDriver()));
        } else if (poshiProperties.browserType.equals("internetexplorer")) {
            if (poshiProperties.seleniumIeDriverExecutable != null) {
                System.setProperty("webdriver.ie.driver", poshiProperties.seleniumExecutableDirName + poshiProperties.seleniumIeDriverExecutable);
            }
            _webDrivers.put(testName, new InternetExplorerWebDriverImpl(portalURL, WebDriverUtil._getInternetExplorerDriver()));
        } else if (poshiProperties.browserType.equals("safari")) {
            _webDrivers.put(testName, new SafariWebDriverImpl(portalURL, WebDriverUtil._getSafariDriver()));
        }
        if (!_webDrivers.containsKey(testName)) {
            throw new RuntimeException("Invalid browser type " + poshiProperties.browserType);
        }
        LiferaySelenium liferaySelenium = (LiferaySelenium)_webDrivers.get(testName);
        liferaySelenium.setTestName(testName);
    }

    public static void stopWebDriver(String testName) {
        WebDriver webDriver = _webDrivers.get(testName);
        if (webDriver != null) {
            webDriver.quit();
        }
        _webDrivers.remove(testName);
    }

    private static WebDriver _getChromeDriver() {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (Validator.isNotNull((String)poshiProperties.seleniumRemoteDriverURL)) {
            return WebDriverUtil._getChromeRemoteDriver();
        }
        WebDriverUtil._validateWebDriverBinary("webdriver.chrome.driver", "chromedriver");
        ChromeOptions chromeOptions = WebDriverUtil._getDefaultChromeOptions();
        if (Validator.isNotNull((String)poshiProperties.browserChromeBinFile)) {
            chromeOptions.setBinary(poshiProperties.browserChromeBinFile);
        }
        if (poshiProperties.testRunType.equals("parallel")) {
            ChromeDriverService chromeDriverService = ChromeDriverService.createServiceWithConfig((ChromeOptions)chromeOptions);
            Thread thread = Thread.currentThread();
            chromeDriverService.sendOutputTo((OutputStream)ParallelPrintStream.getPrintStream(thread.getName()));
            return new ChromeDriver(chromeDriverService, chromeOptions);
        }
        return new ChromeDriver(chromeOptions);
    }

    private static WebDriver _getChromeRemoteDriver() {
        return WebDriverUtil._getRemoteWebDriver((Capabilities)WebDriverUtil._getDefaultChromeOptions());
    }

    private static ChromeOptions _getDefaultChromeOptions() {
        ChromeOptions chromeOptions = new ChromeOptions();
        WebDriverUtil._setGenericCapabilities((MutableCapabilities)chromeOptions);
        HashMap<String, Object> preferences = new HashMap<String, Object>();
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        String outputDirName = poshiProperties.outputDirName;
        try {
            File file = new File(outputDirName);
            outputDirName = file.getCanonicalPath();
        }
        catch (IOException ioException) {
            System.out.println("Unable to get canonical path for " + outputDirName);
        }
        if (OSDetector.isWindows()) {
            outputDirName = StringUtil.replace((String)outputDirName, (String)"/", (String)"\\");
        }
        preferences.put("download.default_directory", outputDirName);
        preferences.put("download.prompt_for_download", false);
        preferences.put("profile.default_content_settings.popups", 0);
        chromeOptions.setExperimentalOption("prefs", preferences);
        if (Validator.isNotNull((String)poshiProperties.browserChromeBinArgs)) {
            chromeOptions.addArguments(poshiProperties.browserChromeBinArgs.split("\\s+"));
        }
        chromeOptions.addArguments(new String[]{"--remote-allow-origins=*"});
        return chromeOptions;
    }

    private static InternetExplorerOptions _getDefaultInternetExplorerOptions() {
        InternetExplorerOptions internetExplorerOptions = new InternetExplorerOptions();
        WebDriverUtil._setGenericCapabilities((MutableCapabilities)internetExplorerOptions);
        internetExplorerOptions.destructivelyEnsureCleanSession();
        internetExplorerOptions.introduceFlakinessByIgnoringSecurityDomains();
        return internetExplorerOptions;
    }

    private static WebDriver _getEdgeDriver() {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (Validator.isNotNull((String)poshiProperties.seleniumRemoteDriverURL)) {
            return WebDriverUtil._getEdgeRemoteDriver();
        }
        return new EdgeDriver();
    }

    private static WebDriver _getEdgeRemoteDriver() {
        EdgeOptions edgeOptions = new EdgeOptions();
        WebDriverUtil._setGenericCapabilities((MutableCapabilities)edgeOptions);
        edgeOptions.setCapability("platform", "WINDOWS");
        return WebDriverUtil._getRemoteWebDriver((Capabilities)edgeOptions);
    }

    private static WebDriver _getFirefoxDriver() {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (Validator.isNotNull((String)poshiProperties.seleniumRemoteDriverURL)) {
            return WebDriverUtil._getFirefoxRemoteDriver();
        }
        WebDriverUtil._validateWebDriverBinary("webdriver.gecko.driver", "geckodriver");
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        WebDriverUtil._setGenericCapabilities((MutableCapabilities)firefoxOptions);
        String outputDirName = poshiProperties.outputDirName;
        if (OSDetector.isWindows()) {
            outputDirName = StringUtil.replace((String)outputDirName, (String)"/", (String)"\\");
        }
        firefoxOptions.addPreference("browser.download.dir", (Object)outputDirName);
        firefoxOptions.addPreference("browser.download.folderList", (Object)2);
        firefoxOptions.addPreference("browser.download.manager.showWhenStarting", (Object)false);
        firefoxOptions.addPreference("browser.download.useDownloadDir", (Object)true);
        firefoxOptions.addPreference("browser.helperApps.alwaysAsk.force", (Object)false);
        firefoxOptions.addPreference("browser.helperApps.neverAsk.saveToDisk", (Object)"application/excel,application/msword,application/pdf,application/zip,audio/mpeg3,image/jpeg,image/png,text/plain");
        firefoxOptions.addPreference("dom.max_chrome_script_run_time", (Object)300);
        firefoxOptions.addPreference("dom.max_script_run_time", (Object)300);
        if (Validator.isNotNull((String)poshiProperties.browserFirefoxBinFile)) {
            File file = new File(poshiProperties.browserFirefoxBinFile);
            FirefoxBinary firefoxBinary = new FirefoxBinary(file);
            firefoxOptions.setBinary(firefoxBinary);
        }
        firefoxOptions.setCapability("locationContextEnabled", false);
        firefoxOptions.setCapability("marionette", true);
        try {
            FirefoxProfile firefoxProfile = new FirefoxProfile();
            firefoxProfile.addExtension(WebDriverUtil.class, "/META-INF/resources/firefox/extensions/jserrorcollector.xpi");
            firefoxOptions.setProfile(firefoxProfile);
        }
        catch (Exception exception) {
            System.out.println("Unable to add the jserrorcollector.xpi extension to the Firefox profile.");
        }
        return new FirefoxDriver(firefoxOptions);
    }

    private static WebDriver _getFirefoxRemoteDriver() {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        WebDriverUtil._setGenericCapabilities((MutableCapabilities)firefoxOptions);
        return WebDriverUtil._getRemoteWebDriver((Capabilities)firefoxOptions);
    }

    private static WebDriver _getInternetExplorerDriver() {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (Validator.isNotNull((String)poshiProperties.seleniumRemoteDriverURL)) {
            return WebDriverUtil._getInternetExplorerRemoteDriver();
        }
        return new InternetExplorerDriver(WebDriverUtil._getDefaultInternetExplorerOptions());
    }

    private static WebDriver _getInternetExplorerRemoteDriver() {
        InternetExplorerOptions internetExplorerOptions = WebDriverUtil._getDefaultInternetExplorerOptions();
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        internetExplorerOptions.setCapability("platform", poshiProperties.seleniumDesiredCapabilitiesPlatform);
        internetExplorerOptions.setCapability("version", poshiProperties.browserVersion);
        return WebDriverUtil._getRemoteWebDriver((Capabilities)internetExplorerOptions);
    }

    private static RemoteWebDriver _getRemoteWebDriver(Capabilities capabilities) {
        RemoteWebDriver remoteWebDriver = new RemoteWebDriver(_REMOTE_DRIVER_URL, capabilities);
        remoteWebDriver.setFileDetector((FileDetector)new LocalFileDetector());
        return remoteWebDriver;
    }

    private static WebDriver _getSafariDriver() {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (Validator.isNotNull((String)poshiProperties.seleniumRemoteDriverURL)) {
            return WebDriverUtil._getSafariRemoteDriver();
        }
        WebDriverUtil._setGenericCapabilities((MutableCapabilities)new SafariOptions());
        return new SafariDriver();
    }

    private static WebDriver _getSafariRemoteDriver() {
        SafariOptions safariOptions = new SafariOptions();
        WebDriverUtil._setGenericCapabilities((MutableCapabilities)safariOptions);
        return WebDriverUtil._getRemoteWebDriver((Capabilities)safariOptions);
    }

    private static void _setGenericCapabilities(MutableCapabilities mutableCapabilities) {
        mutableCapabilities.setCapability("unhandledPromptBehavior", "ignore");
        for (Map.Entry<String, Object> entry : _genericCapabilities.entrySet()) {
            mutableCapabilities.setCapability(entry.getKey(), entry.getValue());
        }
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (poshiProperties.proxyServerEnabled.booleanValue()) {
            mutableCapabilities.setCapability("proxy", (Object)ProxyUtil.getSeleniumProxy());
        }
    }

    private static void _validateWebDriverBinary(String webDriverBinaryPropertyName, String webDriverBinaryName) {
        String webDriverChromeDriverPath;
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (poshiProperties.seleniumExecutableDirName != null && poshiProperties.seleniumChromeDriverExecutable != null) {
            System.setProperty(webDriverBinaryPropertyName, poshiProperties.seleniumExecutableDirName + poshiProperties.seleniumChromeDriverExecutable);
        }
        if ((webDriverChromeDriverPath = System.getProperty(webDriverBinaryPropertyName)) == null) {
            throw new RuntimeException(StringUtil.combine((String[])new String[]{"Please set the system property \"", webDriverBinaryPropertyName, "\" to a valid ", webDriverBinaryName, " binary"}));
        }
        System.out.println(StringUtil.combine((String[])new String[]{"Using \"", webDriverChromeDriverPath, "\" as \"", webDriverBinaryPropertyName, "\" path"}));
    }

    static {
        _genericCapabilities = new HashMap<String, Object>(){
            {
                PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
                if (poshiProperties.proxyServerEnabled.booleanValue()) {
                    this.put("acceptInsecureCerts", true);
                }
            }
        };
        _webDrivers = new HashMap<String, WebDriver>();
        try {
            PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
            _REMOTE_DRIVER_URL = Validator.isNull((String)poshiProperties.seleniumRemoteDriverURL) ? new URL("http://localhost:4444/wd/hub") : (poshiProperties.seleniumRemoteDriverURL.matches(".*\\/wd\\/hub\\/?$") ? new URL(poshiProperties.seleniumRemoteDriverURL) : new URL(poshiProperties.seleniumRemoteDriverURL + "/wd/hub"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }
}

