/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AntCommands
implements Callable<Void> {
    private final String _fileName;
    private final String _target;

    public static void runCommand(String fileName, String target) throws Exception {
        AntCommands antCommands = new AntCommands(fileName, target);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<Void> future = executorService.submit(antCommands);
        future.get(600L, TimeUnit.SECONDS);
    }

    public AntCommands(String fileName, String target) {
        this._fileName = fileName;
        this._target = target;
    }

    @Override
    public Void call() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        StringBuilder sb = new StringBuilder();
        String projectDirName = PoshiGetterUtil.getProjectDirName();
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (!OSDetector.isWindows()) {
            projectDirName = StringUtil.replace((String)projectDirName, (String)"\\", (String)"//");
            sb.append("/bin/bash ant -f ");
            sb.append(this._fileName);
            sb.append(" ");
            sb.append(this._target);
            sb.append(" -Dtest.ant.launched.by.selenium=true -Dtest.class=");
            sb.append(poshiProperties.testName);
        } else {
            sb.append("cmd /c ant -f ");
            sb.append(this._fileName);
            sb.append(" ");
            sb.append(this._target);
            sb.append(" -Dtest.ant.launched.by.selenium=true -Dtest.class=");
            sb.append(poshiProperties.testName);
        }
        Process process = runtime.exec(sb.toString(), null, new File(projectDirName));
        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
        BufferedReader inputBufferedReader = new BufferedReader(inputStreamReader);
        String line = null;
        while ((line = inputBufferedReader.readLine()) != null) {
            System.out.println(line);
        }
        InputStreamReader errorStreamReader = new InputStreamReader(process.getErrorStream());
        BufferedReader errorBufferedReader = new BufferedReader(errorStreamReader);
        if (errorBufferedReader.ready()) {
            while ((line = errorBufferedReader.readLine()) != null) {
                System.out.println(line);
            }
            throw new Exception();
        }
        return null;
    }
}

