/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.liferay.poshi.core.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchiveUtil {
    public static void archive(File sourceFile, File targetFile) {
        String targetFileName = targetFile.getName();
        if (!targetFileName.matches(".*\\.(jar|lar|war|zip)")) {
            throw new RuntimeException("Invalid archive path " + targetFile);
        }
        final ArrayList archiveZipEntries = new ArrayList();
        try {
            final Path sourceFilePath = Paths.get(sourceFile.getCanonicalPath(), new String[0]);
            Files.walkFileTree(sourceFilePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) {
                    String targetFilePathString = String.valueOf(sourceFilePath.relativize(file));
                    targetFilePathString = StringUtil.replace((String)targetFilePathString, (String)"\\", (String)"/");
                    archiveZipEntries.add(new ArchiveZipEntry(targetFilePathString, file));
                    return FileVisitResult.CONTINUE;
                }
            });
            targetFile.delete();
            File parentFile = targetFile.getParentFile();
            parentFile.mkdirs();
            File tmpDir = new File(sourceFile.getParentFile(), "tmp");
            tmpDir.mkdir();
            tmpDir.deleteOnExit();
            File tmpFile = new File(tmpDir, targetFileName);
            tmpFile.delete();
            Collections.sort(archiveZipEntries);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tmpFile));){
                for (ArchiveZipEntry archiveZipEntry : archiveZipEntries) {
                    archiveZipEntry.writeToZipOutputStream(zipOutputStream);
                }
            }
            Files.move(Paths.get(tmpFile.getCanonicalPath(), new String[0]), Paths.get(targetFile.getCanonicalPath(), new String[0]), new CopyOption[0]);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to archive " + sourceFile + " to " + targetFile, ioException);
        }
    }

    public static void archive(String sourceFilePath, String targetFilePath) {
        ArchiveUtil.archive(new File(sourceFilePath), new File(targetFilePath));
    }

    public static void archive(String sourceFile, String targetDir, String archiveType) {
        Path sourceDirPath = Paths.get(sourceFile, new String[0]);
        String archiveFilePath = targetDir + "/" + sourceDirPath.getFileName() + "." + archiveType;
        ArchiveUtil.archive(sourceFile, archiveFilePath);
    }

    private static final class ArchiveZipEntry
    extends ZipEntry
    implements Comparable<ArchiveZipEntry> {
        private final Path _path;

        public ArchiveZipEntry(String name, Path path) {
            super(name);
            this._path = path;
        }

        @Override
        public int compareTo(ArchiveZipEntry archiveZipEntry) {
            String manifestFileName = "META-INF/MANIFEST.MF";
            if (manifestFileName.equals(archiveZipEntry.getName())) {
                return 1;
            }
            String name = this.getName();
            if (manifestFileName.equals(name)) {
                return -1;
            }
            return name.compareTo(archiveZipEntry.getName());
        }

        public void writeToZipOutputStream(ZipOutputStream zipOutputStream) {
            try (InputStream inputStream = Files.newInputStream(this._path, new OpenOption[0]);){
                zipOutputStream.putNextEntry(this);
                byte[] bytes = new byte[1024];
                int bytesRead = inputStream.read(bytes);
                while (bytesRead > 0) {
                    zipOutputStream.write(bytes, 0, bytesRead);
                    bytesRead = inputStream.read(bytes);
                }
                zipOutputStream.flush();
                zipOutputStream.closeEntry();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }
}

