/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.liferay.poshi.core.util.StringUtil;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import jodd.util.Base32;

public class AuthenticationUtil {
    private static final String _ALGORITHM_HMAC_SHA1 = "HmacSHA1";
    private static final int _DIGITS_TIME_BASED_OTP = 6;

    public static String generateTimeBasedOTP(String secretKey) {
        long time = (System.currentTimeMillis() - 3000L) / 30000L;
        String timeCountHex = StringUtil.toUpperCase((String)Long.toHexString(time));
        if (timeCountHex.length() > 16) {
            return timeCountHex;
        }
        timeCountHex = StringUtil.replace((String)String.format("%16s", timeCountHex), (char)' ', (char)'0');
        try {
            Mac mac = Mac.getInstance(_ALGORITHM_HMAC_SHA1);
            mac.init(new SecretKeySpec(Base32.decode((String)secretKey), "RAW"));
            BigInteger bigInteger = new BigInteger("10" + timeCountHex, 16);
            byte[] byteArray = bigInteger.toByteArray();
            byte[] hash = mac.doFinal(Arrays.copyOfRange(byteArray, 1, byteArray.length));
            int offset = hash[hash.length - 1] & 0xF;
            int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
            int timeBasedOTP = binary % (int)Math.pow(10.0, 6.0);
            return String.format("%06d", timeBasedOTP);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid secret key for algorithm HmacSHA1", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("Invalid algorithm HmacSHA1", noSuchAlgorithmException);
        }
    }
}

