/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    public static String format(String dateString, String oldPattern, String newPattern) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(oldPattern);
        Date date = simpleDateFormat.parse(dateString);
        simpleDateFormat.applyPattern(newPattern);
        return simpleDateFormat.format(date);
    }

    public static String getCurrentDate() {
        return DateUtil.getFormattedCurrentDate("d");
    }

    public static String getCurrentDayOfWeek() {
        return DateUtil.getFormattedCurrentDate("EEEE");
    }

    public static String getCurrentHour() {
        return DateUtil.getFormattedCurrentDate("K");
    }

    public static String getCurrentMonth() {
        return DateUtil.getFormattedCurrentDate("M");
    }

    public static String getCurrentMonthName() {
        return DateUtil.getFormattedCurrentDate("MMMM");
    }

    public static String getCurrentYear() {
        return DateUtil.getFormattedCurrentDate("yyyy");
    }

    public static String getDate(String offsetDays) {
        return DateUtil.getFormattedDate(offsetDays, "d");
    }

    public static String getDateOffsetByDays(String offset, String pattern) {
        return DateUtil.getFormattedDate(5, Integer.valueOf(offset), pattern);
    }

    public static String getDateOffsetByHours(String offset, String pattern) {
        return DateUtil.getFormattedDate(10, Integer.valueOf(offset), pattern);
    }

    public static String getDateOffsetByMinutes(String offset, String pattern) {
        return DateUtil.getFormattedDate(12, Integer.valueOf(offset), pattern);
    }

    public static String getDateOffsetByMonths(String offset, String pattern) {
        return DateUtil.getFormattedDate(2, Integer.valueOf(offset), pattern);
    }

    public static String getDateOffsetBySeconds(String offset, String pattern) {
        return DateUtil.getFormattedDate(12, Integer.valueOf(offset), pattern);
    }

    public static String getDateOffsetByYears(String offset, String pattern) {
        return DateUtil.getFormattedDate(1, Integer.valueOf(offset), pattern);
    }

    public static String getDayOfWeek(String offsetDays) {
        return DateUtil.getFormattedDate(offsetDays, "EEEE");
    }

    public static String getFormattedCurrentDate(String pattern) {
        return DateUtil._format(new Date(), pattern);
    }

    public static String getFormattedCurrentDate(String pattern, String timeZoneID) {
        return DateUtil._format(new Date(), pattern, timeZoneID);
    }

    public static String getFormattedDate(int field, int offset, String pattern) {
        return DateUtil._format(DateUtil._getOffsetDate(field, offset), pattern);
    }

    public static String getFormattedDate(String offsetDays, String pattern) {
        return DateUtil._format(DateUtil._getOffsetDate(5, Integer.valueOf(offsetDays)), pattern);
    }

    public static String getMonth(String offsetDays) {
        return DateUtil.getFormattedDate(offsetDays, "M");
    }

    public static String getMonthName(String offsetDays) {
        return DateUtil.getFormattedDate(offsetDays, "MMMM");
    }

    public static String getNanoseconds() {
        return String.valueOf(System.nanoTime());
    }

    public static String getTimeInMilliseconds() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String getTimeInMilliseconds(String date, String timeZone) {
        LocalDateTime localDateTime = LocalDateTime.parse(date, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss"));
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.of(timeZone));
        Instant instant = zonedDateTime.toInstant();
        return String.valueOf(instant.toEpochMilli());
    }

    public static String getYear(String offsetDays) {
        return DateUtil.getFormattedDate(offsetDays, "yyyy");
    }

    private static String _format(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    private static String _format(Date date, String pattern, String timeZoneID) {
        ArrayList<String> availableTimeZoneIDs = new ArrayList<String>(Arrays.asList(TimeZone.getAvailableIDs()));
        if (!availableTimeZoneIDs.contains(timeZoneID)) {
            throw new IllegalArgumentException("Invalid time zone ID: " + timeZoneID);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZoneID));
        return simpleDateFormat.format(date);
    }

    private static Date _getOffsetDate(int field, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(field, offset);
        return calendar.getTime();
    }
}

