/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.sun.mail.imap.IMAPFolder;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailCommands {
    private static IMAPFolder _imapFolder;
    private static Session _imapSession;
    private static Session _smtpSession;
    private static Transport _transport;

    public static void connectToEmailAccount(String emailAddress, String emailPassword) throws Exception {
        Properties imapProperties = System.getProperties();
        imapProperties.setProperty("mail.store.protocol", "imaps");
        _imapSession = Session.getInstance((Properties)imapProperties);
        Store store = _imapSession.getStore("imaps");
        store.connect("imap.gmail.com", emailAddress, emailPassword);
        _imapFolder = (IMAPFolder)store.getFolder("Inbox");
        _imapFolder.open(2);
        Properties smtpProperties = System.getProperties();
        smtpProperties.put("mail.smtp.auth", "true");
        smtpProperties.put("mail.smtp.host", "smtp.gmail.com");
        smtpProperties.put("mail.smtp.password", emailPassword);
        smtpProperties.put("mail.smtp.port", "587");
        smtpProperties.put("mail.smtp.starttls.enable", "true");
        smtpProperties.put("mail.smtp.user", emailAddress);
        _smtpSession = Session.getDefaultInstance((Properties)smtpProperties);
        _transport = _smtpSession.getTransport("smtp");
        _transport.connect("smtp.gmail.com", emailAddress, emailPassword);
    }

    public static void deleteAllEmails() throws Exception {
        Message[] messages;
        for (Message message : messages = _imapFolder.getMessages()) {
            message.setFlag(Flags.Flag.DELETED, true);
        }
        _imapFolder.close(true);
    }

    public static String getEmailBody(int index) throws Exception {
        Message message = _imapFolder.getMessage(index);
        String body = (String)message.getContent();
        return body.trim();
    }

    public static String getEmailSubject(int index) throws Exception {
        Message message = _imapFolder.getMessage(index);
        return message.getSubject();
    }

    public static void replyToEmail(String to, String body) throws Exception {
        Message message = _imapFolder.getMessage(1);
        Message replyMessage = message.reply(false);
        replyMessage.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(to));
        replyMessage.setText(body);
        _transport.sendMessage(replyMessage, replyMessage.getRecipients(MimeMessage.RecipientType.TO));
        _transport.close();
    }

    public static void sendEmail(String to, String subject, String body) throws Exception {
        MimeMessage message = new MimeMessage(_smtpSession);
        message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(to));
        message.setSubject(subject);
        message.setText(body);
        message.saveChanges();
        _transport.sendMessage((Message)message, message.getAllRecipients());
        _transport.close();
    }
}

