/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.runner.util.BufferedProcess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;

public class ExecUtil {
    private static final long _BASH_COMMAND_TIMEOUT_DEFAULT = 3600000L;
    private static long _timeoutDuration = 15L;

    public static String executeCommand(String command) throws IOException, TimeoutException {
        Process process = ExecUtil.executeCommands(true, new File("."), 60000L * _timeoutDuration, command);
        if (process.exitValue() != 0) {
            return ExecUtil.readInputStream(process.getErrorStream(), true);
        }
        return ExecUtil.readInputStream(process.getInputStream(), true);
    }

    public static Process executeCommands(boolean exitOnFirstFail, File baseDir, long timeout, String ... commands) throws IOException, TimeoutException {
        System.out.print("Executing commands: ");
        for (String command : commands) {
            System.out.println(command);
        }
        String commandTerminator = ";";
        if (exitOnFirstFail) {
            commandTerminator = "&&";
        }
        StringBuffer sb = new StringBuffer();
        for (String command : commands) {
            sb.append(command);
            sb.append(" ");
            sb.append(commandTerminator);
            sb.append(" ");
        }
        sb.append("echo Finished executing commands.\n");
        String[] bashCommands = new String[3];
        if (OSDetector.isWindows()) {
            bashCommands[0] = "CMD";
            bashCommands[1] = "/C";
        } else {
            bashCommands[0] = "/bin/sh";
            bashCommands[1] = "-c";
        }
        bashCommands[2] = sb.toString();
        ProcessBuilder processBuilder = new ProcessBuilder(bashCommands);
        processBuilder.directory(baseDir.getAbsoluteFile());
        BufferedProcess process = new BufferedProcess(2000000, processBuilder.start());
        long duration = 0L;
        int returnCode = -1;
        long start = System.currentTimeMillis();
        while (true) {
            try {
                returnCode = ((Process)process).exitValue();
                if (returnCode != 0) break;
                String standardOut = ExecUtil.readInputStream(((Process)process).getInputStream(), true);
                duration = System.currentTimeMillis() - start;
                while (!standardOut.contains("Finished executing commands.") && duration < timeout) {
                    ExecUtil.sleep(10L);
                    standardOut = ExecUtil.readInputStream(((Process)process).getInputStream(), true);
                    duration = System.currentTimeMillis() - start;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                duration = System.currentTimeMillis() - start;
                if (duration >= timeout) {
                    System.out.print("Timeout occurred while executing commands: " + Arrays.toString(commands));
                    throw illegalThreadStateException;
                }
                ExecUtil.sleep(100L);
                continue;
            }
            break;
        }
        return process;
    }

    public static Process executeCommands(boolean exitOnFirstFail, String ... commands) throws IOException, TimeoutException {
        return ExecUtil.executeCommands(exitOnFirstFail, new File("."), 3600000L, commands);
    }

    public static Process executeCommands(String ... commands) throws IOException, TimeoutException {
        return ExecUtil.executeCommands(true, new File("."), 3600000L, commands);
    }

    public static String executeScript(String filePath) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        String line = null;
        File file = new File(filePath);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((line = bufferedReader.readLine()) != null) {
            commands.add(line);
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (String command : commands) {
                sb.append(ExecUtil.executeCommand(command));
            }
        }
        catch (IOException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
        return sb.toString();
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        return ExecUtil.readInputStream(inputStream, false);
    }

    public static String readInputStream(InputStream inputStream, boolean resetAfterReading) throws IOException {
        if (resetAfterReading && !inputStream.markSupported()) {
            Class<?> inputStreamClass = inputStream.getClass();
            System.out.println("Unable to reset after reading input stream " + inputStreamClass.getName());
        }
        if (resetAfterReading && inputStream.markSupported()) {
            inputStream.mark(Integer.MAX_VALUE);
        }
        StringBuffer sb = new StringBuffer();
        byte[] bytes = new byte[1024];
        int size = inputStream.read(bytes);
        while (size > 0) {
            sb.append(new String(Arrays.copyOf(bytes, size)));
            size = inputStream.read(bytes);
        }
        if (resetAfterReading && inputStream.markSupported()) {
            inputStream.reset();
        }
        return sb.toString();
    }

    public static void setTimeoutDuration(String timeoutDuration) {
        Long timeoutDurationLong = GetterUtil.getLong((String)timeoutDuration);
        _timeoutDuration = timeoutDurationLong;
    }

    public static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }
}

