/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.runner.util.ExecUtil;
import com.liferay.poshi.runner.util.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jodd.util.Base64;

public class HttpRequestUtil {
    private static final Integer _MAX_RETRIES_DEFAULT = 3;
    private static final Integer _RETRY_PERIOD_DEFAULT = 5;
    private static final Integer _TIMEOUT_DEFAULT = 0;

    public static Map<String, String> addRequestHeaders(Map<String, String> requestHeaders, String header) {
        int i;
        if (requestHeaders == null) {
            requestHeaders = new HashMap<String, String>();
        }
        if ((i = header.indexOf("=")) == -1) {
            throw new IllegalArgumentException("Invalid header: " + header);
        }
        String key = header.substring(0, i);
        String value = header.substring(i + 1);
        requestHeaders.put(key, value);
        return requestHeaders;
    }

    public static HttpResponse get(HttpAuthorization httpAuthorizationHeader, Integer maxRetries, Map<String, String> requestHeaders, Integer retryPeriod, Integer timeout, String url) throws IOException {
        return HttpRequestUtil.request(httpAuthorizationHeader, maxRetries, null, requestHeaders, "GET", retryPeriod, timeout, url);
    }

    public static HttpResponse get(HttpAuthorization httpAuthorizationHeader, Map<String, String> requestHeaders, String url) throws IOException {
        return HttpRequestUtil.request(httpAuthorizationHeader, _MAX_RETRIES_DEFAULT, null, requestHeaders, "GET", _RETRY_PERIOD_DEFAULT, _TIMEOUT_DEFAULT, url);
    }

    public static HttpAuthorization getHttpAuthorization(String type, String value) {
        if (type.equals("basic")) {
            String[] tokens = value.split(":");
            return new BasicHttpAuthorization(tokens[0], tokens[1]);
        }
        if (type.equals("token")) {
            return new TokenHttpAuthorization(value);
        }
        throw new IllegalArgumentException("Unsupported authorization type: " + type);
    }

    public static String getResponseBody(HttpResponse httpResponse) {
        return httpResponse.getResponseBody();
    }

    public static String getResponseErrorMessage(HttpResponse httpResponse) {
        return httpResponse.getResponseErrorMessage();
    }

    public static String getStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpResponse request(HttpAuthorization httpAuthorizationHeader, Integer maxRetries, String requestBody, Map<String, String> requestHeaders, String requestMethod, Integer retryPeriod, Integer timeout, String url) throws IOException {
        url = HttpRequestUtil._fixURL(url);
        int retryCount = 0;
        while (true) {
            try {
                int responseCode;
                System.out.println("Generating HTTP request for URL: " + url);
                URL urlObject = new URL(url);
                URLConnection urlConnection = urlObject.openConnection();
                if (!(urlConnection instanceof HttpURLConnection)) {
                    throw new IllegalArgumentException("Connection must be of type HTTP");
                }
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                System.out.println("Setting request method: " + requestMethod);
                httpURLConnection.setRequestMethod(requestMethod);
                if (httpAuthorizationHeader != null) {
                    System.out.println("Setting authorization: " + httpAuthorizationHeader);
                    httpURLConnection.setRequestProperty("Authorization", httpAuthorizationHeader.toString());
                }
                if (requestHeaders != null) {
                    for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                        System.out.println("Setting request header key \"" + entry.getKey() + "\" with value \"" + entry.getValue() + "\"");
                        httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                if (requestBody != null) {
                    if (requestMethod.equals("GET")) {
                        throw new IllegalArgumentException("Request method 'GET' cannot have a request body");
                    }
                    System.out.println("Setting request body: " + requestBody);
                    if (requestHeaders != null && requestHeaders.containsKey("Content-Type")) {
                        String contentType = requestHeaders.get("Content-Type");
                        if (contentType.equals("application/json")) {
                            JSONUtil.toJSONObject(requestBody);
                        }
                    } else {
                        requestBody = URLEncoder.encode(requestBody, "UTF-8");
                    }
                    httpURLConnection.setDoOutput(true);
                    Throwable throwable = null;
                    try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                        outputStream.write(requestBody.getBytes("UTF-8"));
                        outputStream.flush();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                if (timeout != 0) {
                    urlConnection.setConnectTimeout(timeout);
                    urlConnection.setReadTimeout(timeout);
                }
                if ((responseCode = httpURLConnection.getResponseCode()) >= 200 && responseCode <= 399) {
                    try (InputStream inputStream = httpURLConnection.getInputStream();){
                        String body = HttpRequestUtil._readInputStream(inputStream, false);
                        HttpResponse httpResponse = new HttpResponse(body, null, responseCode);
                        return httpResponse;
                    }
                }
                try (InputStream inputStream = httpURLConnection.getErrorStream();){
                    String errorMessage = HttpRequestUtil._readInputStream(inputStream, false);
                    HttpResponse httpResponse = new HttpResponse(null, errorMessage, responseCode);
                    return httpResponse;
                }
            }
            catch (IOException ioException) {
                if (maxRetries >= 0 && ++retryCount >= maxRetries) {
                    throw ioException;
                }
                System.out.println("Retrying " + url + " in " + retryPeriod + " seconds");
                ExecUtil.sleep(1000 * retryPeriod);
                continue;
            }
            break;
        }
    }

    public static HttpResponse request(HttpAuthorization httpAuthorizationHeader, String requestBody, Map<String, String> requestHeaders, String requestMethod, String url) throws IOException {
        return HttpRequestUtil.request(httpAuthorizationHeader, _MAX_RETRIES_DEFAULT, requestBody, requestHeaders, requestMethod, _RETRY_PERIOD_DEFAULT, _TIMEOUT_DEFAULT, url);
    }

    private static String _fixURL(String url) {
        url = StringUtil.replace((String)url, (String)" ", (String)"%20");
        url = StringUtil.replace((String)url, (String)"#", (String)"%23");
        url = StringUtil.replace((String)url, (String)"(", (String)"%28");
        url = StringUtil.replace((String)url, (String)")", (String)"%29");
        url = StringUtil.replace((String)url, (String)"[", (String)"%5B");
        url = StringUtil.replace((String)url, (String)"]", (String)"%5D");
        return url;
    }

    private static String _readInputStream(InputStream inputStream, boolean resetAfterReading) throws IOException {
        if (resetAfterReading && !inputStream.markSupported()) {
            Class<?> inputStreamClass = inputStream.getClass();
            System.out.println("Unable to reset after reading input stream " + inputStreamClass.getName());
        }
        if (resetAfterReading && inputStream.markSupported()) {
            inputStream.mark(Integer.MAX_VALUE);
        }
        StringBuffer sb = new StringBuffer();
        byte[] bytes = new byte[1024];
        int size = inputStream.read(bytes);
        while (size > 0) {
            sb.append(new String(Arrays.copyOf(bytes, size)));
            size = inputStream.read(bytes);
        }
        if (resetAfterReading && inputStream.markSupported()) {
            inputStream.reset();
        }
        return sb.toString();
    }

    public static class TokenHttpAuthorization
    extends HttpAuthorization {
        protected String token;

        public TokenHttpAuthorization(String token) {
            super(HttpAuthorization.Type.TOKEN);
            this.token = token;
        }

        public String toString() {
            return StringUtil.combine((String[])new String[]{"token ", this.token});
        }
    }

    public static class HttpResponse {
        protected String body;
        protected String errorMessage;
        protected String statusCode;

        public HttpResponse(String body, String errorMessage, int statusCode) {
            this.body = body;
            this.errorMessage = errorMessage;
            this.statusCode = String.valueOf(statusCode);
        }

        public String getResponseBody() {
            return this.body;
        }

        public String getResponseErrorMessage() {
            return this.errorMessage;
        }

        public String getStatusCode() {
            return this.statusCode;
        }
    }

    public static abstract class HttpAuthorization {
        protected Type type;

        public Type getType() {
            return this.type;
        }

        protected HttpAuthorization(Type type) {
            this.type = type;
        }

        public static enum Type {
            BASIC,
            TOKEN;

        }
    }

    public static class BasicHttpAuthorization
    extends HttpAuthorization {
        protected String password;
        protected String userName;

        public BasicHttpAuthorization(String password, String userName) {
            super(HttpAuthorization.Type.BASIC);
            this.password = password;
            this.userName = userName;
        }

        public String toString() {
            String authorization = StringUtil.combine((String[])new String[]{this.userName, ":", this.password});
            return StringUtil.combine((String[])new String[]{"Basic ", Base64.encodeToString((byte[])authorization.getBytes())});
        }
    }
}

