/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.runner.util.ExecUtil;
import com.liferay.poshi.runner.util.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONCurlUtil {
    public static String delete(String requestString) throws IOException, TimeoutException {
        Request request = new Request(requestString, "DELETE");
        return request.send();
    }

    public static String delete(String requestString, String jsonPath) throws IOException, TimeoutException {
        Request request = new Request(requestString, "DELETE");
        return JSONCurlUtil._getParsedResponse(request, jsonPath);
    }

    public static String get(String requestString) throws IOException, TimeoutException {
        Request request = new Request(requestString, "GET");
        return request.send();
    }

    public static String get(String requestString, String jsonPath) throws IOException, TimeoutException {
        Request request = new Request(requestString, "GET");
        return JSONCurlUtil._getParsedResponse(request, jsonPath);
    }

    public static String head(String requestString) throws IOException, TimeoutException {
        Request request = new Request(requestString, "HEAD");
        return request.send();
    }

    public static String head(String requestString, String jsonPath) throws IOException, TimeoutException {
        Request request = new Request(requestString, "HEAD");
        return JSONCurlUtil._getParsedResponse(request, jsonPath);
    }

    public static String patch(String requestString) throws IOException, TimeoutException {
        Request request = new Request(requestString, "PATCH");
        return request.send();
    }

    public static String patch(String requestString, String jsonPath) throws IOException, TimeoutException {
        Request request = new Request(requestString, "PATCH");
        return JSONCurlUtil._getParsedResponse(request, jsonPath);
    }

    public static String post(String requestString) throws IOException, TimeoutException {
        Request request = new Request(requestString, "POST");
        return request.send();
    }

    public static String post(String requestString, String jsonPath) throws IOException, TimeoutException {
        Request request = new Request(requestString, "POST");
        return JSONCurlUtil._getParsedResponse(request, jsonPath);
    }

    public static String put(String requestString) throws IOException, TimeoutException {
        Request request = new Request(requestString, "PUT");
        return request.send();
    }

    public static String put(String requestString, String jsonPath) throws IOException, TimeoutException {
        Request request = new Request(requestString, "PUT");
        return JSONCurlUtil._getParsedResponse(request, jsonPath);
    }

    private static String _getParsedResponse(Request request, String jsonPath) throws IOException, TimeoutException {
        String response = request.send();
        return JSONUtil.getWithJSONPath(response, jsonPath);
    }

    private static class RequestOption {
        private static Map<String, String> _customOptionsMap = new HashMap<String, String>(){
            {
                this.put("--json-data", "--data");
            }
        };
        private final String _optionType;
        private final String _optionValue;

        public RequestOption(String optionType, String optionValue) {
            this._optionType = optionType;
            this._optionValue = this._formatOptionValue(optionType, optionValue);
        }

        public String getRequestOptionType() {
            if (_customOptionsMap.containsKey(this._optionType)) {
                return _customOptionsMap.get(this._optionType);
            }
            return this._optionType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getRequestOptionType());
            if (!this._optionValue.isEmpty()) {
                sb.append(" ");
                sb.append(this._escapeOptionValue(this._optionValue));
            }
            return sb.toString();
        }

        private String _escapeOptionValue(String optionValue) {
            StringBuilder sb = new StringBuilder();
            if (OSDetector.isWindows()) {
                if (this._isValidJSON(optionValue)) {
                    optionValue = String.valueOf(new JSONObject(optionValue));
                }
                sb.append("\"");
                optionValue = optionValue.replaceAll("\\\\\"", "\\\\\\\\\\\\\\\"");
                optionValue = optionValue.replaceAll("(?<!\\\\)\"", "\\\\\\\"");
                optionValue = StringUtil.replace((String)optionValue, (String)"&", (String)"^&");
                sb.append(optionValue);
                sb.append("\"");
            } else {
                sb.append("'");
                sb.append(optionValue);
                sb.append("'");
            }
            return sb.toString();
        }

        private String _formatOptionValue(String optionType, String optionValue) {
            if ((optionValue = optionValue.trim()).startsWith("'") && optionValue.endsWith("'") || optionValue.startsWith("\"") && optionValue.endsWith("\"")) {
                optionValue = optionValue.substring(1, optionValue.length() - 1);
            }
            if (optionType.equals("--json-data")) {
                try {
                    optionValue = String.valueOf(new JSONObject(optionValue));
                }
                catch (JSONException jsonException) {
                    throw new RuntimeException("Invalid JSON: '" + optionValue + "'");
                }
            }
            return optionValue;
        }

        private boolean _isValidJSON(String jsonTestString) {
            try {
                new JSONObject(jsonTestString);
                return true;
            }
            catch (JSONException jsonException) {
                return false;
            }
        }
    }

    private static class Request {
        private static Pattern _escapePattern = Pattern.compile("<CURL_DATA\\[([\\s\\S]*?)\\]CURL_DATA>");
        private static Pattern _requestPattern = Pattern.compile("(-[\\w#:\\.]|--[\\w#:\\.-]{2,}|(?:[\\s]|^)(?:file|https?):[^\\s]+)(\\s+|\\Z)");
        private Map<String, String> _curlDataMap = new HashMap<String, String>();
        private final int _maxPrintLineLength = 2500;
        private final String _requestMethod;
        private List<RequestOption> _requestOptions = new ArrayList<RequestOption>();
        private final String _requestURL;

        public Request(String requestString, String requestMethod) {
            this._requestMethod = requestMethod;
            requestString = requestString.replaceAll("\\s+\\\\?\\s*\\n", " ");
            requestString = this._encodeCurlData(requestString);
            List<String> tokens = this._tokenize(requestString.trim());
            this._requestURL = this._getRequestURL(tokens);
            tokens.remove(this._requestURL);
            this._setRequestOptions(tokens);
        }

        public String send() throws IOException, TimeoutException {
            StringBuilder sb = new StringBuilder();
            sb.append("curl -X ");
            sb.append(this._requestMethod);
            sb.append(" ");
            sb.append(this._getRequestOptionsString());
            sb.append(" ");
            sb.append(this._requestURL);
            Process process = ExecUtil.executeCommands(true, new File("."), 900000L, sb.toString());
            InputStream inputStream = process.getInputStream();
            String response = ExecUtil.readInputStream(inputStream, true);
            this._log(response);
            if (process.exitValue() != 0) {
                inputStream = process.getErrorStream();
                String errorString = ExecUtil.readInputStream(inputStream, true);
                this._log(errorString);
                throw new RuntimeException("Command finished with exit value: " + process.exitValue());
            }
            return response.replaceAll("\\\\r\\\\n|\\\\n|\\\\r", "%0A");
        }

        private String _encodeCurlData(String requestString) {
            Matcher matcher = _escapePattern.matcher(requestString);
            String encodedRequestString = requestString;
            while (matcher.find()) {
                String key = "$CURLDATA:" + StringUtil.randomString((String)"10");
                this._curlDataMap.put(key, matcher.group(1));
                encodedRequestString = StringUtil.replace((String)encodedRequestString, (String)matcher.group(0), (String)key);
            }
            return encodedRequestString;
        }

        private String _getRequestOptionsString() {
            return StringUtils.join(this._requestOptions, (String)" ");
        }

        private String _getRequestURL(List<String> tokens) {
            String token = tokens.get(0);
            if (token.startsWith("file") || token.startsWith("http")) {
                return token;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("The curl URL must be the first argument of the ");
            sb.append("request string.\n'");
            sb.append(token);
            sb.append("' is an invalid URL.");
            throw new IllegalArgumentException(sb.toString());
        }

        private void _log(String message) {
            if (message == null) {
                message = "";
            }
            if (message.length() > 2500) {
                System.out.println(message.substring(0, 2500) + "...");
                return;
            }
            System.out.println(message);
        }

        private void _setRequestOptions(List<String> tokens) {
            for (int i = 0; i < tokens.size(); ++i) {
                String nextToken;
                String optionType = tokens.get(i);
                Matcher optionTypeMatcher = _requestPattern.matcher(optionType);
                if (!optionTypeMatcher.matches()) continue;
                String optionValue = "";
                if (i < tokens.size() - 1 && !(optionTypeMatcher = _requestPattern.matcher(nextToken = tokens.get(i + 1))).matches()) {
                    if (nextToken.matches("\\$CURLDATA:\\w{10}")) {
                        nextToken = this._curlDataMap.get(nextToken);
                    }
                    optionValue = nextToken;
                    ++i;
                }
                this._requestOptions.add(new RequestOption(optionType, optionValue));
            }
        }

        private List<String> _tokenize(String requestString) {
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher matcher = _requestPattern.matcher(requestString);
            int end = -1;
            int start = -1;
            while (matcher.find()) {
                if (!tokens.isEmpty() && (end = matcher.start()) - start > 1) {
                    String miscellaneousToken = requestString.substring(start, end);
                    tokens.add(miscellaneousToken.trim());
                }
                String token = matcher.group(1);
                tokens.add(token.trim());
                start = matcher.end();
            }
            if (start != requestString.length()) {
                tokens.add(requestString.substring(start));
            }
            return tokens;
        }
    }
}

