/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.liferay.poshi.core.util.ListUtil;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtil {
    public static void assertEquals(JSONObject jsonObject1, JSONObject jsonObject2) throws Exception {
        if (!JSONUtil.equals(jsonObject1, jsonObject2)) {
            throw new RuntimeException("JSON object \n" + jsonObject1.toString() + "\n is not equal to \n" + jsonObject2);
        }
    }

    public static void assertSimilar(JSONObject jsonObject1, JSONObject jsonObject2) throws Exception {
        if (!JSONUtil.similar(jsonObject1, jsonObject2)) {
            throw new RuntimeException("JSON object \n" + jsonObject1.toString() + "\n is not similar to \n" + jsonObject2);
        }
    }

    public static boolean equals(JSONObject jsonObject1, JSONObject jsonObject2) {
        return jsonObject1.equals(jsonObject2);
    }

    public static String formatJSONString(String json) {
        JSONObject jsonObject = JSONUtil.toJSONObject(json);
        return jsonObject.toString();
    }

    public static Object get(JSONObject jsonObject, String name) throws Exception {
        return jsonObject.opt(name);
    }

    public static boolean getBoolean(JSONObject jsonObject, String name) throws Exception {
        return jsonObject.optBoolean(name);
    }

    public static double getDouble(JSONObject jsonObject, String name) throws Exception {
        return jsonObject.optDouble(name);
    }

    public static int getInt(JSONObject jsonObject, String name) throws Exception {
        return jsonObject.optInt(name);
    }

    public static JSONArray getJSONArray(JSONObject jsonObject, String name) throws Exception {
        return jsonObject.optJSONArray(name);
    }

    public static JSONObject getJSONObject(JSONObject jsonObject, String name) throws Exception {
        return jsonObject.optJSONObject(name);
    }

    public static long getLong(JSONObject jsonObject, String name) throws Exception {
        return jsonObject.optLong(name);
    }

    public static String getString(JSONObject jsonObject, String name) throws Exception {
        return jsonObject.optString(name);
    }

    public static String getWithJSONPath(String jsonString, String jsonPath) {
        return JSONUtil.getWithJSONPath(jsonString, jsonPath, "true");
    }

    public static String getWithJSONPath(String jsonString, String jsonPath, String format) {
        DocumentContext documentContext = JsonPath.parse((String)jsonString);
        Object object = documentContext.read(jsonPath, new Predicate[0]);
        if (object == null) {
            throw new RuntimeException("Invalid JSON path " + jsonPath + " in " + jsonString);
        }
        if (Boolean.parseBoolean(format) && object instanceof List) {
            List list = (List)object;
            return ListUtil.toString((List)list);
        }
        return object.toString();
    }

    public static boolean similar(JSONObject jsonObject1, JSONObject jsonObject2) {
        return jsonObject1.similar((Object)jsonObject2);
    }

    public static JSONArray toJSONArray(String json) {
        try {
            return new JSONArray(json);
        }
        catch (JSONException jsonException) {
            throw new RuntimeException("Invalid JSON: '" + json + "'");
        }
    }

    public static JSONObject toJSONObject(String json) {
        try {
            return new JSONObject(json);
        }
        catch (JSONException jsonException) {
            throw new RuntimeException("Invalid JSON: '" + json + "'");
        }
    }
}

