/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util;

import com.liferay.poshi.core.util.PoshiProperties;
import com.liferay.poshi.runner.util.JSONUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.proxy.CaptureType;
import org.openqa.selenium.Proxy;

public class ProxyUtil {
    private static final ProxyUtil _proxyUtil = new ProxyUtil();
    private BrowserMobProxy _browserMobProxy;

    public static String getHarRecording(String jsonPath) throws IOException {
        BrowserMobProxy browserMobProxy = ProxyUtil.getBrowserMobProxy();
        Har har = browserMobProxy.getHar();
        StringWriter stringWriter = new StringWriter();
        har.writeTo((Writer)stringWriter);
        String harString = stringWriter.toString();
        return JSONUtil.getWithJSONPath(harString, jsonPath);
    }

    public static Proxy getSeleniumProxy() {
        return _proxyUtil._getSeleniumProxy();
    }

    public static void startHarRecording(String harName) {
        BrowserMobProxy browserMobProxy = ProxyUtil.getBrowserMobProxy();
        browserMobProxy.newHar(harName);
    }

    public static void stopBrowserMobProxy() {
        _proxyUtil._stopBrowserMobProxy();
    }

    public static void stopHarRecording() {
        BrowserMobProxy browserMobProxy = ProxyUtil.getBrowserMobProxy();
        browserMobProxy.endHar();
    }

    protected static BrowserMobProxy getBrowserMobProxy() {
        return _proxyUtil._getBrowserMobProxy();
    }

    private BrowserMobProxy _getBrowserMobProxy() {
        if (this._browserMobProxy == null) {
            this._startBrowserMobProxy();
        }
        return this._browserMobProxy;
    }

    private Proxy _getSeleniumProxy() {
        if (this._browserMobProxy == null) {
            this._startBrowserMobProxy();
        }
        Proxy seleniumProxy = ClientUtil.createSeleniumProxy((BrowserMobProxy)this._browserMobProxy);
        try {
            InetAddress inetAddress = Inet4Address.getLocalHost();
            String hostIPAddress = inetAddress.getHostAddress();
            seleniumProxy.setHttpProxy(hostIPAddress + ":" + this._browserMobProxy.getPort());
            seleniumProxy.setSslProxy(hostIPAddress + ":" + this._browserMobProxy.getPort());
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
        return seleniumProxy;
    }

    private void _startBrowserMobProxy() {
        this._browserMobProxy = new BrowserMobProxyServer();
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        this._browserMobProxy.start(poshiProperties.proxyServerPort);
        System.out.println("Started BrowserMob Proxy.");
        this._browserMobProxy.enableHarCaptureTypes(new CaptureType[]{CaptureType.REQUEST_CONTENT, CaptureType.RESPONSE_CONTENT});
    }

    private void _stopBrowserMobProxy() {
        if (this._browserMobProxy != null) {
            this._browserMobProxy.stop();
            System.out.println("Stopped BrowserMob Proxy.");
        }
        this._browserMobProxy = null;
    }
}

