/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util.oauth;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.github.scribejava.core.oauth.OAuthService;
import com.liferay.poshi.runner.util.oauth.OAuth10aAPIImpl;

public class OAuth10aUtil {
    public static String createRequest(String accessTokenEndpoint, String accessTokenString, String accessTokenSecret, String apiKey, String apiSecret, String authorizationURL, String requestTokenEndpoint, String requestURL) throws Exception {
        ServiceBuilder serviceBuilder = new ServiceBuilder();
        serviceBuilder.apiKey(apiKey);
        serviceBuilder.apiSecret(apiSecret);
        OAuth10aService oAuthService = (OAuth10aService)serviceBuilder.build((BaseApi)new OAuth10aAPIImpl(accessTokenEndpoint, authorizationURL, requestTokenEndpoint));
        OAuth1AccessToken oAuth1AccessToken = new OAuth1AccessToken(accessTokenString, accessTokenSecret);
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, requestURL, (OAuthService)oAuthService);
        oAuthService.signRequest(oAuth1AccessToken, (AbstractRequest)oAuthRequest);
        Response response = oAuthRequest.send();
        if (!response.isSuccessful()) {
            throw new Exception("Response is not successful");
        }
        return response.getBody();
    }

    public static byte[] tokenToByteArray(String token) {
        token = token.substring(1, token.length() - 1);
        String[] tokenParts = token.split(",");
        byte[] bytes = new byte[tokenParts.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = Byte.parseByte(tokenParts[i].trim());
        }
        return bytes;
    }
}

