/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.util.oauth;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.liferay.poshi.runner.util.oauth.OAuth20APIImpl;

public class OAuth20Util {
    public static String createRequest(String accessTokenEndpoint, String accessTokenString, String apiKey, String apiSecret, String authorizationBaseURL, String callbackURL, String requestURL) throws Exception {
        ServiceBuilder serviceBuilder = new ServiceBuilder();
        serviceBuilder.apiKey(apiKey);
        serviceBuilder.apiSecret(apiSecret);
        serviceBuilder.callback(callbackURL);
        OAuth20Service oAuth20Service = (OAuth20Service)serviceBuilder.build((BaseApi)new OAuth20APIImpl(accessTokenEndpoint, authorizationBaseURL));
        OAuth2AccessToken oAuth2AccessToken = new OAuth2AccessToken(accessTokenString);
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, requestURL, (OAuthService)oAuth20Service);
        oAuth20Service.signRequest(oAuth2AccessToken, (AbstractRequest)oAuthRequest);
        Response response = oAuthRequest.send();
        if (!response.isSuccessful()) {
            throw new Exception("Response is not successful");
        }
        return response.getBody();
    }
}

