/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.var.type;

import com.liferay.poshi.runner.var.type.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultTable
implements Table {
    private static final Pattern _entryPattern = Pattern.compile("(?<entry>.*?)\\|");
    private static final Pattern _rowPattern = Pattern.compile("\\|(?<row>.*\\|)(\\s*\\R)*");
    private boolean _hasColumnNames;
    private boolean _hasRowNames;
    private List<List<String>> _rows;

    public DefaultTable(List<List<String>> rows) {
        this(rows, false, false);
    }

    public DefaultTable(List<List<String>> rows, boolean hasRowNames, boolean hasColumnNames) {
        if (hasColumnNames && hasRowNames) {
            throw new IllegalArgumentException("Table must contain either row names or column names");
        }
        this._rows = rows;
        this._hasRowNames = hasRowNames;
        this._hasColumnNames = hasColumnNames;
    }

    public DefaultTable(String rawTableString) {
        this(DefaultTable._parse(rawTableString), false, false);
    }

    public DefaultTable(String rawTableString, boolean hasRowNames, boolean hasColumnNames) {
        this(DefaultTable._parse(rawTableString), hasRowNames, hasColumnNames);
    }

    @Override
    public List<String> getColumnByIndex(int index) {
        ArrayList<String> columnCellValues = new ArrayList<String>();
        for (List<String> row : this._rows) {
            columnCellValues.add(row.get(index));
        }
        return columnCellValues;
    }

    @Override
    public List<String> getColumnByName(String columnName) {
        if (this._hasColumnNames) {
            List<String> columnNames = this._rows.get(0);
            if (!columnNames.contains(columnName)) {
                throw new RuntimeException("Table does not contain column name: " + columnName);
            }
            int columnIndex = columnNames.indexOf(columnName);
            return this._getListWithoutTitle(this.getColumnByIndex(columnIndex), columnName);
        }
        throw new RuntimeException("Table does not contain column names");
    }

    @Override
    public List<String> getRowByIndex(int index) {
        return this._rows.get(index);
    }

    @Override
    public List<String> getRowByName(String rowName) {
        if (this._hasRowNames) {
            int index = 0;
            for (List<String> row : this._rows) {
                if (rowName.equals(row.get(0))) {
                    return this._getListWithoutTitle(this.getRowByIndex(index), rowName);
                }
                ++index;
            }
            throw new RuntimeException("Table does not contain row name: " + rowName);
        }
        throw new RuntimeException("Table does not contain row names");
    }

    public List<List<String>> getRows() {
        return this._rows;
    }

    @Override
    public int getTableRowWidth(List<List<String>> table) {
        if (table.isEmpty()) {
            return 0;
        }
        List<String> cellValues = table.get(0);
        return cellValues.size();
    }

    @Override
    public int getTableSize() {
        return this._rows.size();
    }

    @Override
    public Table getTransposedTable(List<List<String>> table) {
        ArrayList<List<String>> transposedTable = new ArrayList<List<String>>();
        for (int i = 0; i < this.getTableRowWidth(table); ++i) {
            ArrayList<String> transposedCellValues = new ArrayList<String>();
            for (List<String> cellValues : table) {
                transposedCellValues.add(cellValues.get(i));
            }
            transposedTable.add(transposedCellValues);
        }
        return new DefaultTable(transposedTable);
    }

    private static List<List<String>> _parse(String tableString) {
        Matcher rowMatcher = _rowPattern.matcher(tableString);
        if (!rowMatcher.find()) {
            throw new IllegalArgumentException("Invalid table string:\n" + tableString);
        }
        rowMatcher.reset();
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        while (rowMatcher.find()) {
            String rowValue = rowMatcher.group("row");
            Matcher entryMatcher = _entryPattern.matcher(rowValue);
            ArrayList<String> cellValues = new ArrayList<String>();
            while (entryMatcher.find()) {
                String cellValue = entryMatcher.group("entry");
                cellValues.add(cellValue.trim());
            }
            table.add(cellValues);
        }
        return table;
    }

    private List<String> _getListWithoutTitle(List<String> list, String title) {
        if (title.equals(list.get(0))) {
            ArrayList<String> newList = new ArrayList<String>(list);
            newList.remove(0);
            return newList;
        }
        return list;
    }
}

