/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.runner.var.type;

import com.liferay.poshi.runner.var.type.BaseTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RowsHashTable
extends BaseTable<Map<String, String>> {
    private final List<Map<String, String>> _rowsHashTable = new ArrayList<Map<String, String>>();

    @Override
    public List<Map<String, String>> getTable() {
        return this._rowsHashTable;
    }

    @Override
    public Iterator<Map<String, String>> iterator() {
        return this._rowsHashTable.iterator();
    }

    protected RowsHashTable(List<List<String>> rawData) {
        super(rawData);
        this._verifyRawDataWidth(2);
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
        for (List<String> rawDataRow : rawData) {
            row.put(rawDataRow.get(0), rawDataRow.get(1));
        }
        this._rowsHashTable.add(row);
    }

    private int _getRawDataWidth() {
        if (this.rawData.isEmpty()) {
            return 0;
        }
        List firstRow = (List)this.rawData.get(0);
        return firstRow.size();
    }

    private void _verifyRawDataWidth(int width) {
        if (this._getRawDataWidth() != width) {
            throw new RuntimeException("The raw data must have exactly " + width + " columns");
        }
    }
}

