/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.product.menu.display.context;

import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.PanelCategory;
import com.liferay.application.list.PanelCategoryRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.product.navigation.applications.menu.configuration.ApplicationsMenuInstanceConfiguration;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class ProductMenuDisplayContext {
    private static final String _PORTLET_NAME = "com_liferay_layout_admin_web_portlet_GroupPagesPortlet";
    private static final Log _log = LogFactoryUtil.getLog(ProductMenuDisplayContext.class);
    private List<PanelCategory> _childPanelCategories;
    private Boolean _enableApplicationsMenu;
    private final HttpServletRequest _httpServletRequest;
    private final PanelAppRegistry _panelAppRegistry;
    private final PanelCategoryHelper _panelCategoryHelper;
    private final PanelCategoryRegistry _panelCategoryRegistry;
    private final PortletRequest _portletRequest;
    private final PortletResponse _portletResponse;
    private String _rootPanelCategoryKey;
    private final ThemeDisplay _themeDisplay;

    public ProductMenuDisplayContext(PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._portletRequest);
        this._panelAppRegistry = (PanelAppRegistry)this._portletRequest.getAttribute("PANEL_APP_REGISTRY");
        this._panelCategoryHelper = (PanelCategoryHelper)this._portletRequest.getAttribute("PANEL_CATEGORY_HELPER");
        this._panelCategoryRegistry = (PanelCategoryRegistry)this._portletRequest.getAttribute("PANEL_CATEGORY_REGISTRY");
        this._themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<PanelCategory> getChildPanelCategories() {
        if (this._childPanelCategories != null) {
            return this._childPanelCategories;
        }
        this._childPanelCategories = this._panelCategoryRegistry.getChildPanelCategories("root", this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroup());
        if (this._isEnableApplicationsMenu()) {
            return this._childPanelCategories;
        }
        List applicationsMenuChildPanelCategories = this._panelCategoryRegistry.getChildPanelCategories("applications_menu", this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroup());
        Collections.reverse(applicationsMenuChildPanelCategories);
        this._childPanelCategories.addAll(0, applicationsMenuChildPanelCategories);
        return this._childPanelCategories;
    }

    public int getNotificationsCount(PanelCategory panelCategory) {
        return this._panelCategoryHelper.getNotificationsCount(panelCategory.getKey(), this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroup(), this._themeDisplay.getUser());
    }

    public String getRootPanelCategoryKey() {
        if (this._rootPanelCategoryKey != null) {
            return this._rootPanelCategoryKey;
        }
        this._rootPanelCategoryKey = "";
        List<PanelCategory> childPanelCategories = this.getChildPanelCategories();
        if (!childPanelCategories.isEmpty()) {
            PanelCategory lastChildPanelCategory = childPanelCategories.get(childPanelCategories.size() - 1);
            this._rootPanelCategoryKey = lastChildPanelCategory.getKey();
            if (Validator.isNotNull((String)this._themeDisplay.getPpid())) {
                PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry, this._panelCategoryRegistry);
                for (PanelCategory panelCategory : this._panelCategoryRegistry.getChildPanelCategories("root")) {
                    if (!panelCategoryHelper.containsPortlet(this._themeDisplay.getPpid(), panelCategory.getKey(), this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroup())) continue;
                    this._rootPanelCategoryKey = panelCategory.getKey();
                    return this._rootPanelCategoryKey;
                }
                if (this._isEnableApplicationsMenu()) {
                    return this._rootPanelCategoryKey;
                }
                for (PanelCategory panelCategory : this._panelCategoryRegistry.getChildPanelCategories("applications_menu")) {
                    if (!panelCategoryHelper.containsPortlet(this._themeDisplay.getPpid(), panelCategory.getKey(), this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroup())) continue;
                    this._rootPanelCategoryKey = panelCategory.getKey();
                    return this._rootPanelCategoryKey;
                }
            }
        }
        return this._rootPanelCategoryKey;
    }

    public boolean hasUserPanelCategory() {
        List<PanelCategory> panelCategories = this.getChildPanelCategories();
        for (PanelCategory panelCategory : panelCategories) {
            String panelCategoryKey = panelCategory.getKey();
            if (!panelCategoryKey.equals("user")) continue;
            return true;
        }
        return false;
    }

    public boolean isShowLayoutsTree() {
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)this._httpServletRequest);
        String ppid = ParamUtil.getString((HttpServletRequest)originalHttpServletRequest, (String)"p_p_id");
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)originalHttpServletRequest, (String)(PortalUtil.getPortletNamespace((String)_PORTLET_NAME) + "mvcRenderCommandName"));
        String mvcPath = ParamUtil.getString((HttpServletRequest)originalHttpServletRequest, (String)"mvcPath");
        return !ppid.equals(_PORTLET_NAME) || ppid.equals(_PORTLET_NAME) && Validator.isNotNull((String)mvcRenderCommandName) || ppid.equals(_PORTLET_NAME) && Validator.isNotNull((String)mvcPath);
    }

    public boolean isShowProductMenu() {
        Layout layout = this._themeDisplay.getLayout();
        if (layout.isTypeControlPanel()) {
            return true;
        }
        List<PanelCategory> childPanelCategories = this.getChildPanelCategories();
        return !childPanelCategories.isEmpty();
    }

    private boolean _isEnableApplicationsMenu() {
        if (this._enableApplicationsMenu != null) {
            return this._enableApplicationsMenu;
        }
        this._enableApplicationsMenu = false;
        try {
            ApplicationsMenuInstanceConfiguration applicationsMenuInstanceConfiguration = (ApplicationsMenuInstanceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(ApplicationsMenuInstanceConfiguration.class, (long)this._themeDisplay.getCompanyId());
            this._enableApplicationsMenu = applicationsMenuInstanceConfiguration.enableApplicationsMenu();
            return this._enableApplicationsMenu;
        }
        catch (ConfigurationException configurationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get applications menu instance configuration", (Throwable)configurationException);
            }
            return this._enableApplicationsMenu;
        }
    }
}

