/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.product.menu.internal.helper;

import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.application.list.util.PanelCategoryRegistryUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.product.navigation.applications.menu.configuration.ApplicationsMenuInstanceConfiguration;
import com.liferay.product.navigation.control.menu.manager.ProductNavigationControlMenuManager;
import com.liferay.product.navigation.product.menu.helper.ProductNavigationProductMenuHelper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ProductNavigationProductMenuHelper.class})
public class ProductNavigationProductMenuHelperImpl
implements ProductNavigationProductMenuHelper {
    private static final Log _log = LogFactoryUtil.getLog(ProductNavigationProductMenuHelperImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private PanelAppRegistry _panelAppRegistry;
    @Reference
    private ProductNavigationControlMenuManager _productNavigationControlMenuManager;

    public boolean isShowProductMenu(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isSignedIn() || !this._productNavigationControlMenuManager.isShowControlMenu(httpServletRequest)) {
            return false;
        }
        User user = themeDisplay.getUser();
        if (!themeDisplay.isImpersonated() && !user.isSetupComplete()) {
            return false;
        }
        boolean enableApplicationsMenu = this._isEnableApplicationsMenu(themeDisplay.getCompanyId());
        if (enableApplicationsMenu && this._isApplicationsMenuApp(themeDisplay)) {
            return false;
        }
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (enableApplicationsMenu && scopeGroup.isDepot()) {
            return false;
        }
        List childPanelCategories = PanelCategoryRegistryUtil.getChildPanelCategories((String)"root", (PermissionChecker)themeDisplay.getPermissionChecker(), (Group)themeDisplay.getScopeGroup());
        if (!childPanelCategories.isEmpty()) {
            return true;
        }
        return !this._isEnableApplicationsMenu(themeDisplay.getCompanyId()) && !(childPanelCategories = PanelCategoryRegistryUtil.getChildPanelCategories((String)"applications_menu", (PermissionChecker)themeDisplay.getPermissionChecker(), (Group)themeDisplay.getScopeGroup())).isEmpty();
    }

    private boolean _isApplicationsMenuApp(ThemeDisplay themeDisplay) {
        if (Validator.isNull((String)themeDisplay.getPpid())) {
            return false;
        }
        PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry);
        if (!panelCategoryHelper.isApplicationsMenuApp(themeDisplay.getPpid())) {
            return false;
        }
        Layout layout = themeDisplay.getLayout();
        return layout == null || layout.isTypeControlPanel();
    }

    private boolean _isEnableApplicationsMenu(long companyId) {
        block3: {
            try {
                ApplicationsMenuInstanceConfiguration applicationsMenuInstanceConfiguration = (ApplicationsMenuInstanceConfiguration)this._configurationProvider.getCompanyConfiguration(ApplicationsMenuInstanceConfiguration.class, companyId);
                if (applicationsMenuInstanceConfiguration.enableApplicationsMenu()) {
                    return true;
                }
            }
            catch (ConfigurationException configurationException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)"Unable to get applications menu instance configuration", (Throwable)configurationException);
            }
        }
        return false;
    }
}

