/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.service.builder.internal;

import com.liferay.project.templates.extensions.ProjectTemplateCustomizer;
import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import com.liferay.project.templates.extensions.util.FileUtil;
import com.liferay.project.templates.extensions.util.VersionUtil;
import com.liferay.project.templates.extensions.util.WorkspaceUtil;
import com.liferay.project.templates.service.builder.internal.ServiceBuilderProjectTemplatesArgs;
import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;

public class ServiceBuilderProjectTemplateCustomizer
implements ProjectTemplateCustomizer {
    public String getTemplateName() {
        return "service-builder";
    }

    public void onAfterGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, File destinationDir, ArchetypeGenerationResult archetypeGenerationResult) throws Exception {
        ServiceBuilderProjectTemplatesArgs serviceBuilderProjectTemplatesArgs = (ServiceBuilderProjectTemplatesArgs)projectTemplatesArgs.getProjectTemplatesArgsExt();
        String addOns = serviceBuilderProjectTemplatesArgs.getAddOns();
        Path destinationDirPath = destinationDir.toPath();
        Path projectPath = destinationDirPath.resolve(projectTemplatesArgs.getName());
        File projectDir = projectPath.toFile();
        String artifactId = projectTemplatesArgs.getName();
        if (addOns.equals("false")) {
            File uadDir = new File(projectDir, artifactId + "-uad");
            FileUtil.deleteDir((Path)uadDir.toPath());
        }
        File serviceDir = new File(projectDir, artifactId + "-service");
        File serviceXMLFile = new File(serviceDir, "service.xml");
        String minorVersionString = String.valueOf(VersionUtil.getMinorVersion((String)projectTemplatesArgs.getLiferayVersion()));
        FileUtil.replaceString((File)serviceXMLFile, (String)"7.0", (String)("7." + minorVersionString));
        FileUtil.replaceString((File)serviceXMLFile, (String)"7_0", (String)("7_" + minorVersionString));
    }

    public void onBeforeGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, ArchetypeGenerationRequest archetypeGenerationRequest) throws Exception {
        String artifactId = archetypeGenerationRequest.getArtifactId();
        String apiPath = ":" + artifactId + "-api";
        File destinationDir = new File(archetypeGenerationRequest.getOutputDirectory());
        File workspaceDir = WorkspaceUtil.getWorkspaceDir((File)destinationDir);
        if (workspaceDir != null) {
            Path destinationDirPath = destinationDir.toPath();
            Path workspaceDirPath = workspaceDir.toPath();
            destinationDirPath = destinationDirPath.toAbsolutePath();
            workspaceDirPath = workspaceDirPath.toAbsolutePath();
            String relativePath = String.valueOf(workspaceDirPath.relativize(destinationDirPath));
            apiPath = (relativePath = relativePath.replace(File.separatorChar, ':')).isEmpty() ? ":" + artifactId + apiPath : ":" + relativePath + ":" + artifactId + apiPath;
        }
        Properties properties = archetypeGenerationRequest.getProperties();
        this.setProperty(properties, "apiPath", apiPath);
        ServiceBuilderProjectTemplatesArgs serviceBuilderProjectTemplatesArgs = (ServiceBuilderProjectTemplatesArgs)projectTemplatesArgs.getProjectTemplatesArgsExt();
        String addOns = serviceBuilderProjectTemplatesArgs.getAddOns();
        String liferayVersion = projectTemplatesArgs.getLiferayVersion();
        if (addOns.equals("true") && (liferayVersion.startsWith("7.0") || liferayVersion.startsWith("7.1"))) {
            throw new IllegalArgumentException("Add Ons are not supported in 7.0 or 7.1");
        }
        this.setProperty(properties, "addOns", serviceBuilderProjectTemplatesArgs.getAddOns());
        this.setProperty(properties, "dependencyInjector", serviceBuilderProjectTemplatesArgs.getDependencyInjector());
    }
}

