/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.web.internal.portlet.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.reading.time.calculator.ReadingTimeCalculator;
import com.liferay.reading.time.message.ReadingTimeMessageProvider;
import java.util.Optional;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_reading_time_web_portlet_ReadingTimePortlet", "mvc.command.name=/reading_time/calculate_reading_time"}, service={MVCResourceCommand.class})
public class CalculateReadingTimeMVCResourceCommand
extends BaseMVCResourceCommand {
    @Reference
    private ReadingTimeCalculator _readingTimeCalculator;
    @Reference
    private ReadingTimeMessageProvider _readingTimeMessageProvider;

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        String content = ParamUtil.getString((PortletRequest)resourceRequest, (String)"content");
        String contentType = ParamUtil.getString((PortletRequest)resourceRequest, (String)"contentType");
        Optional readingTimeDurationOptional = this._readingTimeCalculator.calculate(content, contentType, resourceRequest.getLocale());
        readingTimeDurationOptional.ifPresent(readingTimeDuration -> jsonObject.put("readingTimeInSeconds", (double)readingTimeDuration.getSeconds()).put("readingTimeMessage", this._readingTimeMessageProvider.provide(readingTimeDuration, resourceRequest.getLocale())));
        JSONPortletResponseUtil.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (Object)jsonObject);
    }
}

