/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.web.internal.message;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.reading.time.message.ReadingTimeMessageProvider;
import com.liferay.reading.time.model.ReadingTimeEntry;
import java.time.Duration;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"display.style=descriptive"}, service={ReadingTimeMessageProvider.class})
public class DescriptiveReadingTimeMessageProviderImpl
implements ReadingTimeMessageProvider {
    public String provide(Duration readingTimeDuration, Locale locale) {
        long readingTimeInMinutes = readingTimeDuration.toMinutes();
        if (readingTimeInMinutes == 0L) {
            return LanguageUtil.get((Locale)locale, (String)"less-than-a-minute-read");
        }
        if (readingTimeInMinutes == 1L) {
            return LanguageUtil.get((Locale)locale, (String)"a-minute-read");
        }
        return LanguageUtil.format((Locale)locale, (String)"x-minute-read", (Object)readingTimeInMinutes);
    }

    public String provide(ReadingTimeEntry readingTimeEntry, Locale locale) {
        return this.provide(Duration.ofMillis(readingTimeEntry.getReadingTime()), locale);
    }
}

