/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.web.internal.message;

import com.liferay.portal.kernel.language.Language;
import com.liferay.reading.time.message.ReadingTimeMessageProvider;
import com.liferay.reading.time.model.ReadingTimeEntry;
import java.time.Duration;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"display.style=descriptive"}, service={ReadingTimeMessageProvider.class})
public class DescriptiveReadingTimeMessageProviderImpl
implements ReadingTimeMessageProvider {
    @Reference
    private Language _language;

    public String provide(Duration readingTimeDuration, Locale locale) {
        long readingTimeInMinutes = readingTimeDuration.toMinutes();
        if (readingTimeInMinutes == 0L) {
            return this._language.get(locale, "less-than-a-minute-read");
        }
        if (readingTimeInMinutes == 1L) {
            return this._language.get(locale, "a-minute-read");
        }
        return this._language.format(locale, "x-minute-read", (Object)readingTimeInMinutes);
    }

    public String provide(ReadingTimeEntry readingTimeEntry, Locale locale) {
        return this.provide(Duration.ofMillis(readingTimeEntry.getReadingTime()), locale);
    }
}

