/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.web.internal.message;

import com.liferay.portal.kernel.language.Language;
import com.liferay.reading.time.message.ReadingTimeMessageProvider;
import com.liferay.reading.time.model.ReadingTimeEntry;
import java.time.Duration;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"display.style=simple"}, service={ReadingTimeMessageProvider.class})
public class SimpleReadingTimeMessageProviderImpl
implements ReadingTimeMessageProvider {
    @Reference
    private Language _language;

    public String provide(Duration readingTimeDuration, Locale locale) {
        long readingTimeInMinutes = readingTimeDuration.toMinutes();
        if (readingTimeInMinutes == 0L) {
            readingTimeInMinutes = 1L;
        }
        return this._language.format(locale, readingTimeInMinutes == 1L ? "x-minute" : "x-minutes", (Object)readingTimeInMinutes);
    }

    public String provide(ReadingTimeEntry readingTimeEntry, Locale locale) {
        return this.provide(Duration.ofMillis(readingTimeEntry.getReadingTime()), locale);
    }
}

