/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry;

import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistrar;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.dependency.ServiceDependencyManager;
import com.liferay.registry.util.StringPlus;
import com.liferay.registry.util.UnmodifiableCaseInsensitiveMapDictionary;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class BasicRegistryImpl
implements Registry {
    private final Set<ServiceDependencyManager> _serviceDependencyManagers = new HashSet<ServiceDependencyManager>();
    private final AtomicLong _serviceIdCounter = new AtomicLong();
    private final Map<ServiceReference<?>, Object> _services = new ConcurrentSkipListMap();
    private final Map<ServiceTracker<?, ?>, Filter> _serviceTrackers = new ConcurrentHashMap();

    @Override
    public Filter getFilter(String filterString) throws RuntimeException {
        return new BasicFilter(filterString);
    }

    @Override
    public Registry getRegistry() throws SecurityException {
        return this;
    }

    @Override
    public <T> T getService(Class<T> clazz) {
        return this.getService(clazz.getName());
    }

    @Override
    public <T> T getService(ServiceReference<T> serviceReference) {
        BasicServiceReference basicServiceReference = (BasicServiceReference)serviceReference;
        for (Map.Entry<ServiceReference<?>, Object> entry : this._services.entrySet()) {
            if (!basicServiceReference.matches(entry.getKey())) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    @Override
    public <T> T getService(String className) {
        Filter filter = this.getFilter("(objectClass=" + className + ")");
        for (Map.Entry<ServiceReference<?>, Object> entry : this._services.entrySet()) {
            if (!filter.matches(entry.getKey())) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    @Override
    public Collection<ServiceDependencyManager> getServiceDependencyManagers() {
        return Collections.unmodifiableCollection(this._serviceDependencyManagers);
    }

    @Override
    public <T> ServiceReference<T> getServiceReference(Class<T> clazz) {
        return this.getServiceReference(clazz.getName());
    }

    @Override
    public <T> ServiceReference<T> getServiceReference(String className) {
        Filter filter = this.getFilter("(objectClass=" + className + ")");
        for (Map.Entry<ServiceReference<?>, Object> entry : this._services.entrySet()) {
            if (!filter.matches(entry.getKey())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public <T> Collection<ServiceReference<T>> getServiceReferences(Class<T> clazz, String filterString) throws Exception {
        return Arrays.asList(this.getServiceReferences(clazz.getName(), filterString));
    }

    @Override
    public <T> ServiceReference<T>[] getServiceReferences(String className, String filterString) throws Exception {
        ArrayList serviceReferences = new ArrayList();
        BasicFilter filter = new BasicFilter(filterString);
        for (Map.Entry<ServiceReference<?>, Object> entry : this._services.entrySet()) {
            if (!filter.matches(entry.getKey())) continue;
            serviceReferences.add(entry.getKey());
        }
        if (serviceReferences.isEmpty()) {
            return null;
        }
        return serviceReferences.toArray(new ServiceReference[0]);
    }

    @Override
    public <T> ServiceRegistrar<T> getServiceRegistrar(Class<T> clazz) {
        return new ServiceRegistrar<T>(this, clazz);
    }

    @Override
    public <T> Collection<T> getServices(Class<T> clazz, String filterString) throws Exception {
        T[] services = this.getServices(clazz.getName(), filterString);
        if (services == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(services);
    }

    @Override
    public <T> T[] getServices(String className, String filterString) throws Exception {
        ArrayList<Object> services = new ArrayList<Object>();
        if (filterString == null || filterString.equals("")) {
            filterString = "(objectClass=" + className + ")";
        }
        BasicFilter filter = new BasicFilter(filterString);
        for (Map.Entry<ServiceReference<?>, Object> entry : this._services.entrySet()) {
            if (!filter.matches(entry.getKey())) continue;
            services.add(entry.getValue());
        }
        if (services.isEmpty()) {
            return null;
        }
        Object service = services.get(0);
        Class<?> clazz = service.getClass();
        Object[] array = (Object[])Array.newInstance(clazz, services.size());
        return services.toArray(array);
    }

    @Override
    public <T> ServiceRegistration<T> registerService(Class<T> clazz, T service) {
        BasicServiceReference basicServiceReference = new BasicServiceReference(clazz.getName(), this._serviceIdCounter.incrementAndGet(), 0, new HashMap<String, Object>());
        this._addingService(basicServiceReference, service);
        return new BasicServiceRegistration(basicServiceReference);
    }

    @Override
    public <T> ServiceRegistration<T> registerService(Class<T> clazz, T service, Map<String, Object> properties) {
        Integer serviceRanking = (Integer)properties.get("service.ranking");
        if (serviceRanking == null) {
            serviceRanking = 0;
        }
        BasicServiceReference basicServiceReference = new BasicServiceReference(clazz.getName(), this._serviceIdCounter.incrementAndGet(), serviceRanking, properties);
        this._addingService(basicServiceReference, service);
        return new BasicServiceRegistration(basicServiceReference);
    }

    @Override
    public <T> ServiceRegistration<T> registerService(String className, T service) {
        BasicServiceReference basicServiceReference = new BasicServiceReference(className, this._serviceIdCounter.incrementAndGet(), 0, new HashMap<String, Object>());
        this._addingService(basicServiceReference, service);
        return new BasicServiceRegistration(basicServiceReference);
    }

    @Override
    public <T> ServiceRegistration<T> registerService(String className, T service, Map<String, Object> properties) {
        Integer serviceRanking = (Integer)properties.get("service.ranking");
        if (serviceRanking == null) {
            serviceRanking = 0;
        }
        BasicServiceReference basicServiceReference = new BasicServiceReference(className, this._serviceIdCounter.incrementAndGet(), serviceRanking, properties);
        this._addingService(basicServiceReference, service);
        return new BasicServiceRegistration(basicServiceReference);
    }

    @Override
    public <T> ServiceRegistration<T> registerService(String[] classNames, T service) {
        if (classNames == null || classNames.length == 0) {
            throw new IllegalArgumentException();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("objectClass", classNames);
        BasicServiceReference basicServiceReference = new BasicServiceReference(classNames[0], this._serviceIdCounter.incrementAndGet(), 0, properties);
        this._addingService(basicServiceReference, service);
        return new BasicServiceRegistration(basicServiceReference);
    }

    @Override
    public <T> ServiceRegistration<T> registerService(String[] classNames, T service, Map<String, Object> properties) {
        if (classNames == null || classNames.length == 0) {
            throw new IllegalArgumentException();
        }
        properties.put("objectClass", classNames);
        Integer serviceRanking = (Integer)properties.get("service.ranking");
        if (serviceRanking == null) {
            serviceRanking = 0;
        }
        BasicServiceReference basicServiceReference = new BasicServiceReference(classNames[0], this._serviceIdCounter.incrementAndGet(), serviceRanking, properties);
        this._addingService(basicServiceReference, service);
        return new BasicServiceRegistration(basicServiceReference);
    }

    @Override
    public synchronized void registerServiceDependencyManager(ServiceDependencyManager serviceDependencyManager) {
        this._serviceDependencyManagers.add(serviceDependencyManager);
    }

    @Override
    public Registry setRegistry(Registry registry) throws SecurityException {
        return registry;
    }

    @Override
    public <S, T> ServiceTracker<S, T> trackServices(Class<S> clazz) {
        BasicFilter filter = new BasicFilter("(objectClass=" + clazz.getName() + ")");
        return new BasicServiceTracker(filter);
    }

    @Override
    public <S, T> ServiceTracker<S, T> trackServices(Class<S> clazz, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        BasicFilter filter = new BasicFilter("(objectClass=" + clazz.getName() + ")");
        return new BasicServiceTracker<S, T>(filter, serviceTrackerCustomizer);
    }

    @Override
    public <S, T> ServiceTracker<S, T> trackServices(Filter filter) {
        return new BasicServiceTracker(filter);
    }

    @Override
    public <S, T> ServiceTracker<S, T> trackServices(Filter filter, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        return new BasicServiceTracker<S, T>(filter, serviceTrackerCustomizer);
    }

    @Override
    public <S, T> ServiceTracker<S, T> trackServices(String className) {
        return new BasicServiceTracker(new BasicFilter("(objectClass=" + className + ")"));
    }

    @Override
    public <S, T> ServiceTracker<S, T> trackServices(String className, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        BasicFilter filter = new BasicFilter("(objectClass=" + className + ")");
        return new BasicServiceTracker<S, T>(filter, serviceTrackerCustomizer);
    }

    @Override
    public <T> boolean ungetService(ServiceReference<T> serviceReference) {
        return true;
    }

    @Override
    public void unregisterServiceDependencyManager(ServiceDependencyManager serviceDependencyManager) {
        this._serviceDependencyManagers.remove(serviceDependencyManager);
    }

    private <S, T> void _addingService(BasicServiceReference<S> basicServiceReference, S service) {
        this._services.put(basicServiceReference, service);
        for (Map.Entry<ServiceTracker<?, ?>, Filter> entry : this._serviceTrackers.entrySet()) {
            Filter filter = entry.getValue();
            if (!filter.matches(basicServiceReference)) continue;
            ServiceTracker<?, ?> serviceTracker = entry.getKey();
            try {
                serviceTracker.addingService(basicServiceReference);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private <S, T> void _modifiedService(BasicServiceReference<S> basicServiceReference) {
        for (Map.Entry<ServiceTracker<?, ?>, Filter> entry : this._serviceTrackers.entrySet()) {
            ServiceTracker<?, ?> serviceTracker;
            Object service;
            Filter filter = entry.getValue();
            if (!filter.matches(basicServiceReference) || (service = (serviceTracker = entry.getKey()).getService(basicServiceReference)) == null) continue;
            try {
                serviceTracker.modifiedService(basicServiceReference, service);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private <S, T> void _removedService(BasicServiceReference<S> basicServiceReference) {
        for (Map.Entry<ServiceTracker<?, ?>, Filter> entry : this._serviceTrackers.entrySet()) {
            Filter filter = entry.getValue();
            if (!filter.matches(basicServiceReference)) continue;
            ServiceTracker<?, ?> serviceTracker = entry.getKey();
            try {
                serviceTracker.remove(basicServiceReference);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class BasicServiceTracker<S, T>
    implements ServiceTracker<S, T> {
        private volatile CountDownLatch _countDownLatch = new CountDownLatch(1);
        private Filter _filter;
        private final ServiceTrackerCustomizer<S, T> _serviceTrackerCustomizer;
        private final AtomicInteger _stateCounter = new AtomicInteger();
        private final NavigableMap<ServiceReference<S>, T> _trackedServices = new ConcurrentSkipListMap<ServiceReference<S>, T>();

        public BasicServiceTracker(Filter filter) {
            this(filter, null);
        }

        public BasicServiceTracker(Filter filter, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
            this._filter = filter;
            this._serviceTrackerCustomizer = serviceTrackerCustomizer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T addingService(ServiceReference<S> serviceReference) {
            T service = null;
            try {
                service = this._serviceTrackerCustomizer != null ? (T)this._serviceTrackerCustomizer.addingService(serviceReference) : (T)BasicRegistryImpl.this.getService(serviceReference);
                if (service == null) {
                    T t = null;
                    return t;
                }
                this._trackedServices.put(serviceReference, service);
                T t = service;
                return t;
            }
            finally {
                if (service != null) {
                    this._stateCounter.incrementAndGet();
                    this._countDownLatch.countDown();
                }
            }
        }

        @Override
        public void close() {
            BasicRegistryImpl.this._serviceTrackers.remove(this);
            Set set = this._trackedServices.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                iterator.remove();
                this.removedService((ServiceReference)entry.getKey(), entry.getValue());
            }
            this._trackedServices.clear();
        }

        @Override
        public T getService() {
            Map.Entry<ServiceReference<S>, T> firstEntry = this._trackedServices.firstEntry();
            if (firstEntry == null) {
                return null;
            }
            return firstEntry.getValue();
        }

        @Override
        public T getService(ServiceReference<S> serviceReference) {
            BasicServiceReference basicServiceReference = (BasicServiceReference)serviceReference;
            for (ServiceReference curServiceReference : this._trackedServices.keySet()) {
                if (!basicServiceReference.matches(curServiceReference)) continue;
                return (T)this._trackedServices.get(curServiceReference);
            }
            return null;
        }

        @Override
        public ServiceReference<S> getServiceReference() {
            return (ServiceReference)this._trackedServices.firstKey();
        }

        @Override
        public ServiceReference<S>[] getServiceReferences() {
            Set set = this._trackedServices.keySet();
            return set.toArray(new ServiceReference[this._trackedServices.size()]);
        }

        @Override
        public Object[] getServices() {
            Collection values = this._trackedServices.values();
            return values.toArray();
        }

        @Override
        public T[] getServices(T[] services) {
            Collection values = this._trackedServices.values();
            return values.toArray(services);
        }

        @Override
        public SortedMap<ServiceReference<S>, T> getTrackedServiceReferences() {
            return this._trackedServices;
        }

        @Override
        public int getUpdateMarker() {
            return this._stateCounter.get();
        }

        @Override
        public boolean isEmpty() {
            return this._trackedServices.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modifiedService(ServiceReference<S> serviceReference, T service) {
            try {
                if (this._serviceTrackerCustomizer != null) {
                    this._serviceTrackerCustomizer.modifiedService(serviceReference, service);
                }
            }
            finally {
                this._stateCounter.incrementAndGet();
            }
        }

        @Override
        public void open() {
            BasicRegistryImpl.this._serviceTrackers.put(this, this._filter);
            Set set = BasicRegistryImpl.this._services.entrySet();
            for (Map.Entry entry : set) {
                BasicServiceReference basicServiceReference = (BasicServiceReference)entry.getKey();
                if (!this._filter.matches(basicServiceReference._properties)) continue;
                ServiceReference serviceReference = (ServiceReference)entry.getKey();
                this.addingService(serviceReference);
            }
        }

        @Override
        public void open(boolean trackAllServices) {
            this.open();
        }

        @Override
        public void remove(ServiceReference<S> serviceReference) {
            Object service = this._trackedServices.remove(serviceReference);
            if (this._trackedServices.isEmpty()) {
                this._countDownLatch = new CountDownLatch(1);
            }
            this.removedService(serviceReference, service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removedService(ServiceReference<S> serviceReference, T service) {
            try {
                if (this._serviceTrackerCustomizer != null) {
                    this._serviceTrackerCustomizer.removedService(serviceReference, service);
                }
            }
            finally {
                this._stateCounter.incrementAndGet();
            }
        }

        @Override
        public int size() {
            return this._trackedServices.size();
        }

        @Override
        public T waitForService(long timeout) throws InterruptedException {
            this._countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            return this.getService();
        }
    }

    private class BasicServiceRegistration<S>
    implements ServiceRegistration<S> {
        private final BasicServiceReference<S> _basicServiceReference;

        public BasicServiceRegistration(BasicServiceReference<S> basicServiceReference) {
            this._basicServiceReference = basicServiceReference;
        }

        @Override
        public ServiceReference<S> getServiceReference() {
            return this._basicServiceReference;
        }

        @Override
        public void setProperties(Map<String, Object> properties) {
            ((BasicServiceReference)this._basicServiceReference)._properties.putAll(properties);
            BasicRegistryImpl.this._modifiedService(this._basicServiceReference);
        }

        @Override
        public void unregister() {
            BasicRegistryImpl.this._services.remove(this._basicServiceReference);
            BasicRegistryImpl.this._removedService(this._basicServiceReference);
        }
    }

    private class BasicServiceReference<T>
    implements ServiceReference<T> {
        private final Map<String, Object> _properties = new LowerCaseKeyTreeMap();

        public BasicServiceReference(String className, long id, int ranking, Map<String, Object> properties) {
            this._properties.put("service.id", id);
            this._properties.put("service.ranking", ranking);
            ArrayList<String> classNames = new ArrayList<String>();
            classNames.add(className);
            classNames.addAll(StringPlus.asList(properties.get("objectClass")));
            this._properties.putAll(properties);
            this._properties.put("objectClass", classNames);
        }

        @Override
        public int compareTo(Object serviceReference) {
            long otherServiceId;
            Map<String, Object> otherProperties;
            int otherServiceRanking;
            BasicServiceReference otherServiceReference = (BasicServiceReference)serviceReference;
            int thisServiceRanking = (Integer)this._properties.get("service.ranking");
            if (thisServiceRanking != (otherServiceRanking = ((Integer)(otherProperties = otherServiceReference._properties).get("service.ranking")).intValue())) {
                if (thisServiceRanking < otherServiceRanking) {
                    return -1;
                }
                return 1;
            }
            long thisServiceId = (Long)this._properties.get("service.id");
            if (thisServiceId == (otherServiceId = ((Long)otherProperties.get("service.id")).longValue())) {
                return 0;
            }
            if (thisServiceId < otherServiceId) {
                return 1;
            }
            return -1;
        }

        @Override
        public Map<String, Object> getProperties() {
            return new HashMap<String, Object>(this._properties);
        }

        @Override
        public Object getProperty(String key) {
            return this._properties.get(key.toLowerCase());
        }

        @Override
        public String[] getPropertyKeys() {
            Set<String> set = this._properties.keySet();
            return set.toArray(new String[set.size()]);
        }

        public boolean matches(ServiceReference<?> serviceReference) {
            BasicFilter filter = new BasicFilter(this.toString());
            return filter.matches(serviceReference);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Set<Map.Entry<String, Object>> entrySet = this._properties.entrySet();
            if (entrySet.size() > 1) {
                stringBuilder.append('(');
                stringBuilder.append('&');
            }
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Object[] array = null;
                Class<?> clazz = value.getClass();
                if (clazz.isArray()) {
                    array = (Object[])value;
                } else if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    array = collection.toArray();
                } else {
                    array = new Object[]{value};
                }
                if (array.length <= 0) continue;
                for (Object object : array) {
                    stringBuilder.append('(');
                    stringBuilder.append(key);
                    stringBuilder.append('=');
                    stringBuilder.append(object);
                    stringBuilder.append(')');
                }
            }
            if (entrySet.size() > 1) {
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }
    }

    private static class LowerCaseKeyTreeMap
    extends TreeMap<String, Object> {
        private LowerCaseKeyTreeMap() {
        }

        @Override
        public Object put(String key, Object value) {
            return super.put(key.toLowerCase(), value);
        }
    }

    private static class BasicFilter
    implements Filter {
        private aQute.lib.filter.Filter _filter;

        public BasicFilter(String filterString) {
            this._filter = new aQute.lib.filter.Filter(filterString);
        }

        @Override
        public boolean matches(Map<String, Object> properties) {
            UnmodifiableCaseInsensitiveMapDictionary<Object> dictionary = new UnmodifiableCaseInsensitiveMapDictionary<Object>(properties);
            return this._filter.match(dictionary);
        }

        @Override
        public boolean matches(ServiceReference<?> serviceReference) {
            BasicServiceReference basicServiceReference = (BasicServiceReference)serviceReference;
            UnmodifiableCaseInsensitiveMapDictionary dictionary = new UnmodifiableCaseInsensitiveMapDictionary(basicServiceReference._properties);
            return this._filter.match(dictionary);
        }

        @Override
        public boolean matchesCase(Map<String, Object> properties) {
            return this.matches(properties);
        }

        @Override
        public String toString() {
            return this._filter.toString();
        }
    }
}

