/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry;

import com.liferay.registry.Registry;
import com.liferay.registry.ServiceFinalizer;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServiceRegistrar<T> {
    private final Registry _registry;
    private final Set<ServiceRegistration<T>> _serviceRegistrations = new HashSet<ServiceRegistration<T>>();

    public ServiceRegistrar(Registry registry, Class<T> clazz) {
        this._registry = registry;
    }

    public void destroy() {
        this.destroy(null);
    }

    public void destroy(ServiceFinalizer<T> serviceFinalizer) {
        for (ServiceRegistration<T> serviceRegistration : this._serviceRegistrations) {
            if (serviceFinalizer != null) {
                ServiceReference<T> serviceReference = serviceRegistration.getServiceReference();
                T service = this._registry.getService(serviceReference);
                serviceFinalizer.finalize(serviceReference, service);
            }
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
    }

    public Collection<ServiceRegistration<T>> getServiceRegistrations() {
        return Collections.unmodifiableCollection(this._serviceRegistrations);
    }

    public ServiceRegistration<T> registerService(Class<T> clazz, T service) {
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(clazz, service);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(Class<T> clazz, T service, Map<String, Object> properties) {
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(clazz, service, properties);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(String className, T service) {
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(className, service);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(String className, T service, Map<String, Object> properties) {
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(className, service, properties);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(String[] classNames, T service) {
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(classNames, service);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }

    public ServiceRegistration<T> registerService(String[] classNames, T service, Map<String, Object> properties) {
        ServiceRegistration<T> serviceRegistration = this._registry.registerService(classNames, service, properties);
        this._serviceRegistrations.add(serviceRegistration);
        return serviceRegistration;
    }
}

